/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.folding;

import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceClassBody;
import oracle.javatools.parser.java.v2.model.SourceMember;
import oracle.jdevimpl.java.folding.AbstractJavaMemberBlock;

final class JavaClassBlock
extends AbstractJavaMemberBlock {
    private Object key;
    private int anonymousClassId;
    private int classInitId;
    private int instanceInitId;

    public JavaClassBlock(SourceClass sourceClass, boolean bl) {
        super((SourceMember)sourceClass, bl);
        SourceClassBody sourceClassBody = sourceClass.getSourceBody();
        this.setStartOffset(sourceClassBody.getStartOffset());
        this.setEndOffset(sourceClassBody.getEndOffset());
    }

    public void setUserObject(Object object) {
        this.key = null;
        super.setUserObject(object);
    }

    protected Object getId() {
        if (this.key == null) {
            SourceClass sourceClass = this.getClassSym();
            this.key = !sourceClass.isAnonymous() ? sourceClass.getName() : this.getAnonymousId();
        }
        return this.key;
    }

    protected SourceClass getClassSym() {
        return (SourceClass)this.getSym();
    }

    protected String getAnonymousId() {
        JavaClassBlock javaClassBlock = this.getEnclosingClassBlock();
        if (javaClassBlock != null) {
            return javaClassBlock.nextAnonymousId();
        }
        return "";
    }

    protected String nextAnonymousId() {
        SourceClass sourceClass = this.getClassSym();
        String string = Integer.toString(++this.anonymousClassId);
        return sourceClass.getName() + "$" + string;
    }

    protected String nextClassInitializerId() {
        String string = Integer.toString(++this.classInitId);
        return "<clinit>" + string;
    }

    protected String nextInstanceInitializerId() {
        String string = Integer.toString(++this.instanceInitId);
        return "<init>" + string;
    }
}

