/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.folding;

import java.awt.Component;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.CodeMenuConstants;
import oracle.ide.config.ClientSetting;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.model.Project;
import oracle.ide.view.View;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.folding.AbstractCodeFoldingPlugin;
import oracle.javatools.editor.folding.CodeFoldingMargin;
import oracle.javatools.editor.folding.CodeFoldingModel;
import oracle.javatools.editor.folding.CodeFoldingProvider;
import oracle.javatools.editor.folding.FoldingBlock;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceClassBody;
import oracle.javatools.parser.java.v2.model.SourceClassInitializer;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceImport;
import oracle.javatools.parser.java.v2.model.SourceMember;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.doc.SourceDocComment;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdevimpl.java.JavaArb;
import oracle.jdevimpl.java.JavaParserPlugin;
import oracle.jdevimpl.java.folding.AbstractJavaFoldingBlock;
import oracle.jdevimpl.java.folding.JavaClassBlock;
import oracle.jdevimpl.java.folding.JavaCodeFoldingModel;
import oracle.jdevimpl.java.folding.JavaCodeFoldingOptions;
import oracle.jdevimpl.java.folding.JavaFileBlock;
import oracle.jdevimpl.java.folding.JavaImportsBlock;
import oracle.jdevimpl.java.folding.JavaInitializerBlock;
import oracle.jdevimpl.java.folding.JavaMethodBlock;
import oracle.jdevimpl.java.folding.JavadocBlock;

public class JavaCodeFoldingPlugin
extends AbstractCodeFoldingPlugin
implements JavaParserPlugin.HelperClient,
CodeFoldingProvider {
    protected JPopupMenu popup;
    protected Thread modelUpdateThread;
    private static final JavaCodeFoldingController JAVA_FOLDING_CONTROLLER = new JavaCodeFoldingController(null);
    private static final int COLLAPSE_ALL_CMD_ID = Ide.findOrCreateCmdID((String)"JavaCodeFoldingPlugin.COLLAPSE_ALL_CMD_ID");
    private static final int COLLAPSE_JAVADOC_CMD_ID = Ide.findOrCreateCmdID((String)"JavaCodeFoldingPlugin.COLLAPSE_JAVADOC_CMD_ID");
    private static final int COLLAPSE_METHODS_CMD_ID = Ide.findOrCreateCmdID((String)"JavaCodeFoldingPlugin.COLLAPSE_METHODS_CMD_ID");
    private static final int EXPAND_ALL_CMD_ID = Ide.findOrCreateCmdID((String)"JavaCodeFoldingPlugin.EXPAND_ALL_CMD_ID");
    private static final int EXPAND_JAVADOC_CMD_ID = Ide.findOrCreateCmdID((String)"JavaCodeFoldingPlugin.EXPAND_JAVADOC_CMD_ID");
    private static final int EXPAND_METHODS_CMD_ID = Ide.findOrCreateCmdID((String)"JavaCodeFoldingPlugin.EXPAND_METHODS_CMD_ID");
    private static IdeAction collapseAllAction;
    private static IdeAction collapseJavadocAction;
    private static IdeAction collapseMethodsAction;
    private static IdeAction expandAllAction;
    private static IdeAction expandJavadocAction;
    private static IdeAction expandMethodsAction;

    protected CodeFoldingProvider createProvider() {
        return this;
    }

    protected void attach(BasicEditorPane basicEditorPane) {
        super.attach(basicEditorPane);
        JavaParserPlugin.attachHelperClient(basicEditorPane, this);
    }

    protected void detach(BasicEditorPane basicEditorPane) {
        this.interruptUpdateThread();
        JavaParserPlugin.detachHelperClient(basicEditorPane, this);
        super.detach(basicEditorPane);
    }

    public CodeFoldingModel createModel(BasicEditorPane basicEditorPane) {
        SourceFile sourceFile = this.getSourceFile();
        if (sourceFile == null) {
            return null;
        }
        BasicDocument basicDocument = (BasicDocument)basicEditorPane.getDocument();
        JavaCodeFoldingModel javaCodeFoldingModel = new JavaCodeFoldingModel(basicDocument);
        JavaCodeFoldingOptions javaCodeFoldingOptions = JavaCodeFoldingPlugin.getCodeFoldingOptions();
        TextBuffer textBuffer = basicDocument.getTextBuffer();
        int n = textBuffer.getChangeId();
        this.updateModelImmediate(javaCodeFoldingModel, sourceFile, n, javaCodeFoldingOptions);
        return javaCodeFoldingModel;
    }

    public void insertUpdate(CodeFoldingModel codeFoldingModel, int n, int n2) {
        this.interruptUpdateThread();
        JavaCodeFoldingModel javaCodeFoldingModel = (JavaCodeFoldingModel)codeFoldingModel;
        javaCodeFoldingModel.insertUpdate(n, n2);
        javaCodeFoldingModel.reload();
    }

    public void removeUpdate(CodeFoldingModel codeFoldingModel, int n, int n2) {
        this.interruptUpdateThread();
        JavaCodeFoldingModel javaCodeFoldingModel = (JavaCodeFoldingModel)codeFoldingModel;
        javaCodeFoldingModel.removeUpdate(n, n2);
        javaCodeFoldingModel.reload();
    }

    public JPopupMenu getPopupMenu() {
        if (this.popup == null) {
            IdeAction[] ideActionArray = new IdeAction[]{collapseJavadocAction, collapseMethodsAction, collapseAllAction, null, expandJavadocAction, expandMethodsAction, expandAllAction};
            this.popup = new JPopupMenu();
            int n = 0;
            while (n < ideActionArray.length) {
                IdeAction ideAction = ideActionArray[n];
                if (ideAction != null) {
                    JMenuItem jMenuItem = Ide.getMenubar().createMenuItem((ToggleAction)ideAction);
                    this.popup.add(jMenuItem);
                } else {
                    this.popup.addSeparator();
                }
                ++n;
            }
        }
        CodeFoldingMargin codeFoldingMargin = this.getMargin();
        int n = this.popup.getComponentCount();
        while (n-- > 0) {
            AbstractButton abstractButton;
            Action action;
            Component component = this.popup.getComponent(n);
            if (!(component instanceof AbstractButton) || !((action = (abstractButton = (AbstractButton)component).getAction()) instanceof IdeAction)) continue;
            JavaCodeFoldingController.maS$update((IdeAction)action, codeFoldingMargin);
        }
        return this.popup;
    }

    public void notifyCompileScheduled() {
    }

    public void notifyParseFinished(JavaManager javaManager, SourceFile sourceFile, int n, int n2) {
    }

    public void notifyCompileFinished(JavaManager javaManager, SourceFile sourceFile, int n, int n2) {
        int n3;
        JavaCodeFoldingModel javaCodeFoldingModel = (JavaCodeFoldingModel)this.getModel();
        javaCodeFoldingModel.readLock();
        try {
            n3 = javaCodeFoldingModel.getLastChangeId();
        }
        finally {
            javaCodeFoldingModel.readUnlock();
        }
        if (n != n3) {
            this.updateModelAsync(javaCodeFoldingModel, sourceFile, n);
        }
    }

    private void updateModelImmediate(JavaCodeFoldingModel javaCodeFoldingModel, SourceFile sourceFile, int n, JavaCodeFoldingOptions javaCodeFoldingOptions) {
        Object object;
        try {
            object = this.createFoldingTree((CodeFoldingModel)javaCodeFoldingModel, sourceFile, javaCodeFoldingOptions);
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        2 var8_8 = new 2(this, javaCodeFoldingModel, object, n);
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(var8_8);
        } else {
            var8_8.run();
        }
    }

    private void updateModelAsync(JavaCodeFoldingModel javaCodeFoldingModel, SourceFile sourceFile, int n) {
        if (this.modelUpdateThread != null) {
            return;
        }
        1 var4_4 = new 1(this, javaCodeFoldingModel, sourceFile, n);
        this.modelUpdateThread = new Thread((Runnable)var4_4, "Java Code Folding Updater");
        this.modelUpdateThread.setPriority(1);
        this.modelUpdateThread.start();
    }

    private void interruptUpdateThread() {
        if (this.modelUpdateThread != null) {
            this.modelUpdateThread.interrupt();
            this.modelUpdateThread = null;
        }
    }

    protected Object createFoldingTree(CodeFoldingModel codeFoldingModel, SourceFile sourceFile, JavaCodeFoldingOptions javaCodeFoldingOptions) throws InterruptedException {
        AbstractJavaFoldingBlock abstractJavaFoldingBlock = this.createFoldingTree(sourceFile, javaCodeFoldingOptions);
        codeFoldingModel.readLock();
        try {
            AbstractJavaFoldingBlock abstractJavaFoldingBlock2 = (AbstractJavaFoldingBlock)((Object)codeFoldingModel.getRoot());
            if (abstractJavaFoldingBlock2 != null) {
                this.reconcileFoldingState(abstractJavaFoldingBlock2, abstractJavaFoldingBlock);
            }
        }
        finally {
            codeFoldingModel.readUnlock();
        }
        this.checkIfInterrupted();
        return abstractJavaFoldingBlock;
    }

    protected AbstractJavaFoldingBlock createFoldingTree(SourceFile sourceFile, JavaCodeFoldingOptions javaCodeFoldingOptions) throws InterruptedException {
        return this.createFileBlock(sourceFile, javaCodeFoldingOptions);
    }

    protected void reconcileFoldingState(AbstractJavaFoldingBlock abstractJavaFoldingBlock, AbstractJavaFoldingBlock abstractJavaFoldingBlock2) throws InterruptedException {
        this.checkIfInterrupted();
        HashMap<Object, AbstractJavaFoldingBlock> hashMap = new HashMap<Object, AbstractJavaFoldingBlock>();
        Iterator iterator = abstractJavaFoldingBlock.getChildren();
        while (iterator.hasNext()) {
            AbstractJavaFoldingBlock abstractJavaFoldingBlock3 = (AbstractJavaFoldingBlock)((Object)iterator.next());
            this.checkIfInterrupted();
            Object object = abstractJavaFoldingBlock3.getId();
            hashMap.put(object, abstractJavaFoldingBlock3);
        }
        Iterator iterator2 = abstractJavaFoldingBlock2.getChildren();
        while (iterator2.hasNext()) {
            AbstractJavaFoldingBlock abstractJavaFoldingBlock4 = (AbstractJavaFoldingBlock)((Object)iterator2.next());
            this.checkIfInterrupted();
            Object object = abstractJavaFoldingBlock4.getId();
            AbstractJavaFoldingBlock abstractJavaFoldingBlock5 = (AbstractJavaFoldingBlock)((Object)hashMap.remove(object));
            if (abstractJavaFoldingBlock5 != null) {
                boolean bl = abstractJavaFoldingBlock5.isExpanded();
                abstractJavaFoldingBlock4.setExpanded(bl);
            }
            if (abstractJavaFoldingBlock5 == null) continue;
            this.reconcileFoldingState(abstractJavaFoldingBlock5, abstractJavaFoldingBlock4);
        }
    }

    protected void checkIfInterrupted() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    protected Context getContext() {
        return CodeEditor.getContext((BasicEditorPane)this.getEditorPane());
    }

    protected Project getProject() {
        Context context = this.getContext();
        Project project = context.getProject();
        if (project == null && (project = Ide.getActiveProject()) == null) {
            project = Ide.getDefaultProject();
        }
        return project;
    }

    protected SourceFile getSourceFile() {
        Project project = this.getProject();
        JavaManager javaManager = JavaManager.getJavaManager(project);
        Context context = this.getContext();
        URL uRL = context.getNode().getURL();
        return javaManager.getSourceFile(uRL);
    }

    protected JavaFileBlock createFileBlock(SourceFile sourceFile, JavaCodeFoldingOptions javaCodeFoldingOptions) throws InterruptedException {
        JavaFileBlock javaFileBlock = new JavaFileBlock(sourceFile);
        this.addSourceImportBlock(sourceFile, javaCodeFoldingOptions, (FoldingBlock)javaFileBlock);
        this.addChildBlocks((SourceElement)sourceFile, javaCodeFoldingOptions, (FoldingBlock)javaFileBlock);
        return javaFileBlock;
    }

    protected JavaImportsBlock createImportBlock(SourceFile sourceFile, JavaCodeFoldingOptions javaCodeFoldingOptions) throws InterruptedException {
        List list = sourceFile.getSourceImports();
        if (list.isEmpty()) {
            return null;
        }
        int n = Integer.MAX_VALUE;
        int n2 = 0;
        for (SourceImport sourceImport : list) {
            n = Math.min(n, sourceImport.getStartOffset());
            n2 = Math.max(n2, sourceImport.getEndOffset());
        }
        if (this.isValidBlock(n, n2, "import ...;")) {
            boolean bl = javaCodeFoldingOptions != null ? javaCodeFoldingOptions.getFoldImports() : false;
            return new JavaImportsBlock(n, n2, bl ^ true);
        }
        return null;
    }

    protected JavaClassBlock createClassBlock(SourceClass sourceClass, JavaCodeFoldingOptions javaCodeFoldingOptions) throws InterruptedException {
        boolean bl = sourceClass.isAnonymous() ? (javaCodeFoldingOptions != null ? javaCodeFoldingOptions.getFoldAnonymousClasses() : false) : (sourceClass.isMemberClass() ? (javaCodeFoldingOptions != null ? javaCodeFoldingOptions.getFoldInnerClasses() : false) : false);
        SourceClassBody sourceClassBody = sourceClass.getSourceBody();
        if (this.isValidBlock((SourceElement)sourceClassBody, "{...}")) {
            JavaClassBlock javaClassBlock = new JavaClassBlock(sourceClass, bl ^ true);
            this.addChildBlocks((SourceElement)sourceClassBody, javaCodeFoldingOptions, (FoldingBlock)javaClassBlock);
            return javaClassBlock;
        }
        return null;
    }

    protected JavaMethodBlock createMethodBlock(SourceMethod sourceMethod, JavaCodeFoldingOptions javaCodeFoldingOptions, boolean bl) throws InterruptedException {
        SourceBlock sourceBlock = sourceMethod.getBlock();
        if (this.isValidBlock((SourceElement)sourceBlock, "{...}")) {
            JavaMethodBlock javaMethodBlock = new JavaMethodBlock(sourceMethod, bl ^ true);
            this.addChildBlocks((SourceElement)sourceBlock, javaCodeFoldingOptions, (FoldingBlock)javaMethodBlock);
            return javaMethodBlock;
        }
        return null;
    }

    protected JavaInitializerBlock createInitializerBlock(SourceClassInitializer sourceClassInitializer, JavaCodeFoldingOptions javaCodeFoldingOptions, boolean bl) throws InterruptedException {
        SourceBlock sourceBlock = sourceClassInitializer.getBlock();
        if (this.isValidBlock((SourceElement)sourceBlock, "{...}")) {
            JavaInitializerBlock javaInitializerBlock = new JavaInitializerBlock(sourceClassInitializer, bl ^ true);
            this.addChildBlocks((SourceElement)sourceBlock, javaCodeFoldingOptions, (FoldingBlock)javaInitializerBlock);
            return javaInitializerBlock;
        }
        return null;
    }

    protected JavadocBlock createDocCommentBlock(SourceMember sourceMember, JavaCodeFoldingOptions javaCodeFoldingOptions) throws InterruptedException {
        SourceDocComment sourceDocComment = sourceMember.getDocComment();
        if (sourceDocComment != null && this.isValidBlock((SourceElement)sourceDocComment, "/**...*/")) {
            boolean bl = javaCodeFoldingOptions != null ? javaCodeFoldingOptions.getFoldJavadoc() : false;
            JavadocBlock javadocBlock = new JavadocBlock(sourceMember, bl ^ true);
            return javadocBlock;
        }
        return null;
    }

    protected void addChildBlocks(SourceElement sourceElement, JavaCodeFoldingOptions javaCodeFoldingOptions, FoldingBlock foldingBlock) throws InterruptedException {
        List list = sourceElement.getChildren();
        for (SourceElement sourceElement2 : list) {
            this.checkIfInterrupted();
            this.addSourceBlock(sourceElement2, javaCodeFoldingOptions, foldingBlock);
        }
    }

    protected void addSourceBlock(SourceElement sourceElement, JavaCodeFoldingOptions javaCodeFoldingOptions, FoldingBlock foldingBlock) throws InterruptedException {
        int n = sourceElement.getSymbolKind();
        if (n == 3) {
            SourceClass sourceClass = (SourceClass)sourceElement;
            this.addSourceClassBlock(sourceClass, javaCodeFoldingOptions, foldingBlock);
        } else if (n == 5) {
            SourceClassInitializer sourceClassInitializer = (SourceClassInitializer)sourceElement;
            boolean bl = javaCodeFoldingOptions != null ? javaCodeFoldingOptions.getFoldInitializers() : false;
            this.addSourceInitializerBlock(sourceClassInitializer, javaCodeFoldingOptions, bl, foldingBlock);
        } else if (n == 6) {
            SourceMethod sourceMethod = (SourceMethod)sourceElement;
            boolean bl = javaCodeFoldingOptions != null ? javaCodeFoldingOptions.getFoldConstructors() : false;
            this.addSourceMethodBlock(sourceMethod, javaCodeFoldingOptions, bl, foldingBlock);
        } else if (n == 19) {
            SourceMethod sourceMethod = (SourceMethod)sourceElement;
            boolean bl = javaCodeFoldingOptions != null ? javaCodeFoldingOptions.getFoldMethods() : false;
            this.addSourceMethodBlock(sourceMethod, javaCodeFoldingOptions, bl, foldingBlock);
        } else if (n == 10) {
            SourceFieldVariable sourceFieldVariable = (SourceFieldVariable)sourceElement;
            this.addSourceFieldBlock(sourceFieldVariable, javaCodeFoldingOptions, foldingBlock);
        } else {
            this.addChildBlocks(sourceElement, javaCodeFoldingOptions, foldingBlock);
        }
    }

    protected void addSourceImportBlock(SourceFile sourceFile, JavaCodeFoldingOptions javaCodeFoldingOptions, FoldingBlock foldingBlock) throws InterruptedException {
        JavaImportsBlock javaImportsBlock = this.createImportBlock(sourceFile, javaCodeFoldingOptions);
        if (javaImportsBlock != null) {
            foldingBlock.add((FoldingBlock)javaImportsBlock);
        }
    }

    protected void addSourceClassBlock(SourceClass sourceClass, JavaCodeFoldingOptions javaCodeFoldingOptions, FoldingBlock foldingBlock) throws InterruptedException {
        this.addDocCommentBlock((SourceMember)sourceClass, javaCodeFoldingOptions, foldingBlock);
        JavaClassBlock javaClassBlock = this.createClassBlock(sourceClass, javaCodeFoldingOptions);
        if (javaClassBlock != null) {
            foldingBlock.add((FoldingBlock)javaClassBlock);
        }
    }

    protected void addSourceMethodBlock(SourceMethod sourceMethod, JavaCodeFoldingOptions javaCodeFoldingOptions, boolean bl, FoldingBlock foldingBlock) throws InterruptedException {
        this.addDocCommentBlock((SourceMember)sourceMethod, javaCodeFoldingOptions, foldingBlock);
        JavaMethodBlock javaMethodBlock = this.createMethodBlock(sourceMethod, javaCodeFoldingOptions, bl);
        if (javaMethodBlock != null) {
            foldingBlock.add((FoldingBlock)javaMethodBlock);
        }
    }

    protected void addSourceInitializerBlock(SourceClassInitializer sourceClassInitializer, JavaCodeFoldingOptions javaCodeFoldingOptions, boolean bl, FoldingBlock foldingBlock) throws InterruptedException {
        this.addDocCommentBlock((SourceMember)sourceClassInitializer, javaCodeFoldingOptions, foldingBlock);
        JavaInitializerBlock javaInitializerBlock = this.createInitializerBlock(sourceClassInitializer, javaCodeFoldingOptions, bl);
        if (javaInitializerBlock != null) {
            foldingBlock.add((FoldingBlock)javaInitializerBlock);
        }
    }

    protected void addSourceFieldBlock(SourceFieldVariable sourceFieldVariable, JavaCodeFoldingOptions javaCodeFoldingOptions, FoldingBlock foldingBlock) throws InterruptedException {
        this.addDocCommentBlock((SourceMember)sourceFieldVariable, javaCodeFoldingOptions, foldingBlock);
        this.addChildBlocks((SourceElement)sourceFieldVariable, javaCodeFoldingOptions, foldingBlock);
    }

    protected void addDocCommentBlock(SourceMember sourceMember, JavaCodeFoldingOptions javaCodeFoldingOptions, FoldingBlock foldingBlock) throws InterruptedException {
        JavadocBlock javadocBlock = this.createDocCommentBlock(sourceMember, javaCodeFoldingOptions);
        if (javadocBlock != null) {
            foldingBlock.add((FoldingBlock)javadocBlock);
        }
    }

    protected boolean isValidBlock(SourceElement sourceElement, String string) throws InterruptedException {
        if (sourceElement != null) {
            int n = sourceElement.getStartOffset();
            int n2 = sourceElement.getEndOffset();
            return this.isValidBlock(n, n2, string);
        }
        return false;
    }

    protected boolean isValidBlock(int n, int n2, String string) throws InterruptedException {
        int n3;
        BasicEditorPane basicEditorPane = this.getEditorPane();
        if (basicEditorPane == null) {
            throw new InterruptedException();
        }
        int n4 = n2 - n;
        int n5 = string.length();
        if (n4 > n5) {
            return true;
        }
        int n6 = basicEditorPane.getLineFromOffset(n);
        return n6 != (n3 = basicEditorPane.getLineFromOffset(n2));
    }

    protected static JavaCodeFoldingOptions getCodeFoldingOptions() {
        ClientSetting clientSetting = ClientSetting.findOrCreate((String)"oracle.jdeveloper");
        return (JavaCodeFoldingOptions)clientSetting.getData("JavaCodeFoldingOptions");
    }

    static {
        String string = JavaArb.getString(140);
        int n = StringUtils.getMnemonicKeyCode((String)string);
        collapseAllAction = IdeAction.get((int)COLLAPSE_ALL_CMD_ID, null, (String)string, (String)CodeMenuConstants.CATEGORY_CODE_MENU, (Integer)new Integer(n), null, null, (boolean)false);
        collapseAllAction.addController((Controller)JAVA_FOLDING_CONTROLLER);
        string = JavaArb.getString(144);
        n = StringUtils.getMnemonicKeyCode((String)string);
        collapseJavadocAction = IdeAction.get((int)COLLAPSE_JAVADOC_CMD_ID, null, (String)string, (String)CodeMenuConstants.CATEGORY_CODE_MENU, (Integer)new Integer(n), null, null, (boolean)false);
        collapseJavadocAction.addController((Controller)JAVA_FOLDING_CONTROLLER);
        string = JavaArb.getString(142);
        n = StringUtils.getMnemonicKeyCode((String)string);
        collapseMethodsAction = IdeAction.get((int)COLLAPSE_METHODS_CMD_ID, null, (String)string, (String)CodeMenuConstants.CATEGORY_CODE_MENU, (Integer)new Integer(n), null, null, (boolean)false);
        collapseMethodsAction.addController((Controller)JAVA_FOLDING_CONTROLLER);
        string = JavaArb.getString(141);
        n = StringUtils.getMnemonicKeyCode((String)string);
        expandAllAction = IdeAction.get((int)EXPAND_ALL_CMD_ID, null, (String)string, (String)CodeMenuConstants.CATEGORY_CODE_MENU, (Integer)new Integer(n), null, null, (boolean)false);
        expandAllAction.addController((Controller)JAVA_FOLDING_CONTROLLER);
        string = JavaArb.getString(145);
        n = StringUtils.getMnemonicKeyCode((String)string);
        expandJavadocAction = IdeAction.get((int)EXPAND_JAVADOC_CMD_ID, null, (String)string, (String)CodeMenuConstants.CATEGORY_CODE_MENU, (Integer)new Integer(n), null, null, (boolean)false);
        expandJavadocAction.addController((Controller)JAVA_FOLDING_CONTROLLER);
        string = JavaArb.getString(143);
        n = StringUtils.getMnemonicKeyCode((String)string);
        expandMethodsAction = IdeAction.get((int)EXPAND_METHODS_CMD_ID, null, (String)string, (String)CodeMenuConstants.CATEGORY_CODE_MENU, (Integer)new Integer(n), null, null, (boolean)false);
        expandMethodsAction.addController((Controller)JAVA_FOLDING_CONTROLLER);
        KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
        keyStrokeContextRegistry.addAcceleratorDefinitionFile(JavaCodeFoldingPlugin.class.getClassLoader(), "oracle/jdevimpl/java/folding/accelerators.xml");
    }

    static BasicEditorPane mav$getEditorPane(JavaCodeFoldingPlugin javaCodeFoldingPlugin) {
        return javaCodeFoldingPlugin.getEditorPane();
    }

    static CodeFoldingMargin mav$getMargin(JavaCodeFoldingPlugin javaCodeFoldingPlugin) {
        return javaCodeFoldingPlugin.getMargin();
    }

    static void mav$updateModelImmediate(JavaCodeFoldingPlugin javaCodeFoldingPlugin, JavaCodeFoldingModel javaCodeFoldingModel, SourceFile sourceFile, int n, JavaCodeFoldingOptions javaCodeFoldingOptions) {
        javaCodeFoldingPlugin.updateModelImmediate(javaCodeFoldingModel, sourceFile, n, javaCodeFoldingOptions);
    }

    static int ra$COLLAPSE_ALL_CMD_ID() {
        return COLLAPSE_ALL_CMD_ID;
    }

    static int ra$COLLAPSE_JAVADOC_CMD_ID() {
        return COLLAPSE_JAVADOC_CMD_ID;
    }

    static int ra$COLLAPSE_METHODS_CMD_ID() {
        return COLLAPSE_METHODS_CMD_ID;
    }

    static int ra$EXPAND_ALL_CMD_ID() {
        return EXPAND_ALL_CMD_ID;
    }

    static int ra$EXPAND_JAVADOC_CMD_ID() {
        return EXPAND_JAVADOC_CMD_ID;
    }

    static int ra$EXPAND_METHODS_CMD_ID() {
        return EXPAND_METHODS_CMD_ID;
    }

    public final class 2
    implements Runnable {
        private final /* synthetic */ JavaCodeFoldingModel v$model;
        private final /* synthetic */ Object v$root;
        private final /* synthetic */ int v$changeId;
        final /* synthetic */ JavaCodeFoldingPlugin this$0;

        public void run() {
            BasicEditorPane basicEditorPane = JavaCodeFoldingPlugin.mav$getEditorPane(this.this$0);
            if (basicEditorPane != null) {
                CodeFoldingMargin codeFoldingMargin = JavaCodeFoldingPlugin.mav$getMargin(this.this$0);
                int n = basicEditorPane.getCaretPosition();
                this.v$model.setRoot(this.v$root, this.v$changeId);
                codeFoldingMargin.expandEnclosingBlocks(n);
                codeFoldingMargin.repaint();
            }
        }

        public 2(JavaCodeFoldingPlugin javaCodeFoldingPlugin, JavaCodeFoldingModel javaCodeFoldingModel, Object object, int n) {
            this.v$changeId = n;
            this.v$root = object;
            this.v$model = javaCodeFoldingModel;
            this.this$0 = javaCodeFoldingPlugin;
        }
    }

    public final class 1
    implements Runnable {
        private final /* synthetic */ JavaCodeFoldingModel v$model;
        private final /* synthetic */ SourceFile v$sourceFile;
        private final /* synthetic */ int v$changeId;
        final /* synthetic */ JavaCodeFoldingPlugin this$0;

        public void run() {
            JavaCodeFoldingPlugin.mav$updateModelImmediate(this.this$0, this.v$model, this.v$sourceFile, this.v$changeId, null);
            this.this$0.modelUpdateThread = null;
        }

        public 1(JavaCodeFoldingPlugin javaCodeFoldingPlugin, JavaCodeFoldingModel javaCodeFoldingModel, SourceFile sourceFile, int n) {
            this.v$changeId = n;
            this.v$sourceFile = sourceFile;
            this.v$model = javaCodeFoldingModel;
            this.this$0 = javaCodeFoldingPlugin;
        }
    }

    private static final class JavaCodeFoldingController
    implements Controller {
        public boolean update(IdeAction ideAction, Context context) {
            CodeFoldingMargin codeFoldingMargin = JavaCodeFoldingController.getCodeFoldingMargin(context);
            return JavaCodeFoldingController.update(ideAction, codeFoldingMargin);
        }

        public boolean handleEvent(IdeAction ideAction, Context context) {
            CodeFoldingMargin codeFoldingMargin = JavaCodeFoldingController.getCodeFoldingMargin(context);
            int n = ideAction.getCommandId();
            if (n == JavaCodeFoldingPlugin.ra$COLLAPSE_ALL_CMD_ID()) {
                JavaCodeFoldingController.setExpansion(codeFoldingMargin, null, false);
                return true;
            }
            if (n == JavaCodeFoldingPlugin.ra$COLLAPSE_JAVADOC_CMD_ID()) {
                JavaCodeFoldingController.setExpansion(codeFoldingMargin, JavadocBlock.class, false);
                return true;
            }
            if (n == JavaCodeFoldingPlugin.ra$COLLAPSE_METHODS_CMD_ID()) {
                JavaCodeFoldingController.setExpansion(codeFoldingMargin, JavaMethodBlock.class, false);
                return true;
            }
            if (n == JavaCodeFoldingPlugin.ra$EXPAND_ALL_CMD_ID()) {
                JavaCodeFoldingController.setExpansion(codeFoldingMargin, null, true);
                return true;
            }
            if (n == JavaCodeFoldingPlugin.ra$EXPAND_JAVADOC_CMD_ID()) {
                JavaCodeFoldingController.setExpansion(codeFoldingMargin, JavadocBlock.class, true);
                return true;
            }
            if (n == JavaCodeFoldingPlugin.ra$EXPAND_METHODS_CMD_ID()) {
                JavaCodeFoldingController.setExpansion(codeFoldingMargin, JavaMethodBlock.class, true);
                return true;
            }
            return false;
        }

        private static boolean update(IdeAction ideAction, CodeFoldingMargin codeFoldingMargin) {
            int n = ideAction.getCommandId();
            if (n == JavaCodeFoldingPlugin.ra$COLLAPSE_ALL_CMD_ID() || n == JavaCodeFoldingPlugin.ra$COLLAPSE_JAVADOC_CMD_ID() || n == JavaCodeFoldingPlugin.ra$COLLAPSE_METHODS_CMD_ID() || n == JavaCodeFoldingPlugin.ra$EXPAND_ALL_CMD_ID() || n == JavaCodeFoldingPlugin.ra$EXPAND_JAVADOC_CMD_ID() || n == JavaCodeFoldingPlugin.ra$EXPAND_METHODS_CMD_ID()) {
                boolean bl = JavaCodeFoldingController.isFoldingActionEnabled(codeFoldingMargin);
                ideAction.setEnabled(bl);
                return true;
            }
            return false;
        }

        private static CodeFoldingMargin getCodeFoldingMargin(Context context) {
            CodeEditor codeEditor;
            BasicEditorPane basicEditorPane;
            View view;
            if (context != null && (view = context.getView()) instanceof CodeEditor && (basicEditorPane = (codeEditor = (CodeEditor)view).getFocusedEditorPane()) != null) {
                Object object = basicEditorPane.getProperty("code-folding-margin");
                return (CodeFoldingMargin)object;
            }
            return null;
        }

        private static boolean isFoldingActionEnabled(CodeFoldingMargin codeFoldingMargin) {
            CodeFoldingModel codeFoldingModel;
            if (codeFoldingMargin != null && (codeFoldingModel = codeFoldingMargin.getModel()) != null) {
                codeFoldingModel.readLock();
                try {
                    Object object = codeFoldingModel.getRoot();
                    if (object != null) {
                        boolean bl = true;
                        codeFoldingModel.readUnlock();
                        return bl;
                    }
                }
                finally {
                    codeFoldingModel.readUnlock();
                }
            }
            return false;
        }

        private static void setExpansion(CodeFoldingMargin codeFoldingMargin, Class clazz, boolean bl) {
            CodeFoldingModel codeFoldingModel = codeFoldingMargin.getModel();
            codeFoldingModel.readLock();
            try {
                FoldingBlock foldingBlock = (FoldingBlock)codeFoldingModel.getRoot();
                if (foldingBlock != null) {
                    JavaCodeFoldingController.foldChildren(codeFoldingMargin, clazz, bl, foldingBlock);
                    codeFoldingMargin.repaint();
                }
            }
            finally {
                codeFoldingModel.readUnlock();
            }
        }

        private static void foldChildren(CodeFoldingMargin codeFoldingMargin, Class clazz, boolean bl, FoldingBlock foldingBlock) {
            Iterator iterator = foldingBlock.getChildren();
            while (iterator.hasNext()) {
                AbstractJavaFoldingBlock abstractJavaFoldingBlock = (AbstractJavaFoldingBlock)((Object)iterator.next());
                if (clazz == null || abstractJavaFoldingBlock.getClass().isAssignableFrom(clazz)) {
                    codeFoldingMargin.setExpansionState((Object)abstractJavaFoldingBlock, bl);
                }
                JavaCodeFoldingController.foldChildren(codeFoldingMargin, clazz, bl, (FoldingBlock)abstractJavaFoldingBlock);
            }
        }

        private JavaCodeFoldingController() {
        }

        JavaCodeFoldingController(1 var1_1) {
            this();
        }

        static boolean maS$update(IdeAction ideAction, CodeFoldingMargin codeFoldingMargin) {
            return JavaCodeFoldingController.update(ideAction, codeFoldingMargin);
        }

        public final class 1 {
        }
    }
}

