/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.imports;

import oracle.javatools.parser.AbstractLexer;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.java.v2.scanner.JavaLexer;

public class ArrayedJavaLexer
extends JavaLexer {
    private LexerToken[] tokenHistory;
    private int historyCenter;

    public ArrayedJavaLexer(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("bad history: " + n);
        }
        this.historyCenter = n;
        this.tokenHistory = new LexerToken[n * 2 + 1];
    }

    public LexerToken[] getTokenHistory() {
        return this.tokenHistory;
    }

    public int getCurrentIndex() {
        return this.historyCenter;
    }

    public void setPosition(int n) {
        super.setPosition(n);
        this.clearTokenHistory();
    }

    protected void clearTokenHistory() {
        if (this.tokenHistory != null) {
            int n = this.tokenHistory.length;
            int n2 = 0;
            while (n2 < n) {
                this.tokenHistory[n2] = null;
                ++n2;
            }
        }
    }

    public void backup() {
        throw new IllegalStateException("backup not available");
    }

    public int lex(LexerToken lexerToken) {
        int n = this.tokenHistory.length;
        LexerToken lexerToken2 = this.tokenHistory[0];
        if (this.tokenHistory[this.historyCenter] != null) {
            System.arraycopy(this.tokenHistory, 1, this.tokenHistory, 0, n - 1);
            this.tokenHistory[n - 1] = null;
        }
        int n2 = this.historyCenter;
        while (n2 < n) {
            if (this.tokenHistory[n2] == null) {
                LexerToken lexerToken3;
                if (lexerToken2 == null) {
                    lexerToken3 = super.createLexerToken();
                } else {
                    lexerToken3 = lexerToken2;
                    lexerToken2 = null;
                }
                super.lex(lexerToken3);
                this.tokenHistory[n2] = lexerToken3;
            }
            ++n2;
        }
        if (lexerToken != null) {
            this.copyCenterToken(lexerToken);
        }
        return this.tokenHistory[this.historyCenter].getToken();
    }

    private void copyCenterToken(LexerToken lexerToken) {
        AbstractLexer.DefaultLexerToken defaultLexerToken = (AbstractLexer.DefaultLexerToken)this.tokenHistory[this.historyCenter];
        AbstractLexer.DefaultLexerToken defaultLexerToken2 = (AbstractLexer.DefaultLexerToken)lexerToken;
        defaultLexerToken2.setToken(defaultLexerToken.getToken());
        defaultLexerToken2.setStartOffset(defaultLexerToken.getStartOffset());
        defaultLexerToken2.setEndOffset(defaultLexerToken.getEndOffset());
    }
}

