/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.imports;

import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.beans.PropertyChangeEvent;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JViewport;
import javax.swing.ListModel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.undo.UndoableEdit;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.config.ClientSetting;
import oracle.ide.config.IdeSettings;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.IdeAction;
import oracle.ide.keyboard.KeyStrokeMap;
import oracle.ide.keyboard.KeyStrokeOptions;
import oracle.ide.keyboard.KeyStrokes;
import oracle.ide.model.Observer;
import oracle.ide.model.Project;
import oracle.ide.model.UpdateMessage;
import oracle.ide.util.ArraySortedSet;
import oracle.javatools.buffer.OffsetMark;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.ActionHookInvoker;
import oracle.javatools.editor.BasicAction;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.FeedbackManager;
import oracle.javatools.editor.insight.AbstractInsight;
import oracle.javatools.editor.insight.InsightData;
import oracle.javatools.editor.insight.InsightProvider;
import oracle.javatools.editor.insight.InsightView;
import oracle.javatools.editor.insight.ListDataItem;
import oracle.javatools.editor.insight.ListDataItemListModel;
import oracle.javatools.editor.insight.ListInsightData;
import oracle.javatools.editor.insight.ListInsightView;
import oracle.javatools.editor.language.NumberRange;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.editor.popup.PopupWindow;
import oracle.javatools.editor.popup.PopupWindowListener;
import oracle.javatools.editor.popup.PopupWindowManager;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceError;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceImport;
import oracle.javatools.parser.java.v2.scanner.JavaLexer;
import oracle.javatools.parser.java.v2.util.filter.AnnotationFilter;
import oracle.javatools.parser.java.v2.util.filter.JavaFilter;
import oracle.javatools.parser.java.v2.write.SourceTransaction;
import oracle.javatools.parser.util.AsyncScheduler;
import oracle.javatools.parser.util.AsyncTask;
import oracle.javatools.util.Copyable;
import oracle.jdeveloper.audit.java.JavaTransformContext;
import oracle.jdeveloper.audit.transform.UndoableEditCommand;
import oracle.jdeveloper.icons.JavaIcons;
import oracle.jdeveloper.java.CacheSupport;
import oracle.jdeveloper.java.JavaClassLocator;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.model.JavaSourceNode;
import oracle.jdevimpl.java.JavaArb;
import oracle.jdevimpl.java.JavaParserPlugin;
import oracle.jdevimpl.java.imports.ImportController;
import oracle.jdevimpl.java.imports.JavaImportOptions;

public final class ImportAssistPlugin
implements JavaParserPlugin.HelperClient,
PopupWindowListener,
Observer,
HierarchyListener,
FocusListener,
EditorPlugin,
ChangeListener,
CaretListener,
ActionHookInvoker,
ActionListener {
    private static final boolean DEBUG_VERBOSE = false;
    private BasicEditorPane editor;
    private JViewport viewport;
    private Timer updateTimer;
    private Project project;
    private JavaSourceNode javaNode;
    private long cancelEndTime;
    private static final int CANCEL_PERIOD_TIMEOUT = 10000;
    private static final int SHORT_DELAY = 1000;
    private static final int LONG_DELAY = 5000;
    private JavaManager smJavaManager;
    private int smChangeId;
    private SourceFile smFile;
    private SourceError[] smErrors;
    private Map asClassMap;
    private static final String PLUGIN_KEY = ImportAssistPlugin.class.getName();
    private String[] importChoices;
    private SourceError importError;
    private Rectangle importRect;
    private PopupWindow importPopup;
    private AssistInsight assistInsight;
    private boolean inModify;
    private static AsyncScheduler asScheduler = new AsyncScheduler("ImportAssistance", 30000);
    private AssistanceTask asTask;

    public ImportAssistPlugin() {
        this.$init$();
    }

    public void notifyCompileScheduled() {
        this.stopTimer();
        this.clearSemanticErrors();
        if (!this.inModify) {
            this.cancelInsight();
            this.cancelUI();
            this.cancelAssistance();
        }
    }

    public void notifyParseFinished(JavaManager javaManager, SourceFile sourceFile, int n, int n2) {
    }

    public void notifyCompileFinished(JavaManager javaManager, SourceFile sourceFile, int n, int n2) {
        SourceError[] sourceErrorArray;
        List list = sourceFile.getCompileErrors();
        if (list.isEmpty()) {
            sourceErrorArray = SourceError.EMPTY_ARRAY;
        } else {
            ArrayList<SourceError> arrayList = new ArrayList<SourceError>();
            for (SourceError sourceError : list) {
                short s = sourceError.getErrorCode();
                if (s != 56 && s != 69) continue;
                arrayList.add(sourceError);
            }
            sourceErrorArray = arrayList.toArray(new SourceError[arrayList.size()]);
        }
        this.setSemanticErrors(javaManager, sourceFile, sourceErrorArray, n);
        if (this.editor.hasFocus() && this.hasSemanticErrors()) {
            JavaImportOptions javaImportOptions = ImportAssistPlugin.getOptions();
            int n3 = javaImportOptions.getAssistPopupDelay();
            int n4 = Math.max(50, n3 - n2);
            this.restartTimer(n4);
        }
    }

    public void install(BasicEditorPane basicEditorPane) {
        this.editor = basicEditorPane;
        basicEditorPane.addFocusListener((FocusListener)this);
        basicEditorPane.addActionHookInvoker((ActionHookInvoker)this);
        basicEditorPane.addCaretListener((CaretListener)this);
        basicEditorPane.putProperty(PLUGIN_KEY, (Object)this);
        basicEditorPane.addHierarchyListener((HierarchyListener)this);
        this.updateViewportTracking();
        this.updateTimer = new Timer(2000, this);
        this.updateTimer.setRepeats(false);
        Context context = CodeEditor.getContext((BasicEditorPane)basicEditorPane);
        if (context == null) {
            throw new IllegalStateException("Unexpected null context");
        }
        this.updateContext(context);
        JavaParserPlugin.attachHelperClient(basicEditorPane, this);
    }

    private void updateContext(Context context) {
        if (this.project != null) {
            this.project.detach((Observer)this);
            this.project = null;
            this.javaNode = null;
        }
        if (context != null) {
            this.project = context.getProject();
            this.javaNode = (JavaSourceNode)context.getNode();
            if (this.project != null) {
                this.project.attach((Observer)this);
            }
        }
    }

    public void deinstall(BasicEditorPane basicEditorPane) {
        JavaParserPlugin.detachHelperClient(basicEditorPane, this);
        basicEditorPane.putProperty(PLUGIN_KEY, null);
        basicEditorPane.removeActionHookInvoker((ActionHookInvoker)this);
        basicEditorPane.removeCaretListener((CaretListener)this);
        basicEditorPane.removeHierarchyListener((HierarchyListener)this);
        this.clearViewportTracking();
        this.cancelAssistance();
        this.cancelUI();
        this.cancelInsight();
        if (this.updateTimer != null) {
            this.stopTimer();
            this.updateTimer = null;
        }
        this.updateContext(null);
        Container container = basicEditorPane.getParent();
        if (container != null && container instanceof JViewport) {
            ((JViewport)container).removeChangeListener(this);
        }
        basicEditorPane.removeFocusListener((FocusListener)this);
        this.editor = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean invokeAction(String string) {
        if (string.equals("cancel")) {
            ImportAssistPlugin importAssistPlugin = this;
            synchronized (importAssistPlugin) {
                if (this.importPopup != null) {
                    this.cancelAssistance();
                    this.cancelUI();
                    this.cancelInsight();
                    this.cancelEndTime = System.currentTimeMillis() + 10000L;
                }
            }
            return false;
        }
        return false;
    }

    public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
        this.updateViewportTracking();
    }

    private void updateViewportTracking() {
        Container container = this.editor.getParent();
        if (container != this.viewport) {
            this.clearViewportTracking();
            if (container instanceof JViewport) {
                this.viewport = (JViewport)container;
                if (this.viewport != null) {
                    this.viewport.addChangeListener(this);
                }
            }
        }
    }

    private void clearViewportTracking() {
        if (this.viewport != null) {
            this.viewport.removeChangeListener(this);
            this.viewport = null;
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.cancelUI();
        this.cancelAssistance();
        this.restartTimer();
    }

    public void focusGained(FocusEvent focusEvent) {
        this.restartTimer();
    }

    public void focusLost(FocusEvent focusEvent) {
        boolean bl = focusEvent.isTemporary();
        if (!bl) {
            this.cancelInsight();
            this.clearClassMap();
            this.clearSemanticErrors();
        }
        this.stopTimer();
        this.cancelUI();
        this.cancelAssistance();
    }

    public void update(Object object, UpdateMessage updateMessage) {
        if (object instanceof Project) {
            int n = updateMessage.getMessageID();
            if (n == UpdateMessage.OBJECT_RELOADED || n == UpdateMessage.PROPERTY_SET) {
                this.clearSemanticErrors();
                this.clearClassMap();
            } else if (n == UpdateMessage.ATTRIBUTE_CHANGED) {
                // empty if block
            }
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("editor-ide-context")) {
            this.stopTimer();
            this.cancelInsight();
            this.cancelUI();
            this.cancelAssistance();
            this.clearClassMap();
            this.clearSemanticErrors();
            Context context = CodeEditor.getContext((BasicEditorPane)this.editor);
            this.updateContext(context);
        }
    }

    public void caretUpdate(CaretEvent caretEvent) {
        if (!this.inModify) {
            this.cancelInsight();
            this.cancelUI();
            this.cancelAssistance();
            this.restartTimer();
        }
    }

    private void stopTimer() {
        this.updateTimer.stop();
    }

    private void restartTimer() {
        JavaImportOptions javaImportOptions = ImportAssistPlugin.getOptions();
        int n = javaImportOptions.getAssistPopupDelay();
        this.restartTimer(n);
    }

    private void restartTimer(int n) {
        JavaImportOptions javaImportOptions;
        this.stopTimer();
        if (this.hasSemanticErrors() && (javaImportOptions = ImportAssistPlugin.getOptions()).getAssistEnablePopup()) {
            this.updateTimer.setInitialDelay(n);
            this.updateTimer.restart();
        }
    }

    private static JavaImportOptions getOptions() {
        JavaImportOptions javaImportOptions = (JavaImportOptions)Ide.getSettings().getData("JavaImportOptions");
        if (javaImportOptions == null) {
            javaImportOptions = new JavaImportOptions();
            ClientSetting.findOrCreate((String)"oracle.jdeveloper").putData("JavaImportOptions", (Copyable)javaImportOptions);
        }
        return javaImportOptions;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        long l = System.currentTimeMillis();
        int n = (int)(this.cancelEndTime - l);
        if (n <= 0) {
            this.scheduleAssistance();
        } else {
            this.restartTimer(Math.max(100, n));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void popupClosed(PopupWindow popupWindow, int n) {
        ImportAssistPlugin importAssistPlugin = this;
        synchronized (importAssistPlugin) {
            this.importPopup = null;
        }
    }

    public void editorFocusGained(PopupWindow popupWindow) {
    }

    public void editorFocusLost(PopupWindow popupWindow, boolean bl) {
    }

    void $init$() {
        this.cancelEndTime = System.currentTimeMillis();
        this.inModify = false;
        this.asTask = null;
    }

    private TextBuffer getTextBuffer() {
        return this.getDocument().getTextBuffer();
    }

    private BasicDocument getDocument() {
        return (BasicDocument)this.editor.getDocument();
    }

    private void showFeedback(String string) {
        FeedbackManager feedbackManager;
        if (this.editor != null && (feedbackManager = this.editor.getFeedbackManager()) != null) {
            feedbackManager.showFeedback(this.editor, string);
        }
    }

    private void showTemporaryFeedback(String string, int n) {
        FeedbackManager feedbackManager = this.editor.getFeedbackManager();
        if (feedbackManager != null) {
            feedbackManager.showFeedback(this.editor, string, n);
        }
    }

    private JavaManager getJavaManager() {
        return this.smJavaManager;
    }

    private SourceFile getSourceFile() {
        return this.smFile;
    }

    private boolean hasSemanticErrors() {
        SourceError[] sourceErrorArray = this.getSemanticErrors();
        int n = sourceErrorArray == null ? 0 : sourceErrorArray.length;
        return n > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SourceError[] getSemanticErrors() {
        SourceError[] sourceErrorArray;
        ImportAssistPlugin importAssistPlugin = this;
        synchronized (importAssistPlugin) {
            sourceErrorArray = this.smErrors;
        }
        return sourceErrorArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getChangeId() {
        int n;
        ImportAssistPlugin importAssistPlugin = this;
        synchronized (importAssistPlugin) {
            n = this.smChangeId;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSemanticErrors(JavaManager javaManager, SourceFile sourceFile, SourceError[] sourceErrorArray, int n) {
        ImportAssistPlugin importAssistPlugin = this;
        synchronized (importAssistPlugin) {
            this.smJavaManager = javaManager;
            this.smFile = sourceFile;
            this.smErrors = sourceErrorArray;
            this.smChangeId = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearSemanticErrors() {
        ImportAssistPlugin importAssistPlugin = this;
        synchronized (importAssistPlugin) {
            this.smJavaManager = null;
            this.smErrors = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getClassMap() {
        Map map;
        ImportAssistPlugin importAssistPlugin = this;
        synchronized (importAssistPlugin) {
            map = this.asClassMap;
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setClassMap(Map map) {
        ImportAssistPlugin importAssistPlugin = this;
        synchronized (importAssistPlugin) {
            this.asClassMap = map;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearClassMap() {
        ImportAssistPlugin importAssistPlugin = this;
        synchronized (importAssistPlugin) {
            this.asClassMap = null;
        }
    }

    private static ImportAssistPlugin lookupPlugin(BasicEditorPane basicEditorPane) {
        return (ImportAssistPlugin)basicEditorPane.getProperty(PLUGIN_KEY);
    }

    static void invokeImportAssistance(BasicEditorPane basicEditorPane) {
        ImportAssistPlugin importAssistPlugin = ImportAssistPlugin.lookupPlugin(basicEditorPane);
        if (importAssistPlugin != null) {
            importAssistPlugin.respondUI();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void respondUI() {
        Rectangle rectangle;
        SourceError sourceError;
        String[] stringArray;
        ImportAssistPlugin importAssistPlugin = this;
        synchronized (importAssistPlugin) {
            if (this.importPopup != null) {
                PopupWindowManager popupWindowManager = PopupWindowManager.getPopupWindowManager((BasicEditorPane)this.editor);
                popupWindowManager.dismissPopup(this.importPopup);
                this.importPopup = null;
            } else if (this.project != null) {
                String string = JavaArb.getString(175);
                this.showTemporaryFeedback(string, 1000);
                this.stopTimer();
                this.cancelEndTime = System.currentTimeMillis();
                this.scheduleAssistance();
                return;
            }
            stringArray = this.importChoices;
            this.importChoices = null;
            sourceError = this.importError;
            this.importError = null;
            rectangle = this.importRect;
            this.importRect = null;
        }
        if (stringArray != null) {
            if (stringArray.length == 1) {
                this.insertImport(stringArray[0], sourceError);
            } else {
                this.showInsight(stringArray, rectangle, sourceError);
            }
        }
    }

    private void insertImport(String string, SourceError sourceError) {
        block20: {
            TextBuffer textBuffer = this.getTextBuffer();
            SourceFile sourceFile = sourceError.getOwningSourceFile();
            int n = 0;
            List list = sourceFile.getSourceImports();
            for (SourceImport sourceImport : list) {
                n = Math.max(n, sourceImport.getEndOffset());
            }
            String string2 = null;
            int n2 = -1;
            int n3 = -1;
            try {
                JavaLexer javaLexer = new JavaLexer();
                LexerToken lexerToken = javaLexer.createLexerToken();
                javaLexer.setTextBuffer((ReadTextBuffer)textBuffer);
                javaLexer.setPosition(sourceError.getStartOffset());
                javaLexer.setSkipComments(true);
                javaLexer.setRecognizeSQLJ(true);
                int n4 = javaLexer.lex(lexerToken);
                if (n4 == 124) {
                    n4 = javaLexer.lex(lexerToken);
                }
                if (n4 == 4) {
                    String string3;
                    n2 = lexerToken.getStartOffset();
                    n3 = lexerToken.getEndOffset();
                    String string4 = textBuffer.getString(n2, n3 - n2);
                    int n5 = string.lastIndexOf(46);
                    String string5 = string3 = n5 != -1 ? string.substring(n5 + 1) : string;
                    if (!string4.equals(string3)) {
                        string2 = string3;
                    }
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            textBuffer.writeLock();
            try {
                UndoableEdit undoableEdit;
                this.inModify = true;
                OffsetMark offsetMark = null;
                OffsetMark offsetMark2 = null;
                if (string2 != null) {
                    offsetMark = textBuffer.addOffsetMark(n2);
                    offsetMark2 = textBuffer.addOffsetMark(n3);
                }
                UndoableEditCommand undoableEditCommand = new UndoableEditCommand(JavaArb.getString(168), CodeEditor.getContext((BasicEditorPane)this.editor));
                boolean bl = false;
                SourceTransaction sourceTransaction = sourceFile.beginTransaction();
                try {
                    bl = JavaTransformContext.addImport((SourceFile)sourceFile, (String)string) != null;
                }
                finally {
                    if (bl) {
                        undoableEdit = sourceTransaction.commit();
                        undoableEditCommand.addEdit(undoableEdit);
                    } else {
                        sourceTransaction.abort();
                    }
                }
                if (string2 != null) {
                    n2 = offsetMark.getOffset();
                    n3 = offsetMark2.getOffset();
                    textBuffer.removeOffsetMark(offsetMark);
                    textBuffer.removeOffsetMark(offsetMark2);
                    undoableEdit = textBuffer.remove(n2, n3 - n2);
                    undoableEditCommand.addEdit(undoableEdit);
                    undoableEdit = textBuffer.insert(n2, string2.toCharArray());
                    undoableEditCommand.addEdit(undoableEdit);
                    string2 = null;
                }
                if (!undoableEditCommand.hasEdits()) break block20;
                try {
                    CommandProcessor commandProcessor = CommandProcessor.getInstance();
                    commandProcessor.invoke((Command)undoableEditCommand);
                    if (bl) {
                        String string6 = JavaArb.format(43, string);
                        this.showTemporaryFeedback(string6, 5000);
                    }
                }
                catch (Exception exception) {}
            }
            finally {
                this.inModify = false;
                textBuffer.writeUnlock();
            }
        }
        this.restartTimer();
    }

    private String getKeyText() {
        IdeAction ideAction;
        int n;
        Integer n2;
        IdeSettings ideSettings = Ide.getSettings();
        KeyStrokeOptions keyStrokeOptions = ideSettings.getKeyStrokeOptions();
        KeyStrokeMap keyStrokeMap = keyStrokeOptions.getGlobalKeyMap();
        List list = keyStrokeMap.getKeyStrokesFor(n2 = new Integer(n = (ideAction = ImportController.assistImportsAction).getCommandId()));
        if (list.size() > 0) {
            KeyStrokes keyStrokes = (KeyStrokes)list.get(0);
            return keyStrokes.toString();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showUI(SourceError sourceError, Rectangle rectangle, String[] stringArray) {
        if (this.editor == null || !this.editor.isShowing()) {
            return;
        }
        ImportAssistPlugin importAssistPlugin = this;
        synchronized (importAssistPlugin) {
            this.clearAssistance();
            String string = this.getKeyText();
            if (string == null || string.length() == 0) {
                String string2 = JavaArb.getString(173);
                this.showTemporaryFeedback(string2, 5000);
                return;
            }
            this.importChoices = stringArray;
            this.importError = sourceError;
            this.importRect = rectangle;
            int n = stringArray == null ? 0 : stringArray.length;
            String[] stringArray2 = new String[n];
            int n2 = 0;
            while (n2 < n) {
                stringArray2[n2] = ImportAssistPlugin.getClassPackageDisplayText(stringArray[n2]);
                ++n2;
            }
            Arrays.sort(stringArray2, String.CASE_INSENSITIVE_ORDER);
            String string3 = stringArray2[0];
            int n3 = string3.indexOf(40);
            if (n3 != -1) {
                String string4 = string3.substring(n3 + 1, string3.length() - 1);
                String string5 = string3.substring(0, n3 - 1);
                string3 = string4 + "." + string5;
            }
            int n4 = stringArray.length == 1 ? 171 : 172;
            String string6 = JavaArb.format(n4, string3, string);
            JLabel jLabel = new JLabel(string6);
            jLabel.setOpaque(true);
            Border border = UIManager.getBorder("ToolTip.border");
            Border border2 = BorderFactory.createEmptyBorder(2, 2, 2, 2);
            CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(border, border2);
            jLabel.setBorder(compoundBorder);
            LookAndFeel.installColorsAndFont(jLabel, "ToolTip.background", "ToolTip.foreground", "ToolTip.font");
            PopupWindowManager popupWindowManager = PopupWindowManager.getPopupWindowManager((BasicEditorPane)this.editor);
            this.importPopup = popupWindowManager.createPopup((Component)jLabel, false);
            int[] nArray = new int[]{4, 8};
            popupWindowManager.positionPopup(this.importPopup, rectangle, nArray);
            popupWindowManager.showPopup(this.importPopup, (PopupWindowListener)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelUI() {
        ImportAssistPlugin importAssistPlugin = this;
        synchronized (importAssistPlugin) {
            if (this.importPopup != null) {
                PopupWindowManager popupWindowManager = PopupWindowManager.getPopupWindowManager((BasicEditorPane)this.editor);
                popupWindowManager.dismissPopup(this.importPopup);
                this.importPopup = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showInsight(String[] stringArray, Rectangle rectangle, SourceError sourceError) {
        ImportAssistPlugin importAssistPlugin = this;
        synchronized (importAssistPlugin) {
            this.assistInsight = new AssistInsight(stringArray, rectangle, sourceError, null);
            this.editor.installPlugin((EditorPlugin)this.assistInsight);
            this.assistInsight.showInsight();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelInsight() {
        ImportAssistPlugin importAssistPlugin = this;
        synchronized (importAssistPlugin) {
            if (this.assistInsight != null) {
                this.clearInsight();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearInsight() {
        ImportAssistPlugin importAssistPlugin = this;
        synchronized (importAssistPlugin) {
            if (this.assistInsight != null) {
                AssistInsight assistInsight = this.assistInsight;
                this.assistInsight = null;
                this.editor.deinstallPlugin((EditorPlugin)assistInsight);
            }
        }
        this.restartTimer();
    }

    private static String getClassPackageDisplayText(String string) {
        int n = string.lastIndexOf(46);
        if (n != -1) {
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            return string3 + " (" + string2 + ")";
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleAssistance() {
        if (!this.editor.isEditable() || this.project == null || !this.hasSemanticErrors()) {
            return;
        }
        boolean bl = false;
        AssistanceTask assistanceTask = new AssistanceTask(this, null);
        ImportAssistPlugin importAssistPlugin = this;
        synchronized (importAssistPlugin) {
            if (this.asTask != null) {
                asScheduler.cancelTask((AsyncTask)this.asTask);
            }
            this.asTask = assistanceTask;
            if (this.assistInsight != null || this.importPopup != null) {
                bl = true;
            }
        }
        if (!bl) {
            asScheduler.scheduleTask((AsyncTask)assistanceTask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelAssistance() {
        AssistanceTask assistanceTask;
        ImportAssistPlugin importAssistPlugin = this;
        synchronized (importAssistPlugin) {
            assistanceTask = this.asTask;
            this.asTask = null;
        }
        if (assistanceTask != null) {
            asScheduler.cancelTask((AsyncTask)assistanceTask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearAssistance() {
        ImportAssistPlugin importAssistPlugin = this;
        synchronized (importAssistPlugin) {
            this.asTask = null;
        }
    }

    static String maS$getClassPackageDisplayText(String string) {
        return ImportAssistPlugin.getClassPackageDisplayText(string);
    }

    static void mav$insertImport(ImportAssistPlugin importAssistPlugin, String string, SourceError sourceError) {
        importAssistPlugin.insertImport(string, sourceError);
    }

    static JavaManager mav$getJavaManager(ImportAssistPlugin importAssistPlugin) {
        return importAssistPlugin.getJavaManager();
    }

    static void mav$clearInsight(ImportAssistPlugin importAssistPlugin) {
        importAssistPlugin.clearInsight();
    }

    static SourceError[] mav$getSemanticErrors(ImportAssistPlugin importAssistPlugin) {
        return importAssistPlugin.getSemanticErrors();
    }

    static int mav$getChangeId(ImportAssistPlugin importAssistPlugin) {
        return importAssistPlugin.getChangeId();
    }

    static void mav$clearSemanticErrors(ImportAssistPlugin importAssistPlugin) {
        importAssistPlugin.clearSemanticErrors();
    }

    static BasicEditorPane ra$editor(ImportAssistPlugin importAssistPlugin) {
        return importAssistPlugin.editor;
    }

    static JavaImportOptions maS$getOptions() {
        return ImportAssistPlugin.getOptions();
    }

    static void mav$showTemporaryFeedback(ImportAssistPlugin importAssistPlugin, String string, int n) {
        importAssistPlugin.showTemporaryFeedback(string, n);
    }

    static SourceFile mav$getSourceFile(ImportAssistPlugin importAssistPlugin) {
        return importAssistPlugin.getSourceFile();
    }

    static JavaSourceNode ra$javaNode(ImportAssistPlugin importAssistPlugin) {
        return importAssistPlugin.javaNode;
    }

    static Project ra$project(ImportAssistPlugin importAssistPlugin) {
        return importAssistPlugin.project;
    }

    static void mav$showUI(ImportAssistPlugin importAssistPlugin, SourceError sourceError, Rectangle rectangle, String[] stringArray) {
        importAssistPlugin.showUI(sourceError, rectangle, stringArray);
    }

    private static final class AssistDataItem
    extends ListDataItem
    implements Comparable {
        private String asName;
        private Icon asIcon;
        private String displayName;

        private AssistDataItem(String string, Icon icon) {
            this.asName = string;
            this.asIcon = icon;
            this.displayName = ImportAssistPlugin.maS$getClassPackageDisplayText(this.asName);
        }

        public Icon getIcon() {
            return this.asIcon;
        }

        public String getDisplayText() {
            return this.displayName;
        }

        public String getName() {
            return this.asName;
        }

        public int compareTo(Object object) {
            String string = this.getDisplayText();
            String string2 = ((AssistDataItem)object).getDisplayText();
            return string.compareToIgnoreCase(string2);
        }

        AssistDataItem(String string, Icon icon, 1 var3_3) {
            this(string, icon);
        }

        public final class 1 {
        }
    }

    private final class AssistData
    implements ListInsightData {
        private ListDataItem[] asData;
        private ListModel asModel;
        private SourceError asError;

        private AssistData(String[] stringArray, SourceError sourceError) {
            int n = stringArray.length;
            this.asData = new ListDataItem[n];
            this.asError = sourceError;
            Icon icon = JavaIcons.getIcon(1);
            Icon icon2 = JavaIcons.getIcon(0);
            JavaManager javaManager = ImportAssistPlugin.mav$getJavaManager(ImportAssistPlugin.this);
            CacheSupport cacheSupport = javaManager.getCacheSupport();
            cacheSupport.beginCacheUse();
            try {
                int n2 = 0;
                while (n2 < n) {
                    JavaClass javaClass = javaManager.getClass(stringArray[n2]);
                    Icon icon3 = javaClass != null && javaClass.isInterface() ? icon : icon2;
                    this.asData[n2] = new AssistDataItem(stringArray[n2], icon3, null);
                    ++n2;
                }
            }
            finally {
                cacheSupport.endCacheUse();
            }
            Arrays.sort(this.asData);
        }

        public ListModel getListModel() {
            if (this.asModel == null) {
                this.asModel = new ListDataItemListModel(this.asData);
            }
            return this.asModel;
        }

        public Object[] getData() {
            return this.asData;
        }

        public Object[] getMatchingData() {
            return this.asData;
        }

        public int getMatchingDataCount() {
            return this.asData.length;
        }

        public Object getDefault() {
            return this.asData[0];
        }

        public boolean complete(Object object) {
            ImportAssistPlugin.mav$insertImport(ImportAssistPlugin.this, ((ListDataItem)object).getName(), this.asError);
            return false;
        }

        public void partialComplete() {
        }

        AssistData(String[] stringArray, SourceError sourceError, 1 var4_4) {
            this(stringArray, sourceError);
        }

        public final class 1 {
        }
    }

    private final class AssistInsight
    extends AbstractInsight
    implements InsightProvider {
        private InsightData asData;
        private Rectangle asRect;

        private AssistInsight(String[] stringArray, Rectangle rectangle, SourceError sourceError) {
            this.asData = new AssistData(stringArray, sourceError, null);
            this.asRect = rectangle;
        }

        public void install(BasicEditorPane basicEditorPane) {
            super.install(basicEditorPane);
        }

        public void deinstall(BasicEditorPane basicEditorPane) {
            super.deinstall(basicEditorPane);
        }

        protected InsightProvider createInsightProvider() {
            return this;
        }

        public boolean isInsightTriggerChar(char c) {
            return false;
        }

        public void characterTyped(BasicEditorPane basicEditorPane, int n, char c) {
        }

        public Rectangle getShowRectangle() {
            return this.asRect;
        }

        protected void updateInsight() {
        }

        public void hideInsight() {
            super.hideInsight();
            ImportAssistPlugin.mav$clearInsight(ImportAssistPlugin.this);
        }

        protected int[] getPreferredLocations() {
            return AbstractInsight.TOOLTIP_LOCATIONS;
        }

        public InsightData getInsightData(BasicEditorPane basicEditorPane) {
            return this.asData;
        }

        public InsightData updateInsightData(BasicEditorPane basicEditorPane, InsightData insightData) {
            return insightData;
        }

        public InsightView getInsightView() {
            return new ListInsightView();
        }

        AssistInsight(String[] stringArray, Rectangle rectangle, SourceError sourceError, 1 var5_5) {
            this(stringArray, rectangle, sourceError);
        }

        public final class 1 {
        }
    }

    private static final class AssistanceTask
    extends AsyncTask {
        private ImportAssistPlugin asPlugin;
        private Project asProject;
        private JavaSourceNode asNode;
        private boolean asCancelled;

        private AssistanceTask(ImportAssistPlugin importAssistPlugin) {
            this.asPlugin = importAssistPlugin;
            this.asNode = ImportAssistPlugin.ra$javaNode(importAssistPlugin);
            this.asProject = ImportAssistPlugin.ra$project(importAssistPlugin);
            this.asCancelled = false;
        }

        protected void requestCancelImpl() {
            this.asCancelled = true;
        }

        protected boolean isCancelledImpl() {
            return this.asCancelled;
        }

        public Object runImpl() throws AsyncTask.CancelledException {
            JavaImportOptions javaImportOptions;
            if (!this.asNode.isOpen() || this.asNode.isReadOnly()) {
                return null;
            }
            TextBuffer textBuffer = this.asNode.acquireTextBuffer();
            if (textBuffer == null) {
                return null;
            }
            this.bailIfCancelled();
            SourceError[] sourceErrorArray = ImportAssistPlugin.mav$getSemanticErrors(this.asPlugin);
            int n = ImportAssistPlugin.mav$getChangeId(this.asPlugin);
            textBuffer.readLock();
            try {
                int n2 = textBuffer.getChangeId();
                if (n2 != n) {
                    sourceErrorArray = null;
                    ImportAssistPlugin.mav$clearSemanticErrors(this.asPlugin);
                    n = n2;
                }
            }
            finally {
                textBuffer.readUnlock();
            }
            this.bailIfCancelled();
            if (sourceErrorArray == null || sourceErrorArray.length == 0) {
                return null;
            }
            BasicEditorPane basicEditorPane = ImportAssistPlugin.ra$editor(this.asPlugin);
            NumberRange numberRange = AssistanceTask.taskGetVisibleOffsets(basicEditorPane, textBuffer);
            int n3 = numberRange.start;
            int n4 = numberRange.end;
            this.bailIfCancelled();
            SourceError[] sourceErrorArray2 = AssistanceTask.taskGetVisibleErrors(sourceErrorArray, n3, n4);
            this.bailIfCancelled();
            int n5 = sourceErrorArray2.length;
            if (n5 == 0) {
                return null;
            }
            String[] stringArray = AssistanceTask.taskGetClassNames(sourceErrorArray2, textBuffer, n);
            Set set = AssistanceTask.taskFilterClassNames(stringArray, javaImportOptions = ImportAssistPlugin.maS$getOptions());
            if (set.size() == 0) {
                return null;
            }
            this.bailIfCancelled();
            int n6 = basicEditorPane.getCaretPosition();
            SourceError sourceError = null;
            String[] stringArray2 = null;
            String string = null;
            int n7 = 0;
            while (n7 < n5) {
                this.bailIfCancelled();
                String string2 = stringArray[n7];
                if (AssistanceTask.isValidClassName(string2, javaImportOptions)) {
                    int n8;
                    int n9;
                    String string3;
                    int n10;
                    SourceError sourceError2 = sourceErrorArray2[n7];
                    boolean bl = false;
                    if (sourceError2.getStartOffset() <= n6 && n6 <= sourceError2.getEndOffset() && (n10 = (string3 = textBuffer.getString(n9 = sourceError2.getStartOffset(), (n8 = sourceError2.getEndOffset()) - n9)).indexOf(string2)) != -1) {
                        int n11 = n9 + n10;
                        int n12 = n11 + string2.length();
                        if (n11 <= n6 && n6 <= n12) {
                            bl = true;
                        }
                    }
                    JavaManager javaManager = ImportAssistPlugin.mav$getJavaManager(this.asPlugin);
                    JavaClassLocator javaClassLocator = javaManager.getJavaClassLocator();
                    Collection collection = bl ? javaClassLocator.getClassesByPrefix(string2, true) : javaClassLocator.getClassesByName(string2, true);
                    this.bailIfCancelled();
                    if (collection == null) {
                        if (string == null) {
                            string = JavaArb.format(174, string2);
                            ImportAssistPlugin.mav$showTemporaryFeedback(this.asPlugin, string, 5000);
                        }
                    } else {
                        int n13;
                        if (javaImportOptions.getCheckPackageAccess()) {
                            SourceFile sourceFile = sourceError2.getOwningSourceFile();
                            String string4 = sourceFile.getPackageName();
                            AnnotationFilter annotationFilter = null;
                            try {
                                SourceFile sourceFile2 = ImportAssistPlugin.mav$getSourceFile(this.asPlugin);
                                SourceElement sourceElement = sourceFile2.getElementAt(n6);
                                if (sourceElement != null) {
                                    if (sourceElement != null && sourceElement.getSymbolKind() == 21) {
                                        sourceElement = sourceElement.getParent();
                                    }
                                    if (sourceElement != null && sourceElement.getSymbolKind() == 1) {
                                        annotationFilter = new AnnotationFilter();
                                    }
                                }
                            }
                            catch (RuntimeException runtimeException) {
                                annotationFilter = null;
                            }
                            CacheSupport cacheSupport = javaManager.getCacheSupport();
                            try {
                                cacheSupport.beginCacheUse();
                                collection = this.taskFilterVisibleClasses(javaManager, string4, collection, (JavaFilter)annotationFilter);
                            }
                            finally {
                                cacheSupport.endCacheUse();
                            }
                        }
                        if ((n13 = collection.size()) > 0) {
                            stringArray2 = collection.toArray(new String[n13]);
                            sourceError = sourceErrorArray2[n7];
                            break;
                        }
                    }
                }
                ++n7;
            }
            this.bailIfCancelled();
            if (sourceError != null) {
                Rectangle rectangle;
                SourceError sourceError3 = sourceError;
                String[] stringArray3 = stringArray2;
                try {
                    rectangle = basicEditorPane.modelToView(sourceError3.getStartOffset());
                }
                catch (BadLocationException badLocationException) {
                    Object var46_45 = null;
                    return var46_45;
                }
                1 var43_46 = new 1(this, sourceError3, rectangle, stringArray3);
                SwingUtilities.invokeLater(var43_46);
            }
            return null;
        }

        private static boolean isErrorVisible(SourceError sourceError, int n, int n2) {
            int n3 = sourceError.getEndOffset();
            int n4 = sourceError.getStartOffset();
            if (n < n3 && n3 <= n2) {
                return true;
            }
            return n <= n4 && n4 < n2;
        }

        private static String getPackageName(String string) {
            int n = string.lastIndexOf(46);
            String string2 = n != -1 ? string.substring(0, n) : "";
            return string2;
        }

        private static String stripName(String string) {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            if (string.startsWith("new ")) {
                string = string.substring(4);
            }
            if ((n5 = string.indexOf(91)) != -1) {
                string = string.substring(0, n5);
            }
            if ((n4 = string.indexOf(46)) != -1) {
                string = string.substring(0, n4);
            }
            if ((n3 = string.indexOf(60)) != -1) {
                string = string.substring(0, n3);
            }
            if ((n2 = string.indexOf(40)) != -1) {
                string = string.substring(0, n2);
            }
            if ((n = string.indexOf(41)) != -1) {
                string = string.substring(0, n);
            }
            return string.trim();
        }

        private static NumberRange taskGetVisibleOffsets(BasicEditorPane basicEditorPane, TextBuffer textBuffer) {
            if (basicEditorPane == null) {
                return null;
            }
            Rectangle rectangle = basicEditorPane.getVisibleRect();
            if (rectangle == null) {
                return null;
            }
            textBuffer.readLock();
            try {
                int n = BasicAction.getFontHeight((BasicEditorPane)basicEditorPane);
                int n2 = n * 3 / 4;
                Point point = new Point(rectangle.x, rectangle.y + n2);
                int n3 = basicEditorPane.viewToModel(point);
                Point point2 = new Point(rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1 - n2);
                int n4 = basicEditorPane.viewToModel(point2);
                if (n3 == -1 || n4 == -1) {
                    NumberRange numberRange = null;
                    textBuffer.readUnlock();
                    return numberRange;
                }
                int n5 = basicEditorPane.getLineFromOffset(n3);
                int n6 = basicEditorPane.getLineFromOffset(n4);
                n3 = Math.min(n3, basicEditorPane.getLineStartOffset(n5));
                n4 = Math.max(n4, basicEditorPane.getLineEndOffset(n6));
                NumberRange numberRange = new NumberRange(n3, n4);
                textBuffer.readUnlock();
                return numberRange;
            }
            catch (Throwable throwable) {
                textBuffer.readUnlock();
                throw throwable;
            }
        }

        private static SourceError[] taskGetVisibleErrors(SourceError[] sourceErrorArray, int n, int n2) {
            int n3;
            int n4 = n3 = sourceErrorArray != null ? sourceErrorArray.length : 0;
            if (n3 == 0) {
                return new SourceError[0];
            }
            ArrayList<SourceError> arrayList = new ArrayList<SourceError>();
            int n5 = 0;
            while (n5 < n3) {
                SourceError sourceError = sourceErrorArray[n5];
                if (AssistanceTask.isErrorVisible(sourceError, n, n2)) {
                    arrayList.add(sourceError);
                }
                ++n5;
            }
            int n6 = arrayList.size();
            return arrayList.toArray(new SourceError[n6]);
        }

        private static String[] taskGetClassNames(SourceError[] sourceErrorArray, TextBuffer textBuffer, int n) {
            int n2 = sourceErrorArray.length;
            String[] stringArray = new String[n2];
            textBuffer.readLock();
            try {
                if (textBuffer.getChangeId() != n) {
                    String[] stringArray2 = null;
                    textBuffer.readUnlock();
                    return stringArray2;
                }
                int n3 = 0;
                while (n3 < n2) {
                    SourceError sourceError = sourceErrorArray[n3];
                    int n4 = sourceError.getStartOffset();
                    int n5 = sourceError.getEndOffset();
                    String string = textBuffer.getString(n4, n5 - n4);
                    stringArray[n3] = AssistanceTask.stripName(string);
                    ++n3;
                }
            }
            finally {
                textBuffer.readUnlock();
            }
            return stringArray;
        }

        private static boolean isValidClassName(String string, JavaImportOptions javaImportOptions) {
            int n;
            int n2 = n = string == null ? 0 : string.length();
            if (n == 0) {
                return false;
            }
            if (javaImportOptions.getIgnoreShortClasses() && n <= 2) {
                return false;
            }
            return !javaImportOptions.getIgnoreNonUppercase() || Character.isUpperCase(string.charAt(0));
        }

        private static Set taskFilterClassNames(String[] stringArray, JavaImportOptions javaImportOptions) {
            ArraySortedSet arraySortedSet = new ArraySortedSet();
            int n = stringArray == null ? 0 : stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                if (AssistanceTask.isValidClassName(string, javaImportOptions)) {
                    arraySortedSet.add(string);
                }
                ++n2;
            }
            return arraySortedSet;
        }

        private List taskFilterVisibleClasses(JavaManager javaManager, String string, Collection collection, JavaFilter javaFilter) {
            ArrayList<String> arrayList = new ArrayList<String>();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                int n;
                String string2 = iterator.next().toString();
                String string3 = AssistanceTask.getPackageName(string2);
                JavaClass javaClass = javaManager.getClass(string2);
                if (javaFilter != null && javaClass != null && !javaFilter.accepts((JavaElement)javaClass)) continue;
                if (string.equals(string3)) {
                    arrayList.add(string2);
                    continue;
                }
                if (javaClass == null || !Modifier.isPublic(n = javaClass.getModifiers())) continue;
                arrayList.add(string2);
            }
            return arrayList;
        }

        AssistanceTask(ImportAssistPlugin importAssistPlugin, 1 var2_2) {
            this(importAssistPlugin);
        }

        static ImportAssistPlugin ra$asPlugin(AssistanceTask assistanceTask) {
            return assistanceTask.asPlugin;
        }

        public final class 1
        implements Runnable {
            private final /* synthetic */ SourceError v$fixError;
            private final /* synthetic */ Rectangle v$fixRect;
            private final /* synthetic */ String[] v$fixChoices;
            final /* synthetic */ AssistanceTask this$0;

            public void run() {
                if (!this.this$0.isCancelledImpl()) {
                    ImportAssistPlugin.mav$showUI(AssistanceTask.ra$asPlugin(this.this$0), this.v$fixError, this.v$fixRect, this.v$fixChoices);
                }
            }

            public 1(AssistanceTask assistanceTask, SourceError sourceError, Rectangle rectangle, String[] stringArray) {
                this.v$fixChoices = stringArray;
                this.v$fixRect = rectangle;
                this.v$fixError = sourceError;
                this.this$0 = assistanceTask;
            }
        }
    }
}

