/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.imports;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.CodeEditorGutter;
import oracle.ide.ceditor.CodeMenuConstants;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.DynamicMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.editor.EditorManager;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.model.Node;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.view.View;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.gutter.GutterMark;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdeveloper.model.JavaSourceNode;
import oracle.jdevimpl.java.Context2ParserHelper;
import oracle.jdevimpl.java.JavaArb;
import oracle.jdevimpl.java.editing.JavaImplOverPlugin;
import oracle.jdevimpl.java.imports.ImportAssistPlugin;
import oracle.jdevimpl.java.imports.JavaNavigationUtilities;
import oracle.jdevimpl.java.imports.SurroundWithDialog;

public final class ImportController
implements DynamicMenuListener,
CodeMenuConstants,
ContextMenuListener,
Controller {
    private IdeAction completeStatementAction;
    private IdeAction expandSelectionAction;
    private IdeAction narrowSelectionAction;
    private IdeAction gotoNextMethodAction;
    private IdeAction gotoNextFieldAction;
    private IdeAction gotoNextClassAction;
    private IdeAction gotoNextMemberAction;
    private IdeAction gotoPreviousMethodAction;
    private IdeAction gotoPreviousFieldAction;
    private IdeAction gotoPreviousClassAction;
    private IdeAction gotoPreviousMemberAction;
    private IdeAction surroundWithAction;
    private JMenuItem surroundWithMenuItem;
    static IdeAction assistImportsAction;
    private JMenuItem gotoImplementedMenuItem;
    private IdeAction gotoImplementedAction;
    private JMenuItem gotoOverriddenMenuItem;
    private IdeAction gotoOverriddenAction;
    private JComponent[] dynamicItems;

    public ImportController() {
        EditorManager editorManager = EditorManager.getEditorManager();
        ContextMenu contextMenu = editorManager.getContextMenu();
        if (contextMenu != null) {
            contextMenu.addContextMenuListener((ContextMenuListener)this);
        }
        if ((contextMenu = CodeEditorGutter.getGutterContextMenu()) != null) {
            contextMenu.addContextMenuListener((ContextMenuListener)this);
        }
        this.initializeActions();
        this.initializeDynamicActions();
        Ide.getMainWindow().addDynamicMenuListener((DynamicMenuListener)this);
        KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
        keyStrokeContextRegistry.addAcceleratorDefinitionFile(this.getClass().getClassLoader(), "oracle/jdevimpl/java/imports/accelerators.xml");
    }

    public void shutdown() {
        EditorManager editorManager = EditorManager.getEditorManager();
        ContextMenu contextMenu = editorManager.getContextMenu();
        if (contextMenu != null) {
            contextMenu.removeContextMenuListener((ContextMenuListener)this);
        }
        if ((contextMenu = CodeEditorGutter.getGutterContextMenu()) != null) {
            contextMenu.removeContextMenuListener((ContextMenuListener)this);
        }
        Ide.getMainWindow().removeDynamicMenuListener((DynamicMenuListener)this);
    }

    private IdeAction initActionHelper(String string, String string2, String string3, ArrayResourceBundle arrayResourceBundle, int n) {
        int n2 = StringUtils.getMnemonicKeyCode((String)string);
        string = StringUtils.stripMnemonic((String)string);
        IdeAction ideAction = IdeAction.get((int)Ide.findOrCreateCmdID((String)string2), null, (String)string, (String)string3, (Integer)new Integer(n2), (ArrayResourceBundle)arrayResourceBundle, (int)n, null, (boolean)true);
        ideAction.addController((Controller)this);
        return ideAction;
    }

    private void initializeActions() {
        this.completeStatementAction = this.initActionHelper("C&omplete Statement", "ojji.CompleteStatement", CodeMenuConstants.CATEGORY_CODE_MENU, JavaArb.getInstance(), 180);
        this.expandSelectionAction = this.initActionHelper(JavaArb.getString(179), "ojji.ExpandSelection", CodeMenuConstants.CATEGORY_CODE_MENU, JavaArb.getInstance(), 180);
        this.narrowSelectionAction = this.initActionHelper(JavaArb.getString(181), "ojji.NarrowSelection", CodeMenuConstants.CATEGORY_CODE_MENU, JavaArb.getInstance(), 182);
        this.gotoNextMethodAction = this.initActionHelper(JavaArb.getString(183), "ojji.GotoNextMethod", "Navigate", JavaArb.getInstance(), 191);
        this.gotoPreviousMethodAction = this.initActionHelper(JavaArb.getString(184), "ojji.GotoPreviousMethod", "Navigate", JavaArb.getInstance(), 192);
        this.gotoNextFieldAction = this.initActionHelper(JavaArb.getString(185), "ojji.GotoNextField", "Navigate", JavaArb.getInstance(), 193);
        this.gotoPreviousFieldAction = this.initActionHelper(JavaArb.getString(186), "ojji.GotoPreviousField", "Navigate", JavaArb.getInstance(), 194);
        this.gotoNextClassAction = this.initActionHelper(JavaArb.getString(187), "ojji.GotoNextClass", "Navigate", JavaArb.getInstance(), 195);
        this.gotoPreviousClassAction = this.initActionHelper(JavaArb.getString(188), "ojji.GotoPreviousClass", "Navigate", JavaArb.getInstance(), 196);
        this.gotoNextMemberAction = this.initActionHelper(JavaArb.getString(189), "ojji.GotoNextMember", "Navigate", JavaArb.getInstance(), 197);
        this.gotoPreviousMemberAction = this.initActionHelper(JavaArb.getString(190), "ojji.GotoPreviousMember", "Navigate", JavaArb.getInstance(), 198);
        assistImportsAction = this.initActionHelper(JavaArb.getString(169), "ojji.ImportAssistance", CodeMenuConstants.CATEGORY_CODE_MENU, JavaArb.getInstance(), 170);
        this.surroundWithAction = this.initActionHelper(JavaArb.getString(199), "ojji.SurroundWith", CodeMenuConstants.CATEGORY_CODE_MENU, JavaArb.getInstance(), 200);
        this.gotoImplementedAction = this.initActionHelper(JavaArb.getString(328), "ojji.GotoImplementedMethod", IdeMainWindow.ACTION_CATEGORY_NAVIGATE, JavaArb.getInstance(), 329);
        this.gotoOverriddenAction = this.initActionHelper(JavaArb.getString(330), "ojji.GotoOverriddenMethod", IdeMainWindow.ACTION_CATEGORY_NAVIGATE, JavaArb.getInstance(), 331);
        Menubar menubar = Ide.getMenubar();
        JMenu jMenu = MenuManager.getJMenu((String)"Navigate");
        JMenuItem jMenuItem = menubar.createMenuItem((ToggleAction)this.gotoNextMemberAction, JDeveloperMenuConstants.WEIGHT_NAVIGATE_GO_TO_NEXT_MEMBER);
        menubar.add((Component)jMenuItem, jMenu, JDeveloperMenuConstants.SECTION_NAVIGATE_GOTO_MEMBER);
        JMenuItem jMenuItem2 = menubar.createMenuItem((ToggleAction)this.gotoPreviousMemberAction, JDeveloperMenuConstants.WEIGHT_NAVIGATE_GO_TO_PREVIOUS_MEMBER);
        menubar.add((Component)jMenuItem2, jMenu, JDeveloperMenuConstants.SECTION_NAVIGATE_GOTO_MEMBER);
        this.surroundWithMenuItem = menubar.createMenuItem((ToggleAction)this.surroundWithAction, 500.0f);
        this.gotoImplementedMenuItem = menubar.createMenuItem((ToggleAction)this.gotoImplementedAction);
        this.gotoOverriddenMenuItem = menubar.createMenuItem((ToggleAction)this.gotoOverriddenAction);
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        Node node = context.getNode();
        CodeEditor codeEditor = null;
        CodeEditorGutter codeEditorGutter = null;
        BasicEditorPane basicEditorPane = null;
        if (node instanceof JavaSourceNode) {
            View view = context.getView();
            if (view instanceof CodeEditor) {
                codeEditor = (CodeEditor)view;
                basicEditorPane = codeEditor.getFocusedEditorPane();
            } else if (view instanceof CodeEditorGutter.GutterView) {
                codeEditorGutter = (CodeEditorGutter)view.getGUI();
                codeEditor = codeEditorGutter.getCodeEditor();
                basicEditorPane = codeEditor.getFocusedEditorPane();
            }
        }
        if (ideAction == assistImportsAction) {
            if (basicEditorPane != null && basicEditorPane.isEditable()) {
                ImportAssistPlugin.invokeImportAssistance(basicEditorPane);
            }
            return true;
        }
        if (ideAction == this.surroundWithAction) {
            if (basicEditorPane != null && basicEditorPane.isEditable()) {
                IdeMainWindow ideMainWindow = Ide.getMainWindow();
                SurroundWithDialog surroundWithDialog = new SurroundWithDialog();
                surroundWithDialog.performSurroundsWith(basicEditorPane, context, (JFrame)ideMainWindow);
            }
            return true;
        }
        if (ideAction == this.completeStatementAction) {
            if (basicEditorPane != null) {
                JavaNavigationUtilities.expandStatement(basicEditorPane, context);
            }
            return true;
        }
        if (ideAction == this.expandSelectionAction) {
            if (basicEditorPane != null) {
                JavaNavigationUtilities.expandSelection(basicEditorPane, context);
            }
            return true;
        }
        if (ideAction == this.narrowSelectionAction) {
            if (basicEditorPane != null) {
                JavaNavigationUtilities.narrowSelection(basicEditorPane, context);
            }
            return true;
        }
        if (ideAction == this.gotoNextMethodAction) {
            if (basicEditorPane != null) {
                JavaNavigationUtilities.navigateTo(basicEditorPane, context, 0);
            }
            return true;
        }
        if (ideAction == this.gotoPreviousMethodAction) {
            if (basicEditorPane != null) {
                JavaNavigationUtilities.navigateTo(basicEditorPane, context, 1);
            }
            return true;
        }
        if (ideAction == this.gotoNextFieldAction) {
            if (basicEditorPane != null) {
                JavaNavigationUtilities.navigateTo(basicEditorPane, context, 2);
            }
            return true;
        }
        if (ideAction == this.gotoPreviousFieldAction) {
            if (basicEditorPane != null) {
                JavaNavigationUtilities.navigateTo(basicEditorPane, context, 3);
            }
            return true;
        }
        if (ideAction == this.gotoNextClassAction) {
            if (basicEditorPane != null) {
                JavaNavigationUtilities.navigateTo(basicEditorPane, context, 4);
            }
            return true;
        }
        if (ideAction == this.gotoPreviousClassAction) {
            if (basicEditorPane != null) {
                JavaNavigationUtilities.navigateTo(basicEditorPane, context, 5);
            }
            return true;
        }
        if (ideAction == this.gotoNextMemberAction) {
            if (basicEditorPane != null) {
                JavaNavigationUtilities.navigateTo(basicEditorPane, context, 6);
            }
            return true;
        }
        if (ideAction == this.gotoPreviousMemberAction) {
            if (basicEditorPane != null) {
                JavaNavigationUtilities.navigateTo(basicEditorPane, context, 7);
            }
            return true;
        }
        if (ideAction == this.gotoImplementedAction || ideAction == this.gotoOverriddenAction) {
            boolean bl = ideAction == this.gotoImplementedAction;
            JavaImplOverPlugin.ImplOverItem implOverItem = this.getImplOverItem(bl, context, codeEditor, codeEditorGutter, basicEditorPane);
            if (implOverItem != null) {
                implOverItem.gotoImplOverItem();
            }
            return true;
        }
        return false;
    }

    private JavaImplOverPlugin.ImplOverItem getImplOverItem(boolean bl, Context context, CodeEditor codeEditor, CodeEditorGutter codeEditorGutter, BasicEditorPane basicEditorPane) {
        if (basicEditorPane != null) {
            int n = -1;
            if (codeEditorGutter != null) {
                n = CodeEditorGutter.getLineForContext((Context)context);
            } else if (codeEditor != null) {
                int n2 = basicEditorPane.getCaretPosition();
                n = basicEditorPane.getLineFromOffset(n2) + 1;
            }
            if (n != -1) {
                return JavaImplOverPlugin.getImplOverItem(basicEditorPane, n, bl);
            }
        }
        return null;
    }

    public boolean update(IdeAction ideAction, Context context) {
        View view = context.getView();
        CodeEditor codeEditor = null;
        CodeEditorGutter codeEditorGutter = null;
        BasicEditorPane basicEditorPane = null;
        if (view instanceof CodeEditor) {
            codeEditor = (CodeEditor)view;
        } else if (view instanceof CodeEditorGutter.GutterView) {
            codeEditorGutter = (CodeEditorGutter)view.getGUI();
            codeEditor = codeEditorGutter.getCodeEditor();
        }
        if (codeEditor != null) {
            basicEditorPane = codeEditor.getFocusedEditorPane();
        }
        if (ideAction == assistImportsAction || ideAction == this.surroundWithAction) {
            Node node;
            ideAction.setEnabled(false);
            boolean bl = false;
            if (basicEditorPane != null && (node = context.getNode()) instanceof JavaSourceNode) {
                bl = basicEditorPane.isEditable();
            }
            ideAction.setEnabled(bl);
            return true;
        }
        if (ideAction == this.gotoNextMethodAction || ideAction == this.gotoNextFieldAction || ideAction == this.gotoPreviousFieldAction || ideAction == this.gotoNextClassAction || ideAction == this.gotoPreviousClassAction || ideAction == this.gotoNextMemberAction || ideAction == this.gotoPreviousMemberAction || ideAction == this.gotoPreviousMethodAction) {
            if (view instanceof CodeEditor && context.getNode() instanceof JavaSourceNode) {
                ideAction.setEnabled(true);
                return true;
            }
            ideAction.setEnabled(false);
            return true;
        }
        if (ideAction == this.expandSelectionAction || ideAction == this.narrowSelectionAction || ideAction == this.completeStatementAction) {
            if (view instanceof CodeEditor && context.getNode() instanceof JavaSourceNode) {
                Context2ParserHelper context2ParserHelper = Context2ParserHelper.createHelper(context);
                if (context2ParserHelper.getSourceFile() == null) {
                    ideAction.setEnabled(false);
                } else {
                    ideAction.setEnabled(true);
                }
                return true;
            }
            ideAction.setEnabled(false);
            return true;
        }
        if (ideAction == this.gotoImplementedAction || ideAction == this.gotoOverriddenAction) {
            boolean bl = false;
            if (basicEditorPane != null) {
                boolean bl2 = ideAction == this.gotoImplementedAction;
                JavaImplOverPlugin.ImplOverItem implOverItem = this.getImplOverItem(bl2, context, codeEditor, codeEditorGutter, basicEditorPane);
                bl = implOverItem != null;
            }
            ideAction.setEnabled(bl);
            return true;
        }
        return false;
    }

    public void menuWillShow(ContextMenu contextMenu) {
        Context context = contextMenu.getContext();
        View view = context.getView();
        if (view instanceof CodeEditor) {
            CodeEditor codeEditor = (CodeEditor)view;
            Node node = context.getNode();
            if (node instanceof JavaSourceNode) {
                contextMenu.add((Component)this.surroundWithMenuItem, CodeMenuConstants.SECTION_SOURCE_CTXT_MENU);
                BasicEditorPane basicEditorPane = codeEditor.getFocusedEditorPane();
                this.surroundWithMenuItem.setEnabled(basicEditorPane.isEditable());
            }
        } else if (view instanceof CodeEditorGutter.GutterView) {
            CodeEditorGutter codeEditorGutter = (CodeEditorGutter)view.getGUI();
            CodeEditor codeEditor = codeEditorGutter.getCodeEditor();
            BasicEditorPane basicEditorPane = codeEditor.getFocusedEditorPane();
            if (CodeEditorGutter.isMarkDroppingDown((Context)context)) {
                GutterMark gutterMark = CodeEditorGutter.getMarkForContext((Context)context);
                String string = gutterMark.getGutterColumn().getColumnName();
                if ("implements-overrides-column".equals(string) && gutterMark.getUserData() instanceof List) {
                    List list = (List)gutterMark.getUserData();
                    int n = 0;
                    while (n < list.size()) {
                        JavaImplOverPlugin.ImplOverItem implOverItem = (JavaImplOverPlugin.ImplOverItem)list.get(n);
                        JMenuItem jMenuItem = contextMenu.createMenuItem(implOverItem.createGotoSourceAction());
                        contextMenu.add((Component)jMenuItem);
                        ++n;
                    }
                }
            } else {
                JavaImplOverPlugin.ImplOverItem implOverItem;
                JavaImplOverPlugin.ImplOverItem implOverItem2 = this.getImplOverItem(true, context, codeEditor, codeEditorGutter, basicEditorPane);
                if (implOverItem2 != null) {
                    contextMenu.add((Component)this.gotoImplementedMenuItem, 1.0f);
                }
                if ((implOverItem = this.getImplOverItem(false, context, codeEditor, codeEditorGutter, basicEditorPane)) != null) {
                    contextMenu.add((Component)this.gotoOverriddenMenuItem, 1.0f);
                }
            }
        }
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public boolean handleDefaultAction(Context context) {
        View view = context.getView();
        if (view instanceof CodeEditorGutter.GutterView && CodeEditorGutter.isMarkDroppingDown((Context)context)) {
            GutterMark gutterMark = CodeEditorGutter.getMarkForContext((Context)context);
            if (gutterMark.getUserData() instanceof List) {
                List list = (List)gutterMark.getUserData();
                JavaImplOverPlugin.ImplOverItem implOverItem = (JavaImplOverPlugin.ImplOverItem)list.get(0);
                implOverItem.gotoImplOverItem();
            }
            return true;
        }
        return false;
    }

    private void initializeDynamicActions() {
        Menubar menubar = Ide.getMenubar();
        ArrayList<JMenuItem> arrayList = new ArrayList<JMenuItem>();
        JMenuItem jMenuItem = menubar.createMenuItem((ToggleAction)this.surroundWithAction, 500.0f);
        arrayList.add(jMenuItem);
        JMenuItem jMenuItem2 = menubar.createMenuItem((ToggleAction)this.completeStatementAction, 125.0f);
        arrayList.add(jMenuItem2);
        JMenuItem jMenuItem3 = menubar.createMenuItem((ToggleAction)this.expandSelectionAction, 540.0f);
        arrayList.add(jMenuItem3);
        JMenuItem jMenuItem4 = menubar.createMenuItem((ToggleAction)this.narrowSelectionAction, 540.0f);
        arrayList.add(jMenuItem4);
        int n = arrayList.size();
        this.dynamicItems = arrayList.toArray(new JMenuItem[n]);
    }

    public JComponent[] gatherDynamicActions(Context context) {
        Node node;
        View view = context.getView();
        if (view instanceof CodeEditor && (node = context.getNode()) instanceof JavaSourceNode) {
            return this.dynamicItems;
        }
        return new JComponent[0];
    }
}

