/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.imports;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.ClientSetting;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.OffsetMark;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditDescriptor;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.java.v2.JavaParser;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceImport;
import oracle.javatools.parser.java.v2.model.SourcePackage;
import oracle.javatools.parser.java.v2.scanner.JavaLexer;
import oracle.jdeveloper.java.CacheSupport;
import oracle.jdeveloper.java.JavaClassLocator;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.model.JavaSourceNode;
import oracle.jdeveloper.style.CodingStyleManager;
import oracle.jdeveloper.style.CodingStyleOptions;
import oracle.jdevimpl.java.JavaArb;
import oracle.jdevimpl.java.imports.JavaImportOptions;

public final class ImportUtilities2 {
    protected static final EditDescriptor sortImportsDescriptor;
    protected static final EditDescriptor widenImportsDescriptor;
    protected static final EditDescriptor narrowImportsDescriptor;
    protected static final EditDescriptor removeUnusedImportsDescriptor;

    static {
        String string = JavaArb.getString(159);
        sortImportsDescriptor = new EditDescriptor(string);
        string = JavaArb.getString(160);
        widenImportsDescriptor = new EditDescriptor(string);
        string = JavaArb.getString(161);
        narrowImportsDescriptor = new EditDescriptor(string);
        string = "DEAD";
        removeUnusedImportsDescriptor = new EditDescriptor(string);
    }

    public static void insertImport(String string, boolean bl, SourceFile sourceFile, TextBuffer textBuffer) {
        ImportLine[] importLineArray = ImportUtilities2.getImports(sourceFile, textBuffer);
        ImportLine[] importLineArray2 = ImportUtilities2.insertImport(string, bl, sourceFile, importLineArray, textBuffer);
        ImportUtilities2.disposeImports(importLineArray2, textBuffer);
    }

    public static void insertImports(String[] stringArray, SourceFile sourceFile, TextBuffer textBuffer) {
        ImportLine[] importLineArray = ImportUtilities2.getImports(sourceFile, textBuffer);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            importLineArray = ImportUtilities2.insertImport(stringArray[n2], false, sourceFile, importLineArray, textBuffer);
            ++n2;
        }
        ImportUtilities2.disposeImports(importLineArray, textBuffer);
    }

    protected static ImportLine[] insertImport(String string, boolean bl, SourceFile sourceFile, ImportLine[] importLineArray, TextBuffer textBuffer) {
        String string2;
        String string3 = ImportUtilities2.getPackageName(sourceFile);
        if (string3.equals(string2 = ImportUtilities2.getPackageFor(string))) {
            return importLineArray;
        }
        int n = importLineArray.length;
        String string4 = ImportUtilities2.getImportText(string, bl);
        LineMap lineMap = textBuffer.getLineMap();
        if (n == 0) {
            int n2;
            int n3;
            int n4 = 0;
            SourcePackage sourcePackage = sourceFile.getSourcePackage();
            if (sourcePackage != null && ImportUtilities2.isWhitespace(textBuffer, n4 = sourcePackage.getEndOffset(), n3 = lineMap.getLineEndOffset(n2 = lineMap.getLineFromOffset(n4)))) {
                n4 = n3;
            }
            ImportLine importLine = ImportUtilities2.createAndInsertImport(string4, string, textBuffer, n4);
            if (n4 != 0) {
                ImportUtilities2.insertEmptyLine(textBuffer, n4);
            }
            return new ImportLine[]{importLine};
        }
        ImportLine importLine = null;
        ImportLine importLine2 = null;
        int n5 = 0;
        int n6 = 0;
        while (n6 < n) {
            ImportLine importLine3 = importLineArray[n6];
            String string5 = importLine3._fqName;
            int n7 = string.compareToIgnoreCase(string5);
            if (n7 < 0) {
                importLine2 = importLine3;
                break;
            }
            if (n7 <= 0) {
                return importLineArray;
            }
            importLine = importLine3;
            n5 = n6 + 1;
            ++n6;
        }
        int n8 = importLine != null ? importLine._end.getOffset() : importLine2._start.getOffset();
        ImportLine importLine4 = ImportUtilities2.createAndInsertImport(string4, string, textBuffer, n8);
        ArrayList<ImportLine> arrayList = new ArrayList<ImportLine>(Arrays.asList(importLineArray));
        arrayList.add(n5, importLine4);
        ArrayList<ImportLine> arrayList2 = new ArrayList<ImportLine>();
        arrayList2.add(importLine);
        arrayList2.add(importLine4);
        arrayList2.add(importLine2);
        arrayList2.remove(null);
        int n9 = arrayList2.size();
        ImportLine[] importLineArray2 = arrayList2.toArray(new ImportLine[n9]);
        lineMap = textBuffer.getLineMap();
        int n10 = lineMap.getLineFromOffset(importLineArray2[0]._start.getOffset());
        int n11 = lineMap.getLineFromOffset(importLineArray2[n9 - 1]._end.getOffset());
        ImportUtilities2.removeEmptyLines(textBuffer, n10, n11);
        JavaImportOptions javaImportOptions = ImportUtilities2.getImportOptions();
        ImportUtilities2.groupImports(importLineArray2, textBuffer, javaImportOptions);
        int n12 = arrayList.size();
        return arrayList.toArray(new ImportLine[n12]);
    }

    public static void narrowImports(BasicEditorPane basicEditorPane, Context context) {
        new NarrowOperation().performOperation(basicEditorPane, context);
    }

    public static void widenImports(BasicEditorPane basicEditorPane, Context context) {
        new WidenOperation().performOperation(basicEditorPane, context);
    }

    public static void removeUnusedImports(BasicEditorPane basicEditorPane, Context context) {
        new RemoveUnusedOperation().performOperation(basicEditorPane, context);
    }

    public static void sortImports(BasicEditorPane basicEditorPane, Context context) {
        new SortOperation().performOperation(basicEditorPane, context);
    }

    protected static ImportLine[] narrowImports(ImportLine[] importLineArray, TextBuffer textBuffer) {
        ImportLine[] importLineArray2 = importLineArray;
        importLineArray = ImportUtilities2.removeUnusedImports(importLineArray, textBuffer);
        int n = importLineArray.length;
        ArrayList<ImportLine> arrayList = new ArrayList<ImportLine>(n);
        int n2 = 0;
        while (n2 < n) {
            ImportLine importLine = importLineArray[n2];
            SourceImport sourceImport = importLine._import;
            if (sourceImport == null) {
                arrayList.add(importLine);
            } else if (ImportUtilities2.isNarrowImport(importLine)) {
                arrayList.add(importLine);
            } else {
                ArrayList<String> arrayList2 = new ArrayList<String>();
                for (Object e : sourceImport.getImportedElements()) {
                    JavaHasType javaHasType;
                    JavaType javaType;
                    if (!(e instanceof JavaHasType) || (javaType = (javaHasType = (JavaHasType)e).getResolvedType()) == null) continue;
                    String string = javaType.getQualifiedName();
                    arrayList2.add(string);
                }
                Collections.sort(arrayList2, String.CASE_INSENSITIVE_ORDER);
                boolean bl = sourceImport.isStatic();
                int n3 = importLine._start.getOffset();
                OffsetMark offsetMark = textBuffer.addOffsetMark(n3, true);
                if (arrayList2.size() == 0) {
                    arrayList.add(importLine);
                } else {
                    ImportUtilities2.removeImport(importLine, textBuffer);
                    ImportUtilities2.disposeImport(importLine, textBuffer);
                    for (String string : arrayList2) {
                        String string2 = ImportUtilities2.getImportText(string, bl);
                        ImportLine importLine2 = ImportUtilities2.createAndInsertImport(string2, string, textBuffer, offsetMark.getOffset());
                        arrayList.add(importLine2);
                    }
                }
                textBuffer.removeOffsetMark(offsetMark);
            }
            ++n2;
        }
        int n4 = arrayList.size();
        return arrayList.toArray(new ImportLine[n4]);
    }

    protected static ImportLine[] widenImports(JavaClassLocator javaClassLocator, SourceFile sourceFile, ImportLine[] importLineArray, TextBuffer textBuffer) {
        String string = ImportUtilities2.getPackageName(sourceFile);
        List list = ImportUtilities2.getPackageList(importLineArray);
        list.remove("java.lang");
        list.remove(string);
        Collection collection = javaClassLocator.getClassesInPackage(string);
        HashMap<String, Collection> hashMap = new HashMap<String, Collection>();
        for (String string2 : list) {
            Collection collection2 = javaClassLocator.getClassesInPackage(string2);
            hashMap.put(string2, collection2);
        }
        hashMap.put("java.lang", javaClassLocator.getClassesInPackage("java.lang"));
        ImportLine[] importLineArray2 = ImportUtilities2.getWideImports(importLineArray);
        List list2 = ImportUtilities2.getPackageList(importLineArray2);
        ArrayList arrayList = new ArrayList(list);
        arrayList.removeAll(list2);
        int n = importLineArray.length;
        ArrayList<ImportLine> arrayList2 = new ArrayList<ImportLine>(n);
        ArrayList arrayList3 = new ArrayList(list);
        int n2 = 0;
        while (n2 < n) {
            ImportLine importLine = importLineArray[n2];
            if (ImportUtilities2.isStatic(importLine)) {
                arrayList2.add(importLine);
            } else {
                String string3 = ImportUtilities2.getPackageFor(importLine._fqName);
                if (string3.equals(string)) {
                    ImportUtilities2.removeImport(importLine, textBuffer);
                    ImportUtilities2.disposeImport(importLine, textBuffer);
                } else {
                    String string4 = ImportUtilities2.getClassFor(importLine._fqName);
                    if (collection.contains(string4)) {
                        arrayList2.add(importLine);
                    } else if (ImportUtilities2.isWideImport(importLine)) {
                        arrayList2.add(importLine);
                    } else {
                        int n3 = 0;
                        for (Collection collection3 : hashMap.values()) {
                            if (!collection3.contains(string4)) continue;
                            ++n3;
                        }
                        int n4 = importLine._end.getOffset();
                        if (n3 <= 1) {
                            n4 = importLine._start.getOffset();
                            ImportUtilities2.removeImport(importLine, textBuffer);
                            ImportUtilities2.disposeImport(importLine, textBuffer);
                        } else {
                            arrayList2.add(importLine);
                        }
                        if (string3.length() != 0 && arrayList3.contains(string3)) {
                            String string5 = string3 + ".*";
                            String string6 = ImportUtilities2.getImportText(string5, false);
                            ImportLine importLine2 = ImportUtilities2.createAndInsertImport(string6, string5, textBuffer, n4);
                            arrayList2.add(importLine2);
                            arrayList3.remove(string3);
                        }
                    }
                }
            }
            ++n2;
        }
        int n5 = arrayList2.size();
        return arrayList2.toArray(new ImportLine[n5]);
    }

    protected static ImportLine[] removeUnusedImports(ImportLine[] importLineArray, TextBuffer textBuffer) {
        int n = importLineArray.length;
        ArrayList<ImportLine> arrayList = new ArrayList<ImportLine>(n);
        int n2 = 0;
        while (n2 < n) {
            ImportLine importLine = importLineArray[n2];
            SourceImport sourceImport = importLine._import;
            if (sourceImport == null) {
                arrayList.add(importLine);
            } else if (sourceImport.isUsed()) {
                arrayList.add(importLine);
            } else {
                ImportUtilities2.removeImport(importLine, textBuffer);
                ImportUtilities2.disposeImport(importLine, textBuffer);
            }
            ++n2;
        }
        int n3 = arrayList.size();
        return arrayList.toArray(new ImportLine[n3]);
    }

    protected static ImportLine[] sortAndGroupImports(ImportLine[] importLineArray, TextBuffer textBuffer, JavaImportOptions javaImportOptions) {
        ImportLine[] importLineArray2 = ImportUtilities2.sortImports(importLineArray, textBuffer);
        ImportUtilities2.groupImports(importLineArray2, textBuffer, javaImportOptions);
        return importLineArray2;
    }

    protected static void removeImport(ImportLine importLine, TextBuffer textBuffer) {
        int n = importLine._start.getOffset();
        int n2 = importLine._end.getOffset();
        textBuffer.remove(n, n2 - n);
    }

    protected static ImportLine[] sortImports(ImportLine[] importLineArray, TextBuffer textBuffer) {
        if (importLineArray == null || importLineArray.length == 0) {
            return importLineArray;
        }
        int n = importLineArray.length;
        Object[] objectArray = new ImportLine[n];
        System.arraycopy(importLineArray, 0, objectArray, 0, n);
        Arrays.sort(objectArray);
        int n2 = 0;
        while (n2 < n) {
            ImportUtilities2.removeImport(importLineArray[n2], textBuffer);
            ++n2;
        }
        int n3 = importLineArray[0]._start.getOffset();
        int n4 = importLineArray[n - 1]._end.getOffset();
        LineMap lineMap = textBuffer.getLineMap();
        int n5 = lineMap.getLineFromOffset(n3);
        int n6 = lineMap.getLineFromOffset(n4);
        ImportUtilities2.removeEmptyLines(textBuffer, n5, n6);
        ImportLine[] importLineArray2 = new ImportLine[n];
        OffsetMark offsetMark = textBuffer.addOffsetMark(n3, true);
        int n7 = 0;
        while (n7 < n) {
            Object object = objectArray[n7];
            importLineArray2[n7] = ImportUtilities2.createAndInsertImport(((ImportLine)object)._textLine, ((ImportLine)object)._fqName, textBuffer, offsetMark.getOffset());
            ++n7;
        }
        textBuffer.removeOffsetMark(offsetMark);
        ImportUtilities2.disposeImports(importLineArray, textBuffer);
        return importLineArray2;
    }

    protected static void removeEmptyLines(TextBuffer textBuffer, int n, int n2) {
        LineMap lineMap = textBuffer.getLineMap();
        int n3 = n2 - 1;
        while (n3 >= n) {
            if (ImportUtilities2.isEmptyLine(textBuffer, n3)) {
                int n4 = lineMap.getLineStartOffset(n3);
                int n5 = lineMap.getLineEndOffset(n3);
                textBuffer.remove(n4, n5 - n4);
            }
            --n3;
        }
    }

    protected static ImportLine[] getImports(SourceFile sourceFile, TextBuffer textBuffer) {
        if (sourceFile != null) {
            ArrayList<ImportLine> arrayList = new ArrayList<ImportLine>();
            for (SourceImport sourceImport : sourceFile.getSourceImports()) {
                ImportLine importLine = ImportUtilities2.getImport(sourceImport, textBuffer);
                arrayList.add(importLine);
            }
            int n = arrayList.size();
            return arrayList.toArray(new ImportLine[n]);
        }
        return new ImportLine[0];
    }

    protected static ImportLine getImport(SourceImport sourceImport, TextBuffer textBuffer) {
        int n;
        int n2 = sourceImport.getStartOffset();
        int n3 = sourceImport.getEndOffset();
        String string = sourceImport.getName();
        String string2 = textBuffer.getString(n2, n3 - n2);
        ImportLine importLine = new ImportLine();
        importLine._sourceLine = importLine._textLine = string2;
        importLine._fqName = string;
        importLine._import = sourceImport;
        LineMap lineMap = textBuffer.getLineMap();
        int n4 = lineMap.getLineEndOffset(n = lineMap.getLineFromOffset(n3));
        if (ImportUtilities2.isWhitespace(textBuffer, n3, n4)) {
            n3 = n4;
            importLine._sourceLine = textBuffer.getString(n2, n3 - n2);
        }
        importLine._start = textBuffer.addOffsetMark(n2, true);
        importLine._end = textBuffer.addOffsetMark(n3, false);
        return importLine;
    }

    protected static ImportLine createAndInsertImport(String string, String string2, TextBuffer textBuffer, int n) {
        ImportLine importLine = new ImportLine();
        importLine._fqName = string2;
        importLine._sourceLine = string + "\n";
        importLine._textLine = string;
        int n2 = importLine._sourceLine.length();
        textBuffer.insert(n, importLine._sourceLine.toCharArray());
        importLine._start = textBuffer.addOffsetMark(n, true);
        importLine._end = textBuffer.addOffsetMark(n + n2, false);
        return importLine;
    }

    protected static void groupImports(ImportLine[] importLineArray, TextBuffer textBuffer, JavaImportOptions javaImportOptions) {
        CodingStyleManager codingStyleManager = CodingStyleManager.getCodingStyleManager();
        CodingStyleOptions codingStyleOptions = codingStyleManager.getCodingStyleOptions();
        if (codingStyleOptions.getGroupImports()) {
            int n = importLineArray.length - 1;
            int n2 = 0;
            while (n2 < n) {
                ImportLine importLine = importLineArray[n2];
                ImportLine importLine2 = importLineArray[n2 + 1];
                if (!ImportUtilities2.isGrouped(importLine, importLine2, javaImportOptions)) {
                    int n3 = importLine2._start.getOffset();
                    LineMap lineMap = textBuffer.getLineMap();
                    int n4 = lineMap.getLineFromOffset(n3);
                    int n5 = lineMap.getLineStartOffset(n4);
                    ImportUtilities2.insertEmptyLine(textBuffer, n5);
                }
                ++n2;
            }
        }
    }

    protected static boolean isGrouped(ImportLine importLine, ImportLine importLine2, JavaImportOptions javaImportOptions) {
        int n;
        String string;
        String string2 = ImportUtilities2.getPackageFor(importLine._fqName);
        if (string2.equals(string = ImportUtilities2.getPackageFor(importLine2._fqName))) {
            return true;
        }
        CodingStyleManager codingStyleManager = CodingStyleManager.getCodingStyleManager();
        CodingStyleOptions codingStyleOptions = codingStyleManager.getCodingStyleOptions();
        int n2 = codingStyleOptions.getGroupPackageDepth();
        if (n2 > 0 && (n = ImportUtilities2.getSharedPackageDepth(string2, string)) >= n2) {
            return true;
        }
        return importLine2._fqName.startsWith(importLine._fqName);
    }

    protected static boolean isEmptyLine(TextBuffer textBuffer, int n) {
        LineMap lineMap = textBuffer.getLineMap();
        int n2 = lineMap.getLineStartOffset(n);
        int n3 = lineMap.getLineEndOffset(n);
        return ImportUtilities2.isWhitespace(textBuffer, n2, n3);
    }

    protected static boolean isWhitespace(TextBuffer textBuffer, int n, int n2) {
        int n3 = n;
        while (n3 < n2) {
            char c = textBuffer.getChar(n3);
            if (!Character.isWhitespace(c)) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    protected static boolean isCommentLine(TextBuffer textBuffer, int n) {
        LineMap lineMap = textBuffer.getLineMap();
        int n2 = lineMap.getLineStartOffset(n);
        JavaLexer javaLexer = new JavaLexer(3);
        javaLexer.setRecognizeSQLJ(true);
        javaLexer.setSkipComments(false);
        javaLexer.setTextBuffer((ReadTextBuffer)textBuffer);
        javaLexer.setPosition(n2);
        LexerToken lexerToken = javaLexer.createLexerToken();
        int n3 = javaLexer.lex(lexerToken);
        switch (n3) {
            case 24: 
            case 25: 
            case 26: {
                return true;
            }
        }
        return false;
    }

    protected static void disposeImports(ImportLine[] importLineArray, TextBuffer textBuffer) {
        int n = importLineArray.length;
        int n2 = 0;
        while (n2 < n) {
            ImportUtilities2.disposeImport(importLineArray[n2], textBuffer);
            ++n2;
        }
    }

    protected static void disposeImport(ImportLine importLine, TextBuffer textBuffer) {
        textBuffer.removeOffsetMark(importLine._start);
        textBuffer.removeOffsetMark(importLine._end);
    }

    protected static boolean isWideImport(ImportLine importLine) {
        return importLine._fqName.endsWith(".*");
    }

    protected static boolean isNarrowImport(ImportLine importLine) {
        return ImportUtilities2.isWideImport(importLine) ^ true;
    }

    protected static boolean isStatic(ImportLine importLine) {
        if (importLine._import != null) {
            return importLine._import.isStatic();
        }
        return importLine._textLine.indexOf(" static ") != -1;
    }

    protected static String getImportText(String string, boolean bl) {
        String string2 = "import " + (bl ? "static " : "") + string + ";";
        return string2;
    }

    protected static void insertEmptyLine(TextBuffer textBuffer, int n) {
        textBuffer.insert(n, "\n".toCharArray());
    }

    protected static List getPackageList(ImportLine[] importLineArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = importLineArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string;
            ImportLine importLine = importLineArray[n2];
            if (!ImportUtilities2.isStatic(importLine) && (string = ImportUtilities2.getPackageFor(importLine._fqName)).length() > 0 && arrayList.indexOf(string) == -1) {
                arrayList.add(string);
            }
            ++n2;
        }
        return arrayList;
    }

    protected static ImportLine[] getNarrowImports(ImportLine[] importLineArray) {
        ArrayList<ImportLine> arrayList = new ArrayList<ImportLine>();
        int n = importLineArray.length;
        int n2 = 0;
        while (n2 < n) {
            ImportLine importLine = importLineArray[n2];
            if (ImportUtilities2.isNarrowImport(importLine)) {
                arrayList.add(importLine);
            }
            ++n2;
        }
        int n3 = arrayList.size();
        return arrayList.toArray(new ImportLine[n3]);
    }

    protected static ImportLine[] getWideImports(ImportLine[] importLineArray) {
        ArrayList<ImportLine> arrayList = new ArrayList<ImportLine>();
        int n = importLineArray.length;
        int n2 = 0;
        while (n2 < n) {
            ImportLine importLine = importLineArray[n2];
            if (ImportUtilities2.isWideImport(importLine)) {
                arrayList.add(importLine);
            }
            ++n2;
        }
        int n3 = arrayList.size();
        return arrayList.toArray(new ImportLine[n3]);
    }

    protected static String getPackageFor(String string) {
        int n = string.lastIndexOf(46);
        if (n != -1) {
            return string.substring(0, n);
        }
        return "";
    }

    protected static String getClassFor(String string) {
        int n = string.lastIndexOf(46);
        if (n != -1) {
            return string.substring(n + 1);
        }
        return string;
    }

    protected static int getSharedPackageDepth(String string, String string2) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = 0;
        int n8 = string.length();
        int n9 = 0;
        int n10 = string2.length();
        int n11 = 0;
        while (n7 < n8 && n9 < n10 && (n6 = (n5 = (n4 = string.indexOf(46, n7)) != -1 ? n4 : n8) - n7) == (n3 = (n2 = (n = string2.indexOf(46, n9)) != -1 ? n : n10) - n9) && string.regionMatches(n7, string2, n9, n6)) {
            ++n11;
            n7 = n4 != -1 ? n4 + 1 : n8;
            n9 = n != -1 ? n + 1 : n10;
        }
        return n11;
    }

    protected static JavaManager getJavaManager(Context context) {
        Project project = context.getProject();
        if (project == null) {
            project = Ide.getActiveProject();
        }
        if (project == null) {
            project = Ide.getDefaultProject();
        }
        JavaManager javaManager = JavaManager.getJavaManager(project);
        return javaManager;
    }

    protected static TextBuffer getTextBuffer(Context context) {
        JavaSourceNode javaSourceNode = ImportUtilities2.getJavaSourceNode(context);
        if (javaSourceNode != null) {
            return javaSourceNode.acquireTextBuffer();
        }
        return null;
    }

    protected static JavaSourceNode getJavaSourceNode(Context context) {
        Node node = context.getNode();
        if (node instanceof JavaSourceNode) {
            return (JavaSourceNode)node;
        }
        return null;
    }

    protected static SourceFile getParseTree(Context context) {
        JavaSourceNode javaSourceNode = ImportUtilities2.getJavaSourceNode(context);
        if (javaSourceNode != null) {
            JavaManager javaManager = ImportUtilities2.getJavaManager(context);
            return ImportUtilities2.getParseTree(javaManager, javaSourceNode);
        }
        return null;
    }

    protected static SourceFile getCompiledParseTree(Context context) {
        JavaSourceNode javaSourceNode = ImportUtilities2.getJavaSourceNode(context);
        if (javaSourceNode != null) {
            JavaManager javaManager = ImportUtilities2.getJavaManager(context);
            return ImportUtilities2.getCompiledParseTree(javaManager, javaSourceNode);
        }
        return null;
    }

    protected static SourceFile getParseTree(TextBuffer textBuffer) {
        SourceFile sourceFile = null;
        textBuffer.readLock();
        try {
            sourceFile = JavaParser.parse((ReadTextBuffer)textBuffer);
            if (sourceFile != null) {
                sourceFile.pinTextBuffer(textBuffer);
            }
        }
        finally {
            textBuffer.readUnlock();
        }
        return sourceFile;
    }

    protected static SourceFile getParseTree(JavaManager javaManager, JavaSourceNode javaSourceNode) {
        TextBuffer textBuffer = javaSourceNode.acquireTextBuffer();
        URL uRL = javaSourceNode.getURL();
        SourceFile sourceFile = null;
        textBuffer.readLock();
        try {
            sourceFile = ImportUtilities2.getParseTree(textBuffer);
            if (sourceFile != null) {
                sourceFile.setURL(uRL);
                sourceFile.setProvider((JavaProvider)javaManager);
            }
        }
        finally {
            textBuffer.readUnlock();
        }
        return sourceFile;
    }

    protected static SourceFile getCompiledParseTree(JavaManager javaManager, JavaSourceNode javaSourceNode) {
        SourceFile sourceFile;
        block6: {
            TextBuffer textBuffer = javaSourceNode.acquireTextBuffer();
            sourceFile = null;
            textBuffer.readLock();
            try {
                sourceFile = ImportUtilities2.getParseTree(javaManager, javaSourceNode);
                if (sourceFile == null) break block6;
                CacheSupport cacheSupport = javaManager.getCacheSupport();
                try {
                    cacheSupport.beginCacheUse();
                    sourceFile.compile();
                }
                finally {
                    cacheSupport.endCacheUse();
                }
            }
            finally {
                textBuffer.readUnlock();
            }
        }
        return sourceFile;
    }

    protected static String getPackageName(SourceFile sourceFile) {
        String string = sourceFile.getPackageName();
        if (string == null) {
            return "";
        }
        return string;
    }

    protected static JavaImportOptions getImportOptions() {
        ClientSetting clientSetting = ClientSetting.findOrCreate((String)"oracle.jdeveloper");
        JavaImportOptions javaImportOptions = (JavaImportOptions)clientSetting.getData("JavaImportOptions");
        return javaImportOptions;
    }

    protected static class NarrowOperation
    extends ImportOperation {
        protected ImportLine[] performOperationImpl(SourceFile sourceFile, ImportLine[] importLineArray, TextBuffer textBuffer, JavaImportOptions javaImportOptions) {
            return ImportUtilities2.narrowImports(importLineArray, textBuffer);
        }

        protected EditDescriptor getDescriptor() {
            return narrowImportsDescriptor;
        }

        protected NarrowOperation() {
        }
    }

    protected static class WidenOperation
    extends ImportOperation {
        protected ImportLine[] performOperationImpl(SourceFile sourceFile, ImportLine[] importLineArray, TextBuffer textBuffer, JavaImportOptions javaImportOptions) {
            JavaManager javaManager = (JavaManager)sourceFile.getProvider();
            JavaClassLocator javaClassLocator = javaManager.getJavaClassLocator();
            CacheSupport cacheSupport = javaManager.getCacheSupport();
            cacheSupport.beginCacheUse();
            try {
                ImportLine[] importLineArray2 = ImportUtilities2.widenImports(javaClassLocator, sourceFile, importLineArray, textBuffer);
                cacheSupport.endCacheUse();
                return importLineArray2;
            }
            catch (Throwable throwable) {
                cacheSupport.endCacheUse();
                throw throwable;
            }
        }

        protected EditDescriptor getDescriptor() {
            return widenImportsDescriptor;
        }

        protected WidenOperation() {
        }
    }

    protected static class RemoveUnusedOperation
    extends ImportOperation {
        protected ImportLine[] performOperationImpl(SourceFile sourceFile, ImportLine[] importLineArray, TextBuffer textBuffer, JavaImportOptions javaImportOptions) {
            return ImportUtilities2.removeUnusedImports(importLineArray, textBuffer);
        }

        protected EditDescriptor getDescriptor() {
            return removeUnusedImportsDescriptor;
        }

        protected RemoveUnusedOperation() {
        }
    }

    protected static class SortOperation
    extends ImportOperation {
        protected boolean needsCompile() {
            return false;
        }

        protected boolean shouldSort(JavaImportOptions javaImportOptions) {
            return true;
        }

        protected EditDescriptor getDescriptor() {
            return sortImportsDescriptor;
        }

        protected SortOperation() {
        }
    }

    protected static abstract class ImportOperation {
        protected void performOperation(BasicEditorPane basicEditorPane, Context context) {
            basicEditorPane.beginEdit(this.getDescriptor());
            try {
                TextBuffer textBuffer = ImportUtilities2.getTextBuffer(context);
                SourceFile sourceFile = this.buildParseTree(context);
                ImportLine[] importLineArray = ImportUtilities2.getImports(sourceFile, textBuffer);
                int n = -1;
                if (importLineArray.length > 0) {
                    n = importLineArray[0]._start.getOffset();
                }
                JavaImportOptions javaImportOptions = ImportUtilities2.getImportOptions();
                ImportLine[] importLineArray2 = this.performOperationImpl(sourceFile, importLineArray, textBuffer, javaImportOptions);
                if (this.shouldSort(javaImportOptions)) {
                    ImportLine[] importLineArray3 = ImportUtilities2.sortAndGroupImports(importLineArray2, textBuffer, javaImportOptions);
                    ImportUtilities2.disposeImports(importLineArray3, textBuffer);
                } else {
                    ImportUtilities2.disposeImports(importLineArray2, textBuffer);
                }
                if (n != -1 && javaImportOptions.getMoveCaret()) {
                    basicEditorPane.setCaretPositionCenter(n);
                }
            }
            finally {
                basicEditorPane.endEdit();
            }
        }

        protected SourceFile buildParseTree(Context context) {
            return this.needsCompile() ? ImportUtilities2.getCompiledParseTree(context) : ImportUtilities2.getParseTree(context);
        }

        protected boolean needsCompile() {
            return true;
        }

        protected boolean shouldSort(JavaImportOptions javaImportOptions) {
            return javaImportOptions.getSortOnOrganize();
        }

        protected ImportLine[] performOperationImpl(SourceFile sourceFile, ImportLine[] importLineArray, TextBuffer textBuffer, JavaImportOptions javaImportOptions) {
            return importLineArray;
        }

        protected abstract EditDescriptor getDescriptor();

        protected ImportOperation() {
        }
    }

    protected static class ImportLine
    implements Comparable {
        protected String _sourceLine;
        protected String _textLine;
        protected String _fqName;
        protected SourceImport _import;
        protected OffsetMark _start;
        protected OffsetMark _end;

        public int compareTo(Object object) {
            ImportLine importLine = (ImportLine)object;
            return this._fqName.compareToIgnoreCase(importLine._fqName);
        }

        public String toString() {
            return this._textLine;
        }

        protected ImportLine() {
        }
    }
}

