/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.imports;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.text.NumberFormat;
import java.util.Hashtable;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.ide.controls.ItemSelectableTracker;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.ApplyListener;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.jdevimpl.java.JavaArb;
import oracle.jdevimpl.java.imports.JavaImportOptions;

public final class JavaImportOptionsPanel
extends DefaultTraversablePanel
implements ChangeListener,
ApplyListener {
    private JCheckBox checkbox_sortOnOrganize;
    private JCheckBox checkbox_moveCaret;
    private JCheckBox checkbox_assistEnablePopup;
    private JSlider slider_assistPopupDelay;
    private JLabel label_assistPopupDelayText;
    private NumberFormat numberFormatter;

    public JavaImportOptionsPanel() {
        this.setHelpID("f1_idedidesetimports_html");
        this.setLayout(new GridBagLayout());
        this.initializeComponent();
    }

    public void onEntry(TraversableContext traversableContext) {
        JavaImportOptions javaImportOptions = this.findOptions(traversableContext);
        this.loadSettingsFrom(javaImportOptions);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        JavaImportOptions javaImportOptions = this.findOptions(traversableContext);
        this.saveSettingsTo(javaImportOptions);
    }

    private JavaImportOptions findOptions(TraversableContext traversableContext) {
        JavaImportOptions javaImportOptions = (JavaImportOptions)traversableContext.find("JavaImportOptions");
        return javaImportOptions;
    }

    public void apply(ApplyEvent applyEvent) {
        TraversableContext traversableContext = (TraversableContext)applyEvent.getSource();
        JavaImportOptions javaImportOptions = this.findOptions(traversableContext);
        JavaImportOptionsPanel.applyOptions(javaImportOptions);
    }

    public void cancel(ApplyEvent applyEvent) {
    }

    public static void applyOptions(JavaImportOptions javaImportOptions) {
    }

    public void stateChanged(ChangeEvent changeEvent) {
        float f = (float)this.slider_assistPopupDelay.getValue() / 10.0f;
        String string = JavaArb.format(237, this.numberFormatter.format(f));
        this.slider_assistPopupDelay.setToolTipText(string);
        this.label_assistPopupDelayText.setText(string);
    }

    void loadSettingsFrom(JavaImportOptions javaImportOptions) {
        boolean bl = javaImportOptions.getSortOnOrganize();
        boolean bl2 = javaImportOptions.getMoveCaret();
        this.checkbox_sortOnOrganize.setSelected(bl);
        this.checkbox_moveCaret.setSelected(bl2);
        boolean bl3 = javaImportOptions.getAssistEnablePopup();
        int n = javaImportOptions.getAssistPopupDelay();
        this.checkbox_assistEnablePopup.setSelected(bl3);
        this.slider_assistPopupDelay.setValue(n / 100);
    }

    void saveSettingsTo(JavaImportOptions javaImportOptions) throws TraversalException {
        boolean bl = this.checkbox_sortOnOrganize.isSelected();
        boolean bl2 = this.checkbox_moveCaret.isSelected();
        javaImportOptions.setSortOnOrganize(bl);
        javaImportOptions.setMoveCaret(bl2);
        int n = this.slider_assistPopupDelay.getValue() * 100;
        boolean bl3 = this.checkbox_assistEnablePopup.isSelected();
        javaImportOptions.setAssistEnablePopup(bl3);
        javaImportOptions.setAssistPopupDelay(n);
    }

    private void initializeComponent() {
        this.numberFormatter = NumberFormat.getNumberInstance();
        this.numberFormatter.setMinimumFractionDigits(1);
        this.numberFormatter.setMaximumFractionDigits(1);
        String string = JavaArb.getString(215);
        this.checkbox_sortOnOrganize = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_sortOnOrganize, (String)string);
        String string2 = JavaArb.getString(216);
        this.checkbox_moveCaret = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_moveCaret, (String)string2);
        String string3 = JavaArb.getString(217);
        this.checkbox_assistEnablePopup = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_assistEnablePopup, (String)string3);
        String string4 = JavaArb.getString(218);
        JLabel jLabel = new JLabel();
        this.slider_assistPopupDelay = new JSlider(5, 50, 25);
        this.slider_assistPopupDelay.addChangeListener(this);
        this.label_assistPopupDelayText = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.slider_assistPopupDelay, (String)string4);
        String string5 = this.numberFormatter.format(0.5);
        String string6 = this.numberFormatter.format(5.0);
        JLabel jLabel2 = new JLabel(string5);
        JLabel jLabel3 = new JLabel(string6);
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>(5);
        hashtable.put(new Integer(5), jLabel2);
        hashtable.put(new Integer(50), jLabel3);
        this.slider_assistPopupDelay.setLabelTable(hashtable);
        this.slider_assistPopupDelay.setPaintLabels(true);
        this.slider_assistPopupDelay.setPaintTicks(true);
        this.slider_assistPopupDelay.setMajorTickSpacing(5);
        this.slider_assistPopupDelay.setMinorTickSpacing(1);
        this.slider_assistPopupDelay.setSnapToTicks(true);
        Component[] componentArray = new Component[]{this.slider_assistPopupDelay, jLabel, this.label_assistPopupDelayText, jLabel2, jLabel3};
        ItemSelectableTracker itemSelectableTracker = new ItemSelectableTracker((ItemSelectable)this.checkbox_assistEnablePopup, componentArray);
        Insets insets = new Insets(2, 5, 2, 5);
        Insets insets2 = new Insets(2, 30, 2, 5);
        Insets insets3 = new Insets(2, 60, 2, 5);
        Insets insets4 = new Insets(2, 5, 2, 5);
        Insets insets5 = new Insets(0, 0, 0, 0);
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
        jPanel.add((Component)this.checkbox_sortOnOrganize, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
        jPanel.add((Component)this.checkbox_moveCaret, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
        jPanel2.add((Component)this.checkbox_assistEnablePopup, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, insets2, 0, 0);
        jPanel2.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, insets3, 0, 0);
        jPanel2.add((Component)this.label_assistPopupDelayText, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, 1, 1, 2, 1.0, 0.0, 17, 2, insets4, 0, 0);
        jPanel2.add((Component)this.slider_assistPopupDelay, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 1, insets5, 0, 0);
        this.add(jPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, insets5, 0, 0);
        this.add(Box.createVerticalStrut(10), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 1, insets5, 0, 0);
        this.add(jPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 17, 0, insets5, 0, 0);
        this.add(Box.createGlue(), gridBagConstraints);
    }
}

