/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.imports;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.model.Node;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceClassBody;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFieldDeclaration;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceFormalParameterList;
import oracle.javatools.parser.java.v2.model.SourceHasName;
import oracle.javatools.parser.java.v2.model.SourceLocalVariable;
import oracle.javatools.parser.java.v2.model.SourceLocalVariableDeclaration;
import oracle.javatools.parser.java.v2.model.SourceMember;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceListExpression;
import oracle.javatools.parser.java.v2.model.statement.SourceBlockStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceBreakStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceDoStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceElseClause;
import oracle.javatools.parser.java.v2.model.statement.SourceForStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceIfStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceSwitchStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceWhileStatement;
import oracle.javatools.parser.java.v2.write.SourceTransaction;
import oracle.jdeveloper.model.JavaSourceNode;
import oracle.jdeveloper.refactoring.util.RefactoringCommandSupport;
import oracle.jdevimpl.java.Context2ParserHelper;

public class JavaNavigationUtilities {
    public static final int ACTION_NEXT_METHOD = 0;
    public static final int ACTION_PREV_METHOD = 1;
    public static final int ACTION_NEXT_FIELD = 2;
    public static final int ACTION_PREV_FIELD = 3;
    public static final int ACTION_NEXT_CLASS = 4;
    public static final int ACTION_PREV_CLASS = 5;
    public static final int ACTION_NEXT_MEMBER = 6;
    public static final int ACTION_PREV_MEMBER = 7;
    private static BasicEditorPane _currentEditorPane = null;
    private static ArrayList _selectionStack = new ArrayList();

    public static void navigateTo(BasicEditorPane basicEditorPane, Context context, int n) {
        SourceFile sourceFile;
        Node node = context.getNode();
        if (node instanceof JavaSourceNode && (sourceFile = JavaNavigationUtilities.getSourceFile(context)) != null) {
            JavaNavigationUtilities.navigate(basicEditorPane, sourceFile, n);
        }
    }

    private static SourceFile getSourceFile(Context context) {
        Context2ParserHelper context2ParserHelper = Context2ParserHelper.createHelper(context);
        return context2ParserHelper.getSourceFile();
    }

    private static void checkExpandStack(BasicEditorPane basicEditorPane, int n, int n2) {
        if (_currentEditorPane == basicEditorPane && _selectionStack.size() > 0) {
            Point point = (Point)_selectionStack.get(_selectionStack.size() - 1);
            if (point.x == n && point.y == n2) {
                return;
            }
        }
        _currentEditorPane = basicEditorPane;
        _selectionStack.clear();
        _selectionStack.add(new Point(n, n2));
    }

    public static void narrowSelection(BasicEditorPane basicEditorPane, Context context) {
        int n = basicEditorPane.getSelectionStart();
        int n2 = basicEditorPane.getSelectionEnd();
        JavaNavigationUtilities.checkExpandStack(basicEditorPane, n, n2);
        if (_selectionStack.size() > 0) {
            _selectionStack.remove(_selectionStack.size() - 1);
        }
        if (_selectionStack.size() > 0) {
            Point point = (Point)_selectionStack.get(_selectionStack.size() - 1);
            basicEditorPane.select(point.x, point.y);
        }
    }

    public static void expandSelection(BasicEditorPane basicEditorPane, Context context) {
        JotProxyElementV2 jotProxyElementV2;
        int n = basicEditorPane.getSelectionStart();
        int n2 = basicEditorPane.getSelectionEnd();
        JavaNavigationUtilities.checkExpandStack(basicEditorPane, n, n2);
        SourceFile sourceFile = JavaNavigationUtilities.getSourceFile(context);
        if (sourceFile == null) {
            return;
        }
        JotProxyElementV2 jotProxyElementV22 = jotProxyElementV2 = new JotProxyElementV2((SourceElement)sourceFile, basicEditorPane);
        while (jotProxyElementV22 != null) {
            jotProxyElementV2 = jotProxyElementV22;
            JotProxyElementV2[] jotProxyElementV2Array = jotProxyElementV22.getContainedElements();
            jotProxyElementV22 = null;
            int n3 = 0;
            while (jotProxyElementV22 == null && n3 < jotProxyElementV2Array.length) {
                int n4 = jotProxyElementV2Array[n3].getStartOffset();
                int n5 = jotProxyElementV2Array[n3].getEndOffset();
                if (n4 <= n && n5 >= n2 && (n4 != n || n5 != n2)) {
                    jotProxyElementV22 = jotProxyElementV2Array[n3];
                }
                ++n3;
            }
        }
        int n6 = basicEditorPane.getDocument().getLength();
        Point point = new Point(jotProxyElementV2.getStartOffset(), jotProxyElementV2.getEndOffset());
        if (point.x < 0) {
            point.x = 0;
        }
        if (point.y > n6 || point.y < 0) {
            point.y = n6;
        }
        if (point.x <= n && point.y >= n2) {
            _selectionStack.add(point);
            basicEditorPane.select(point.x, point.y);
        }
    }

    private static int[] prunePositions(SourceFile sourceFile, int n) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        switch (n) {
            case 0: 
            case 1: {
                bl2 = true;
                break;
            }
            case 2: 
            case 3: {
                bl3 = true;
                break;
            }
            case 4: 
            case 5: {
                bl = true;
                break;
            }
            case 6: 
            case 7: {
                bl3 = true;
                bl = true;
                bl2 = true;
            }
        }
        ArrayList arrayList = new ArrayList();
        for (SourceClass sourceClass : sourceFile.getClasses()) {
            JavaNavigationUtilities.recPruneClass(arrayList, sourceClass, bl, bl2, bl3);
        }
        int[] nArray = new int[arrayList.size()];
        int n2 = 0;
        while (n2 < arrayList.size()) {
            Integer n3 = (Integer)arrayList.get(n2);
            nArray[n2] = n3;
            ++n2;
        }
        Arrays.sort(nArray);
        return nArray;
    }

    private static void recPruneClass(ArrayList arrayList, SourceClass sourceClass, boolean bl, boolean bl2, boolean bl3) {
        if (bl) {
            Integer n = JavaNavigationUtilities.getOffset((SourceHasName)sourceClass);
            arrayList.add(n);
        }
        for (SourceFieldDeclaration sourceFieldDeclaration : sourceClass.getSourceFieldDeclarations()) {
            if (bl3) {
                Integer n;
                List list = sourceFieldDeclaration.getVariables();
                if (list != null && list.size() > 0) {
                    SourceVariable sourceVariable = (SourceVariable)list.get(0);
                    n = JavaNavigationUtilities.getOffset((SourceHasName)sourceVariable);
                } else {
                    n = new Integer(sourceFieldDeclaration.getStartOffset());
                }
                arrayList.add(n);
            }
            JavaNavigationUtilities.recPruneElement(arrayList, (SourceElement)sourceFieldDeclaration, bl, bl2, bl3);
        }
        Iterator iterator = sourceClass.getSourceMethods().iterator();
        JavaNavigationUtilities.recPruneMethods(arrayList, iterator, bl, bl2, bl3);
        iterator = sourceClass.getSourceConstructors().iterator();
        JavaNavigationUtilities.recPruneMethods(arrayList, iterator, bl, bl2, bl3);
        Iterator iterator2 = sourceClass.getDeclaredClasses().iterator();
        while (iterator2.hasNext()) {
            JavaNavigationUtilities.recPruneClass(arrayList, (SourceClass)iterator2.next(), bl, bl2, bl3);
        }
    }

    private static Integer getOffset(SourceHasName sourceHasName) {
        SourceName sourceName = sourceHasName.getNameElement();
        int n = sourceName != null ? sourceName.getStartOffset() : sourceHasName.getStartOffset();
        return new Integer(n);
    }

    private static void recPruneElement(ArrayList arrayList, SourceElement sourceElement, boolean bl, boolean bl2, boolean bl3) {
        switch (sourceElement.getSymbolKind()) {
            case 3: {
                JavaNavigationUtilities.recPruneClass(arrayList, (SourceClass)sourceElement, bl, bl2, bl3);
                break;
            }
            default: {
                Iterator iterator = sourceElement.getChildren().iterator();
                while (iterator.hasNext()) {
                    JavaNavigationUtilities.recPruneElement(arrayList, (SourceElement)iterator.next(), bl, bl2, bl3);
                }
                break block0;
            }
        }
    }

    private static void recPruneMethods(ArrayList arrayList, Iterator iterator, boolean bl, boolean bl2, boolean bl3) {
        while (iterator.hasNext()) {
            SourceBlock sourceBlock;
            SourceMethod sourceMethod = (SourceMethod)iterator.next();
            if (bl2) {
                Integer n = JavaNavigationUtilities.getOffset((SourceHasName)sourceMethod);
                arrayList.add(n);
            }
            if ((sourceBlock = sourceMethod.getBlock()) == null) continue;
            JavaNavigationUtilities.recPruneElement(arrayList, (SourceElement)sourceBlock, bl, bl2, bl3);
        }
    }

    private static void navigate(BasicEditorPane basicEditorPane, SourceFile sourceFile, int n) {
        int[] nArray = JavaNavigationUtilities.prunePositions(sourceFile, n);
        int n2 = basicEditorPane.getCaretPosition();
        int n3 = basicEditorPane.getLineFromOffset(n2);
        int n4 = n2;
        block0 : switch (n) {
            case 0: 
            case 2: 
            case 4: 
            case 6: {
                if (nArray.length > 0) {
                    n4 = nArray[0];
                }
                int n5 = basicEditorPane.getLineEndOffset(n3);
                int n6 = 0;
                while (n6 < nArray.length) {
                    if (n5 < nArray[n6]) {
                        n4 = nArray[n6];
                        break block0;
                    }
                    ++n6;
                }
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                if (nArray.length > 0) {
                    n4 = nArray[nArray.length - 1];
                }
                int n7 = basicEditorPane.getLineStartOffset(n3);
                int n8 = nArray.length - 1;
                while (n8 >= 0) {
                    if (n7 > nArray[n8]) {
                        n4 = nArray[n8];
                        break block0;
                    }
                    --n8;
                }
                break;
            }
        }
        if (n4 != n2) {
            basicEditorPane.select(n4, n4);
        }
    }

    private static SourceElement findExpandableElement(SourceElement sourceElement, int n) {
        SourceFile sourceFile = (SourceFile)sourceElement;
        SourceElement sourceElement2 = sourceFile.getElementAt(n);
        while (sourceElement2 != null) {
            switch (sourceElement2.getSymbolKind()) {
                case 3: 
                case 9: 
                case 18: 
                case 19: 
                case 34: 
                case 37: 
                case 39: 
                case 40: 
                case 42: 
                case 46: {
                    return sourceElement2;
                }
            }
            sourceElement2 = sourceElement2.getParent();
        }
        return sourceElement2;
    }

    public static void expandStatement(BasicEditorPane basicEditorPane, Context context) {
        int n = basicEditorPane.getCaretPosition();
        SourceFile sourceFile = JavaNavigationUtilities.getSourceFile(context);
        if (sourceFile == null) {
            return;
        }
        SourceElement sourceElement = JavaNavigationUtilities.findExpandableElement((SourceElement)sourceFile, n);
        if (sourceElement != null) {
            switch (sourceElement.getSymbolKind()) {
                case 3: {
                    JavaNavigationUtilities.expandClassDeclaration(context, basicEditorPane, sourceFile, sourceElement);
                    break;
                }
                case 19: {
                    JavaNavigationUtilities.expandMethodDeclaration(context, basicEditorPane, sourceFile, sourceElement);
                    break;
                }
                case 9: {
                    JavaNavigationUtilities.expandFieldDeclaration(context, basicEditorPane, sourceFile, sourceElement);
                    break;
                }
                case 18: 
                case 37: {
                    JavaNavigationUtilities.expandLocalsOrExpression(context, basicEditorPane, sourceFile, sourceElement);
                    break;
                }
                case 39: {
                    JavaNavigationUtilities.expandForStatement(context, basicEditorPane, sourceFile, sourceElement);
                    break;
                }
                case 42: {
                    JavaNavigationUtilities.expandSwitchStatement(context, basicEditorPane, sourceFile, sourceElement);
                    break;
                }
                case 46: {
                    JavaNavigationUtilities.expandWhileStatement(context, basicEditorPane, sourceFile, sourceElement);
                    break;
                }
                case 34: {
                    JavaNavigationUtilities.expandDoStatement(context, basicEditorPane, sourceFile, sourceElement);
                    break;
                }
                case 40: {
                    JavaNavigationUtilities.expandIfStatement(context, basicEditorPane, sourceFile, sourceElement);
                }
            }
        }
    }

    private static void expandClassDeclaration(Context context, BasicEditorPane basicEditorPane, SourceFile sourceFile, SourceElement sourceElement) {
        int n = basicEditorPane.getCaretPosition();
        RefactoringCommandSupport refactoringCommandSupport = new RefactoringCommandSupport();
        SourceTransaction sourceTransaction = null;
        try {
            int n2 = -1;
            sourceTransaction = refactoringCommandSupport.beginTransaction((SourceElement)sourceFile);
            SourceFactory sourceFactory = sourceFile.getFactory();
            SourceClass sourceClass = (SourceClass)sourceElement;
            SourceClassBody sourceClassBody = sourceClass.getSourceBody();
            if (sourceClassBody == null) {
                sourceClassBody = sourceFactory.createClassBody();
                sourceClassBody.addSelf((SourceElement)sourceClass);
            }
            sourceTransaction.savepoint();
            sourceClassBody = sourceClass.getSourceBody();
            if (n <= sourceClassBody.getStartOffset()) {
                n2 = JavaNavigationUtilities.adjustSourceBody(sourceFactory, sourceTransaction, sourceClassBody, n2);
            }
            refactoringCommandSupport.commit(context, "Expand Statement");
            if (n2 != -1) {
                basicEditorPane.select(n2, n2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            refactoringCommandSupport.abort();
        }
    }

    private static void expandMethodDeclaration(Context context, BasicEditorPane basicEditorPane, SourceFile sourceFile, SourceElement sourceElement) {
        int n = basicEditorPane.getCaretPosition();
        RefactoringCommandSupport refactoringCommandSupport = new RefactoringCommandSupport();
        SourceTransaction sourceTransaction = null;
        try {
            SourceBlock sourceBlock;
            int n2 = -1;
            sourceTransaction = refactoringCommandSupport.beginTransaction((SourceElement)sourceFile);
            SourceFactory sourceFactory = sourceFile.getFactory();
            SourceMethod sourceMethod = (SourceMethod)sourceElement;
            SourceFormalParameterList sourceFormalParameterList = sourceMethod.getFormalParameterList();
            boolean bl = false;
            if (sourceFormalParameterList == null) {
                sourceFormalParameterList = sourceFactory.createFormalParameterList();
                sourceFormalParameterList.addSelf((SourceElement)sourceMethod);
                bl = true;
            }
            if ((sourceBlock = sourceMethod.getBlock()) == null) {
                sourceBlock = sourceFactory.createBlock();
                sourceBlock.addSelf((SourceElement)sourceMethod);
            }
            sourceTransaction.savepoint();
            if (bl) {
                n2 = sourceFormalParameterList.getStartOffset() + 1;
            } else {
                sourceBlock = sourceMethod.getBlock();
                if (n <= sourceBlock.getStartOffset()) {
                    n2 = JavaNavigationUtilities.adjustSourceBlock(sourceFactory, sourceTransaction, sourceBlock, n2);
                }
            }
            refactoringCommandSupport.commit(context, "Expand Statement");
            if (n2 != -1) {
                basicEditorPane.select(n2, n2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            refactoringCommandSupport.abort();
        }
    }

    private static void expandFieldDeclaration(Context context, BasicEditorPane basicEditorPane, SourceFile sourceFile, SourceElement sourceElement) {
        String string = sourceElement.getText();
        SourceFactory sourceFactory = sourceFile.getFactory();
        SourceMember sourceMember = !string.endsWith(";") ? sourceFactory.createMember(string + ';') : sourceFactory.createMember(string);
        int n = -1;
        SourceTransaction sourceTransaction = null;
        RefactoringCommandSupport refactoringCommandSupport = new RefactoringCommandSupport();
        try {
            sourceTransaction = refactoringCommandSupport.beginTransaction((SourceElement)sourceFile);
            sourceElement.replaceSelf((SourceElement)sourceMember);
            sourceTransaction.savepoint();
            n = sourceMember.getEndOffset();
            refactoringCommandSupport.commit(context, "Expand Statement");
            if (n != -1) {
                basicEditorPane.select(n, n);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            refactoringCommandSupport.abort();
        }
    }

    private static void expandLocalsOrExpression(Context context, BasicEditorPane basicEditorPane, SourceFile sourceFile, SourceElement sourceElement) {
        String string = sourceElement.getText();
        SourceFactory sourceFactory = sourceFile.getFactory();
        SourceStatement sourceStatement = !string.endsWith(";") ? sourceFactory.createStatement('{' + string + ';' + '}') : sourceFactory.createStatement('{' + string + '}');
        int n = -1;
        SourceTransaction sourceTransaction = null;
        RefactoringCommandSupport refactoringCommandSupport = new RefactoringCommandSupport();
        try {
            sourceTransaction = refactoringCommandSupport.beginTransaction((SourceElement)sourceFile);
            SourceBlockStatement sourceBlockStatement = (SourceBlockStatement)sourceStatement;
            SourceElement sourceElement2 = (SourceElement)sourceBlockStatement.getBlock().getChildren().get(0);
            sourceElement2 = sourceElement2.cloneSelf(sourceFile);
            sourceElement.replaceSelf(sourceElement2);
            sourceTransaction.savepoint();
            n = sourceElement2.getEndOffset();
            refactoringCommandSupport.commit(context, "Expand Statement");
            if (n != -1) {
                basicEditorPane.select(n, n);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            refactoringCommandSupport.abort();
        }
    }

    private static void expandForStatement(Context context, BasicEditorPane basicEditorPane, SourceFile sourceFile, SourceElement sourceElement) {
        int n = basicEditorPane.getCaretPosition();
        SourceForStatement sourceForStatement = (SourceForStatement)sourceElement;
        SourceFactory sourceFactory = sourceFile.getFactory();
        boolean bl = false;
        SourceStatement sourceStatement = sourceForStatement.getPrimaryClause();
        if (sourceStatement == null) {
            bl = true;
            sourceStatement = sourceFactory.createStatement("{\n}");
        } else {
            if (n <= sourceStatement.getStartOffset()) {
                bl = true;
            }
            sourceStatement = (SourceStatement)sourceStatement.cloneSelf(sourceFile);
        }
        int n2 = -1;
        SourceTransaction sourceTransaction = null;
        RefactoringCommandSupport refactoringCommandSupport = new RefactoringCommandSupport();
        try {
            SourceStatement sourceStatement2;
            SourceForStatement sourceForStatement2;
            SourceListExpression sourceListExpression;
            sourceTransaction = refactoringCommandSupport.beginTransaction((SourceElement)sourceFile);
            SourceListExpression sourceListExpression2 = sourceForStatement.getForInitializationList();
            SourceLocalVariableDeclaration sourceLocalVariableDeclaration = null;
            if (sourceListExpression2 != null) {
                sourceListExpression2 = (SourceListExpression)sourceListExpression2.cloneSelf(sourceFile);
            } else {
                sourceLocalVariableDeclaration = sourceForStatement.getForVariableDeclaration();
                if (sourceLocalVariableDeclaration != null) {
                    sourceLocalVariableDeclaration = (SourceLocalVariableDeclaration)sourceLocalVariableDeclaration.cloneSelf(sourceFile);
                }
            }
            SourceExpression sourceExpression = sourceForStatement.getForConditional();
            if (sourceExpression != null) {
                sourceExpression = (SourceExpression)sourceExpression.cloneSelf(sourceFile);
            }
            if ((sourceListExpression = sourceForStatement.getForUpdateList()) != null) {
                sourceListExpression = (SourceListExpression)sourceListExpression.cloneSelf(sourceFile);
            }
            if (sourceLocalVariableDeclaration == null) {
                sourceForStatement2 = sourceFactory.createForStatement(sourceListExpression2, sourceExpression, sourceListExpression, sourceStatement);
            } else {
                SourceExpression sourceExpression2;
                List list = sourceLocalVariableDeclaration.getVariables();
                SourceLocalVariable[] sourceLocalVariableArray = new SourceLocalVariable[list.size()];
                sourceLocalVariableArray = list.toArray(sourceLocalVariableArray);
                int n3 = 0;
                while (n3 < sourceLocalVariableArray.length) {
                    sourceLocalVariableArray[n3] = (SourceLocalVariable)sourceLocalVariableArray[n3].cloneSelf(sourceFile);
                    ++n3;
                }
                sourceForStatement2 = sourceForStatement.getForType() != 2 ? sourceFactory.createForVariableStatement(sourceLocalVariableDeclaration, sourceExpression, sourceListExpression, sourceStatement) : ((sourceExpression2 = sourceForStatement.getForCollection()) != null ? sourceFactory.createForEnhancedStatement(sourceLocalVariableArray[0], (SourceExpression)sourceExpression2.cloneSelf(sourceFile), sourceStatement) : (SourceForStatement)sourceForStatement.cloneSelf(sourceFile));
            }
            sourceForStatement.replaceSelf((SourceElement)sourceForStatement2);
            sourceTransaction.savepoint();
            if (bl && (sourceStatement2 = sourceForStatement2.getPrimaryClause()) instanceof SourceBlockStatement) {
                SourceBlockStatement sourceBlockStatement = (SourceBlockStatement)sourceStatement2;
                n2 = JavaNavigationUtilities.adjustSourceBlock(sourceFactory, sourceTransaction, sourceBlockStatement.getBlock(), n2);
            }
            refactoringCommandSupport.commit(context, "Expand Statement");
            if (n2 != -1) {
                basicEditorPane.select(n2, n2);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            refactoringCommandSupport.abort();
        }
    }

    private static void expandWhileStatement(Context context, BasicEditorPane basicEditorPane, SourceFile sourceFile, SourceElement sourceElement) {
        int n = basicEditorPane.getCaretPosition();
        SourceWhileStatement sourceWhileStatement = (SourceWhileStatement)sourceElement;
        SourceFactory sourceFactory = sourceFile.getFactory();
        boolean bl = false;
        boolean bl2 = false;
        SourceExpression sourceExpression = sourceWhileStatement.getControlExpression();
        if (sourceExpression == null) {
            sourceExpression = sourceFactory.createExpression("true");
            bl = true;
        } else {
            sourceExpression = (SourceExpression)sourceExpression.cloneSelf(sourceFile);
        }
        SourceStatement sourceStatement = sourceWhileStatement.getPrimaryClause();
        if (sourceStatement == null) {
            bl2 = true;
            sourceStatement = sourceFactory.createStatement("{\n}");
        } else {
            if (n <= sourceStatement.getStartOffset()) {
                bl2 = true;
            }
            sourceStatement = (SourceStatement)sourceStatement.cloneSelf(sourceFile);
        }
        int n2 = -1;
        SourceTransaction sourceTransaction = null;
        RefactoringCommandSupport refactoringCommandSupport = new RefactoringCommandSupport();
        try {
            SourceStatement sourceStatement2;
            sourceTransaction = refactoringCommandSupport.beginTransaction((SourceElement)sourceFile);
            SourceWhileStatement sourceWhileStatement2 = sourceFactory.createWhileStatement(sourceExpression, sourceStatement);
            sourceWhileStatement.replaceSelf((SourceElement)sourceWhileStatement2);
            sourceTransaction.savepoint();
            if (bl) {
                sourceExpression = sourceWhileStatement2.getControlExpression();
                SourceExpression sourceExpression2 = sourceExpression.getFirstOperand();
                n2 = sourceExpression2.getStartOffset();
                sourceExpression2.removeSelf();
            }
            if (bl2 && (sourceStatement2 = sourceWhileStatement2.getPrimaryClause()) instanceof SourceBlockStatement) {
                SourceBlockStatement sourceBlockStatement = (SourceBlockStatement)sourceStatement2;
                n2 = JavaNavigationUtilities.adjustSourceBlock(sourceFactory, sourceTransaction, sourceBlockStatement.getBlock(), n2);
            }
            refactoringCommandSupport.commit(context, "Expand Statement");
            if (n2 != -1) {
                basicEditorPane.select(n2, n2);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            refactoringCommandSupport.abort();
        }
    }

    private static void expandDoStatement(Context context, BasicEditorPane basicEditorPane, SourceFile sourceFile, SourceElement sourceElement) {
        int n = basicEditorPane.getCaretPosition();
        SourceDoStatement sourceDoStatement = (SourceDoStatement)sourceElement;
        SourceFactory sourceFactory = sourceFile.getFactory();
        boolean bl = false;
        boolean bl2 = false;
        SourceExpression sourceExpression = sourceDoStatement.getControlExpression();
        if (sourceExpression == null || sourceExpression.getFirstOperand() == null || sourceExpression.getFirstOperand().getStartOffset() == -1) {
            sourceExpression = sourceFactory.createExpression("true");
            bl = true;
        } else {
            sourceExpression = (SourceExpression)sourceExpression.cloneSelf(sourceFile);
        }
        SourceStatement sourceStatement = sourceDoStatement.getPrimaryClause();
        if (sourceStatement == null) {
            bl2 = true;
            sourceStatement = sourceFactory.createStatement("{\n}");
        } else {
            if (n <= sourceStatement.getStartOffset()) {
                bl2 = true;
            }
            sourceStatement = (SourceStatement)sourceStatement.cloneSelf(sourceFile);
        }
        int n2 = -1;
        SourceTransaction sourceTransaction = null;
        RefactoringCommandSupport refactoringCommandSupport = new RefactoringCommandSupport();
        try {
            SourceStatement sourceStatement2;
            sourceTransaction = refactoringCommandSupport.beginTransaction((SourceElement)sourceFile);
            SourceDoStatement sourceDoStatement2 = sourceFactory.createDoStatement(sourceExpression, sourceStatement);
            sourceDoStatement.replaceSelf((SourceElement)sourceDoStatement2);
            sourceTransaction.savepoint();
            if (bl2 && (sourceStatement2 = sourceDoStatement2.getPrimaryClause()) instanceof SourceBlockStatement) {
                SourceBlockStatement sourceBlockStatement = (SourceBlockStatement)sourceStatement2;
                n2 = JavaNavigationUtilities.adjustSourceBlock(sourceFactory, sourceTransaction, sourceBlockStatement.getBlock(), n2);
            }
            if (bl) {
                sourceExpression = sourceDoStatement2.getControlExpression();
                SourceExpression sourceExpression2 = sourceExpression.getFirstOperand();
                if (n2 == -1) {
                    n2 = sourceExpression2.getStartOffset();
                }
                sourceExpression2.removeSelf();
            }
            refactoringCommandSupport.commit(context, "Expand Statement");
            if (n2 != -1) {
                basicEditorPane.select(n2, n2);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            refactoringCommandSupport.abort();
        }
    }

    private static void expandIfStatement(Context context, BasicEditorPane basicEditorPane, SourceFile sourceFile, SourceElement sourceElement) {
        int n = basicEditorPane.getCaretPosition();
        SourceIfStatement sourceIfStatement = (SourceIfStatement)sourceElement;
        boolean bl = false;
        boolean bl2 = false;
        SourceExpression sourceExpression = sourceIfStatement.getControlExpression();
        SourceFactory sourceFactory = sourceFile.getFactory();
        if (sourceExpression == null) {
            sourceExpression = sourceFactory.createExpression("true");
            bl = true;
        } else {
            sourceExpression = (SourceExpression)sourceExpression.cloneSelf(sourceFile);
        }
        SourceStatement sourceStatement = sourceIfStatement.getPrimaryClause();
        if (sourceStatement == null) {
            bl2 = true;
            sourceStatement = sourceFactory.createStatement("{\n}");
        } else {
            if (n <= sourceStatement.getStartOffset()) {
                bl2 = true;
            }
            sourceStatement = (SourceStatement)sourceStatement.cloneSelf(sourceFile);
        }
        SourceElseClause sourceElseClause = sourceIfStatement.getElseClause();
        if (sourceElseClause != null) {
            sourceElseClause = sourceElseClause.getPrimaryClause() != null ? (SourceElseClause)sourceElseClause.cloneSelf(sourceFile) : sourceFactory.createElseClause(sourceFactory.createStatement("{\n}"));
        }
        int n2 = -1;
        SourceTransaction sourceTransaction = null;
        RefactoringCommandSupport refactoringCommandSupport = new RefactoringCommandSupport();
        try {
            SourceStatement sourceStatement2;
            sourceTransaction = refactoringCommandSupport.beginTransaction((SourceElement)sourceFile);
            SourceIfStatement sourceIfStatement2 = sourceFactory.createIfStatement(sourceExpression, sourceStatement, sourceElseClause);
            sourceIfStatement.replaceSelf((SourceElement)sourceIfStatement2);
            sourceTransaction.savepoint();
            if (bl) {
                sourceExpression = sourceIfStatement2.getControlExpression();
                SourceExpression sourceExpression2 = sourceExpression.getFirstOperand();
                n2 = sourceExpression2.getStartOffset();
                sourceExpression2.removeSelf();
            }
            if (bl2) {
                SourceStatement sourceStatement3 = sourceIfStatement2.getPrimaryClause();
                if (sourceStatement3 instanceof SourceBlockStatement) {
                    SourceBlockStatement sourceBlockStatement = (SourceBlockStatement)sourceStatement3;
                    n2 = JavaNavigationUtilities.adjustSourceBlock(sourceFactory, sourceTransaction, sourceBlockStatement.getBlock(), n2);
                }
            } else if (sourceElseClause != null && (sourceStatement2 = sourceElseClause.getPrimaryClause()) instanceof SourceBlockStatement) {
                SourceBlockStatement sourceBlockStatement = (SourceBlockStatement)sourceStatement2;
                n2 = JavaNavigationUtilities.adjustSourceBlock(sourceFactory, sourceTransaction, sourceBlockStatement.getBlock(), n2);
            }
            refactoringCommandSupport.commit(context, "Expand Statement");
            if (n2 != -1) {
                basicEditorPane.select(n2, n2);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            refactoringCommandSupport.abort();
        }
    }

    private static void expandSwitchStatement(Context context, BasicEditorPane basicEditorPane, SourceFile sourceFile, SourceElement sourceElement) {
        int n = basicEditorPane.getCaretPosition();
        SourceSwitchStatement sourceSwitchStatement = (SourceSwitchStatement)sourceElement;
        SourceFactory sourceFactory = sourceFile.getFactory();
        boolean bl = false;
        boolean bl2 = false;
        SourceExpression sourceExpression = sourceSwitchStatement.getControlExpression();
        if (sourceExpression == null) {
            sourceExpression = sourceFactory.createExpression("true");
            bl = true;
        } else {
            sourceExpression = (SourceExpression)sourceExpression.cloneSelf(sourceFile);
        }
        SourceBlockStatement sourceBlockStatement = (SourceBlockStatement)sourceSwitchStatement.getPrimaryClause();
        if (sourceBlockStatement == null) {
            bl2 = true;
            sourceBlockStatement = sourceFactory.createBlockStatement(sourceFactory.createBlock("{\n}"));
        } else {
            if (n <= sourceBlockStatement.getStartOffset()) {
                bl2 = true;
            }
            sourceBlockStatement = (SourceBlockStatement)sourceBlockStatement.cloneSelf(sourceFile);
        }
        int n2 = -1;
        SourceTransaction sourceTransaction = null;
        RefactoringCommandSupport refactoringCommandSupport = new RefactoringCommandSupport();
        try {
            SourceStatement sourceStatement;
            sourceTransaction = refactoringCommandSupport.beginTransaction((SourceElement)sourceFile);
            SourceSwitchStatement sourceSwitchStatement2 = sourceFactory.createSwitchStatement(sourceExpression, sourceBlockStatement);
            sourceSwitchStatement.replaceSelf((SourceElement)sourceSwitchStatement2);
            sourceTransaction.savepoint();
            if (bl) {
                sourceExpression = sourceSwitchStatement2.getControlExpression();
                SourceExpression sourceExpression2 = sourceExpression.getFirstOperand();
                n2 = sourceExpression2.getStartOffset();
                sourceExpression2.removeSelf();
            }
            if (bl2 && (sourceStatement = sourceSwitchStatement2.getPrimaryClause()) instanceof SourceBlockStatement) {
                SourceBlockStatement sourceBlockStatement2 = (SourceBlockStatement)sourceStatement;
                n2 = JavaNavigationUtilities.adjustSourceBlock(sourceFactory, sourceTransaction, sourceBlockStatement2.getBlock(), n2);
            }
            refactoringCommandSupport.commit(context, "Expand Statement");
            if (n2 != -1) {
                basicEditorPane.select(n2, n2);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            refactoringCommandSupport.abort();
        }
    }

    private static int adjustSourceBlock(SourceFactory sourceFactory, SourceTransaction sourceTransaction, SourceBlock sourceBlock, int n) {
        SourceBreakStatement sourceBreakStatement = sourceFactory.createBreakStatement(null);
        sourceBlock.getChildren().add(0, sourceBreakStatement);
        sourceTransaction.savepoint();
        if (n == -1) {
            n = sourceBreakStatement.getStartOffset();
        }
        String string = sourceBlock.getText();
        String string2 = string.substring(0, sourceBreakStatement.getStartOffset() - sourceBlock.getStartOffset()) + string.substring(sourceBreakStatement.getEndOffset() - sourceBlock.getStartOffset());
        sourceBlock.replaceSelf((SourceElement)sourceFactory.createBlock(string2));
        return n;
    }

    private static int adjustSourceBody(SourceFactory sourceFactory, SourceTransaction sourceTransaction, SourceClassBody sourceClassBody, int n) {
        SourceFieldDeclaration sourceFieldDeclaration = sourceFactory.createFieldDeclaration(sourceFactory.createType("int"), "xxxx");
        sourceClassBody.getChildren().add(0, sourceFieldDeclaration);
        sourceTransaction.savepoint();
        if (n == -1) {
            n = sourceFieldDeclaration.getStartOffset();
        }
        SourceClass sourceClass = (SourceClass)sourceClassBody.getParent();
        String string = sourceClass.getText();
        String string2 = string.substring(0, sourceFieldDeclaration.getStartOffset() - sourceClass.getStartOffset()) + string.substring(sourceFieldDeclaration.getEndOffset() - sourceClass.getStartOffset());
        sourceClass.replaceSelf((SourceElement)sourceFactory.createClass(string2));
        return n;
    }

    public static class JotProxyElementV2 {
        private static final JotProxyElementV2[] NULL_TOKLIST = new JotProxyElementV2[0];
        private SourceElement _jElem;
        private int _oStart;
        private int _oEnd;
        private JotProxyElementV2[] _childs;
        BasicEditorPane _editorPane;

        public JotProxyElementV2(SourceElement sourceElement, BasicEditorPane basicEditorPane) {
            this._jElem = sourceElement;
            this._oStart = sourceElement.getStartOffset();
            this._oEnd = sourceElement.getEndOffset();
            this._editorPane = basicEditorPane;
        }

        public JotProxyElementV2(int n, int n2, JotProxyElementV2[] jotProxyElementV2Array, BasicEditorPane basicEditorPane) {
            this._oStart = n;
            this._oEnd = n2;
            this._childs = jotProxyElementV2Array;
            this._editorPane = basicEditorPane;
        }

        public int getStartOffset() {
            return this._oStart;
        }

        public int getEndOffset() {
            return this._oEnd;
        }

        private String getStringFromEditor() {
            String string = "";
            try {
                string = this._editorPane.getText(this._oStart, this._oEnd - this._oStart);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return string;
        }

        private void adjustChildsToLines() {
            int n = this._oStart;
            int n2 = 0;
            while (n2 < this._childs.length) {
                JotProxyElementV2 jotProxyElementV2 = this._childs[n2];
                int n3 = this._editorPane.getLineStartOffset(this._editorPane.getLineFromOffset(jotProxyElementV2.getStartOffset()));
                int n4 = this._editorPane.getLineEndOffset(this._editorPane.getLineFromOffset(jotProxyElementV2.getEndOffset()));
                jotProxyElementV2._oStart = Math.max(n, n3);
                jotProxyElementV2._oEnd = n2 < this._childs.length - 1 ? Math.min(n4, this._childs[n2 + 1]._oStart) : Math.min(n4, this._oEnd);
                n = jotProxyElementV2._oEnd;
                ++n2;
            }
        }

        private JotProxyElementV2[] extractTokens(int n, String string) {
            ArrayList<JotProxyElementV2> arrayList = new ArrayList<JotProxyElementV2>();
            boolean bl = false;
            int n2 = 0;
            int n3 = 0;
            int n4 = string.length();
            while (n2 <= n4) {
                if (n2 < n4 && Character.isJavaIdentifierPart(string.charAt(n2))) {
                    if (!bl) {
                        n3 = n2;
                        bl = true;
                    }
                } else if (bl) {
                    arrayList.add(new JotProxyElementV2(n + n3, n + n2, NULL_TOKLIST, this._editorPane));
                    bl = false;
                }
                ++n2;
            }
            return arrayList.toArray(new JotProxyElementV2[arrayList.size()]);
        }

        private void fillChilds() {
            int n = this._jElem.getSymbolKind();
            switch (n) {
                case 53: {
                    String string = this.getStringFromEditor();
                    this._childs = this.extractTokens(this._oStart, string);
                    return;
                }
                case 12: 
                case 52: {
                    SourceElement[] sourceElementArray = this._jElem.getContainedElements();
                    ArrayList<JotProxyElementV2> arrayList = new ArrayList<JotProxyElementV2>();
                    int n2 = -1;
                    int n3 = -1;
                    int n4 = 0;
                    while (n4 < sourceElementArray.length) {
                        SourceElement sourceElement = sourceElementArray[n4];
                        if (n2 == -1) {
                            n2 = sourceElement.getStartOffset();
                        }
                        arrayList.add(new JotProxyElementV2(sourceElement, this._editorPane));
                        n3 = sourceElement.getEndOffset();
                        ++n4;
                    }
                    JotProxyElementV2 jotProxyElementV2 = null;
                    if (n2 != -1) {
                        JotProxyElementV2[] jotProxyElementV2Array = new JotProxyElementV2[arrayList.size()];
                        jotProxyElementV2Array = arrayList.toArray(jotProxyElementV2Array);
                        jotProxyElementV2 = new JotProxyElementV2(n2, n3, jotProxyElementV2Array, this._editorPane);
                        this._childs = new JotProxyElementV2[1];
                        this._childs[0] = jotProxyElementV2;
                        return;
                    }
                }
                case 2: {
                    SourceElement[] sourceElementArray = this._jElem.getContainedElements();
                    ArrayList<JotProxyElementV2> arrayList = new ArrayList<JotProxyElementV2>();
                    ArrayList<JotProxyElementV2> arrayList2 = null;
                    int n5 = -10;
                    int n6 = 0;
                    int n7 = 0;
                    int n8 = 0;
                    while (n8 < sourceElementArray.length) {
                        SourceElement sourceElement = sourceElementArray[n8];
                        int n9 = this._editorPane.getLineFromOffset(sourceElement.getStartOffset());
                        int n10 = this._editorPane.getLineFromOffset(sourceElement.getEndOffset());
                        if (n9 - n5 > 0) {
                            if (arrayList2 != null) {
                                JotProxyElementV2[] jotProxyElementV2Array = new JotProxyElementV2[arrayList2.size()];
                                jotProxyElementV2Array = arrayList2.toArray(jotProxyElementV2Array);
                                arrayList.add(new JotProxyElementV2(n6, n7, jotProxyElementV2Array, this._editorPane));
                            }
                            arrayList2 = new ArrayList<JotProxyElementV2>();
                            n6 = Math.max(this._oStart, this._editorPane.getLineStartOffset(n9));
                            n7 = Math.min(this._oEnd, this._editorPane.getLineStartOffset(n10 + 1));
                            arrayList2.add(new JotProxyElementV2(sourceElement, this._editorPane));
                            n5 = n10;
                        } else {
                            n7 = Math.min(this._oEnd, this._editorPane.getLineStartOffset(n10 + 1));
                            arrayList2.add(new JotProxyElementV2(sourceElement, this._editorPane));
                            n5 = n10;
                        }
                        ++n8;
                    }
                    if (arrayList2 != null) {
                        JotProxyElementV2[] jotProxyElementV2Array = new JotProxyElementV2[arrayList2.size()];
                        jotProxyElementV2Array = arrayList2.toArray(jotProxyElementV2Array);
                        arrayList.add(new JotProxyElementV2(n6, n7, jotProxyElementV2Array, this._editorPane));
                    }
                    JotProxyElementV2[] jotProxyElementV2Array = new JotProxyElementV2[arrayList.size()];
                    jotProxyElementV2Array = arrayList.toArray(jotProxyElementV2Array);
                    arrayList = new ArrayList();
                    arrayList2 = null;
                    n5 = -10;
                    n6 = 0;
                    n7 = 0;
                    int n11 = 0;
                    while (n11 < jotProxyElementV2Array.length) {
                        JotProxyElementV2 jotProxyElementV2 = jotProxyElementV2Array[n11];
                        int n12 = this._editorPane.getLineFromOffset(jotProxyElementV2.getStartOffset());
                        int n13 = this._editorPane.getLineFromOffset(jotProxyElementV2.getEndOffset());
                        if (n12 - n5 > 0) {
                            if (arrayList2 != null) {
                                JotProxyElementV2[] jotProxyElementV2Array2 = new JotProxyElementV2[arrayList2.size()];
                                jotProxyElementV2Array2 = arrayList2.toArray(jotProxyElementV2Array2);
                                arrayList.add(new JotProxyElementV2(n6, n7, jotProxyElementV2Array2, this._editorPane));
                            }
                            arrayList2 = new ArrayList();
                            n6 = jotProxyElementV2.getStartOffset();
                            n7 = jotProxyElementV2.getEndOffset();
                            arrayList2.add(jotProxyElementV2);
                            n5 = n13;
                        } else {
                            n7 = jotProxyElementV2.getEndOffset();
                            arrayList2.add(jotProxyElementV2);
                            n5 = n13;
                        }
                        ++n11;
                    }
                    if (arrayList2 != null) {
                        JotProxyElementV2[] jotProxyElementV2Array3 = new JotProxyElementV2[arrayList2.size()];
                        jotProxyElementV2Array3 = arrayList2.toArray(jotProxyElementV2Array3);
                        arrayList.add(new JotProxyElementV2(n6, n7, jotProxyElementV2Array3, this._editorPane));
                    }
                    jotProxyElementV2Array = new JotProxyElementV2[arrayList.size()];
                    if ((jotProxyElementV2Array = arrayList.toArray(jotProxyElementV2Array)).length != 0) {
                        this._childs = new JotProxyElementV2[1];
                        this._childs[0] = new JotProxyElementV2(jotProxyElementV2Array[0].getStartOffset(), jotProxyElementV2Array[jotProxyElementV2Array.length - 1].getEndOffset(), jotProxyElementV2Array, this._editorPane);
                    } else {
                        this._childs = NULL_TOKLIST;
                    }
                    return;
                }
            }
            SourceElement[] sourceElementArray = this._jElem.getContainedElements();
            this._childs = new JotProxyElementV2[sourceElementArray.length];
            int n14 = 0;
            while (n14 < sourceElementArray.length) {
                this._childs[n14] = new JotProxyElementV2(sourceElementArray[n14], this._editorPane);
                ++n14;
            }
            if (n == 4) {
                this.adjustChildsToLines();
            }
        }

        public JotProxyElementV2[] getContainedElements() {
            if (this._childs == null) {
                this.fillChilds();
            }
            return this._childs;
        }
    }
}

