/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.imports;

import oracle.javatools.parser.LexerToken;

public final class TokenPattern {
    public static final int EQUAL = 1;
    public static final int CENTER = 0;
    public static final int NOT_EQUAL = -1;
    private int[] pattern;
    private int patternCenter;
    private int patternLength;

    public TokenPattern(int[] nArray) {
        int n = nArray.length;
        if (n == 0 || n % 2 == 1) {
            throw new IllegalArgumentException("bad pattern");
        }
        this.pattern = nArray;
        this.patternLength = n / 2;
        this.patternCenter = -1;
        int n2 = 0;
        while (n2 < this.patternLength) {
            int n3 = n2 * 2 + 1;
            if (nArray[n3] == 0) {
                this.patternCenter = n2;
            }
            ++n2;
        }
        if (this.patternCenter == -1) {
            throw new IllegalStateException("center not declared");
        }
    }

    public boolean matchesPattern(LexerToken[] lexerTokenArray, int n) {
        if (lexerTokenArray == null || lexerTokenArray.length < this.patternLength) {
            return false;
        }
        int n2 = n - this.patternCenter;
        if (n2 < 0) {
            return false;
        }
        int n3 = n + (this.patternLength - this.patternCenter - 1);
        if (n3 >= lexerTokenArray.length) {
            return false;
        }
        int n4 = 0;
        while (n4 < this.patternLength) {
            int n5 = n4 * 2;
            int n6 = this.pattern[n5];
            int n7 = this.pattern[n5 + 1];
            int n8 = lexerTokenArray[n4 + n2].getToken();
            switch (n7) {
                case 0: 
                case 1: {
                    if (n6 == n8) break;
                    return false;
                }
                case -1: {
                    if (n6 != n8) break;
                    return false;
                }
            }
            ++n4;
        }
        return true;
    }
}

