/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.index;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.jdevimpl.java.index.JarPath;
import oracle.jdevimpl.java.index.LibraryManager;
import oracle.jdevimpl.java.index.Path;

public final class DirPath
implements Path {
    private URL dirURL;
    private int fileType;
    private String[] fileSuffixes;
    private Map packageMap;
    private int packageCount;

    public DirPath(URL uRL, int n) {
        this.dirURL = uRL;
        this.fileType = n;
        this.fileSuffixes = n == 1 ? Path.CLASS_SUFFIXES : Path.SOURCE_SUFFIXES;
        this.packageMap = new HashMap(20);
        this.packageCount = 0;
    }

    public void getSubPackages(String string, Collection collection) {
        PackageEntry packageEntry = this.findPackage(string);
        if (packageEntry != null) {
            Object[] objectArray = PackageEntry.ra$subPackageList(packageEntry);
            JarPath.addToCollection(objectArray, collection);
        }
    }

    public void getClassesInPackage(String string, Collection collection) {
        PackageEntry packageEntry = this.findPackage(string);
        if (packageEntry != null) {
            String[] stringArray = PackageEntry.ra$classList(packageEntry);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string2 = stringArray[n2];
                if (this.fileType == 2 || string2.indexOf(36) == -1) {
                    collection.add(string2);
                }
                ++n2;
            }
        }
    }

    public void findClasses(String string, boolean bl, Collection collection) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("");
        block0: while (arrayList.size() > 0) {
            String string2 = arrayList.remove(0).toString();
            PackageEntry packageEntry = this.findPackage(string2);
            String[] stringArray = PackageEntry.ra$subPackageList(packageEntry);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string3 = string2.length() > 0 ? string2 + "." + stringArray[n2] : stringArray[n2];
                arrayList.add(string3);
                ++n2;
            }
            String[] stringArray2 = PackageEntry.ra$classList(packageEntry);
            int n3 = stringArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                if (string.equals(stringArray2[n4]) || bl && stringArray2[n4].startsWith(string)) {
                    StringBuffer stringBuffer = new StringBuffer(string2);
                    stringBuffer.append('.');
                    stringBuffer.append(string);
                    collection.add(stringBuffer.toString());
                    if (!bl) continue block0;
                }
                ++n4;
            }
        }
    }

    public void getInnerClasses(String string, Collection collection) {
        if (this.fileType == 2) {
            return;
        }
        int n = string.lastIndexOf(46);
        String string2 = n == -1 ? "" : string.substring(0, n);
        String string3 = n == -1 ? string : string.substring(n + 1);
        int n2 = string3.length();
        int n3 = n2 + 2;
        PackageEntry packageEntry = this.findPackage(string2);
        if (packageEntry != null) {
            String[] stringArray = PackageEntry.ra$classList(packageEntry);
            int n4 = stringArray.length;
            int n5 = 0;
            while (n5 < n4) {
                String string4 = stringArray[n5];
                if (string4.length() >= n3 && string4.charAt(n2) == '$' && string4.indexOf(36, n2 + 1) == -1 && string4.startsWith(string3)) {
                    collection.add(string4);
                }
                ++n5;
            }
        }
    }

    public URL getURL(String string) {
        String string2 = string.replace('.', '/');
        int n = this.fileSuffixes.length;
        int n2 = 0;
        while (n2 < n) {
            String string3 = string2 + this.fileSuffixes[n2];
            URL uRL = URLFactory.newURL((URL)this.dirURL, (String)string3);
            if (URLFileSystem.exists((URL)uRL)) {
                return uRL;
            }
            ++n2;
        }
        return null;
    }

    public void buildIndex() {
        this.buildEntry("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PackageEntry findPackage(String string) {
        PackageEntry packageEntry = null;
        DirPath dirPath = this;
        synchronized (dirPath) {
            packageEntry = (PackageEntry)this.packageMap.get(string);
        }
        String string2 = string.replace('.', '/');
        URL uRL = URLFactory.newDirURL((URL)this.dirURL, (String)string2);
        long l = URLFileSystem.lastModified((URL)uRL);
        if (packageEntry != null && l == PackageEntry.ra$lastModified(packageEntry)) {
            return packageEntry;
        }
        URL[] uRLArray = URLFileSystem.list((URL)uRL);
        int n = uRLArray != null ? uRLArray.length : 0;
        int n2 = this.fileSuffixes.length;
        ArrayList<String> arrayList = new ArrayList<String>(n);
        ArrayList<String> arrayList2 = new ArrayList<String>(n);
        int n3 = 0;
        while (n3 < n) {
            URL uRL2 = uRLArray[n3];
            boolean bl = URLFileSystem.isDirectoryPath((URL)uRL2);
            String string3 = URLFileSystem.getFileName((URL)uRL2);
            if (bl) {
                arrayList2.add(new String(string3));
            } else {
                int n4 = 0;
                while (n4 < n2) {
                    if (string3.endsWith(this.fileSuffixes[n4])) {
                        int n5 = string3.lastIndexOf(46);
                        arrayList.add(new String(string3.substring(0, n5)));
                        break;
                    }
                    ++n4;
                }
            }
            ++n3;
        }
        String[] stringArray = LibraryManager.getStringArray(arrayList);
        String[] stringArray2 = LibraryManager.getStringArray(arrayList2);
        packageEntry = new PackageEntry(l, stringArray, stringArray2, null);
        DirPath dirPath2 = this;
        synchronized (dirPath2) {
            this.packageMap.put(string, packageEntry);
        }
        return packageEntry;
    }

    private void buildEntry(String string) {
        Thread.yield();
        PackageEntry packageEntry = this.findPackage(string);
        if (packageEntry != null) {
            String[] stringArray = PackageEntry.ra$subPackageList(packageEntry);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string2 = string.length() > 0 ? string + "." + stringArray[n2] : stringArray[n2];
                this.buildEntry(string2);
                ++n2;
            }
        }
    }

    private static final class PackageEntry {
        private long lastModified;
        private String[] classList;
        private String[] subPackageList;

        private PackageEntry(long l, String[] stringArray, String[] stringArray2) {
            this.lastModified = l;
            this.classList = stringArray;
            this.subPackageList = stringArray2;
        }

        static String[] ra$subPackageList(PackageEntry packageEntry) {
            return packageEntry.subPackageList;
        }

        static long ra$lastModified(PackageEntry packageEntry) {
            return packageEntry.lastModified;
        }

        PackageEntry(long l, String[] stringArray, String[] stringArray2, 1 var5_4) {
            this(l, stringArray, stringArray2);
        }

        static String[] ra$classList(PackageEntry packageEntry) {
            return packageEntry.classList;
        }

        public final class 1 {
        }
    }
}

