/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.index;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import oracle.ide.net.JarIndex;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFactory;
import oracle.ide.util.ArraySortedSet;
import oracle.jdevimpl.java.index.LibraryManager;
import oracle.jdevimpl.java.index.Path;

public final class JarPath
implements Path {
    private URL jarURL;
    private int fileType;
    private String[] fileSuffixes;
    private JarIndex jarIndex;
    private HashMap packageMap;

    public JarPath(URL uRL, int n) {
        this.jarURL = uRL;
        this.fileType = n;
        this.fileSuffixes = n == 1 ? Path.CLASS_SUFFIXES : Path.SOURCE_SUFFIXES;
    }

    public void getSubPackages(String string, Collection collection) {
        this.ensureIndexBuilt();
        PackageEntry packageEntry = this.findPackage(string);
        if (packageEntry != null) {
            Object[] objectArray = PackageEntry.ra$subPackageList(packageEntry);
            JarPath.addToCollection(objectArray, collection);
        }
    }

    public void getClassesInPackage(String string, Collection collection) {
        this.ensureIndexBuilt();
        PackageEntry packageEntry = this.findPackage(string);
        if (packageEntry != null) {
            String[] stringArray = PackageEntry.ra$classList(packageEntry);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string2 = stringArray[n2];
                if (this.fileType == 2 || string2.indexOf(36) == -1) {
                    collection.add(string2);
                }
                ++n2;
            }
        }
    }

    public void findClasses(String string, boolean bl, Collection collection) {
        this.ensureIndexBuilt();
        Set set = this.packageMap.keySet();
        Iterator iterator = set.iterator();
        block0: while (iterator.hasNext()) {
            String string2 = iterator.next().toString();
            PackageEntry packageEntry = (PackageEntry)this.packageMap.get(string2);
            String[] stringArray = PackageEntry.ra$classList(packageEntry);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                if (string.equals(stringArray[n2]) || bl && stringArray[n2].startsWith(string)) {
                    StringBuffer stringBuffer = new StringBuffer(string2);
                    stringBuffer.append('.');
                    stringBuffer.append(string);
                    collection.add(stringBuffer.toString());
                    if (!bl) continue block0;
                }
                ++n2;
            }
        }
    }

    public void getInnerClasses(String string, Collection collection) {
        if (this.fileType == 2) {
            return;
        }
        int n = string.lastIndexOf(46);
        String string2 = n == -1 ? "" : string.substring(0, n);
        String string3 = n == -1 ? string : string.substring(n + 1);
        int n2 = string3.length();
        int n3 = n2 + 2;
        this.ensureIndexBuilt();
        PackageEntry packageEntry = this.findPackage(string2);
        if (packageEntry != null) {
            String[] stringArray = PackageEntry.ra$classList(packageEntry);
            int n4 = stringArray.length;
            int n5 = 0;
            while (n5 < n4) {
                String string4 = stringArray[n5];
                if (string4.length() >= n3 && string4.charAt(n2) == '$' && string4.indexOf(36, n2 + 1) == -1 && string4.startsWith(string3)) {
                    collection.add(string4);
                }
                ++n5;
            }
        }
    }

    public URL getURL(String string) {
        this.ensureIndexBuilt();
        if (this.jarIndex == null) {
            return null;
        }
        int n = this.fileSuffixes.length;
        String string2 = string.replace('.', '/');
        String string3 = JarUtil.getJarEntry((URL)this.jarURL);
        int n2 = string3 != null ? string3.length() : 0;
        int n3 = 0;
        while (n3 < n) {
            String string4 = string2 + this.fileSuffixes[n3];
            if (this.jarIndex.entryIndex(string3 + string4) >= 0) {
                return URLFactory.newJarURL((URL)this.jarURL, (String)string4);
            }
            ++n3;
        }
        return null;
    }

    public synchronized void buildIndex() {
        block10: {
            if (this.packageMap != null) break block10;
            try {
                int n = this.fileSuffixes.length;
                this.jarIndex = JarUtil.getJarIndex((URL)this.jarURL);
                String[] stringArray = this.jarIndex.getEntries();
                int n2 = stringArray.length;
                String string = JarUtil.getJarEntry((URL)this.jarURL);
                int n3 = string != null ? string.length() : 0;
                HashMap hashMap = new HashMap(n2);
                HashMap hashMap2 = new HashMap(n2);
                int n4 = 0;
                while (n4 < n2) {
                    block12: {
                        String string2;
                        block11: {
                            string2 = stringArray[n4];
                            if (n3 <= 0) break block11;
                            if (!string2.startsWith(string)) break block12;
                            string2 = string2.substring(n3);
                        }
                        if (string2.length() != 0) {
                            int n5 = 0;
                            while (n5 < n) {
                                if (string2.endsWith(this.fileSuffixes[n5])) {
                                    JarPath.addClassToMaps(string2, hashMap, hashMap2);
                                    break;
                                }
                                ++n5;
                            }
                        }
                    }
                    ++n4;
                }
                ArraySortedSet arraySortedSet = new ArraySortedSet(100);
                arraySortedSet.addAll(hashMap.keySet());
                arraySortedSet.addAll(hashMap2.keySet());
                this.packageMap = new HashMap(arraySortedSet.size());
                for (Object e : arraySortedSet) {
                    String string3 = (String)e;
                    Collection collection = (Collection)hashMap.get(e);
                    String[] stringArray2 = LibraryManager.getStringArray(collection);
                    Collection collection2 = (Collection)hashMap2.get(e);
                    String[] stringArray3 = LibraryManager.getStringArray(collection2);
                    if (stringArray2.length <= 0 && stringArray3.length <= 0) continue;
                    PackageEntry packageEntry = new PackageEntry(stringArray2, stringArray3, null);
                    this.packageMap.put(string3, packageEntry);
                }
            }
            catch (IOException iOException) {
                this.packageMap = new HashMap(1);
                this.jarIndex = null;
            }
        }
    }

    protected static void addToCollection(Object[] objectArray, Collection collection) {
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            collection.add(objectArray[n2]);
            ++n2;
        }
    }

    private static void addClassToMaps(String string, Map map, Map map2) {
        int n = string.lastIndexOf(46);
        String string2 = string.substring(0, n).replace('/', '.');
        int n2 = string2.lastIndexOf(46);
        String string3 = n2 != -1 ? string2.substring(0, n2) : "";
        String string4 = n2 != -1 ? string2.substring(n2 + 1) : string2;
        boolean bl = true;
        Collection collection = (Collection)map.get(string3);
        if (collection == null) {
            collection = new ArraySortedSet(75);
            map.put(string3, collection);
            bl = false;
        } else {
            string4 = new String(string4);
        }
        collection.add(string4);
        if (bl) {
            return;
        }
        if (string3.length() == 0) {
            return;
        }
        String string5 = "";
        int n3 = 0;
        boolean bl2 = false;
        while (!bl2) {
            int n4 = string3.indexOf(46, n3);
            if (n4 == -1) {
                bl2 = true;
                n4 = string3.length();
            }
            String string6 = string3.substring(n3, n4);
            Collection collection2 = (Collection)map2.get(string5);
            if (collection2 == null) {
                collection2 = new ArraySortedSet(20);
                map2.put(string5, collection2);
            }
            collection2.add(string6);
            string5 = string3.substring(0, n4);
            n3 = n4 + 1;
        }
    }

    private void ensureIndexBuilt() {
        this.buildIndex();
    }

    private PackageEntry findPackage(String string) {
        this.ensureIndexBuilt();
        return (PackageEntry)this.packageMap.get(string);
    }

    private static final class PackageEntry {
        private String[] classList;
        private String[] subPackageList;

        private PackageEntry(String[] stringArray, String[] stringArray2) {
            this.classList = stringArray;
            this.subPackageList = stringArray2;
        }

        PackageEntry(String[] stringArray, String[] stringArray2, 1 var3_3) {
            this(stringArray, stringArray2);
        }

        static String[] ra$classList(PackageEntry packageEntry) {
            return packageEntry.classList;
        }

        static String[] ra$subPackageList(PackageEntry packageEntry) {
            return packageEntry.subPackageList;
        }

        public final class 1 {
        }
    }
}

