/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.index;

import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.util.ArraySortedSet;
import oracle.jdevimpl.java.index.DirPath;
import oracle.jdevimpl.java.index.JarPath;
import oracle.jdevimpl.java.index.Path;

public final class LibraryManager {
    public static final int CLASS_POLICY = 1;
    public static final int SOURCE_POLICY = 2;
    private static final int DEFAULT_POLICY = 1;
    private Path[] classPaths;
    private Path[] sourcePaths;
    private int fetchPolicy;
    private static Map classPathCache = new HashMap();
    private static Map sourcePathCache = new HashMap();
    public static final String[] EMPTY_LIST = new String[0];

    public LibraryManager(URLPath uRLPath, URLPath uRLPath2, int n) {
        this.classPaths = this.convertToPaths(uRLPath, 1);
        this.sourcePaths = this.convertToPaths(uRLPath2, 2);
        this.fetchPolicy = n;
    }

    public void setFetchPolicy(int n) {
        this.fetchPolicy = n;
    }

    public String[] getSubPackages(String string) {
        ArraySortedSet arraySortedSet = new ArraySortedSet(10);
        this.getSubPackages(string, (Collection)arraySortedSet);
        int n = arraySortedSet.size();
        String[] stringArray = (String[])arraySortedSet.toArray((Object[])new String[n]);
        return stringArray;
    }

    public void getSubPackages(String string, Collection collection) {
        switch (this.fetchPolicy) {
            case 2: {
                int n = this.sourcePaths.length;
                int n2 = 0;
                while (n2 < n) {
                    Path path = this.sourcePaths[n2];
                    path.getSubPackages(string, collection);
                    ++n2;
                }
                break;
            }
        }
        int n = this.classPaths.length;
        int n3 = 0;
        while (n3 < n) {
            Path path = this.classPaths[n3];
            path.getSubPackages(string, collection);
            ++n3;
        }
    }

    public String[] findClasses(String string, boolean bl) {
        ArraySortedSet arraySortedSet = new ArraySortedSet(10);
        this.findClasses(string, bl, (Collection)arraySortedSet);
        int n = arraySortedSet.size();
        String[] stringArray = (String[])arraySortedSet.toArray((Object[])new String[n]);
        return stringArray;
    }

    public void findClasses(String string, boolean bl, Collection collection) {
        switch (this.fetchPolicy) {
            case 2: {
                int n = this.sourcePaths.length;
                int n2 = 0;
                while (n2 < n) {
                    Path path = this.sourcePaths[n2];
                    path.findClasses(string, bl, collection);
                    ++n2;
                }
                break;
            }
        }
        int n = this.classPaths.length;
        int n3 = 0;
        while (n3 < n) {
            Path path = this.classPaths[n3];
            path.findClasses(string, bl, collection);
            ++n3;
        }
    }

    public String[] getClassesInPackage(String string) {
        ArraySortedSet arraySortedSet = new ArraySortedSet(50);
        this.getClassesInPackage(string, (Collection)arraySortedSet);
        int n = arraySortedSet.size();
        String[] stringArray = (String[])arraySortedSet.toArray((Object[])new String[n]);
        return stringArray;
    }

    public void getClassesInPackage(String string, Collection collection) {
        switch (this.fetchPolicy) {
            case 2: {
                int n = this.sourcePaths.length;
                int n2 = 0;
                while (n2 < n) {
                    Path path = this.sourcePaths[n2];
                    path.getClassesInPackage(string, collection);
                    ++n2;
                }
                break;
            }
        }
        int n = this.classPaths.length;
        int n3 = 0;
        while (n3 < n) {
            Path path = this.classPaths[n3];
            path.getClassesInPackage(string, collection);
            ++n3;
        }
    }

    public String[] getInnerClasses(String string) {
        ArraySortedSet arraySortedSet = new ArraySortedSet(10);
        this.getInnerClasses(string);
        int n = arraySortedSet.size();
        String[] stringArray = (String[])arraySortedSet.toArray((Object[])new String[n]);
        return stringArray;
    }

    public void getInnerClasses(String string, Collection collection) {
        int n = this.classPaths.length;
        int n2 = 0;
        while (n2 < n) {
            Path path = this.classPaths[n2];
            path.getInnerClasses(string, collection);
            ++n2;
        }
    }

    public URL getClassURL(String string) {
        int n = this.classPaths.length;
        int n2 = 0;
        while (n2 < n) {
            Path path = this.classPaths[n2];
            URL uRL = path.getURL(string);
            if (uRL != null) {
                return uRL;
            }
            ++n2;
        }
        return null;
    }

    public URL getSourceURL(String string) {
        int n = this.sourcePaths.length;
        int n2 = 0;
        while (n2 < n) {
            Path path = this.sourcePaths[n2];
            URL uRL = path.getURL(string);
            if (uRL != null) {
                return uRL;
            }
            ++n2;
        }
        return null;
    }

    public URL getURL(String string) {
        switch (this.fetchPolicy) {
            case 2: {
                Node node;
                long l;
                URL uRL = this.getClassURL(string);
                URL uRL2 = this.getSourceURL(string);
                if (uRL == null) {
                    return uRL2;
                }
                if (uRL2 == null) {
                    return uRL;
                }
                long l2 = URLFileSystem.lastModified((URL)uRL);
                if (l2 >= (l = (node = NodeFactory.find((URL)uRL2)) != null && node.isOpen() ? node.getTimestamp() : URLFileSystem.lastModified((URL)uRL2))) {
                    return uRL;
                }
                return uRL2;
            }
        }
        URL uRL = this.getClassURL(string);
        if (uRL == null) {
            uRL = this.getSourceURL(string);
        }
        return uRL;
    }

    public synchronized void buildIndex() {
        int n;
        switch (this.fetchPolicy) {
            case 2: {
                n = this.sourcePaths.length;
                int n2 = 0;
                while (n2 < n) {
                    Path path = this.sourcePaths[n2];
                    path.buildIndex();
                    ++n2;
                }
                break;
            }
        }
        n = this.classPaths.length;
        int n3 = 0;
        while (n3 < n) {
            Path path = this.classPaths[n3];
            path.buildIndex();
            ++n3;
        }
    }

    private Path[] convertToPaths(URLPath uRLPath, int n) {
        URL[] uRLArray = uRLPath != null ? uRLPath.getEntries() : null;
        int n2 = uRLArray != null ? uRLArray.length : 0;
        Path[] pathArray = new Path[n2];
        int n3 = 0;
        while (n3 < n2) {
            URL uRL = uRLArray[n3];
            Path path = LibraryManager.getCache(uRL, n);
            if (path == null) {
                path = JarUtil.isJarURL((URL)uRL) ? (Path)new JarPath(uRL, n) : (Path)new DirPath(uRL, n);
                LibraryManager.putCached(uRL, n, path);
            }
            pathArray[n3] = path;
            ++n3;
        }
        return pathArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Path getCache(URL uRL, int n) {
        Map map = n == 1 ? classPathCache : sourcePathCache;
        Path path = null;
        Map map2 = map;
        synchronized (map2) {
            SoftReference softReference = (SoftReference)map.get(uRL);
            if (softReference != null) {
                path = (Path)softReference.get();
            }
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void putCached(URL uRL, int n, Path path) {
        Map map = n == 1 ? classPathCache : sourcePathCache;
        SoftReference<Path> softReference = new SoftReference<Path>(path);
        Map map2 = map;
        synchronized (map2) {
            map.put(uRL, softReference);
        }
    }

    public static String[] getStringArray(Collection collection) {
        int n = collection == null ? 0 : collection.size();
        String[] stringArray = n == 0 ? EMPTY_LIST : collection.toArray(new String[n]);
        return stringArray;
    }
}

