/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.insight;

import java.util.ArrayList;
import javax.swing.ListModel;
import javax.swing.text.BadLocationException;
import oracle.ide.model.Project;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditDescriptor;
import oracle.javatools.editor.insight.ListDataItem;
import oracle.javatools.editor.insight.ListDataItemListModel;
import oracle.javatools.editor.insight.ListInsightData;
import oracle.javatools.parser.java.v2.CallerContext;
import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaPackage;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.util.filter.JavaFilter;
import oracle.jdeveloper.compiler.OjcConfiguration;
import oracle.jdeveloper.style.CodingStyleManager;
import oracle.jdeveloper.style.CodingStyleOptions;
import oracle.jdevimpl.java.insight.InsightContext;
import oracle.jdevimpl.java.insight.InsightDataItem;
import oracle.jdevimpl.java.insight.JavaInsightOptions;
import oracle.jdevimpl.java.util.ExpressionFinder;
import oracle.jdevimpl.java.util.FoundSymbol;

abstract class AbstractCompletionInsightData
implements CallerContext.Constants,
JavaConstants,
ListInsightData {
    private static final int verboseValue = 0;
    static final int VERBOSE_MEMBER = 256;
    static final int VERBOSE_CLASS = 128;
    static final int VERBOSE_IMPORT = 64;
    static final int VERBOSE_PACKAGE = 32;
    static final int VERBOSE_LABEL = 16;
    static final int VERBOSE_ABSTRACT = 2;
    static final int VERBOSE_DETECT = 1;
    protected static final int OPTION_HIDE_DEPRECATED = 1;
    protected static final int OPTION_STRIKE_THRU_DEPRECATED = 2;
    protected static final int OPTION_SHOW_ACCESS_ICONS = 4;
    protected static final int OPTION_HIDE_OBJECT_DOT_STATIC = 8;
    final InsightContext helper;
    JavaProvider provider;
    CallerContext callerContext;
    ListDataItemListModel listModel;
    InsightDataItem[] dataList;
    InsightDataItem[] filterDataList;
    String currentPrefix;
    Object[] matchingDataList;
    int analysisStartOffset;
    int optionsMask;
    private JavaFilter resultFilter;
    static final InsightDataItem[] kEmptyDataList = new InsightDataItem[0];

    static boolean verboseOutput(int n) {
        return (0 & n) == n;
    }

    void verbosePrintln(String string) {
        if (AbstractCompletionInsightData.verboseOutput(2)) {
            System.out.print("AbstractInsight (");
            System.out.print(this.identifySelf());
            System.out.print("): ");
            System.out.println(string);
        }
    }

    abstract EditDescriptor getEditDescriptor();

    abstract String identifySelf();

    abstract void fillInitialDataImpl();

    abstract void updateDataImpl();

    int getNameStartOffset(ReadTextBuffer readTextBuffer, int n) {
        return AbstractCompletionInsightData.getIdentifierStart(readTextBuffer, n);
    }

    int getNameEndOffset(ReadTextBuffer readTextBuffer, int n) {
        return AbstractCompletionInsightData.getIdentifierEnd(readTextBuffer, n);
    }

    int getAnalysisStartOffset(ReadTextBuffer readTextBuffer, int n) {
        ExpressionFinder expressionFinder = this.helper.getFinder();
        FoundSymbol foundSymbol = expressionFinder.determinePrimaryPrefix(n, this.getPrimaryPrefixFilter());
        if (foundSymbol == null) {
            return AbstractCompletionInsightData.getIdentifierStart(readTextBuffer, n);
        }
        return foundSymbol.startOffset;
    }

    int getPrimaryPrefixFilter() {
        return 0;
    }

    protected CodingStyleOptions getCodingStyleOptions() {
        CodingStyleManager codingStyleManager = CodingStyleManager.getCodingStyleManager();
        if (codingStyleManager != null) {
            return codingStyleManager.getCodingStyleOptions();
        }
        return null;
    }

    protected void retrieveOptions(JavaInsightOptions javaInsightOptions) {
        OjcConfiguration ojcConfiguration;
        Project project;
        if (!javaInsightOptions.getShowDeprecated()) {
            this.optionsMask |= 1;
        } else if (javaInsightOptions.getStrikethruDeprecated()) {
            this.optionsMask |= 2;
        }
        if (javaInsightOptions.getShowAccessIcons()) {
            this.optionsMask |= 4;
        }
        if ((project = this.helper.getProject()) != null && (ojcConfiguration = OjcConfiguration.getInstance((PropertyStorage)project)).isShowObjectDotStaticWarnings()) {
            this.optionsMask |= 8;
        }
    }

    AbstractCompletionInsightData(InsightContext insightContext) {
        this.$init$();
        this.helper = insightContext;
        JavaInsightOptions javaInsightOptions = insightContext.getJavaInsightOptions();
        this.retrieveOptions(javaInsightOptions);
        this.provider = insightContext.getProvider();
        this.callerContext = insightContext.getCallerContext();
    }

    public ListModel getListModel() {
        return this.buildListModel();
    }

    private ListDataItemListModel buildListModel() {
        this.listModel = new ListDataItemListModel((ListDataItem[])((InsightDataItem[])this.getData()));
        return this.listModel;
    }

    public Object[] getData() {
        JavaFilter javaFilter = this.getResultFilter();
        if (javaFilter == null) {
            return this.dataList;
        }
        if (this.filterDataList == null) {
            int n = this.dataList.length;
            ArrayList<InsightDataItem> arrayList = new ArrayList<InsightDataItem>(n);
            int n2 = 0;
            while (n2 < n) {
                JavaElement javaElement = this.dataList[n2].getUnderlyingItem();
                if (javaFilter.accepts(javaElement)) {
                    arrayList.add(this.dataList[n2]);
                }
                ++n2;
            }
            int n3 = arrayList.size();
            this.filterDataList = arrayList.toArray(new InsightDataItem[n3]);
        }
        return this.filterDataList;
    }

    public Object[] getMatchingData() {
        if (this.matchingDataList == null) {
            String string = this.getCurrentPrefix();
            ListDataItemListModel listDataItemListModel = this.buildListModel();
            this.matchingDataList = listDataItemListModel.getMatchingData(string);
        }
        return this.matchingDataList;
    }

    public int getMatchingDataCount() {
        Object[] objectArray = this.getMatchingData();
        return objectArray == null ? 0 : objectArray.length;
    }

    public Object getDefault() {
        String string = this.getCurrentPrefix();
        ListDataItemListModel listDataItemListModel = this.buildListModel();
        ListDataItem listDataItem = listDataItemListModel.findClosestDataItem(string);
        return listDataItem;
    }

    protected String getCurrentPrefix() {
        if (this.currentPrefix == null) {
            TextBuffer textBuffer = this.helper.getTextBuffer();
            int n = this.helper.getCaretPosition();
            int n2 = this.getNameStartOffset((ReadTextBuffer)textBuffer, n);
            int n3 = n - n2;
            this.currentPrefix = textBuffer.getString(n2, n3);
        }
        return this.currentPrefix;
    }

    public boolean complete(Object object) {
        InsightDataItem insightDataItem = (InsightDataItem)((Object)object);
        String string = insightDataItem.getName();
        BasicDocument basicDocument = this.helper.getDocument();
        TextBuffer textBuffer = this.helper.getTextBuffer();
        int n = this.helper.getCaretPosition();
        int n2 = this.helper.getCaretPositionAdjustment();
        int n3 = this.getNameStartOffset((ReadTextBuffer)textBuffer, n);
        int n4 = this.getNameEndOffset((ReadTextBuffer)textBuffer, n);
        BasicEditorPane basicEditorPane = this.helper.getEditorPane();
        basicEditorPane.beginEdit(this.getEditDescriptor());
        try {
            try {
                basicDocument.remove(n3 + n2, n4 - n3);
                basicDocument.insertString(n3 + n2, string, null);
            }
            catch (BadLocationException badLocationException) {
                System.err.println("Exception occurred in completion: " + badLocationException);
                badLocationException.printStackTrace();
            }
        }
        finally {
            basicEditorPane.endEdit();
        }
        return false;
    }

    public void partialComplete() {
        BasicDocument basicDocument = this.helper.getDocument();
        TextBuffer textBuffer = this.helper.getTextBuffer();
        int n = this.helper.getCaretPosition();
        basicDocument.readLock();
        try {
            int n2 = this.getNameStartOffset((ReadTextBuffer)textBuffer, n);
            int n3 = this.getNameEndOffset((ReadTextBuffer)textBuffer, n);
            int n4 = n - n2;
            String string = textBuffer.getString(n2, n4);
            ListDataItemListModel listDataItemListModel = this.buildListModel();
            String string2 = listDataItemListModel.findCommonPrefix(string);
            if (string2.length() == 0) {
                basicDocument.readUnlock();
                return;
            }
            int n5 = this.helper.getCaretPositionAdjustment();
            BasicEditorPane basicEditorPane = this.helper.getEditorPane();
            basicEditorPane.beginEdit(this.getEditDescriptor());
            try {
                try {
                    basicDocument.remove(n2 + n5, n3 - n2);
                    basicDocument.insertString(n2 + n5, string2, null);
                }
                catch (BadLocationException badLocationException) {
                    System.err.println("Exception occurred in partial completion: " + badLocationException);
                    badLocationException.printStackTrace();
                }
            }
            finally {
                basicEditorPane.endEdit();
            }
        }
        finally {
            basicDocument.readUnlock();
        }
    }

    void $init$() {
        this.optionsMask = 0;
    }

    void clearData() {
        this.dataList = kEmptyDataList;
        this.matchingDataList = null;
        this.listModel = null;
        this.filterDataList = null;
        this.currentPrefix = null;
    }

    private void clearFilterData() {
        this.listModel = null;
        this.matchingDataList = null;
        this.filterDataList = null;
    }

    private void updateDataListForAccessIcons() {
        if (this.option(4)) {
            int n = this.dataList.length;
            int n2 = 0;
            while (n2 < n) {
                this.dataList[n2].setShowAccessIcon();
                ++n2;
            }
        }
    }

    final void fillInitialData() {
        this.verbosePrintln("fillInitialData");
        this.clearData();
        TextBuffer textBuffer = this.helper.getTextBuffer();
        int n = this.helper.getCaretPosition();
        this.analysisStartOffset = this.getAnalysisStartOffset((ReadTextBuffer)textBuffer, n);
        this.fillInitialDataImpl();
        this.updateDataListForAccessIcons();
    }

    final void updateData() {
        this.verbosePrintln("updateData");
        TextBuffer textBuffer = this.helper.getTextBuffer();
        int n = this.helper.getCaretPosition();
        int n2 = this.getAnalysisStartOffset((ReadTextBuffer)textBuffer, n);
        if (n2 != this.analysisStartOffset) {
            this.clearData();
            return;
        }
        this.verbosePrintln("updateDataImpl");
        this.updateDataImpl();
        this.currentPrefix = null;
        this.matchingDataList = null;
        this.updateDataListForAccessIcons();
    }

    void fillDataListHelper(CallerContext.InputOptions inputOptions) {
        this.fillDataListHelper(0, 0, false, inputOptions);
    }

    void fillDataListHelper(int n, int n2, boolean bl, CallerContext.InputOptions inputOptions) {
        CallerContext.Output output;
        this.clearData();
        JavaPackage javaPackage = null;
        JavaHasType javaHasType = null;
        if (n != n2) {
            SourceFactory sourceFactory;
            SourceExpression sourceExpression;
            TextBuffer textBuffer = this.helper.getTextBuffer();
            String string = textBuffer.getString(n, n2 - n);
            SourceElement sourceElement = this.callerContext.getSourceScope();
            SourceFile sourceFile = sourceElement.getOwningSourceFile();
            if (sourceFile == null) {
                CommonUtilities.panic((String)"No SourceFile instance");
            }
            if ((sourceExpression = (sourceFactory = sourceFile.getFactory()).createExpression(string)) != null) {
                sourceExpression.setContext(this.callerContext);
                javaHasType = sourceExpression.getResolvedObject();
                if (javaHasType == null) {
                    if (CommonUtilities.isValidQualifiedName((String)string)) {
                        javaPackage = this.provider.getPackage(string);
                    } else {
                        this.errorSemantic("Could not determine lhs context.");
                        return;
                    }
                }
            }
        }
        if (!(output = javaPackage != null ? this.callerContext.listNames(javaPackage, inputOptions) : this.callerContext.listNames(javaHasType, inputOptions)).isEmpty()) {
            this.dataList = InsightDataItem.createInsightDataItems(output.all);
        } else {
            this.errorEmpty(null);
        }
    }

    void errorParsing() {
    }

    void errorSemantic(String string) {
    }

    void errorEmpty(String string) {
    }

    /*
     * Unable to fully structure code
     */
    protected String findCurrentPrefix() {
        var1_1 = this.helper.getTextBuffer();
        var2_2 = this.helper.getCaretPosition();
        var3_3 = this.analysisStartOffset;
        var4_4 = AbstractCompletionInsightData.getIdentifierStart((ReadTextBuffer)var1_1, var2_2);
        if (var4_4 != var3_3) ** GOTO lbl8
        return "";
lbl-1000:
        // 1 sources

        {
            --var4_4;
lbl8:
            // 2 sources

            ** while (Character.isWhitespace((char)var1_1.getChar((int)(var4_4 - 1))))
        }
lbl9:
        // 1 sources

        var5_5 = var4_4 - var3_3;
        return var1_1.getString(var3_3, var5_5);
    }

    protected static int getIdentifierStart(ReadTextBuffer readTextBuffer, int n) {
        int n2 = n - 1;
        while (n2 >= 0) {
            char c = readTextBuffer.getChar(n2);
            if (!Character.isJavaIdentifierPart(c)) break;
            --n2;
        }
        return n2 + 1;
    }

    protected static int getIdentifierEnd(ReadTextBuffer readTextBuffer, int n) {
        int n2 = n;
        int n3 = readTextBuffer.getLength();
        while (n2 < n3) {
            char c = readTextBuffer.getChar(n2);
            if (!Character.isJavaIdentifierPart(c)) break;
            ++n2;
        }
        return n2;
    }

    protected static String removeInitialNew(String string) {
        if (!string.startsWith("new")) {
            return string;
        }
        if (!Character.isWhitespace(string.charAt(3))) {
            return string;
        }
        int n = string.length();
        int n2 = 4;
        while (n2 < n) {
            if (!Character.isWhitespace(string.charAt(n2))) break;
            ++n2;
        }
        return string.substring(n2);
    }

    JavaFilter getResultFilter() {
        return this.resultFilter;
    }

    void setResultFilter(JavaFilter javaFilter) {
        if (this.resultFilter != null) {
            this.clearFilterData();
        }
        this.resultFilter = javaFilter;
    }

    protected final boolean option(int n) {
        return (this.optionsMask & n) != 0;
    }
}

