/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.insight;

import oracle.javatools.editor.insight.TooltipDataItem;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.jdevimpl.java.JavaArb;

final class AnnotationDataItem
extends TooltipDataItem
implements Comparable {
    private JavaMethod method;
    private String displayText;
    private boolean hasValue;

    AnnotationDataItem() {
        this.method = null;
        this.displayText = JavaArb.getString(42);
        this.hasValue = true;
    }

    AnnotationDataItem(JavaMethod javaMethod, boolean bl) {
        this.method = javaMethod;
        this.displayText = null;
        this.hasValue = bl;
    }

    public String getDisplayText() {
        if (this.displayText == null && this.method != null) {
            JavaType javaType = this.method.getReturnType();
            JavaClass javaClass = null;
            if (javaType != null) {
                javaClass = javaType.getTypeErasure();
            }
            String string = javaClass != null ? javaClass.getName() : "<unknown>";
            String string2 = this.method.getName();
            this.displayText = string + ' ' + string2;
        }
        return this.displayText;
    }

    final boolean hasValue() {
        return this.hasValue;
    }

    public boolean isDeprecated() {
        return this.method.isDeprecated();
    }

    public String toString() {
        return this.getDisplayText();
    }

    private String getCompareKey() {
        if (this.method != null) {
            return this.method.getName();
        }
        return "";
    }

    public int compareTo(Object object) {
        if (object instanceof AnnotationDataItem) {
            return this.getCompareKey().compareTo(((AnnotationDataItem)object).getCompareKey());
        }
        return 0;
    }
}

