/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.insight;

import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.undo.UndoableEdit;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.javatools.buffer.OffsetMark;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditDescriptor;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.java.v2.JavaParser;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceImport;
import oracle.javatools.parser.java.v2.model.SourcePackage;
import oracle.javatools.parser.java.v2.scanner.JavaLexer;
import oracle.javatools.parser.java.v2.util.SimplifyTypeHelper;
import oracle.javatools.parser.java.v2.write.SourceTransaction;
import oracle.jdeveloper.audit.java.JavaTransformContext;
import oracle.jdeveloper.audit.transform.UndoableEditCommand;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.style.CodingStyleOptions;
import oracle.jdevimpl.java.Context2ParserHelper;
import oracle.jdevimpl.java.JavaArb;
import oracle.jdevimpl.java.insight.AbstractCompletionInsightData;
import oracle.jdevimpl.java.insight.InsightContext;
import oracle.jdevimpl.java.insight.JavaInsightOptions;

abstract class AutoImportInsightData
extends AbstractCompletionInsightData {
    private static final int OPTION_ADD_AUTOMATIC_IMPORT = 16;
    private static final int OPTION_USE_EXPLICIT_IMPORT = 32;
    static final EditDescriptor dropPackageDescriptor;
    private int importInsertOffset;

    static {
        String string = JavaArb.getString(56);
        dropPackageDescriptor = new EditDescriptor(string);
    }

    protected void retrieveOptions(JavaInsightOptions javaInsightOptions) {
        CodingStyleOptions codingStyleOptions;
        super.retrieveOptions(javaInsightOptions);
        if (javaInsightOptions.getAutoImport()) {
            this.optionsMask |= 0x10;
        }
        if ((codingStyleOptions = this.getCodingStyleOptions()) != null && !codingStyleOptions.getUseWideImports()) {
            this.optionsMask |= 0x20;
        }
    }

    AutoImportInsightData(InsightContext insightContext) {
        super(insightContext);
        TextBuffer textBuffer = insightContext.getTextBuffer();
        this.getParsedInfo(textBuffer);
    }

    void autoImport(String string) {
        String string2;
        boolean bl = this.option(16);
        if (!bl) {
            return;
        }
        SourceElement sourceElement = this.callerContext.getSourceScope();
        SimplifyTypeHelper simplifyTypeHelper = SimplifyTypeHelper.simplifyTypeName((SourceElement)sourceElement, (String)string);
        if (simplifyTypeHelper == null) {
            return;
        }
        int n = -1;
        String string3 = simplifyTypeHelper.getSimplifiedName();
        if (string3 != null) {
            int n2 = string.length();
            int n3 = string3.length();
            n = this.analysisStartOffset + n2 - n3;
        }
        if ((string2 = simplifyTypeHelper.getImportName()) != null) {
            if (string3 == null) {
                CommonUtilities.panic((String)"Add-import implies drop-prefix.");
            }
            this.doAutoImport(n, string2);
        } else if (string3 != null) {
            this.doDropPrefix(n);
        }
    }

    private void getParsedInfo(TextBuffer textBuffer) {
        this.importInsertOffset = 0;
        SourceFile sourceFile = JavaParser.parse((ReadTextBuffer)textBuffer);
        if (sourceFile != null) {
            List list;
            SourcePackage sourcePackage = sourceFile.getSourcePackage();
            if (sourcePackage != null) {
                this.importInsertOffset = sourcePackage.getEndOffset();
            }
            if (!(list = sourceFile.getSourceImports()).isEmpty()) {
                for (SourceImport sourceImport : list) {
                    this.importInsertOffset = Math.max(this.importInsertOffset, sourceImport.getEndOffset());
                }
            }
        }
    }

    private void doDropPrefix(int n) {
        int n2 = this.analysisStartOffset;
        int n3 = n - n2;
        BasicEditorPane basicEditorPane = this.helper.getEditorPane();
        BasicDocument basicDocument = this.helper.getDocument();
        basicEditorPane.beginEdit(dropPackageDescriptor);
        try {
            try {
                basicDocument.remove(n2, n3);
            }
            catch (BadLocationException badLocationException) {
                System.err.println("Exception occurred in completion: " + badLocationException);
                badLocationException.printStackTrace();
            }
        }
        finally {
            basicEditorPane.endEdit();
        }
    }

    private void doAutoImport(int n, String string) {
        TextBuffer textBuffer = this.helper.getTextBuffer();
        textBuffer.writeLock();
        try {
            UndoableEdit undoableEdit;
            Context context = CodeEditor.getContext((BasicEditorPane)this.helper.getEditorPane());
            JavaManager javaManager = Context2ParserHelper.createHelper(context).getJavaManager();
            SourceFile sourceFile = javaManager.getSourceFile(textBuffer);
            OffsetMark offsetMark = textBuffer.addOffsetMark(this.analysisStartOffset);
            OffsetMark offsetMark2 = textBuffer.addOffsetMark(n);
            UndoableEditCommand undoableEditCommand = new UndoableEditCommand(JavaArb.getString(55), context);
            boolean bl = false;
            SourceTransaction sourceTransaction = sourceFile.beginTransaction();
            try {
                bl = JavaTransformContext.addImport((SourceFile)sourceFile, (String)string) != null;
            }
            finally {
                if (bl) {
                    undoableEdit = sourceTransaction.commit();
                    undoableEditCommand.addEdit(undoableEdit);
                } else {
                    sourceTransaction.abort();
                }
            }
            int n2 = offsetMark.getOffset();
            int n3 = offsetMark2.getOffset();
            textBuffer.removeOffsetMark(offsetMark);
            textBuffer.removeOffsetMark(offsetMark2);
            undoableEdit = textBuffer.remove(n2, n3 - n2);
            undoableEditCommand.addEdit(undoableEdit);
            try {
                CommandProcessor commandProcessor = CommandProcessor.getInstance();
                commandProcessor.invoke((Command)undoableEditCommand);
                if (bl) {
                    String string2 = JavaArb.format(43, string);
                    this.helper.showFeedback(string2);
                }
            }
            catch (Exception exception) {}
        }
        finally {
            textBuffer.writeUnlock();
        }
    }

    private boolean isOkayToAddNarrowImport(String string) {
        if (string.length() == 0) {
            return false;
        }
        TextBuffer textBuffer = this.helper.getTextBuffer();
        textBuffer.readLock();
        try {
            boolean bl = !this.narrowImportAlreadyExists(textBuffer, string) && !this.isSimpleNameReferencedElsewhere(textBuffer, string);
            textBuffer.readUnlock();
            return bl;
        }
        catch (Throwable throwable) {
            textBuffer.readUnlock();
            throw throwable;
        }
    }

    private boolean narrowImportAlreadyExists(TextBuffer textBuffer, String string) {
        List list;
        SourceFile sourceFile = JavaParser.parse((ReadTextBuffer)textBuffer);
        if (sourceFile != null && !(list = sourceFile.getSourceImports()).isEmpty()) {
            for (SourceImport sourceImport : list) {
                String string2 = sourceImport.getName();
                if (!string2.endsWith(string)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isSimpleNameReferencedElsewhere(TextBuffer textBuffer, String string) {
        char c = string.charAt(0);
        boolean bl = false;
        JavaLexer javaLexer = new JavaLexer();
        javaLexer.setTextBuffer((ReadTextBuffer)textBuffer);
        LexerToken lexerToken = javaLexer.createLexerToken();
        block5: while (true) {
            int n = javaLexer.lex(lexerToken);
            switch (n) {
                case 0: {
                    break block5;
                }
                case 43: {
                    bl = true;
                    continue block5;
                }
                case 4: {
                    int n2;
                    String string2;
                    int n3;
                    if (!bl && textBuffer.getChar(n3 = lexerToken.getStartOffset()) == c && string.equals(string2 = textBuffer.getString(n3, n2 = lexerToken.getEndOffset() - n3))) {
                        return true;
                    }
                }
                default: {
                    bl = false;
                    continue block5;
                }
            }
            break;
        }
        return false;
    }
}

