/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.insight;

import javax.swing.text.BadLocationException;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditDescriptor;
import oracle.javatools.parser.java.v2.CallerContext;
import oracle.javatools.parser.java.v2.JavaTokens;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceHasModifiers;
import oracle.javatools.parser.java.v2.model.SourceMember;
import oracle.javatools.parser.java.v2.util.filter.AnnotationFilter;
import oracle.javatools.parser.java.v2.util.filter.AssignableFilter;
import oracle.javatools.parser.java.v2.util.filter.JavaFilter;
import oracle.javatools.parser.java.v2.util.filter.OrFilter;
import oracle.jdevimpl.java.JavaArb;
import oracle.jdevimpl.java.insight.AutoImportInsightData;
import oracle.jdevimpl.java.insight.InsightContext;
import oracle.jdevimpl.java.insight.InsightDataItem;
import oracle.jdevimpl.java.insight.PackageFilter;
import oracle.jdevimpl.java.insight.TypeFilter;
import oracle.jdevimpl.java.util.ExpressionFinder;
import oracle.jdevimpl.java.util.FoundSymbol;

final class ClassInsightData
extends AutoImportInsightData
implements JavaTokens {
    private static final EditDescriptor classDescriptor;
    private String namePrefix;
    private String thisName;
    private int showMode;
    private static final int SHOW_EXTENDIBLE_CLASSES = 1;
    private static final int SHOW_EXTENDIBLE_INTERFACES = 2;
    private static final int SHOW_ALL_INTERFACES = 3;
    private static final int SHOW_THROWABLES = 4;
    private static final int SHOW_ANNOTATIONS = 5;
    private static final int SHOW_EVERYTHING = 6;

    int getAnalysisStartOffset(ReadTextBuffer readTextBuffer, int n) {
        ExpressionFinder expressionFinder = this.helper.getFinder();
        FoundSymbol foundSymbol = expressionFinder.determinePrimaryPrefix(n, this.getPrimaryPrefixFilter());
        if (foundSymbol == null) {
            return ClassInsightData.getIdentifierStart(readTextBuffer, n);
        }
        String string = ClassInsightData.removeInitialNew(foundSymbol.string);
        int n2 = foundSymbol.string.length() - string.length();
        return foundSymbol.startOffset + n2;
    }

    EditDescriptor getEditDescriptor() {
        return classDescriptor;
    }

    String identifySelf() {
        return "Class";
    }

    ClassInsightData(InsightContext insightContext, int n, JavaFilter javaFilter) {
        super(insightContext);
        this.$init$();
        this.setResultFilter(javaFilter);
        this.determineContext(n);
        this.fillInitialData();
    }

    static {
        String string = JavaArb.getString(53);
        classDescriptor = new EditDescriptor(string);
    }

    public boolean complete(Object object) {
        boolean bl;
        InsightDataItem insightDataItem = (InsightDataItem)((Object)object);
        String string = insightDataItem.getName();
        String string2 = "";
        boolean bl2 = false;
        InsightDataItem insightDataItem2 = insightDataItem;
        boolean bl3 = bl = insightDataItem.getItemType() == 9;
        if (bl) {
            string2 = ".";
            bl2 = true;
        }
        BasicDocument basicDocument = this.helper.getDocument();
        TextBuffer textBuffer = this.helper.getTextBuffer();
        int n = this.helper.getCaretPosition();
        int n2 = this.analysisStartOffset;
        int n3 = this.getNameStartOffset((ReadTextBuffer)textBuffer, n);
        int n4 = this.getNameEndOffset((ReadTextBuffer)textBuffer, n);
        int n5 = this.helper.getCaretPositionAdjustment();
        basicDocument.readLock();
        try {
            String string3;
            if (string2.length() > 0 && textBuffer.getLength() > n4 && (string3 = textBuffer.getString(n4, 1)).equals(string2)) {
                ++n4;
            }
            BasicEditorPane basicEditorPane = this.helper.getEditorPane();
            basicEditorPane.beginEdit(classDescriptor);
            try {
                try {
                    basicDocument.remove(n3 + n5, n4 - n3);
                    basicDocument.insertString(n3 + n5, string + string2, null);
                }
                catch (BadLocationException badLocationException) {
                    System.err.println("Exception occurred in completion: " + badLocationException);
                    badLocationException.printStackTrace();
                }
            }
            finally {
                basicEditorPane.endEdit();
            }
            if (!bl && this.namePrefix.length() > 0) {
                this.autoImport(this.namePrefix + string);
            }
        }
        finally {
            basicDocument.readUnlock();
        }
        return bl2;
    }

    void $init$() {
        this.thisName = null;
    }

    void fillInitialDataImpl() {
        this.namePrefix = this.findCurrentPrefix();
        this.fillDataList();
    }

    void updateDataImpl() {
        String string = this.findCurrentPrefix();
        if (!string.startsWith(this.namePrefix)) {
            this.clearData();
            return;
        }
        if (!this.namePrefix.equals(string)) {
            this.namePrefix = string;
            this.fillDataList();
        }
    }

    private void determineContext(int n) {
        switch (n) {
            case 110: {
                ExpressionFinder expressionFinder = this.helper.getFinder();
                int n2 = this.helper.getCaretPosition();
                String[] stringArray = new String[1];
                boolean bl = expressionFinder.precededByClassKeyword(n2, stringArray);
                this.thisName = bl ? stringArray[0] : null;
                this.showMode = bl ? 1 : 2;
                break;
            }
            case 117: {
                this.showMode = 3;
                break;
            }
            case 137: 
            case 138: {
                this.showMode = 4;
                break;
            }
            case 124: {
                this.showMode = 6;
                break;
            }
            case 79: {
                this.showMode = 5;
                break;
            }
            default: {
                throw new RuntimeException("Should not be reachable");
            }
        }
    }

    private void fillDataList() {
        int n;
        int n2 = n = this.analysisStartOffset;
        if (this.namePrefix.length() > 0) {
            n2 += this.namePrefix.length() - 1;
        }
        CallerContext.InputOptions inputOptions = new CallerContext.InputOptions();
        inputOptions.input = (byte)6;
        if (this.option(1)) {
            inputOptions.squash = (byte)(inputOptions.squash | 0x10);
        }
        switch (this.showMode) {
            case 4: {
                JavaClass javaClass = this.provider.getClassByVMName("java/lang/Throwable");
                if (javaClass == null) break;
                inputOptions.filter = new AssignableFilter((JavaType)javaClass);
                break;
            }
            case 1: {
                inputOptions.squash = (byte)(inputOptions.squash | 0x40);
                inputOptions.filter = new TypeFilter(true, false, true);
                break;
            }
            case 2: {
                inputOptions.squash = (byte)(inputOptions.squash | 0x40);
                inputOptions.filter = new TypeFilter(false, true, true);
                break;
            }
            case 3: {
                inputOptions.filter = new TypeFilter(false, true, false);
                break;
            }
            case 5: {
                int n3 = this.helper.getCaretPosition();
                SourceFile sourceFile = this.helper.getSourceFile();
                SourceElement sourceElement = sourceFile.getElementAt(n3);
                if (sourceElement.getSymbolKind() == 1) {
                    sourceElement = sourceElement.getParent();
                }
                if (sourceElement instanceof SourceMember) {
                    SourceMember sourceMember = (SourceMember)sourceElement;
                    inputOptions.filter = new AnnotationFilter((SourceHasModifiers)sourceMember);
                } else {
                    int n4 = sourceElement.getSymbolKind();
                    switch (n4) {
                        case 12: 
                        case 13: 
                        case 17: 
                        case 18: 
                        case 22: {
                            inputOptions.filter = new AnnotationFilter(n4);
                        }
                    }
                }
                if (inputOptions.filter != null) break;
                inputOptions.filter = new AnnotationFilter();
                break;
            }
            case 6: {
                break;
            }
            default: {
                throw new RuntimeException("Not a showMode");
            }
        }
        if (inputOptions.filter != null) {
            PackageFilter packageFilter = new PackageFilter();
            OrFilter orFilter = new OrFilter((JavaFilter)packageFilter, inputOptions.filter);
            inputOptions.filter = orFilter;
        }
        this.fillDataListHelper(n, n2, false, inputOptions);
    }
}

