/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.insight;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.accessibility.AccessibleContext;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.insight.PrototypeCellProvider;
import oracle.javatools.parser.java.v2.model.JavaVariable;
import oracle.javatools.util.SwingUtils;
import oracle.jdevimpl.java.insight.InsightDataItem;

final class CompletionCellRenderer
extends JLabel
implements PrototypeCellProvider,
ListCellRenderer {
    private boolean boldDeclaredMembersOption;
    private boolean italicLocalVariablesOption;
    private boolean strikethruDeprecatedOption;
    private boolean showDefiningClassOption;
    private static final int HORIZONTAL_PADDING = 6;
    private static final int VERTICAL_PADDING = 2;
    private static final int INSIDE_PADDING = 8;
    private int cellTypeWidth;
    private int cellNameWidth;
    private int cellIconWidth;
    private int cellHeight;
    private Dimension cellSize;
    private InsightDataItem currentItem;

    public CompletionCellRenderer() {
        this.$init$();
        this.setOpaque(false);
        this.updateCellSize(0, 0, 0, 0);
    }

    protected void setBoldDeclaredMembers(boolean bl) {
        this.boldDeclaredMembersOption = bl;
    }

    protected void setItalicLocalVariables(boolean bl) {
        this.italicLocalVariablesOption = bl;
    }

    protected void setStrikethruDeprecated(boolean bl) {
        this.strikethruDeprecatedOption = bl;
    }

    protected void setShowDefiningClass(boolean bl) {
        this.showDefiningClassOption = bl;
    }

    void $init$() {
        this.boldDeclaredMembersOption = false;
        this.italicLocalVariablesOption = false;
        this.strikethruDeprecatedOption = false;
        this.showDefiningClassOption = false;
        this.cellTypeWidth = 0;
        this.cellNameWidth = 0;
        this.cellIconWidth = 0;
        this.cellHeight = 0;
        this.cellSize = new Dimension();
        this.currentItem = null;
    }

    private void updateCellSize(int n, int n2, int n3, int n4) {
        this.cellTypeWidth = Math.max(n, 50);
        this.cellNameWidth = Math.max(n2, 80);
        this.cellIconWidth = n3;
        this.cellHeight = n4;
        this.cellSize.width = 6 + this.cellIconWidth + 8 + this.cellTypeWidth + 8 + this.cellNameWidth + 6;
        this.cellSize.height = 2 + this.cellHeight + 2;
        EditorProperties editorProperties = EditorProperties.getProperties();
        int n5 = editorProperties.getIntegerProperty("insight-max-popup-width");
        Dimension dimension = this.getToolkit().getScreenSize();
        if (this.cellSize.width > (n5 = Math.min(dimension.width / 2 - 20, n5))) {
            this.cellSize.width = n5;
            int n6 = n5 - 12 - this.cellIconWidth - 16;
            this.cellTypeWidth = Math.min(n6 / 3, this.cellTypeWidth);
            this.cellNameWidth = n6 - this.cellTypeWidth;
        }
        this.setMinimumSize(this.cellSize);
        this.setPreferredSize(this.cellSize);
        this.setMaximumSize(this.cellSize);
    }

    public void paint(Graphics graphics) {
        Font font;
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.cellSize.width, this.cellSize.height);
        if (this.currentItem != null && (font = this.getFont()) != null) {
            String string;
            Font font2;
            FontMetrics fontMetrics = this.getFontMetrics(font);
            int n = fontMetrics.getAscent();
            int n2 = fontMetrics.getHeight();
            Font font3 = this.boldDeclaredMembersOption ? font.deriveFont(1) : font;
            FontMetrics fontMetrics2 = this.getFontMetrics(font3);
            Font font4 = this.italicLocalVariablesOption ? font.deriveFont(2) : font;
            FontMetrics fontMetrics3 = this.getFontMetrics(font4);
            boolean bl = this.currentItem.belongsToClass();
            boolean bl2 = this.currentItem.getUnderlyingItem() instanceof JavaVariable;
            Font font5 = bl ? font3 : (font2 = bl2 ? font4 : font);
            FontMetrics fontMetrics4 = bl ? fontMetrics2 : (bl2 ? fontMetrics3 : fontMetrics);
            Icon icon = this.currentItem.getIcon();
            if (icon != null) {
                int n3 = 6;
                int n4 = 2;
                int n5 = icon.getIconHeight();
                int n6 = (this.cellHeight - n5) / 2;
                icon.paintIcon(this, graphics, 6, 2 + n6);
            }
            graphics.setColor(this.getForeground());
            graphics.setFont(font2);
            int n7 = (this.cellHeight - n2) / 2;
            int n8 = 2 + n + n7;
            String string2 = this.currentItem.getDisplayCellName();
            int n9 = fontMetrics4.stringWidth(string2);
            if (n9 > this.cellNameWidth) {
                string2 = this.truncateString(string2, n9, this.cellNameWidth, fontMetrics4);
                n9 = fontMetrics4.stringWidth(string2);
            }
            int n10 = 6 + this.cellIconWidth + 8;
            SwingUtils.drawString((Graphics)graphics, (String)string2, (int)n10, (int)n8);
            String string3 = this.currentItem.getDisplayCellType();
            int n11 = fontMetrics4.stringWidth(string3);
            if (this.showDefiningClassOption && (string = this.currentItem.declaringClass()) != null && string.length() > 0) {
                string3 = string3 + " - " + string;
                n11 += fontMetrics4.stringWidth(" - ") + fontMetrics4.stringWidth(string);
            }
            if (n11 > this.cellTypeWidth) {
                string3 = this.truncateString(string3, n11, this.cellTypeWidth, fontMetrics4);
                n11 = fontMetrics4.stringWidth(string3);
            }
            int n12 = this.cellSize.width - 6 - n11;
            SwingUtils.drawString((Graphics)graphics, (String)string3, (int)n12, (int)n8);
            if (this.strikethruDeprecatedOption && this.currentItem.isDeprecated()) {
                int n13 = n7 + 2 + n * 2 / 3;
                if (n9 > 0) {
                    graphics.drawLine(n10, n13, n10 + n9, n13);
                }
                if (n11 > 0) {
                    graphics.drawLine(n12, n13, n12 + n11, n13);
                }
            }
        }
    }

    protected String truncateString(String string, int n, int n2, FontMetrics fontMetrics) {
        if (n < n2) {
            return string;
        }
        String string2 = "...";
        int n3 = n2 - fontMetrics.stringWidth("...");
        int n4 = n;
        int n5 = string.length() - 1;
        while (n4 > n3 && n5 > 0) {
            char c = string.charAt(n5--);
            int n6 = fontMetrics.charWidth(c);
            n4 -= n6;
        }
        String string3 = string.substring(0, n5 + 1) + "...";
        return string3;
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        if (bl) {
            this.setBackground(jList.getSelectionBackground());
            this.setForeground(jList.getSelectionForeground());
        } else {
            this.setBackground(jList.getBackground());
            this.setForeground(jList.getForeground());
        }
        this.setFont(jList.getFont());
        if (object instanceof InsightDataItem) {
            this.currentItem = (InsightDataItem)((Object)object);
            AccessibleContext accessibleContext = this.getAccessibleContext();
            if (accessibleContext != null) {
                accessibleContext.setAccessibleName(this.currentItem.getAccessibleText());
            }
        }
        return this;
    }

    public Object getPrototypeCell(JList jList, ListModel listModel) {
        Font font = jList.getFont();
        FontMetrics fontMetrics = this.getFontMetrics(font);
        Font font2 = this.boldDeclaredMembersOption ? font.deriveFont(1) : font;
        FontMetrics fontMetrics2 = this.getFontMetrics(font2);
        Font font3 = this.italicLocalVariablesOption ? font.deriveFont(2) : font;
        FontMetrics fontMetrics3 = this.getFontMetrics(font3);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        String string = this.showDefiningClassOption ? " - " : null;
        int n4 = fontMetrics.getHeight();
        int n5 = listModel.getSize();
        int n6 = 0;
        while (n6 < n5) {
            String string2;
            InsightDataItem insightDataItem = (InsightDataItem)((Object)listModel.getElementAt(n6));
            Icon icon = insightDataItem.getIcon();
            boolean bl = insightDataItem.belongsToClass();
            boolean bl2 = insightDataItem.getUnderlyingItem() instanceof JavaVariable;
            FontMetrics fontMetrics4 = bl ? fontMetrics2 : (bl2 ? fontMetrics3 : fontMetrics);
            int n7 = 0;
            if (string != null && (string2 = insightDataItem.declaringClass()) != null && string2.length() > 0) {
                n7 = fontMetrics4.stringWidth(string) + fontMetrics4.stringWidth(string2);
            }
            String string3 = insightDataItem.getDisplayCellType();
            int n8 = fontMetrics4.stringWidth(string3) + n7;
            n = Math.max(n, n8);
            String string4 = insightDataItem.getDisplayCellName();
            int n9 = fontMetrics4.stringWidth(string4);
            n2 = Math.max(n2, n9);
            if (icon != null) {
                int n10 = icon.getIconWidth();
                n3 = Math.max(n3, n10);
                int n11 = icon.getIconHeight();
                n4 = Math.max(n4, n11);
            }
            ++n6;
        }
        this.updateCellSize(n, n2, n3, n4);
        return new int[0];
    }
}

