/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.insight;

import javax.swing.ListCellRenderer;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.config.ClientSetting;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.FeedbackManager;
import oracle.javatools.editor.insight.AbstractInsight;
import oracle.javatools.editor.insight.InsightData;
import oracle.javatools.editor.insight.InsightProvider;
import oracle.javatools.editor.insight.InsightView;
import oracle.javatools.editor.insight.ListInsightView;
import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.util.filter.JavaFilter;
import oracle.javatools.util.Copyable;
import oracle.jdevimpl.java.insight.CompletionCellRenderer;
import oracle.jdevimpl.java.insight.InsightContext;
import oracle.jdevimpl.java.insight.InsightContextImpl;
import oracle.jdevimpl.java.insight.InsightDataItem;
import oracle.jdevimpl.java.insight.JavaInsightOptions;
import oracle.jdevimpl.java.insight.RegularInsightProvider;
import oracle.jdevimpl.java.insight.SmartInsightProvider;

public class CompletionInsight
extends AbstractInsight
implements JavaConstants {
    private JavaFilter _smartFilter;
    protected static final String COMPLETION_INSTANCE = "java-completion";
    protected static final String PARAMETER_INSTANCE = "java-parameter";
    public static final int FEEDBACK_MESSAGE_DELAY = 5000;
    protected static final boolean DEBUG_DUMP_TEXT_BUFFER = false;
    protected static final String DEBUG_DUMP_FILE_NAME = "insight_buffer_dump.java";

    public CompletionInsight() {
        this.$init$();
    }

    public CompletionInsight(Context context) {
        this();
    }

    protected Context getContext() {
        Context context = CodeEditor.getContext((BasicEditorPane)this.getEditorPane());
        return context;
    }

    public int getInsightType() {
        return 1;
    }

    void $init$() {
        this._smartFilter = null;
    }

    protected InsightProvider createInsightProvider() {
        return new RegularProvider(false);
    }

    protected InsightProvider createSmartInsightProvider() {
        return new RegularProvider(true);
    }

    protected InsightContext createInsightContext(BasicEditorPane basicEditorPane) {
        return new InsightContextImpl(this, basicEditorPane);
    }

    public boolean isInsightTriggerChar(char c) {
        return c == '.' || c == '@';
    }

    private static boolean isMethodWithParameters(InsightDataItem insightDataItem) {
        if (insightDataItem.getItemType() != 8) {
            return false;
        }
        JavaMethod javaMethod = (JavaMethod)insightDataItem.getUnderlyingItem();
        return javaMethod.getParameters().isEmpty() ^ true;
    }

    protected boolean isExactMatch(InsightData insightData) {
        Object[] objectArray = insightData.getMatchingData();
        if (objectArray == null) {
            return false;
        }
        int n = objectArray.length;
        if (n <= 1) {
            return n == 1;
        }
        InsightDataItem insightDataItem = (InsightDataItem)((Object)objectArray[0]);
        if (!CompletionInsight.isMethodWithParameters(insightDataItem)) {
            return false;
        }
        JavaMethod javaMethod = (JavaMethod)insightDataItem.getUnderlyingItem();
        String string = javaMethod.getName();
        JavaType javaType = javaMethod.getReturnType();
        if (javaType == null) {
            return false;
        }
        boolean bl = "V".equals(javaType.getDescriptor());
        int n2 = 1;
        while (n2 < n) {
            boolean bl2;
            InsightDataItem insightDataItem2 = (InsightDataItem)((Object)objectArray[n2]);
            if (!CompletionInsight.isMethodWithParameters(insightDataItem2)) {
                return false;
            }
            JavaMethod javaMethod2 = (JavaMethod)insightDataItem2.getUnderlyingItem();
            if (!string.equals(javaMethod2.getName())) {
                return false;
            }
            JavaType javaType2 = javaMethod2.getReturnType();
            boolean bl3 = bl2 = javaType2 != null && "V".equals(javaType2.getDescriptor());
            if (bl != bl2) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected String getTypeString(int n) {
        switch (n) {
            case 1: {
                return COMPLETION_INSTANCE;
            }
            case 2: {
                return PARAMETER_INSTANCE;
            }
        }
        throw new IllegalStateException("unknown type: " + n);
    }

    public AbstractInsight getInsight(int n) {
        String string = this.getTypeString(n);
        BasicEditorPane basicEditorPane = this.getEditorPane();
        return (AbstractInsight)basicEditorPane.getProperty(string);
    }

    public void install(BasicEditorPane basicEditorPane) {
        super.install(basicEditorPane);
        int n = this.getInsightType();
        String string = this.getTypeString(n);
        basicEditorPane.putProperty(string, (Object)this);
    }

    public void deinstall(BasicEditorPane basicEditorPane) {
        super.deinstall(basicEditorPane);
        int n = this.getInsightType();
        String string = this.getTypeString(n);
        basicEditorPane.putProperty(string, null);
    }

    public void hideInsight() {
        super.hideInsight();
    }

    public InsightView getInsightView() {
        JavaInsightOptions javaInsightOptions = this.getJavaInsightOptions();
        CompletionCellRenderer completionCellRenderer = new CompletionCellRenderer();
        completionCellRenderer.setBoldDeclaredMembers(javaInsightOptions.getBoldDeclaredMembers());
        completionCellRenderer.setItalicLocalVariables(javaInsightOptions.getItalicLocalVariables());
        completionCellRenderer.setStrikethruDeprecated(javaInsightOptions.getStrikethruDeprecated());
        completionCellRenderer.setShowDefiningClass(javaInsightOptions.getShowDefiningClass());
        return new ListInsightView((ListCellRenderer)completionCellRenderer);
    }

    public JavaInsightOptions getJavaInsightOptions() {
        JavaInsightOptions javaInsightOptions = (JavaInsightOptions)Ide.getSettings().getData("JavaInsightOptions");
        if (javaInsightOptions == null) {
            javaInsightOptions = new JavaInsightOptions();
            ClientSetting.findOrCreate((String)"oracle.jdeveloper").putData("JavaInsightOptions", (Copyable)javaInsightOptions);
        }
        return javaInsightOptions;
    }

    protected void showFeedback(String string) {
        BasicEditorPane basicEditorPane = this.getEditorPane();
        FeedbackManager feedbackManager = basicEditorPane.getFeedbackManager();
        if (feedbackManager != null) {
            feedbackManager.showFeedback(basicEditorPane, string);
        }
    }

    protected void showFeedback(String string, int n) {
        BasicEditorPane basicEditorPane = this.getEditorPane();
        FeedbackManager feedbackManager = basicEditorPane.getFeedbackManager();
        if (feedbackManager != null) {
            feedbackManager.showFeedback(basicEditorPane, string, n);
        }
    }

    protected void hideFeedback() {
        BasicEditorPane basicEditorPane = this.getEditorPane();
        FeedbackManager feedbackManager = basicEditorPane.getFeedbackManager();
        if (feedbackManager != null) {
            feedbackManager.hideFeedback(basicEditorPane);
        }
    }

    public int getCaretPositionAdjustment() {
        return 0;
    }

    static void wa$_smartFilter(CompletionInsight completionInsight, JavaFilter javaFilter) {
        completionInsight._smartFilter = javaFilter;
    }

    static JavaFilter ra$_smartFilter(CompletionInsight completionInsight) {
        return completionInsight._smartFilter;
    }

    protected class RegularProvider
    implements InsightProvider {
        final boolean _useSmartFilter;

        protected RegularProvider() {
            this(false);
        }

        protected RegularProvider(boolean bl) {
            this._useSmartFilter = bl;
        }

        protected void setSmartFilter(BasicEditorPane basicEditorPane) {
            if (CompletionInsight.ra$_smartFilter(CompletionInsight.this) == null && this._useSmartFilter) {
                InsightContext insightContext = CompletionInsight.this.createInsightContext(basicEditorPane);
                SmartInsightProvider smartInsightProvider = new SmartInsightProvider(insightContext);
                CompletionInsight.wa$_smartFilter(CompletionInsight.this, smartInsightProvider.filterInsightData());
            }
        }

        public InsightData getInsightData(BasicEditorPane basicEditorPane) {
            CompletionInsight.wa$_smartFilter(CompletionInsight.this, null);
            this.setSmartFilter(basicEditorPane);
            InsightContext insightContext = CompletionInsight.this.createInsightContext(basicEditorPane);
            RegularInsightProvider regularInsightProvider = new RegularInsightProvider(insightContext, CompletionInsight.ra$_smartFilter(CompletionInsight.this));
            return regularInsightProvider.getInsightData();
        }

        public InsightData updateInsightData(BasicEditorPane basicEditorPane, InsightData insightData) {
            if (!this._useSmartFilter) {
                CompletionInsight.wa$_smartFilter(CompletionInsight.this, null);
            }
            this.setSmartFilter(basicEditorPane);
            InsightContext insightContext = CompletionInsight.this.createInsightContext(basicEditorPane);
            RegularInsightProvider regularInsightProvider = new RegularInsightProvider(insightContext, CompletionInsight.ra$_smartFilter(CompletionInsight.this));
            return regularInsightProvider.updateInsightData(insightData);
        }

        public InsightView getInsightView() {
            return CompletionInsight.this.getInsightView();
        }
    }
}

