/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.insight;

import java.util.ArrayList;
import javax.swing.text.BadLocationException;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditDescriptor;
import oracle.javatools.parser.java.v2.common.QuickHasName;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceMember;
import oracle.javatools.parser.java.v2.model.doc.SourceDocElement;
import oracle.jdeveloper.javadoc.TagDescriptor;
import oracle.jdeveloper.javadoc.TagManager;
import oracle.jdevimpl.java.JavaArb;
import oracle.jdevimpl.java.insight.AbstractCompletionInsightData;
import oracle.jdevimpl.java.insight.InsightContext;
import oracle.jdevimpl.java.insight.InsightDataItem;

public class DocTagInsightData
extends AbstractCompletionInsightData {
    private static final EditDescriptor editDescriptor;
    private String tagPrefix;
    private int type;

    void $init$() {
        this.type = 0;
    }

    DocTagInsightData(InsightContext insightContext) {
        super(insightContext);
        SourceDocElement sourceDocElement;
        SourceMember sourceMember;
        this.$init$();
        int n = insightContext.getCaretPosition();
        SourceFile sourceFile = insightContext.getSourceFile();
        SourceElement sourceElement = sourceFile.getElementAt(n);
        if (sourceElement instanceof SourceDocElement && (sourceMember = (sourceDocElement = (SourceDocElement)sourceElement).getOwningMember()) != null) {
            this.type = sourceMember.getElementKind();
        }
        if (this.type == 0) {
            // empty if block
        }
        this.fillInitialData();
    }

    static {
        String string = JavaArb.getString(58);
        editDescriptor = new EditDescriptor(string);
    }

    String identifySelf() {
        return "DocTag";
    }

    EditDescriptor getEditDescriptor() {
        return editDescriptor;
    }

    void fillInitialDataImpl() {
        this.tagPrefix = this.findCurrentPrefix();
        this.refreshDataList();
    }

    void updateDataImpl() {
        String string = this.findCurrentPrefix();
        if (!string.startsWith(this.tagPrefix)) {
            this.clearData();
        }
        if (!this.tagPrefix.equals(string)) {
            this.tagPrefix = string;
            this.clearData();
            this.refreshDataList();
        }
    }

    public boolean complete(Object object) {
        InsightDataItem insightDataItem = (InsightDataItem)((Object)object);
        String string = insightDataItem.getName();
        BasicDocument basicDocument = this.helper.getDocument();
        TextBuffer textBuffer = this.helper.getTextBuffer();
        int n = this.helper.getCaretPosition();
        int n2 = this.helper.getCaretPositionAdjustment();
        basicDocument.readLock();
        try {
            int n3 = this.getStartOfTag((ReadTextBuffer)textBuffer, n);
            int n4 = this.getEndOfTag((ReadTextBuffer)textBuffer, n);
            BasicEditorPane basicEditorPane = this.helper.getEditorPane();
            basicEditorPane.beginEdit(this.getEditDescriptor());
            try {
                try {
                    basicDocument.remove(n3 + n2, n4 - n3);
                    basicDocument.insertString(n3 + n2, string, null);
                    if (string.endsWith("}")) {
                        basicEditorPane.setCaretPosition(basicEditorPane.getCaretPosition() - 1);
                    }
                }
                catch (BadLocationException badLocationException) {
                    System.err.println("Exception occurred in doc tag completion: " + badLocationException);
                    badLocationException.printStackTrace();
                }
            }
            finally {
                basicEditorPane.endEdit();
            }
        }
        finally {
            basicDocument.readUnlock();
        }
        return false;
    }

    protected String findCurrentPrefix() {
        int n;
        TextBuffer textBuffer = this.helper.getTextBuffer();
        int n2 = this.helper.getCaretPosition();
        if (n2 == (n = this.getStartOfTag((ReadTextBuffer)textBuffer, n2 - 1))) {
            return "";
        }
        int n3 = n2 - n;
        return textBuffer.getString(n, n3);
    }

    int getNameStartOffset(ReadTextBuffer readTextBuffer, int n) {
        return this.getStartOfTag(readTextBuffer, n);
    }

    int getNameEndOffset(ReadTextBuffer readTextBuffer, int n) {
        return this.getEndOfTag(readTextBuffer, n);
    }

    private void refreshDataList() {
        int n;
        String string = this.tagPrefix.toLowerCase();
        TagManager tagManager = TagManager.getInstance();
        switch (this.type) {
            case 3: {
                n = 1;
                break;
            }
            case 5: {
                n = 2;
                break;
            }
            case 8: {
                n = 4;
                break;
            }
            default: {
                n = 0;
            }
        }
        ArrayList arrayList = tagManager.getTags(n);
        ArrayList arrayList2 = tagManager.getInlineTags(n);
        int n2 = arrayList.size() + arrayList2.size();
        ArrayList<InsightDataItem> arrayList3 = new ArrayList<InsightDataItem>(n2);
        for (TagDescriptor tagDescriptor : arrayList) {
            String string2 = tagDescriptor.toString();
            if (string.length() != 0 && !string2.toLowerCase().startsWith(string)) continue;
            String string3 = tagDescriptor.isAllowsTemplate() ? tagDescriptor.getTemplate() : "";
            String string4 = string3.length() > 0 ? string2 + ' ' + string3 : string2;
            QuickHasName quickHasName = QuickHasName.createHasName((String)string4);
            arrayList3.add(new InsightDataItem((JavaElement)quickHasName));
        }
        for (TagDescriptor tagDescriptor : arrayList2) {
            String string5 = tagDescriptor.toString();
            if (string.length() != 0 && !string5.toLowerCase().startsWith(string)) continue;
            QuickHasName quickHasName = QuickHasName.createHasName((String)string5);
            arrayList3.add(new InsightDataItem((JavaElement)quickHasName));
        }
        int n3 = arrayList3.size();
        this.dataList = arrayList3.toArray(new InsightDataItem[n3]);
    }

    private int getStartOfTag(ReadTextBuffer readTextBuffer, int n) {
        int n2;
        for (n2 = n; n2 >= 0; --n2) {
            char c = readTextBuffer.getChar(n2);
            if (c == '{' || c == '*') break;
            if (c != '@') {
                continue;
            }
            c = readTextBuffer.getChar(--n2);
            if (c == '{') break;
            ++n2;
            break;
        }
        return n2;
    }

    private int getEndOfTag(ReadTextBuffer readTextBuffer, int n) {
        int n2 = n;
        int n3 = readTextBuffer.getLength();
        while (n2 < n3) {
            char c = readTextBuffer.getChar(n2);
            if (Character.isWhitespace(c)) break;
            ++n2;
        }
        return n2;
    }
}

