/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.insight;

import javax.swing.text.BadLocationException;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditDescriptor;
import oracle.javatools.parser.java.v2.CallerContext;
import oracle.javatools.parser.java.v2.common.QuickHasName;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.jdevimpl.java.JavaArb;
import oracle.jdevimpl.java.insight.AbstractCompletionInsightData;
import oracle.jdevimpl.java.insight.InsightContext;
import oracle.jdevimpl.java.insight.InsightDataItem;

final class ImportInsightData
extends AbstractCompletionInsightData {
    private static final EditDescriptor editDescriptor;
    private String importPrefix;

    int getNameStartOffset(ReadTextBuffer readTextBuffer, int n) {
        if (readTextBuffer.getChar(n - 1) == '*') {
            return n - 1;
        }
        return super.getNameStartOffset(readTextBuffer, n);
    }

    int getNameEndOffset(ReadTextBuffer readTextBuffer, int n) {
        if (readTextBuffer.getChar(n) == '*') {
            return n + 1;
        }
        return ImportInsightData.getIdentifierEnd(readTextBuffer, n);
    }

    EditDescriptor getEditDescriptor() {
        return editDescriptor;
    }

    String identifySelf() {
        return "Import";
    }

    int getPrimaryPrefixFilter() {
        return 1;
    }

    ImportInsightData(InsightContext insightContext) {
        super(insightContext);
        this.fillInitialData();
    }

    static {
        String string = JavaArb.getString(52);
        editDescriptor = new EditDescriptor(string);
    }

    public boolean complete(Object object) {
        String string;
        InsightDataItem insightDataItem = (InsightDataItem)((Object)object);
        String string2 = insightDataItem.getName();
        String string3 = ".";
        boolean bl = true;
        if (string2.equals("*")) {
            string3 = ";";
            bl = false;
        } else if (insightDataItem.getItemType() == 3) {
            string3 = ";";
            bl = false;
        }
        BasicDocument basicDocument = this.helper.getDocument();
        TextBuffer textBuffer = this.helper.getTextBuffer();
        int n = this.helper.getCaretPosition();
        int n2 = this.helper.getCaretPositionAdjustment();
        int n3 = this.getNameStartOffset((ReadTextBuffer)textBuffer, n);
        int n4 = this.getNameEndOffset((ReadTextBuffer)textBuffer, n);
        BasicEditorPane basicEditorPane = this.helper.getEditorPane();
        basicEditorPane.beginEdit(editDescriptor);
        if (textBuffer.getLength() > n4 && (string = textBuffer.getString(n4, 1)).equals(string3)) {
            ++n4;
        }
        try {
            try {
                basicDocument.remove(n3 + n2, n4 - n3);
                basicDocument.insertString(n3 + n2, string2 + string3, null);
            }
            catch (BadLocationException badLocationException) {
                System.err.println("Exception occurred in completion: " + badLocationException);
                badLocationException.printStackTrace();
            }
        }
        finally {
            basicEditorPane.endEdit();
        }
        return bl;
    }

    void fillInitialDataImpl() {
        this.importPrefix = this.findCurrentPrefix();
        this.fillDataList();
    }

    void updateDataImpl() {
        String string = this.findCurrentPrefix();
        if (!string.startsWith(this.importPrefix)) {
            this.clearData();
            return;
        }
        if (!this.importPrefix.equals(string)) {
            this.importPrefix = string;
            this.fillDataList();
        }
    }

    private void fillDataList() {
        int n;
        int n2 = n = this.analysisStartOffset;
        CallerContext.InputOptions inputOptions = new CallerContext.InputOptions();
        inputOptions.input = (byte)2;
        inputOptions.squash = 1;
        if (this.importPrefix.length() > 0) {
            n2 += this.importPrefix.length() - 1;
            inputOptions.input = (byte)(inputOptions.input | 4);
        }
        this.fillDataListHelper(n, n2, false, inputOptions);
        if (this.importPrefix.length() > 0) {
            int n3 = this.dataList.length;
            InsightDataItem[] insightDataItemArray = new InsightDataItem[n3 + 1];
            System.arraycopy(this.dataList, 0, insightDataItemArray, 0, n3);
            insightDataItemArray[n3] = new InsightDataItem((JavaElement)QuickHasName.createHasName((String)"*"));
            this.dataList = insightDataItemArray;
        }
    }
}

