/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.insight;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.Icon;
import oracle.javatools.editor.insight.ListDataItem;
import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaHasName;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaLocalVariable;
import oracle.javatools.parser.java.v2.model.JavaMember;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaVariable;
import oracle.jdeveloper.icons.JavaIcons;
import oracle.jdevimpl.java.JavaArb;
import oracle.jdevimpl.java.explorer.OverlayedIcon;
import oracle.jdevimpl.java.explorer.SideBySideIcon;

class InsightDataItem
extends ListDataItem
implements JavaConstants {
    private JavaElement item;
    private String displayText;
    private Icon itemIcon;
    private boolean fullSignature;
    private boolean showAccessIcons;
    private static final String PACKAGE_TYPE = JavaArb.getString(37);
    private static final String CLASS_TYPE = JavaArb.getString(38);
    private static final String LABEL_TYPE;
    private static final String INTERFACE_TYPE;
    private static final String ANNOTATION_TYPE;

    static InsightDataItem[] createInsightDataItems(ArrayList arrayList) {
        int n = arrayList.size();
        InsightDataItem[] insightDataItemArray = new InsightDataItem[n];
        Iterator iterator = arrayList.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            JavaElement javaElement = (JavaElement)iterator.next();
            insightDataItemArray[n2++] = new InsightDataItem(javaElement);
        }
        return insightDataItemArray;
    }

    static InsightDataItem[] createInsightDataItems(JavaElement[] javaElementArray) {
        int n = javaElementArray.length;
        InsightDataItem[] insightDataItemArray = new InsightDataItem[n];
        int n2 = 0;
        while (n2 < n) {
            insightDataItemArray[n2] = new InsightDataItem(javaElementArray[n2]);
            ++n2;
        }
        return insightDataItemArray;
    }

    void setFullSignature() {
        this.fullSignature = true;
    }

    void setShowAccessIcon() {
        this.showAccessIcons = true;
    }

    InsightDataItem(JavaElement javaElement) {
        this.$init$();
        this.item = javaElement;
    }

    void $init$() {
        this.fullSignature = false;
        this.showAccessIcons = false;
    }

    public String toString() {
        return this.getDisplayText();
    }

    public String getName() {
        if (this.item instanceof JavaHasName) {
            String string = ((JavaHasName)this.item).getName();
            if (this.item.getElementKind() != 9) {
                return string;
            }
            int n = string.lastIndexOf(46);
            if (n != -1) {
                return string.substring(n + 1);
            }
            return string;
        }
        return "";
    }

    protected String getDisplayCellType() {
        int n = this.item.getElementKind();
        switch (n) {
            case 15: {
                return LABEL_TYPE;
            }
            case 1: {
                if (!"*".equals(this.getName())) {
                    return "";
                }
            }
            case 9: {
                return PACKAGE_TYPE;
            }
            case 3: 
            case 10: {
                JavaType javaType = (JavaType)this.item;
                if (javaType.isAnnotation()) {
                    return ANNOTATION_TYPE;
                }
                if (javaType.isInterface()) {
                    return INTERFACE_TYPE;
                }
                return CLASS_TYPE;
            }
            case 5: 
            case 7: 
            case 8: 
            case 14: 
            case 16: {
                JavaHasType javaHasType = (JavaHasType)this.item;
                JavaType javaType = javaHasType.getResolvedType();
                if (javaType != null) {
                    return javaType.getName();
                }
                return "";
            }
        }
        throw new RuntimeException("Not an item type " + n);
    }

    protected String getDisplayCellName() {
        int n = this.item.getElementKind();
        switch (n) {
            case 1: {
                if (!(this.item instanceof JavaHasName)) {
                    return "";
                }
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 16: {
                return this.getName();
            }
            case 8: {
                JavaMethod javaMethod = (JavaMethod)this.item;
                if (this.fullSignature) {
                    return InsightDataItem.getShortSignature(javaMethod);
                }
                return InsightDataItem.getVeryShortSignature(javaMethod);
            }
        }
        throw new RuntimeException("Not an item type" + n);
    }

    protected String getDisplayTextImpl() {
        int n = this.item.getElementKind();
        switch (n) {
            case 1: {
                if (!(this.item instanceof JavaHasName)) {
                    return "";
                }
            }
            case 3: 
            case 9: 
            case 15: {
                return this.getName();
            }
            case 5: 
            case 7: 
            case 14: 
            case 16: {
                JavaVariable javaVariable = (JavaVariable)this.item;
                String string = javaVariable.getName();
                JavaType javaType = javaVariable.getResolvedType();
                if (javaType != null) {
                    return javaType.getName() + ' ' + string;
                }
                return string;
            }
            case 8: {
                JavaMethod javaMethod = (JavaMethod)this.item;
                String string = this.fullSignature ? InsightDataItem.getShortSignature(javaMethod) : InsightDataItem.getVeryShortSignature(javaMethod);
                JavaType javaType = javaMethod.getReturnType();
                if (javaType != null) {
                    return javaType.getName() + ' ' + string;
                }
                return string;
            }
        }
        throw new RuntimeException("Not an item type" + n);
    }

    public final Icon getIcon() {
        if (this.itemIcon != null) {
            return this.itemIcon;
        }
        int n = this.item.getElementKind();
        switch (n) {
            case 3: 
            case 10: {
                JavaType javaType = (JavaType)this.item;
                if (javaType.isInterface()) {
                    this.itemIcon = JavaIcons.getIcon(1);
                    break;
                }
                this.itemIcon = JavaIcons.getIcon(0);
                break;
            }
            case 8: {
                this.itemIcon = JavaIcons.getIcon(3);
                break;
            }
            case 5: 
            case 7: 
            case 14: 
            case 16: {
                this.itemIcon = JavaIcons.getIcon(2);
                break;
            }
            case 1: {
                if (!"*".equals(this.getName())) {
                    return null;
                }
            }
            case 9: {
                this.itemIcon = JavaIcons.getIcon(5);
                break;
            }
            case 15: {
                return null;
            }
            default: {
                throw new RuntimeException("Not an item type" + n);
            }
        }
        if (this.showAccessIcons && (n == 3 || n == 8 || n == 5)) {
            int n2 = this.item.getModifiers();
            Icon icon = Modifier.isPublic(n2) ? JavaArb.getIcon(62) : (Modifier.isProtected(n2) ? JavaArb.getIcon(63) : (Modifier.isPrivate(n2) ? JavaArb.getIcon(64) : JavaArb.getIcon(65)));
            if (Modifier.isStatic(n2)) {
                Icon icon2 = JavaArb.getIcon(66);
                icon = new OverlayedIcon(icon2, icon);
            }
            if (Modifier.isFinal(n2)) {
                Icon icon3 = JavaArb.getIcon(67);
                icon = new OverlayedIcon(icon3, icon);
            } else if (Modifier.isAbstract(n2)) {
                Icon icon4 = JavaArb.getIcon(68);
                icon = new OverlayedIcon(icon4, icon);
            }
            this.itemIcon = new SideBySideIcon(this.itemIcon, icon, 1);
        }
        return this.itemIcon;
    }

    public String getDisplayText() {
        if (this.displayText == null) {
            this.displayText = this.getDisplayTextImpl();
        }
        return this.displayText;
    }

    public boolean belongsToClass() {
        return false;
    }

    public String declaringClass() {
        int n = this.item.getElementKind();
        switch (n) {
            case 5: 
            case 8: {
                JavaMember javaMember = (JavaMember)this.item;
                return javaMember.getOwningClass().getName();
            }
        }
        return "";
    }

    public boolean isDeprecated() {
        return this.item.isDeprecated();
    }

    public int getItemType() {
        return this.item.getElementKind();
    }

    public JavaElement getUnderlyingItem() {
        return this.item;
    }

    private static String getShortSignature(JavaMethod javaMethod) {
        String string = javaMethod.getName();
        Collection collection = javaMethod.getParameters();
        if (collection.isEmpty()) {
            return string + "()";
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append('(');
        Iterator iterator = collection.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            JavaLocalVariable javaLocalVariable;
            JavaType javaType;
            if (bl) {
                stringBuffer.append(',');
            }
            if ((javaType = (javaLocalVariable = (JavaLocalVariable)iterator.next()).getResolvedType()) != null) {
                stringBuffer.append(javaType.getName());
            } else {
                stringBuffer.append("<unknown>");
            }
            bl = true;
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    private static String getVeryShortSignature(JavaMethod javaMethod) {
        String string = javaMethod.getName();
        if (javaMethod.getParameters().isEmpty()) {
            return string + "()";
        }
        return string + "(...)";
    }

    static {
        INTERFACE_TYPE = JavaArb.getString(39);
        LABEL_TYPE = JavaArb.getString(40);
        ANNOTATION_TYPE = JavaArb.getString(41);
    }
}

