/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.insight;

import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaVariable;
import oracle.javatools.parser.java.v2.util.filter.JavaFilter;

class IntConstantFilter
implements JavaConstants,
JavaFilter {
    public final boolean accepts(JavaElement javaElement) {
        switch (javaElement.getElementKind()) {
            case 5: {
                JavaField javaField = (JavaField)javaElement;
                if (!javaField.isStatic()) {
                    return false;
                }
            }
            case 7: {
                if (javaElement.isFinal()) break;
                return false;
            }
            default: {
                return false;
            }
        }
        JavaVariable javaVariable = (JavaVariable)javaElement;
        JavaType javaType = javaVariable.getResolvedType();
        if (javaType != null) {
            String string = javaType.getDescriptor();
            char c = string.charAt(0);
            switch (c) {
                case 'B': 
                case 'C': 
                case 'I': 
                case 'S': {
                    return true;
                }
            }
            return false;
        }
        Object object = javaVariable.getConstantValue();
        if (object == null) {
            return false;
        }
        return object instanceof Integer || object instanceof Character || object instanceof Byte || object instanceof Short;
    }
}

