/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.insight;

import java.util.ArrayList;
import javax.swing.text.BadLocationException;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditDescriptor;
import oracle.javatools.editor.insight.AbstractInsight;
import oracle.javatools.parser.java.v2.CallerContext;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.util.filter.JavaFilter;
import oracle.jdevimpl.java.JavaArb;
import oracle.jdevimpl.java.insight.AutoImportInsightData;
import oracle.jdevimpl.java.insight.InsightContext;
import oracle.jdevimpl.java.insight.InsightDataItem;
import oracle.jdevimpl.java.insight.JavaInsightOptions;
import oracle.jdevimpl.java.util.ExpressionFinder;
import oracle.jdevimpl.java.util.FoundSymbol;

class MemberInsightData
extends AutoImportInsightData
implements CallerContext.Constants {
    private static final int OPTION_HIDE_ROOT_PACKAGES = 256;
    private static final int OPTION_HIDE_IMPORTED_CLASSES = 512;
    private static final int OPTION_HIDE_OBJECT_MEMBERS = 1024;
    private static final int OPTION_SHOW_OVERLOADED_METHODS = 2048;
    private static final EditDescriptor editDescriptor;
    private String primaryPrefix;

    static {
        String string = JavaArb.getString(57);
        editDescriptor = new EditDescriptor(string);
    }

    EditDescriptor getEditDescriptor() {
        return editDescriptor;
    }

    String identifySelf() {
        return "Member";
    }

    int getPrimaryPrefixFilter() {
        return 0;
    }

    MemberInsightData(InsightContext insightContext, JavaFilter javaFilter) {
        super(insightContext);
        this.setResultFilter(javaFilter);
        this.fillInitialData();
    }

    public boolean complete(Object object) {
        SourceElement sourceElement;
        SourceFile sourceFile;
        InsightDataItem insightDataItem = (InsightDataItem)((Object)object);
        String string = insightDataItem.getName();
        String string2 = "";
        boolean bl = false;
        boolean bl2 = false;
        int n = insightDataItem.getItemType();
        if (n == 9) {
            string2 = ".";
            bl = true;
        } else if (n == 8) {
            string2 = "()";
            JavaMethod javaMethod = (JavaMethod)insightDataItem.getUnderlyingItem();
            bl2 = javaMethod.getParameters().size() == 0;
            JavaType javaType = javaMethod.getReturnType();
            if (javaType != null && "V".equals(javaType.getDescriptor())) {
                string2 = "();";
            }
        }
        BasicDocument basicDocument = this.helper.getDocument();
        TextBuffer textBuffer = this.helper.getTextBuffer();
        int n2 = this.helper.getCaretPosition();
        boolean bl3 = false;
        if (n == 3 && this.getResultFilter() != null && (sourceFile = (sourceElement = this.callerContext.getSourceScope()).getOwningSourceFile()) != null) {
            SourceElement sourceElement2 = sourceFile.getElementAt(n2);
            while (sourceElement2 != null) {
                switch (sourceElement2.getSymbolKind()) {
                    case 62: {
                        bl3 = true;
                    }
                    case 3: {
                        sourceElement2 = null;
                        break;
                    }
                    default: {
                        sourceElement2 = sourceElement2.getParent();
                    }
                }
            }
        }
        int n3 = this.helper.getCaretPositionAdjustment();
        basicDocument.readLock();
        try {
            String string3;
            int n4 = this.getNameStartOffset((ReadTextBuffer)textBuffer, n2);
            int n5 = this.getNameEndOffset((ReadTextBuffer)textBuffer, n2);
            if (textBuffer.getLength() > n5) {
                if (string2.startsWith("()") && !bl2) {
                    String string4 = textBuffer.getString(n5, 1);
                    if (string2.startsWith(string4)) {
                        string2 = "(";
                        ++n5;
                    }
                } else {
                    int n6 = string2.length();
                    int n7 = Math.min(textBuffer.getLength() - n5, n6);
                    String string5 = textBuffer.getString(n5, n7);
                    if (string5.equals(string2)) {
                        n5 += n6;
                    } else if (string2.equals("();") && string5.startsWith("()")) {
                        n5 += 2;
                    }
                }
            }
            BasicEditorPane basicEditorPane = this.helper.getEditorPane();
            basicEditorPane.beginEdit(this.getEditDescriptor());
            try {
                try {
                    basicDocument.remove(n4 + n3, n5 - n4);
                    basicDocument.insertString(n4 + n3, string + string2, null);
                    if (string2.startsWith("(") && !bl2) {
                        AbstractInsight abstractInsight;
                        int n8 = string2.length() - 1;
                        if (n8 != 0) {
                            basicEditorPane.setCaretPosition(basicEditorPane.getCaretPosition() - n8);
                        }
                        if ((abstractInsight = this.helper.getInsight(2)) != null) {
                            abstractInsight.restartPopupTimer();
                        }
                    }
                    if (bl3) {
                        int n9 = basicEditorPane.getCaretPosition();
                        int n10 = textBuffer.getLength();
                        while (n9 < n10 && textBuffer.getChar(n9) != ')') {
                            ++n9;
                        }
                        if (++n9 < n10) {
                            basicEditorPane.setCaretPosition(n9);
                        }
                    }
                }
                catch (BadLocationException badLocationException) {
                    System.err.println("Exception occurred in completion: " + badLocationException);
                    badLocationException.printStackTrace();
                }
            }
            finally {
                basicEditorPane.endEdit();
            }
            if (n != 9 && (string3 = this.determinePossibleImportString(string)) != null) {
                this.autoImport(string3);
            }
        }
        finally {
            basicDocument.readUnlock();
        }
        return bl;
    }

    private JavaHasType resolveExpression(String string) {
        SourceFactory sourceFactory;
        SourceExpression sourceExpression;
        SourceElement sourceElement = this.callerContext.getSourceScope();
        SourceFile sourceFile = sourceElement.getOwningSourceFile();
        if (sourceFile == null) {
            CommonUtilities.panic((String)"No SourceFile instance");
        }
        if ((sourceExpression = (sourceFactory = sourceFile.getFactory()).createExpression(string)) == null) {
            return null;
        }
        sourceExpression.setContext(this.callerContext);
        return sourceExpression.getResolvedObject();
    }

    private String determinePossibleImportString(String string) {
        String string2;
        int n;
        String string3 = this.primaryPrefix + string;
        int n2 = string3.length();
        int n3 = 0;
        while (n3 < n2) {
            char c = string3.charAt(n3);
            if (c != '.' && !Character.isJavaIdentifierPart(c)) break;
            ++n3;
        }
        if ((n = (string2 = string3.substring(0, n3)).indexOf(46)) == -1) {
            return null;
        }
        String string4 = string2.substring(0, n);
        JavaHasType javaHasType = this.resolveExpression(string4);
        if (javaHasType != null) {
            return null;
        }
        String string5 = string2;
        int n4 = string5.length();
        int n5 = string5.indexOf(46, n + 1);
        String string6 = null;
        while (true) {
            String string7;
            JavaType javaType;
            if (n5 == -1) {
                n5 = n4;
            }
            if ((javaType = this.callerContext.resolveTypeName(string7 = string5.substring(0, n5))) != null) {
                string6 = string7;
            } else {
                javaHasType = this.resolveExpression(string7);
                if (javaHasType != null) {
                    return string6;
                }
            }
            if (n5 == n4) break;
            n5 = string5.indexOf(46, n5 + 1);
        }
        return string6;
    }

    protected void retrieveOptions(JavaInsightOptions javaInsightOptions) {
        super.retrieveOptions(javaInsightOptions);
        if (!javaInsightOptions.getShowTopLevelPackages()) {
            this.optionsMask |= 0x100;
        }
        if (!javaInsightOptions.getShowImportedClasses()) {
            this.optionsMask |= 0x200;
        }
        if (!javaInsightOptions.getShowObjectMethods()) {
            this.optionsMask |= 0x400;
        }
        if (javaInsightOptions.getShowOverloadedMethods()) {
            this.optionsMask |= 0x800;
        }
    }

    protected void fillInitialDataImpl() {
        TextBuffer textBuffer = this.helper.getTextBuffer();
        int n = this.helper.getCaretPosition();
        ExpressionFinder expressionFinder = this.helper.getFinder();
        FoundSymbol foundSymbol = expressionFinder.determinePrimaryPrefix(n, this.getPrimaryPrefixFilter());
        this.primaryPrefix = "";
        if (foundSymbol != null) {
            int n2 = foundSymbol.startOffset;
            int n3 = foundSymbol.endOffset;
            this.primaryPrefix = textBuffer.getString(n2, n3 - n2);
        }
        this.clearData();
        this.fillDataList();
    }

    protected void updateDataImpl() {
        TextBuffer textBuffer = this.helper.getTextBuffer();
        int n = this.helper.getCaretPosition();
        ExpressionFinder expressionFinder = this.helper.getFinder();
        FoundSymbol foundSymbol = expressionFinder.determinePrimaryPrefix(n, this.getPrimaryPrefixFilter());
        String string = "";
        if (foundSymbol != null) {
            int n2 = foundSymbol.startOffset;
            int n3 = foundSymbol.endOffset;
            string = textBuffer.getString(n2, n3 - n2);
        }
        if (!this.primaryPrefix.equals(string)) {
            this.primaryPrefix = string;
            this.clearData();
            this.fillDataList();
        }
    }

    private void fillDataList() {
        int n;
        int n2 = n = this.analysisStartOffset;
        if (this.primaryPrefix.length() > 0) {
            n2 += this.primaryPrefix.length() - 1;
        }
        CallerContext.InputOptions inputOptions = new CallerContext.InputOptions();
        inputOptions.input = (byte)15;
        if (this.option(256)) {
            inputOptions.squash = (byte)(inputOptions.squash | 2);
        }
        if (this.option(512)) {
            inputOptions.squash = (byte)(inputOptions.squash | 1);
        }
        if (this.option(1)) {
            inputOptions.squash = (byte)(inputOptions.squash | 0x10);
        }
        if (this.option(1024)) {
            inputOptions.squash = (byte)(inputOptions.squash | 8);
        }
        if (this.option(8)) {
            inputOptions.squash = (byte)(inputOptions.squash | 4);
        }
        this.fillDataListHelper(n, n2, true, inputOptions);
        if (this.option(2048)) {
            int n3 = this.dataList.length;
            int n4 = 0;
            while (n4 < n3) {
                this.dataList[n4].setFullSignature();
                ++n4;
            }
        } else {
            ArrayList<InsightDataItem> arrayList = new ArrayList<InsightDataItem>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            int n5 = this.dataList.length;
            int n6 = 0;
            while (n6 < n5) {
                InsightDataItem insightDataItem = this.dataList[n6];
                if (insightDataItem.getItemType() != 8) {
                    arrayList.add(insightDataItem);
                } else {
                    String string = insightDataItem.getDisplayText();
                    if (insightDataItem.isDeprecated()) {
                        string = string + 'd';
                    }
                    if (!arrayList2.contains(string)) {
                        arrayList2.add(string);
                        arrayList.add(insightDataItem);
                    }
                }
                ++n6;
            }
            int n7 = arrayList.size();
            this.dataList = arrayList.toArray(new InsightDataItem[n7]);
        }
    }
}

