/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.insight;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.insight.PrototypeCellProvider;
import oracle.javatools.editor.insight.TooltipDataItem;
import oracle.javatools.util.SwingUtils;
import oracle.jdevimpl.java.insight.AnnotationDataItem;
import oracle.jdevimpl.java.insight.ParameterDataItem;

final class ParameterCellRenderer
extends JComponent
implements PrototypeCellProvider,
ListCellRenderer {
    private boolean strikethruDeprecatedOption;
    private static final int PADDING = 2;
    private Dimension cellSize;
    private boolean cellTooWide;
    private TooltipDataItem currentItem;
    private static final String SEPARATOR = ", ";

    public ParameterCellRenderer() {
        this.$init$();
        this.setOpaque(false);
        this.cellSize = new Dimension(0, 0);
        this.currentItem = null;
        this.updateCellSize();
    }

    protected void setStrikethruDeprecated(boolean bl) {
        this.strikethruDeprecatedOption = bl;
    }

    void $init$() {
        this.strikethruDeprecatedOption = false;
    }

    private void updateCellSize() {
        this.calculateCellSize(this.getFont(), this.currentItem, this.cellSize);
        EditorProperties editorProperties = EditorProperties.getProperties();
        int n = editorProperties.getIntegerProperty("insight-max-popup-width");
        Dimension dimension = this.getToolkit().getScreenSize();
        n = Math.min(dimension.width / 2 - 5, n);
        if (this.cellSize.width > n) {
            this.cellTooWide = true;
            this.cellSize.width = n;
        } else {
            this.cellTooWide = false;
        }
        this.setMinimumSize(this.cellSize);
        this.setPreferredSize(this.cellSize);
        this.setMaximumSize(this.cellSize);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void calculateCellSize(Font font, TooltipDataItem tooltipDataItem, Dimension dimension) {
        if (tooltipDataItem != null) {
            if (tooltipDataItem instanceof ParameterDataItem) {
                this.calculateCellSize(font, (ParameterDataItem)tooltipDataItem, dimension);
                return;
            } else {
                if (!(tooltipDataItem instanceof AnnotationDataItem)) throw new IllegalArgumentException(tooltipDataItem.getClass().getName());
                this.calculateCellSize(font, (AnnotationDataItem)tooltipDataItem, dimension);
            }
            return;
        } else {
            dimension.height = 4;
            dimension.width = 4;
        }
    }

    public void paint(Graphics graphics) {
        Font font;
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.cellSize.width, this.cellSize.height);
        if (this.currentItem != null && (font = this.getFont()) != null) {
            if (this.currentItem instanceof ParameterDataItem) {
                this.paint(graphics, font, (ParameterDataItem)this.currentItem);
            } else if (this.currentItem instanceof AnnotationDataItem) {
                this.paint(graphics, font, (AnnotationDataItem)this.currentItem);
            } else {
                throw new IllegalArgumentException(this.currentItem.getClass().getName());
            }
        }
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        this.setBackground(jList.getBackground());
        this.setForeground(jList.getForeground());
        this.setFont(jList.getFont());
        this.currentItem = (TooltipDataItem)object;
        this.updateCellSize();
        return this;
    }

    public Object getPrototypeCell(JList jList, ListModel listModel) {
        Font font = jList.getFont();
        Dimension dimension = new Dimension(0, 0);
        int n = 0;
        TooltipDataItem tooltipDataItem = null;
        int n2 = listModel.getSize();
        int n3 = 0;
        while (n3 < n2) {
            TooltipDataItem tooltipDataItem2 = (TooltipDataItem)listModel.getElementAt(n3);
            this.calculateCellSize(font, tooltipDataItem2, dimension);
            if (dimension.width > n) {
                n = dimension.width;
                tooltipDataItem = tooltipDataItem2;
            }
            ++n3;
        }
        return tooltipDataItem;
    }

    private void calculateCellSize(Font font, ParameterDataItem parameterDataItem, Dimension dimension) {
        int n = 0;
        int n2 = 0;
        if (font != null) {
            FontMetrics fontMetrics = this.getFontMetrics(font);
            Font font2 = font.deriveFont(1);
            FontMetrics fontMetrics2 = this.getFontMetrics(font2);
            n2 = fontMetrics.getHeight();
            int n3 = parameterDataItem.getArgumentIndex();
            int n4 = parameterDataItem.getParameterCount();
            if (n4 == 0) {
                String string = parameterDataItem.getDisplayText();
                n = fontMetrics.stringWidth(string);
            } else {
                String string = "";
                int n5 = 0;
                while (n5 < n4) {
                    if (string.length() > 0) {
                        n += fontMetrics.stringWidth(string);
                    }
                    string = SEPARATOR;
                    FontMetrics fontMetrics3 = n5 == n3 ? fontMetrics2 : fontMetrics;
                    String string2 = parameterDataItem.getParameter(n5);
                    n += fontMetrics3.stringWidth(string2);
                    ++n5;
                }
            }
        }
        dimension.width = n + 4;
        dimension.height = n2 + 4;
    }

    private void paint(Graphics graphics, Font font, ParameterDataItem parameterDataItem) {
        int n;
        FontMetrics fontMetrics = this.getFontMetrics(font);
        Font font2 = font.deriveFont(1);
        FontMetrics fontMetrics2 = this.getFontMetrics(font2);
        int n2 = fontMetrics.getAscent();
        int n3 = fontMetrics2.getAscent();
        int n4 = 2;
        int n5 = 2;
        int n6 = parameterDataItem.getArgumentIndex();
        if (n6 >= (n = parameterDataItem.getParameterCount())) {
            graphics.setColor(Color.gray);
        } else {
            graphics.setColor(this.getForeground());
        }
        int n7 = n4;
        int n8 = 0;
        if (n == 0) {
            String string = parameterDataItem.getDisplayText();
            graphics.setFont(font);
            SwingUtils.drawString((Graphics)graphics, (String)string, (int)n4, (int)(n5 + n2));
            n8 = fontMetrics.stringWidth(string);
        } else {
            int n9 = 0;
            int n10 = 0;
            int n11 = 0;
            String string = "...";
            if (this.cellTooWide) {
                int n12 = fontMetrics.stringWidth("...");
                Dimension dimension = new Dimension();
                this.calculateCellSize(font, parameterDataItem, dimension);
                int n13 = this.cellSize.width;
                int n14 = dimension.width;
                while (n14 > n13) {
                    int n15;
                    if (n6 - (n15 = n9++) >= 2) {
                        String string2 = parameterDataItem.getParameter(n15);
                        n14 -= fontMetrics.stringWidth(string2);
                        n14 += n12;
                        continue;
                    }
                    int n16 = n - n10 - 1;
                    if (n16 - n6 >= 2) {
                        String string3 = parameterDataItem.getParameter(n16);
                        ++n10;
                        n14 -= fontMetrics.stringWidth(string3);
                        n14 += n12;
                        continue;
                    }
                    if (n6 - n15 >= 1) {
                        String string4 = parameterDataItem.getParameter(n15);
                        ++n9;
                        n14 -= fontMetrics.stringWidth(string4);
                        n14 += n12;
                        continue;
                    }
                    if (n16 - n6 >= 1) {
                        String string5 = parameterDataItem.getParameter(n16);
                        ++n10;
                        n14 -= fontMetrics.stringWidth(string5);
                        n14 += n12;
                        continue;
                    }
                    String string6 = parameterDataItem.getParameter(n6);
                    n11 = this.truncateString(string6, n14, n13, fontMetrics2);
                    break;
                }
            }
            int n17 = n9;
            int n18 = n - n10 - 1;
            String string7 = "";
            Font font3 = null;
            FontMetrics fontMetrics3 = null;
            int n19 = 0;
            int n20 = 0;
            while (n20 < n) {
                if (string7.length() > 0) {
                    SwingUtils.drawString((Graphics)graphics, (String)string7, (int)n4, (int)n19);
                    int n21 = fontMetrics3.stringWidth(string7);
                    n4 += n21;
                    n8 += n21;
                }
                string7 = SEPARATOR;
                if (n20 == n6) {
                    font3 = font2;
                    fontMetrics3 = fontMetrics2;
                    n19 = n3;
                } else {
                    font3 = font;
                    fontMetrics3 = fontMetrics;
                    n19 = n2;
                }
                String string8 = parameterDataItem.getParameter(n20);
                graphics.setFont(font3);
                if (n20 < n17 || n20 > n18) {
                    string8 = "...";
                } else if (n20 == n6 && n11 > 0) {
                    int n22 = string8.length();
                    string8 = string8.substring(0, n22 - n11) + "...";
                }
                SwingUtils.drawString((Graphics)graphics, (String)string8, (int)n4, (int)n19);
                int n23 = fontMetrics3.stringWidth(string8);
                n4 += n23;
                n8 += n23;
                ++n20;
            }
        }
        if (this.strikethruDeprecatedOption && parameterDataItem.isDeprecated()) {
            int n24 = n5 + n2 / 2;
            if (n8 > 0) {
                graphics.drawLine(n7, n24, n7 + n8, n24);
            }
        }
    }

    protected int truncateString(String string, int n, int n2, FontMetrics fontMetrics) {
        if (n < n2) {
            return 0;
        }
        String string2 = "...";
        int n3 = n2 - fontMetrics.stringWidth("...");
        int n4 = n;
        int n5 = string.length() - 1;
        while (n4 > n3 && n5 > 0) {
            char c = string.charAt(n5--);
            int n6 = fontMetrics.charWidth(c);
            n4 -= n6;
        }
        return string.length() - (n5 + 1);
    }

    private void calculateCellSize(Font font, AnnotationDataItem annotationDataItem, Dimension dimension) {
        int n = 0;
        int n2 = 0;
        if (font != null) {
            String string = annotationDataItem.getDisplayText();
            Font font2 = annotationDataItem.hasValue() ? font : font.deriveFont(1);
            FontMetrics fontMetrics = this.getFontMetrics(font2);
            n2 = fontMetrics.getHeight();
            n = fontMetrics.stringWidth(string);
        }
        dimension.width = n + 4;
        dimension.height = n2 + 4;
    }

    public void paint(Graphics graphics, Font font, AnnotationDataItem annotationDataItem) {
        Font font2 = annotationDataItem.hasValue() ? font : font.deriveFont(1);
        FontMetrics fontMetrics = this.getFontMetrics(font2);
        int n = 2;
        int n2 = 2;
        int n3 = 2;
        graphics.setColor(this.getForeground());
        String string = annotationDataItem.getDisplayText();
        graphics.setFont(font2);
        SwingUtils.drawString((Graphics)graphics, (String)string, (int)n2, (int)(n3 + fontMetrics.getAscent()));
        n2 += fontMetrics.stringWidth(string);
    }
}

