/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.insight;

import java.util.Collection;
import java.util.Iterator;
import oracle.javatools.editor.insight.ListDataItem;
import oracle.javatools.editor.insight.TooltipDataItem;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaVariable;
import oracle.jdevimpl.java.JavaArb;

final class ParameterDataItem
extends TooltipDataItem
implements Comparable {
    private JavaMethod method;
    private String[] parameters;
    private String displayText;
    private int argumentIndex;

    ParameterDataItem(JavaMethod javaMethod, int n) {
        this.method = javaMethod;
        this.displayText = null;
        this.argumentIndex = n;
        this.buildParameters(javaMethod);
    }

    int getParameterCount() {
        JavaClass javaClass = this.method.getOwningClass();
        int n = this.parameters.length;
        if (!this.method.isConstructor()) {
            return n;
        }
        boolean bl = !javaClass.isStatic() && javaClass.getOwningClass() != null;
        return bl ? n - 1 : n;
    }

    String getParameter(int n) {
        JavaClass javaClass = this.method.getOwningClass();
        if (!this.method.isConstructor()) {
            return this.parameters[n];
        }
        boolean bl = !javaClass.isStatic() && javaClass.getOwningClass() != null;
        return this.parameters[bl ? n + 1 : n];
    }

    int getArgumentIndex() {
        return this.argumentIndex;
    }

    private void buildParameters(JavaMethod javaMethod) {
        Collection collection = javaMethod.getParameters();
        int n = collection.size();
        this.parameters = new String[n];
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = collection.iterator();
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.setLength(0);
            JavaVariable javaVariable = (JavaVariable)iterator.next();
            String string = javaVariable.getName();
            JavaType javaType = javaVariable.getResolvedType();
            String string2 = javaType != null ? javaType.getQualifiedName() : "<unknown>";
            int n3 = string2.lastIndexOf(46);
            if (n3 != -1) {
                string2 = string2.substring(n3 + 1);
            }
            stringBuffer.append(string2);
            if (string != null && string.length() > 0) {
                stringBuffer.append(" ");
                stringBuffer.append(string);
            }
            this.parameters[n2] = stringBuffer.toString();
            ++n2;
        }
    }

    public String getDisplayText() {
        if (this.displayText == null) {
            int n = this.getParameterCount();
            if (n == 0) {
                this.displayText = JavaArb.getString(42);
            } else {
                StringBuffer stringBuffer = new StringBuffer();
                String string = "";
                int n2 = 0;
                while (n2 < n) {
                    stringBuffer.append(string);
                    string = ", ";
                    stringBuffer.append(this.getParameter(n2));
                    ++n2;
                }
                this.displayText = stringBuffer.toString();
            }
        }
        return this.displayText;
    }

    public boolean isDeprecated() {
        return this.method.isDeprecated();
    }

    public String toString() {
        return this.getDisplayText();
    }

    public int compareTo(Object object) {
        ParameterDataItem parameterDataItem = (ParameterDataItem)object;
        String string = this.getDisplayText();
        String string2 = parameterDataItem.getDisplayText();
        return ListDataItem.compareInsensitive((String)string, (String)string2);
    }
}

