/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.insight;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import javax.swing.ListModel;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.insight.TooltipDataItem;
import oracle.javatools.editor.insight.TooltipDataItemListModel;
import oracle.javatools.editor.insight.TooltipInsightData;
import oracle.javatools.parser.java.v2.CallerContext;
import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.model.JavaAnnotation;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceAnnotation;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.jdevimpl.java.insight.AbstractCompletionInsightData;
import oracle.jdevimpl.java.insight.AnnotationDataItem;
import oracle.jdevimpl.java.insight.InsightContext;
import oracle.jdevimpl.java.insight.ParameterDataItem;
import oracle.jdevimpl.java.util.ExpressionFinder;
import oracle.jdevimpl.java.util.FoundSymbol;

final class ParameterInsightData
extends TooltipInsightData
implements CallerContext.Constants,
JavaConstants {
    private CallerContext callerContext;
    private InsightContext helper;
    private TooltipDataItemListModel tooltipListModel;
    protected TooltipDataItem[] tooltipDataList;
    protected FoundSymbol methodInvocation;
    protected int argumentIndex;
    static final TooltipDataItem[] kEmptyTooltipList = new TooltipDataItem[0];

    ParameterInsightData(InsightContext insightContext) {
        this.$init$();
        this.helper = insightContext;
        this.callerContext = insightContext.getCallerContext();
        this.fillInitialData();
    }

    public ListModel getListModel() {
        return this.buildListModel();
    }

    private TooltipDataItemListModel buildListModel() {
        if (this.tooltipListModel == null) {
            Arrays.sort(this.tooltipDataList);
            this.tooltipListModel = new TooltipDataItemListModel(this.tooltipDataList);
        }
        return this.tooltipListModel;
    }

    public Object[] getData() {
        return this.tooltipDataList;
    }

    void $init$() {
        this.argumentIndex = -1;
    }

    private void clearData() {
        this.tooltipDataList = kEmptyTooltipList;
        this.tooltipListModel = null;
    }

    protected void fillInitialData() {
        this.updateData();
    }

    protected void updateData() {
        this.clearData();
        int[] nArray = new int[1];
        ExpressionFinder expressionFinder = this.helper.getFinder();
        int n = this.helper.getCaretPosition();
        this.methodInvocation = expressionFinder.determineArgumentInvocation(n, nArray);
        this.argumentIndex = nArray[0];
        if (this.methodInvocation == null) {
            return;
        }
        if (expressionFinder.isMethodDeclaration(this.methodInvocation)) {
            return;
        }
        if (expressionFinder.isAnnotation(this.methodInvocation)) {
            this.fillAnnotationData();
        } else {
            this.fillParameterData();
        }
    }

    private void fillAnnotationData() {
        SourceFile sourceFile = this.helper.getSourceFile();
        SourceAnnotation sourceAnnotation = null;
        SourceElement sourceElement = sourceFile.getElementAt(this.methodInvocation.startOffset);
        while (sourceAnnotation == null && sourceElement != null) {
            if (sourceElement instanceof SourceAnnotation) {
                sourceAnnotation = (SourceAnnotation)sourceElement;
            }
            sourceElement = sourceElement.getParent();
        }
        if (sourceAnnotation == null) {
            return;
        }
        JavaAnnotation javaAnnotation = (JavaAnnotation)sourceAnnotation.getCompiledObject();
        JavaType javaType = javaAnnotation.getAnnotationType();
        ArrayList<AnnotationDataItem> arrayList = new ArrayList<AnnotationDataItem>();
        Map map = javaAnnotation.getComponents();
        for (JavaMethod javaMethod : javaType.getMethods()) {
            String string = javaMethod.getName();
            if (!map.containsKey(string)) continue;
            Object v = map.get(string);
            boolean bl = v != null;
            AnnotationDataItem annotationDataItem = new AnnotationDataItem(javaMethod, bl);
            arrayList.add(annotationDataItem);
        }
        int n = arrayList.size();
        if (n == 0) {
            AnnotationDataItem annotationDataItem = new AnnotationDataItem();
            this.tooltipDataList = new TooltipDataItem[]{annotationDataItem};
        } else {
            this.tooltipDataList = arrayList.toArray(new TooltipDataItem[n]);
        }
    }

    private void fillParameterData() {
        String string = this.methodInvocation.string;
        int n = string.lastIndexOf(46);
        String string2 = n == -1 ? null : string.substring(0, n);
        JavaHasType javaHasType = null;
        if (n != -1) {
            SourceFactory sourceFactory;
            SourceExpression sourceExpression;
            TextBuffer textBuffer = this.helper.getTextBuffer();
            int n2 = this.methodInvocation.startOffset;
            int n3 = n2 + n;
            String string3 = textBuffer.getString(n2, n3 - n2);
            SourceElement sourceElement = this.callerContext.getSourceScope();
            SourceFile sourceFile = sourceElement.getOwningSourceFile();
            if (sourceFile == null) {
                CommonUtilities.panic((String)"No SourceFile instance");
            }
            if ((sourceExpression = (sourceFactory = sourceFile.getFactory()).createExpression(string3)) == null) {
                return;
            }
            sourceExpression.setContext(this.callerContext);
            javaHasType = sourceExpression.getResolvedObject();
            if (javaHasType == null) {
                return;
            }
        }
        int n4 = n + 1;
        while (!Character.isJavaIdentifierPart(string.charAt(n4))) {
            ++n4;
        }
        CallerContext.InputOptions inputOptions = new CallerContext.InputOptions();
        if (!this.helper.getJavaInsightOptions().getShowDeprecated()) {
            inputOptions.squash = (byte)(inputOptions.squash | 0x10);
        }
        CallerContext.Output output = null;
        int n5 = string.length();
        if (n4 + 4 < n5 && string.indexOf("new", n4) == n4 && Character.isWhitespace(string.charAt(n4 + 3))) {
            n4 += 4;
            while (!Character.isJavaIdentifierPart(string.charAt(n4))) {
                ++n4;
            }
            String string4 = string.substring(n4);
            JavaType javaType = javaHasType == null ? this.callerContext.resolveTypeName(string4) : this.callerContext.resolveTypeName(javaHasType, string4);
            if (javaType != null) {
                output = this.callerContext.listMethods((JavaHasType)javaType, "<init>", null, inputOptions);
            }
        } else {
            String string5 = string.substring(n4);
            output = this.callerContext.listMethods(javaHasType, string5, null, inputOptions);
        }
        if (output == null) {
            return;
        }
        ArrayList arrayList = output.all;
        if (arrayList.size() == 0) {
            return;
        }
        this.tooltipDataList = this.makeItems(arrayList);
    }

    private TooltipDataItem[] makeItems(ArrayList arrayList) {
        int n = arrayList.size();
        TooltipDataItem[] tooltipDataItemArray = new ParameterDataItem[n];
        int n2 = 0;
        while (n2 < n) {
            JavaMethod javaMethod = (JavaMethod)arrayList.get(n2);
            tooltipDataItemArray[n2] = new ParameterDataItem(javaMethod, this.argumentIndex);
            ++n2;
        }
        return tooltipDataItemArray;
    }

    private static String removeInitialNew(String string) {
        return AbstractCompletionInsightData.removeInitialNew(string);
    }
}

