/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.insight;

import java.util.ArrayList;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.insight.InsightData;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceImport;
import oracle.javatools.parser.java.v2.model.SourceMember;
import oracle.javatools.parser.java.v2.scanner.JavaLexer;
import oracle.javatools.parser.java.v2.util.filter.JavaFilter;
import oracle.jdevimpl.java.JavaArb;
import oracle.jdevimpl.java.insight.ClassInsightData;
import oracle.jdevimpl.java.insight.DocTagInsightData;
import oracle.jdevimpl.java.insight.ImportInsightData;
import oracle.jdevimpl.java.insight.InsightContext;
import oracle.jdevimpl.java.insight.LabelInsightData;
import oracle.jdevimpl.java.insight.MemberInsightData;
import oracle.jdevimpl.java.insight.PackageInsightData;
import oracle.jdevimpl.java.util.ExpressionFinder;

class RegularInsightProvider
implements JavaConstants {
    private final InsightContext context;
    private final JavaFilter smartFilter;
    protected static final int IN_UNKNOWN = 0;
    protected static final int IN_PACKAGE = 1;
    protected static final int IN_IMPORT = 2;
    protected static final int IN_CLASS = 3;
    protected static final int IN_CLASS_DECLARATION = 4;
    protected static final int IN_CLASS_MEMBER = 5;
    protected static final int IN_CLASS_BODY = 6;
    protected static final int IN_DOC_COMMENT = 7;
    public static final int FEEDBACK_MESSAGE_DELAY = 5000;
    protected static final boolean DEBUG_DUMP_TEXT_BUFFER = false;
    protected static final String DEBUG_DUMP_FILE_NAME = "insight_buffer_dump.java";

    RegularInsightProvider(InsightContext insightContext, JavaFilter javaFilter) {
        this.context = insightContext;
        this.smartFilter = javaFilter;
    }

    public InsightData getInsightData() {
        Object object = null;
        object = this.getInsightDataViaLexer();
        if (object == null) {
            if (!this.verifyValidContext()) {
                return null;
            }
            int n = this.getSimpleContextType();
            if (n == 0) {
                n = this.getComplexContextType();
            }
            switch (n) {
                case 1: {
                    object = new PackageInsightData(this.context);
                    break;
                }
                case 2: {
                    object = new ImportInsightData(this.context);
                    break;
                }
                case 7: {
                    object = new DocTagInsightData(this.context);
                    break;
                }
                case 5: 
                case 6: {
                    break;
                }
            }
        }
        if (object != null) {
            Object[] objectArray = object.getData();
            return objectArray.length > 0 ? object : null;
        }
        return null;
    }

    public InsightData updateInsightData(InsightData insightData) {
        if (insightData instanceof PackageInsightData) {
            PackageInsightData packageInsightData = (PackageInsightData)insightData;
            packageInsightData.updateData();
        } else if (insightData instanceof ImportInsightData) {
            ImportInsightData importInsightData = (ImportInsightData)insightData;
            importInsightData.updateData();
        } else if (insightData instanceof ClassInsightData) {
            ClassInsightData classInsightData = (ClassInsightData)insightData;
            classInsightData.setResultFilter(this.smartFilter);
            classInsightData.updateData();
        } else if (insightData instanceof MemberInsightData) {
            MemberInsightData memberInsightData = (MemberInsightData)insightData;
            memberInsightData.setResultFilter(this.smartFilter);
            memberInsightData.updateData();
        } else if (insightData instanceof LabelInsightData) {
            LabelInsightData labelInsightData = (LabelInsightData)insightData;
            labelInsightData.updateData();
        } else if (insightData instanceof DocTagInsightData) {
            DocTagInsightData docTagInsightData = (DocTagInsightData)insightData;
            docTagInsightData.updateData();
        }
        return insightData;
    }

    private InsightData getInsightDataViaLexer() {
        int n;
        ExpressionFinder expressionFinder = this.context.getFinder();
        if (expressionFinder.isCursorPartOfLabelUsage(n = this.context.getCaretPosition())) {
            return new LabelInsightData(this.context);
        }
        int n2 = expressionFinder.isCursorPartOfQualifiedNameUsage(n);
        if (n2 != -1) {
            TextBuffer textBuffer = this.context.getTextBuffer();
            int n3 = RegularInsightProvider.getTokenAtOffset(textBuffer, n2);
            switch (n3) {
                case 125: {
                    return new PackageInsightData(this.context);
                }
                case 118: {
                    return new ImportInsightData(this.context);
                }
                case 79: 
                case 110: 
                case 117: 
                case 124: 
                case 137: 
                case 138: {
                    return new ClassInsightData(this.context, n3, this.smartFilter);
                }
            }
            throw new RuntimeException("Not a qualified name keyword.");
        }
        if (expressionFinder.isCursorPartOfCodeUsage(n)) {
            return new MemberInsightData(this.context, this.smartFilter);
        }
        return null;
    }

    protected boolean verifyValidContext() {
        TextBuffer textBuffer = this.context.getTextBuffer();
        int n = this.context.getCaretPosition();
        int n2 = RegularInsightProvider.getTokenAtOffset(textBuffer, n);
        String string = null;
        if (RegularInsightProvider.isSQLJToken(n2)) {
            string = JavaArb.getString(50);
        } else if (RegularInsightProvider.isLiteralToken(n2)) {
            string = JavaArb.getString(49);
        }
        if (string != null) {
            this.context.showFeedback(string);
            return false;
        }
        return true;
    }

    protected int getSimpleContextType() {
        int n;
        TextBuffer textBuffer = this.context.getTextBuffer();
        LineMap lineMap = textBuffer.getLineMap();
        int n2 = this.context.getCaretPosition();
        if (RegularInsightProvider.getTokenAtOffset(textBuffer, n2) == 26) {
            return 7;
        }
        int n3 = 0;
        int n4 = lineMap.getLineFromOffset(n2);
        int n5 = lineMap.getLineStartOffset(n4);
        char[] cArray = textBuffer.getChars(n5, (n = lineMap.getLineEndOffset(n4)) - n5);
        String string = new String(cArray);
        String string2 = string.trim();
        if (string2.startsWith("package")) {
            n3 = 1;
        } else if (string2.startsWith("import")) {
            n3 = 2;
        }
        return n3;
    }

    /*
     * Unable to fully structure code
     */
    protected int getComplexContextType() {
        block8: {
            block7: {
                block6: {
                    var1_1 = this.context.getCaretPosition();
                    var2_2 = this.context.getSourceFile();
                    if (var2_2 == null) {
                        var3_3 = JavaArb.getString(45);
                        this.context.showFeedback(var3_3);
                        return 0;
                    }
                    var4_4 = new ArrayList<Object>();
                    var4_4.add(var2_2);
                    var5_5 = 0;
                    var6_6 = var2_2.getSourcePackage();
                    if (var6_6 == null || !RegularInsightProvider.inJavaSymbol(var1_1, (SourceElement)var6_6)) break block6;
                    var5_5 = 1;
                    var4_4.add(var6_6);
                    ** GOTO lbl56
                }
                var7_7 = var2_2.getSourceImports();
                if (var7_7.isEmpty()) break block7;
                for (SourceImport var9_9 : var7_7) {
                    if (!RegularInsightProvider.inJavaSymbol(var1_1, (SourceElement)var9_9)) continue;
                    var5_5 = 2;
                    var4_4.add(var9_9);
                    ** GOTO lbl56
                }
            }
            if ((var10_10 = var2_2.getSourceClasses()).isEmpty()) break block8;
            for (SourceClass var12_12 : var10_10) {
                if (!RegularInsightProvider.inJavaSymbol(var1_1, (SourceElement)var12_12)) continue;
                var5_5 = 3;
                var4_4.add(var12_12);
                if (true) ** GOTO lbl56
            }
        }
        var13_13 = JavaArb.getString(46);
        this.context.showFeedback(var13_13);
        return 0;
        block2: while (true) {
            if (!RegularInsightProvider.inJavaSymbol(var1_1, (SourceElement)(var16_16 = (var15_15 = (SourceClass)var4_4.get(var14_14 = var4_4.size() - 1)).getSourceBody()))) {
                var5_5 = 4;
                break;
            }
            var5_5 = 6;
            var4_4.add(var16_16);
            var17_17 = var15_15.getSourceMembers();
            if (var17_17.isEmpty()) break;
            for (SourceMember var19_19 : var17_17) {
                if (!RegularInsightProvider.inJavaSymbol(var1_1, (SourceElement)var19_19)) continue;
                var5_5 = 5;
                var4_4.add(var19_19);
                if (!(var19_19 instanceof SourceClass)) break block2;
                var5_5 = 3;
                var4_4.add(var19_19);
lbl56:
                // 4 sources

                if (var5_5 == 3) continue block2;
            }
            break;
        }
        return var5_5;
    }

    private static boolean inJavaSymbol(int n, SourceElement sourceElement) {
        return n >= sourceElement.getStartOffset() && n <= sourceElement.getEndOffset();
    }

    public static int getTokenAtOffset(TextBuffer textBuffer, int n) {
        int n2;
        JavaLexer javaLexer = new JavaLexer();
        LexerToken lexerToken = javaLexer.createLexerToken();
        javaLexer.setTextBuffer((ReadTextBuffer)textBuffer);
        javaLexer.setSkipComments(false);
        javaLexer.setRecognizeSQLJ(true);
        javaLexer.setPosition(0);
        int n3 = -1;
        while ((n2 = javaLexer.lex(lexerToken)) != 0) {
            int n4 = lexerToken.getStartOffset();
            int n5 = lexerToken.getEndOffset();
            if (n5 < n) continue;
            if (n4 <= n && n < n5) {
                n3 = n2;
                break;
            }
            if (n5 == n) {
                n3 = n2;
                continue;
            }
            if (n < n4) break;
            throw new IllegalStateException("Unexpected");
        }
        javaLexer.setTextBuffer(null);
        return n3;
    }

    public static boolean isSQLJToken(int n) {
        switch (n) {
            case 6: {
                return true;
            }
        }
        return false;
    }

    public static boolean isCommentToken(int n) {
        switch (n) {
            case 24: 
            case 25: 
            case 26: {
                return true;
            }
        }
        return false;
    }

    public static boolean isLiteralToken(int n) {
        return 8 <= n && n < 16;
    }

    public static boolean isKeywordToken(int n) {
        return 96 <= n && n < 146;
    }
}

