/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.insight;

import java.util.HashSet;
import java.util.Iterator;
import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceLocalVariable;
import oracle.javatools.parser.java.v2.model.SourceLocalVariableDeclaration;
import oracle.javatools.parser.java.v2.model.expression.SourceAssignmentExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceInfixExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceInvokeExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceListExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceNewClassExpression;
import oracle.javatools.parser.java.v2.model.statement.SourceSwitchLabel;
import oracle.javatools.parser.java.v2.util.filter.AssignableFilter;
import oracle.javatools.parser.java.v2.util.filter.JavaFilter;
import oracle.javatools.parser.java.v2.util.filter.OrFilter;
import oracle.jdevimpl.java.insight.InsightContext;
import oracle.jdevimpl.java.insight.IntConstantFilter;

final class SmartInsightProvider
implements JavaConstants {
    private final InsightContext context;

    SmartInsightProvider(InsightContext insightContext) {
        this.context = insightContext;
    }

    private static SourceElement getLeftElem(SourceElement sourceElement, int n) {
        int n2 = sourceElement.getEndOffset();
        int n3 = sourceElement.getStartOffset();
        if (n <= n3) {
            return null;
        }
        SourceElement sourceElement2 = sourceElement;
        Iterator iterator = sourceElement.getChildren().iterator();
        while (iterator.hasNext()) {
            SourceElement sourceElement3 = SmartInsightProvider.getLeftElem((SourceElement)iterator.next(), n);
            if (sourceElement3 == null) continue;
            sourceElement2 = sourceElement3;
        }
        return sourceElement2;
    }

    private static int calculateElemSignature(SourceElement sourceElement, int n) {
        SourceElement sourceElement2;
        int n2 = sourceElement.getSymbolKind();
        if (n > 0 && (sourceElement2 = sourceElement.getParent()) != null) {
            n2 += 73 * SmartInsightProvider.calculateElemSignature(sourceElement2, n - 1);
        }
        return n2;
    }

    private static int calculateSignature(int n, int n2) {
        return n + 73 * n2;
    }

    private static int calculateSignature(int n, int n2, int n3) {
        return n + 73 * (n2 + 73 * n3);
    }

    private static int calculateSignature(int n, int n2, int n3, int n4) {
        return n + 73 * (n2 + 73 * (n3 + 73 * n4));
    }

    private static String getAdjustedText(SourceElement sourceElement, int n) {
        String string = sourceElement.getText();
        if (n > sourceElement.getStartOffset() && n < sourceElement.getEndOffset()) {
            string = string.substring(0, n - sourceElement.getStartOffset());
        }
        return string;
    }

    private JavaFilter checkAssign(JavaHasType javaHasType, String string) {
        if ((string = string.trim()).endsWith(";")) {
            return null;
        }
        if (string.endsWith(",")) {
            return null;
        }
        if (string.indexOf(61) != -1) {
            if (string.endsWith("new")) {
                if ((string = string.substring(0, string.length() - 3).trim()).endsWith("=")) {
                    JavaType javaType = javaHasType.getResolvedType();
                    return new AssignableFilter(javaHasType.getResolvedType(), 2);
                }
            } else {
                if (string.endsWith("[")) {
                    JavaClass javaClass = this.context.getProvider().getClass("int");
                    return new AssignableFilter((JavaType)javaClass, 1);
                }
                if (string.endsWith("(")) {
                    return new AssignableFilter(javaHasType.getResolvedType(), 3);
                }
            }
            return new AssignableFilter(javaHasType.getResolvedType(), 1);
        }
        return null;
    }

    private JavaFilter lookForCaseLabel(SourceElement sourceElement, int n) {
        SourceElement sourceElement2 = sourceElement;
        while (sourceElement2 != null) {
            SourceSwitchLabel sourceSwitchLabel;
            if (sourceElement2.getSymbolKind() == 24 && (sourceSwitchLabel = (SourceSwitchLabel)sourceElement2).getText().startsWith("case")) {
                return new IntConstantFilter();
            }
            sourceElement2 = sourceElement2.getParent();
        }
        return null;
    }

    private JavaFilter lookForDeclaration(SourceElement sourceElement, int n) {
        SourceElement sourceElement2 = sourceElement;
        SourceLocalVariable sourceLocalVariable = null;
        while (sourceElement2 != null) {
            if (sourceElement2.getSymbolKind() == 17) {
                sourceLocalVariable = (SourceLocalVariable)sourceElement2;
            } else if (sourceElement2.getSymbolKind() == 18) {
                if (sourceLocalVariable == null) {
                    return null;
                }
                SourceLocalVariableDeclaration sourceLocalVariableDeclaration = (SourceLocalVariableDeclaration)sourceElement2;
                SourceElement sourceElement3 = sourceLocalVariableDeclaration.getParent();
                String string = sourceElement3.getSymbolKind() == 39 ? SmartInsightProvider.getAdjustedText(sourceElement3, n) : SmartInsightProvider.getAdjustedText((SourceElement)sourceLocalVariableDeclaration, n);
                return this.checkAssign((JavaHasType)sourceLocalVariable, string);
            }
            sourceElement2 = sourceElement2.getParent();
        }
        return null;
    }

    private JavaFilter lookForInfixExpression(SourceElement sourceElement, int n) {
        SourceElement sourceElement2 = sourceElement;
        while (sourceElement2 != null) {
            if (sourceElement2.getSymbolKind() == 51) {
                SourceInfixExpression sourceInfixExpression = (SourceInfixExpression)sourceElement2;
                switch (sourceInfixExpression.getOperatorCode()) {
                    case 20: 
                    case 21: 
                    case 22: 
                    case 25: 
                    case 30: 
                    case 42: {
                        SourceExpression sourceExpression;
                        if (n < sourceInfixExpression.getEndOffset() || (sourceExpression = sourceInfixExpression.getFirstOperand()) == null) break;
                        JavaType javaType = sourceExpression.getResolvedType();
                        return new AssignableFilter(javaType, 1);
                    }
                }
            }
            sourceElement2 = sourceElement2.getParent();
        }
        return null;
    }

    private int getArgumentPosition(SourceListExpression sourceListExpression, int n) {
        int n2 = 0;
        int n3 = 0;
        for (SourceElement sourceElement : sourceListExpression.getOperands()) {
            if (sourceElement.getEndOffset() < n) {
                n2 = n3;
            }
            ++n3;
        }
        String string = SmartInsightProvider.getAdjustedText((SourceElement)sourceListExpression, n).trim();
        if (string.endsWith(",")) {
            ++n2;
        }
        return n2;
    }

    private JavaFilter findPossibleParameterTypes(SourceListExpression sourceListExpression, JavaClass object, String string, int n, boolean bl) {
        HashSet<JavaType> hashSet = new HashSet<JavaType>();
        while (object != null) {
            Iterator iterator = string != null ? object.getMethods(string).iterator() : object.getDeclaredConstructors().iterator();
            while (iterator.hasNext()) {
                JavaMethod javaMethod = (JavaMethod)iterator.next();
                JavaType[] javaTypeArray = javaMethod.getParameterTypes();
                if (n >= javaTypeArray.length) continue;
                boolean bl2 = true;
                int n2 = 0;
                while (n2 < n) {
                    SourceExpression sourceExpression = sourceListExpression.getOperandAt(n2);
                    JavaType javaType = sourceExpression.getResolvedType();
                    bl2 &= javaTypeArray[n2].isAssignableFrom(javaType);
                    ++n2;
                }
                if (!bl2) continue;
                hashSet.add(javaTypeArray[n]);
            }
            JavaType javaType = object.getSuperclass();
            object = string != null && javaType != null ? javaType.getTypeErasure() : null;
        }
        if (hashSet.isEmpty()) {
            return null;
        }
        JavaFilter[] javaFilterArray = new JavaFilter[hashSet.size()];
        int n3 = 0;
        for (JavaType javaType : hashSet) {
            javaFilterArray[n3++] = bl ? new AssignableFilter(javaType, 2) : new AssignableFilter(javaType, 1);
        }
        return new OrFilter(javaFilterArray);
    }

    private JavaFilter lookForMethodParameter(SourceElement sourceElement, int n) {
        SourceElement sourceElement2 = sourceElement;
        SourceListExpression sourceListExpression = null;
        while (sourceElement2 != null) {
            if (sourceElement2.getSymbolKind() == 52) {
                if (n <= sourceElement2.getEndOffset()) {
                    sourceListExpression = (SourceListExpression)sourceElement2;
                }
            } else if ((sourceElement2.getSymbolKind() == 54 || sourceElement2.getSymbolKind() == 56) && n < sourceElement2.getEndOffset()) {
                JavaClass javaClass;
                if (sourceListExpression == null) {
                    return null;
                }
                int n2 = this.getArgumentPosition(sourceListExpression, n);
                SourceExpression sourceExpression = sourceListExpression.getOperandAt(n2);
                boolean bl = false;
                if (sourceExpression != null && (sourceExpression.getSymbolKind() == 62 || sourceExpression.getSymbolKind() == 60) && n < sourceExpression.getEndOffset()) {
                    bl = true;
                }
                SourceInvokeExpression sourceInvokeExpression = (SourceInvokeExpression)sourceElement2;
                String string = null;
                if (sourceInvokeExpression instanceof SourceMethodCallExpression) {
                    SourceMethodCallExpression sourceMethodCallExpression = (SourceMethodCallExpression)sourceInvokeExpression;
                    string = sourceMethodCallExpression.getName();
                    JavaHasType javaHasType = sourceInvokeExpression.getResolvedLhs();
                    if (javaHasType != null) {
                        javaClass = javaHasType.getResolvedType().getTypeErasure();
                    } else {
                        SourceElement sourceElement3 = sourceElement2;
                        while (sourceElement3 != null && sourceElement3.getSymbolKind() != 3) {
                            sourceElement3 = sourceElement3.getParent();
                        }
                        javaClass = (JavaClass)sourceElement3;
                    }
                } else {
                    SourceNewClassExpression sourceNewClassExpression = (SourceNewClassExpression)sourceInvokeExpression;
                    javaClass = sourceNewClassExpression.getSourceType().getResolvedType().getTypeErasure();
                }
                return this.findPossibleParameterTypes(sourceListExpression, javaClass, string, n2, bl);
            }
            sourceElement2 = sourceElement2.getParent();
        }
        return null;
    }

    private JavaFilter lookForAssignement(SourceElement sourceElement, int n) {
        SourceElement sourceElement2 = sourceElement;
        SourceAssignmentExpression sourceAssignmentExpression = null;
        while (sourceElement2 != null) {
            if (sourceElement2.getSymbolKind() == 49) {
                sourceAssignmentExpression = (SourceAssignmentExpression)sourceElement2;
            } else if (sourceElement2.getSymbolKind() == 37 || sourceElement2.getSymbolKind() == 52) {
                if (sourceAssignmentExpression == null) {
                    return null;
                }
                String string = SmartInsightProvider.getAdjustedText(sourceElement2, n);
                return this.checkAssign((JavaHasType)sourceAssignmentExpression.getResolvedType(), string);
            }
            sourceElement2 = sourceElement2.getParent();
        }
        return null;
    }

    private JavaFilter lookForCast(SourceElement sourceElement, int n) {
        SourceElement sourceElement2 = sourceElement;
        while (sourceElement2 != null) {
            if (sourceElement2.getSymbolKind() == 60) {
                if (n >= sourceElement2.getEndOffset()) {
                    return null;
                }
                int n2 = sourceElement2.getStartOffset() + 1;
                if (n2 == n) {
                    return null;
                }
                return this.filterInsightData(n2);
            }
            sourceElement2 = sourceElement2.getParent();
        }
        return null;
    }

    private JavaFilter lookForWrapper(SourceElement sourceElement, int n) {
        SourceElement sourceElement2 = sourceElement;
        while (sourceElement2 != null) {
            if (sourceElement2.getSymbolKind() == 62) {
                int n2;
                if (n >= sourceElement2.getEndOffset()) {
                    return null;
                }
                SourceElement sourceElement3 = sourceElement2.getParent();
                if (sourceElement3 != null) {
                    if (sourceElement3.getSymbolKind() == 40 || sourceElement3.getSymbolKind() == 46) {
                        JavaClass javaClass = this.context.getProvider().getClass("boolean");
                        return new AssignableFilter((JavaType)javaClass, 1);
                    }
                    if (sourceElement3.getSymbolKind() == 42) {
                        JavaClass javaClass = this.context.getProvider().getClass("int");
                        return new AssignableFilter((JavaType)javaClass, 1);
                    }
                }
                if ((n2 = sourceElement2.getStartOffset() + 1) == n) {
                    return null;
                }
                return this.filterInsightData(n2);
            }
            sourceElement2 = sourceElement2.getParent();
        }
        return null;
    }

    public JavaFilter filterInsightData() {
        return this.filterInsightData(this.context.getCaretPosition());
    }

    private JavaFilter filterInsightData(int n) {
        int n2 = 14659005;
        int n3 = 1070126074;
        int n4 = 7096570;
        int n5 = 14658421;
        int n6 = 21287697;
        int n7 = 97184;
        int n8 = 48712;
        SourceFile sourceFile = this.context.getSourceFile();
        SourceElement sourceElement = SmartInsightProvider.getLeftElem((SourceElement)sourceFile, n);
        JavaFilter javaFilter = this.lookForInfixExpression(sourceElement, n);
        if (javaFilter != null) {
            return javaFilter;
        }
        javaFilter = this.lookForMethodParameter(sourceElement, n);
        if (javaFilter != null) {
            return javaFilter;
        }
        javaFilter = this.lookForCast(sourceElement, n);
        if (javaFilter != null) {
            return javaFilter;
        }
        javaFilter = this.lookForWrapper(sourceElement, n);
        if (javaFilter != null) {
            return javaFilter;
        }
        javaFilter = this.lookForDeclaration(sourceElement, n);
        if (javaFilter != null) {
            return javaFilter;
        }
        javaFilter = this.lookForAssignement(sourceElement, n);
        if (javaFilter != null) {
            return javaFilter;
        }
        javaFilter = this.lookForCaseLabel(sourceElement, n);
        if (javaFilter != null) {
            return javaFilter;
        }
        javaFilter = new 1();
        return javaFilter;
    }

    final class 1
    implements JavaFilter {
        public boolean accepts(JavaElement javaElement) {
            return true;
        }
    }
}

