/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.usage;

import java.net.URL;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.SourceBlockElement;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceMember;
import oracle.javatools.parser.java.v2.util.Usages;
import oracle.jdeveloper.usage.event.UsageEvent;
import oracle.jdeveloper.usage.event.UsageListener;
import oracle.jdevimpl.java.usage.ClassUsageQuery;
import oracle.jdevimpl.java.usage.ConstructorUsageQuery;
import oracle.jdevimpl.java.usage.FieldUsageQuery;
import oracle.jdevimpl.java.usage.MethodUsageQuery;

public abstract class BaseUsageQuery
extends Usages {
    private UsageEvent lastEvent;
    private final URL url;
    private final UsageListener listener;
    private final int[] startLocations;
    private final int[] endLocations;
    private int locationIndex;

    public static void findClassUsages(SourceFile sourceFile, UsageListener usageListener, int[] nArray, int[] nArray2, String string) {
        URL uRL = sourceFile.getURL();
        ClassUsageQuery classUsageQuery = new ClassUsageQuery(uRL, usageListener, nArray, nArray2, string);
        Usages.processUsages((SourceFile)sourceFile, (Usages)classUsageQuery);
    }

    public static void findConstructorUsages(SourceFile sourceFile, UsageListener usageListener, int[] nArray, int[] nArray2, String string, String[] stringArray) {
        URL uRL = sourceFile.getURL();
        ConstructorUsageQuery constructorUsageQuery = new ConstructorUsageQuery(uRL, usageListener, nArray, nArray2, string, stringArray);
        Usages.processUsages((SourceFile)sourceFile, (Usages)constructorUsageQuery);
    }

    public static void findFieldUsages(SourceFile sourceFile, UsageListener usageListener, int[] nArray, int[] nArray2, String string, String string2) {
        URL uRL = sourceFile.getURL();
        FieldUsageQuery fieldUsageQuery = new FieldUsageQuery(uRL, usageListener, nArray, nArray2, string, string2);
        Usages.processUsages((SourceFile)sourceFile, (Usages)fieldUsageQuery);
    }

    public static void findMethodUsages(SourceFile sourceFile, UsageListener usageListener, int[] nArray, int[] nArray2, String string, String string2, String[] stringArray) {
        URL uRL = sourceFile.getURL();
        MethodUsageQuery methodUsageQuery = new MethodUsageQuery(uRL, usageListener, nArray, nArray2, string, string2, stringArray);
        Usages.processUsages((SourceFile)sourceFile, (Usages)methodUsageQuery);
    }

    void $init$() {
        this.lastEvent = null;
        this.locationIndex = 0;
    }

    BaseUsageQuery(URL uRL, UsageListener usageListener, int[] nArray, int[] nArray2) {
        this.$init$();
        this.url = uRL;
        this.listener = usageListener;
        this.startLocations = nArray;
        this.endLocations = nArray2;
    }

    final URL getURL() {
        return this.url;
    }

    final UsageListener getListener() {
        return this.listener;
    }

    final UsageEvent getLastEvent() {
        return this.lastEvent;
    }

    final void setLastEvent(UsageEvent usageEvent) {
        this.lastEvent = usageEvent;
    }

    abstract boolean match(JavaElement var1);

    abstract UsageEvent generateUsageEvent(int var1, int var2, int var3);

    public final boolean shouldTraverse(SourceElement sourceElement) {
        if (sourceElement instanceof SourceMember || sourceElement instanceof SourceBlockElement) {
            this.offsetAdvance(sourceElement);
        }
        return this.offsetFound(sourceElement);
    }

    final void processCandidate(SourceElement sourceElement, JavaElement javaElement, int n) {
        int[] nArray = this.findLocation(sourceElement);
        if (nArray == null) {
            return;
        }
        if (!this.match(javaElement)) {
            return;
        }
        int n2 = nArray[0];
        int n3 = nArray[1];
        UsageEvent usageEvent = this.generateUsageEvent(n, n2, n3);
        if (usageEvent != null) {
            this.setLastEvent(usageEvent);
        }
    }

    private int[] findLocation(SourceElement sourceElement) {
        if (this.startLocations == null || this.endLocations == null) {
            return null;
        }
        int n = sourceElement.getStartOffset();
        int n2 = sourceElement.getEndOffset();
        int n3 = this.startLocations.length;
        int n4 = 0;
        while (n4 < n3) {
            int n5 = this.startLocations[n4];
            int n6 = this.endLocations[n4];
            if (n <= n5 && n6 <= n2) {
                return new int[]{n5, n6};
            }
            ++n4;
        }
        return null;
    }

    private final void offsetAdvance(SourceElement sourceElement) {
        int n = this.startLocations.length;
        while (this.locationIndex < n) {
            int n2 = this.startLocations[this.locationIndex];
            if (sourceElement.getEndOffset() < n2) {
                return;
            }
            if (sourceElement.getStartOffset() <= n2) {
                return;
            }
            ++this.locationIndex;
        }
    }

    private final boolean offsetFound(SourceElement sourceElement) {
        int n = this.startLocations.length;
        int n2 = this.locationIndex;
        while (n2 < n) {
            int n3 = this.startLocations[n2];
            if (sourceElement.getEndOffset() < n3) {
                return false;
            }
            if (sourceElement.getStartOffset() <= n3) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

