/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.usage;

import java.lang.reflect.Modifier;
import java.net.URL;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.doc.SourceDocReference;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.jdeveloper.usage.event.FieldUsageEvent;
import oracle.jdeveloper.usage.event.FieldUsageListener;
import oracle.jdeveloper.usage.event.UsageEvent;
import oracle.jdeveloper.usage.event.UsageListener;
import oracle.jdevimpl.java.usage.BaseUsageQuery;

class FieldUsageQuery
extends BaseUsageQuery {
    protected final String targetClassName;
    protected final String targetFieldName;

    FieldUsageQuery(URL uRL, UsageListener usageListener, int[] nArray, int[] nArray2, String string, String string2) {
        super(uRL, usageListener, nArray, nArray2);
        this.targetClassName = string;
        this.targetFieldName = string2;
    }

    protected boolean match(JavaElement javaElement) {
        JavaField javaField = (JavaField)javaElement;
        String string = javaField.getName();
        if (!string.equals(this.targetFieldName)) {
            return false;
        }
        JavaClass javaClass = javaField.getOwningClass();
        if (javaClass == null) {
            return false;
        }
        int n = javaField.getModifiers();
        boolean bl = Modifier.isStatic(n);
        String string2 = javaClass.getRawName();
        if (this.targetClassName.equals(string2)) {
            return true;
        }
        if (bl) {
            return false;
        }
        for (JavaType javaType : javaClass.getHierarchy()) {
            String string3 = javaType.getRawName();
            if (!this.targetClassName.equals(string3)) continue;
            return true;
        }
        return false;
    }

    protected UsageEvent generateUsageEvent(int n, int n2, int n3) {
        FieldUsageEvent fieldUsageEvent = new FieldUsageEvent(null, n, this.getURL(), n2, n3);
        boolean bl = false;
        if (bl) {
            return null;
        }
        FieldUsageListener fieldUsageListener = (FieldUsageListener)this.getListener();
        fieldUsageListener.notifyFieldUsage(fieldUsageEvent);
        return fieldUsageEvent;
    }

    public void declareField(SourceFieldVariable sourceFieldVariable) {
        this.processCandidate((SourceElement)sourceFieldVariable, (JavaElement)sourceFieldVariable, 201);
    }

    public void useFieldInDocComment(SourceDocReference sourceDocReference, JavaField javaField) {
    }

    public void useFieldInExpression(SourceExpression sourceExpression, JavaField javaField) {
        this.processCandidate((SourceElement)sourceExpression, (JavaElement)javaField, 202);
    }
}

