/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.usage;

import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Collection;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaVariable;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.doc.SourceDocReference;
import oracle.javatools.parser.java.v2.model.expression.SourceInvokeExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.jdeveloper.usage.event.MethodUsageEvent;
import oracle.jdeveloper.usage.event.MethodUsageListener;
import oracle.jdeveloper.usage.event.UsageEvent;
import oracle.jdeveloper.usage.event.UsageListener;
import oracle.jdevimpl.java.usage.BaseUsageQuery;

public class MethodUsageQuery
extends BaseUsageQuery {
    protected final String targetClassName;
    protected final String targetMethodName;
    protected final String[] targetParameters;

    MethodUsageQuery(URL uRL, UsageListener usageListener, int[] nArray, int[] nArray2, String string, String string2, String[] stringArray) {
        super(uRL, usageListener, nArray, nArray2);
        this.targetClassName = string;
        this.targetMethodName = string2;
        this.targetParameters = stringArray;
    }

    protected boolean match(JavaElement javaElement) {
        String string;
        JavaMethod javaMethod = (JavaMethod)javaElement;
        JavaMethod javaMethod2 = javaMethod.getMethodErasure();
        if (javaMethod2 != null) {
            javaMethod = javaMethod2;
        }
        if (!(string = javaMethod.getName()).equals(this.targetMethodName)) {
            return false;
        }
        JavaClass javaClass = javaMethod.getOwningClass();
        if (javaClass == null) {
            return false;
        }
        int n = this.targetParameters.length;
        Collection collection = javaMethod.getParameters();
        if (n != collection.size()) {
            return false;
        }
        int n2 = 0;
        for (JavaVariable javaVariable : collection) {
            JavaType javaType = javaVariable.getResolvedType();
            if (javaType == null) {
                return false;
            }
            String string2 = javaType.getRawName();
            if (this.targetParameters[n2++].equals(string2)) continue;
            return false;
        }
        return this.matchOwningClass(javaMethod, javaClass);
    }

    protected boolean matchOwningClass(JavaMethod javaMethod, JavaClass javaClass) {
        int n = javaMethod.getModifiers();
        boolean bl = Modifier.isStatic(n);
        String string = javaClass.getRawName();
        if (this.targetClassName.equals(string)) {
            return true;
        }
        if (bl) {
            return false;
        }
        for (JavaType javaType : javaClass.getHierarchy()) {
            String string2 = javaType.getRawName();
            if (!this.targetClassName.equals(string2)) continue;
            return true;
        }
        return false;
    }

    protected UsageEvent generateUsageEvent(int n, int n2, int n3) {
        MethodUsageEvent methodUsageEvent = new MethodUsageEvent(null, n, this.getURL(), n2, n3);
        boolean bl = false;
        if (bl) {
            return null;
        }
        MethodUsageListener methodUsageListener = (MethodUsageListener)this.getListener();
        methodUsageListener.notifyMethodUsage(methodUsageEvent);
        return methodUsageEvent;
    }

    public void declareConstructor(SourceMethod sourceMethod) {
        this.processCandidate((SourceElement)sourceMethod, (JavaElement)sourceMethod, 301);
    }

    public void declareMethod(SourceMethod sourceMethod) {
        this.processCandidate((SourceElement)sourceMethod, (JavaElement)sourceMethod, 401);
    }

    public void useMethodInDocComment(SourceDocReference sourceDocReference, JavaMethod javaMethod) {
    }

    public void useMethodInExpression(SourceInvokeExpression sourceInvokeExpression, JavaMethod javaMethod) {
        if (sourceInvokeExpression.getSymbolKind() == 56) {
            this.processCandidate((SourceElement)sourceInvokeExpression, (JavaElement)javaMethod, 304);
        } else {
            SourceMethodCallExpression sourceMethodCallExpression = (SourceMethodCallExpression)sourceInvokeExpression;
            String string = sourceMethodCallExpression.getName();
            if (string.equals("this")) {
                this.processCandidate((SourceElement)sourceInvokeExpression, (JavaElement)javaMethod, 302);
            } else if (string.equals("super")) {
                this.processCandidate((SourceElement)sourceInvokeExpression, (JavaElement)javaMethod, 303);
            } else {
                this.processCandidate((SourceElement)sourceInvokeExpression, (JavaElement)javaMethod, 402);
            }
        }
    }
}

