/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.util;

import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.editor.language.NumberRange;
import oracle.javatools.editor.language.java.JavaBraceProvider;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.java.v2.JavaTokens;
import oracle.javatools.parser.java.v2.common.PrimitiveType;
import oracle.javatools.parser.java.v2.scanner.JavaLexer;
import oracle.javatools.parser.java.v2.scanner.LexerUtilities;
import oracle.jdevimpl.java.util.FoundSymbol;

public class ExpressionFinder
implements JavaTokens {
    private static boolean verboseOutput = false;
    public static final int FILTER_ACCEPT_STAR = 1;
    public static final int FILTER_ACCEPT_BRACES = 0;
    private JavaBraceProvider braceProvider;
    private ReadTextBuffer buffer;
    private static final int kSearchBackwardsGuess = 500;
    private static final double kCandidateDensityGuess = 0.05;
    private static NumberRange left = new NumberRange(0, 0);
    private static NumberRange right = new NumberRange(0, 0);

    public ExpressionFinder(ReadTextBuffer readTextBuffer, JavaBraceProvider javaBraceProvider) {
        this.buffer = readTextBuffer;
        this.braceProvider = javaBraceProvider;
    }

    public ExpressionFinder(ReadTextBuffer readTextBuffer, LanguageSupport languageSupport) {
        this.buffer = readTextBuffer;
        this.braceProvider = (JavaBraceProvider)languageSupport.getBraceProvider();
    }

    private int getSearchStartPoint(int n, JavaLexer javaLexer, LexerToken lexerToken) {
        int n2 = 0;
        javaLexer.setPosition(0);
        while (true) {
            int n3 = this.lex(javaLexer, lexerToken);
            int n4 = lexerToken.getStartOffset();
            if (n - 500 < n4 || n3 == 0) {
                return n2;
            }
            n2 = n4;
        }
    }

    private int[] createInitialArray() {
        int n = 25;
        if (n < 1) {
            n = 1;
        }
        return new int[n];
    }

    private int[] addToIntArray(int n, int[] nArray, int n2) {
        if (n2 == nArray.length) {
            int n3 = n2 * 2;
            int[] nArray2 = new int[n3];
            System.arraycopy(nArray, 0, nArray2, 0, n2);
            nArray = nArray2;
        }
        nArray[n2] = n;
        return nArray;
    }

    private int getPrecedingToken(int n, JavaLexer javaLexer, LexerToken lexerToken) {
        int n2 = this.getSearchStartPoint(n, javaLexer, lexerToken);
        javaLexer.setPosition(n2);
        int n3 = 0;
        while (true) {
            int n4 = this.lex(javaLexer, lexerToken);
            int n5 = lexerToken.getStartOffset();
            if (n <= n5 || n4 == 0) {
                return n3;
            }
            n3 = n4;
        }
    }

    public FoundSymbol determinePrimaryStart(int n) {
        JavaLexer javaLexer = new JavaLexer();
        javaLexer.setTextBuffer(this.buffer);
        LexerToken lexerToken = javaLexer.createLexerToken();
        int[] nArray = this.buildPrimaryCandidateArray(n, javaLexer, lexerToken);
        int n2 = nArray.length;
        if (n2 == 0) {
            return null;
        }
        FoundSymbol foundSymbol = null;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = nArray[n3];
            FoundSymbol foundSymbol2 = this.testThisPrimary(n4, n, javaLexer, lexerToken);
            if (foundSymbol2 != null) {
                foundSymbol = foundSymbol2;
                break;
            }
            ++n3;
        }
        if (foundSymbol == null) {
            return null;
        }
        if (foundSymbol.startOffset > 0 && this.buffer.getChar(foundSymbol.startOffset - 1) == '@') {
            return foundSymbol;
        }
        boolean bl = false;
        javaLexer.setPosition(foundSymbol.endOffset);
        int n5 = this.lex(javaLexer, lexerToken);
        if (n5 == 55) {
            bl = true;
            int n6 = this.findEndOfBraceMatching(lexerToken.getStartOffset());
            if (n6 != -1) {
                foundSymbol.endOffset = n6;
            }
        }
        if (!bl) {
            javaLexer.setPosition(foundSymbol.startOffset);
            n5 = this.lex(javaLexer, lexerToken);
            if (n5 == 124) {
                this.lex(javaLexer, lexerToken);
                int n7 = lexerToken.getStartOffset();
                if (n7 < foundSymbol.endOffset) {
                    foundSymbol.startOffset = n7;
                    foundSymbol.resetString(this.buffer);
                }
            }
        }
        return foundSymbol;
    }

    private int[] buildPrimaryCandidateArray(int n, JavaLexer javaLexer, LexerToken lexerToken) {
        int n2 = this.getSearchStartPoint(n, javaLexer, lexerToken);
        int[] nArray = this.createInitialArray();
        int n3 = 0;
        javaLexer.setPosition(n2);
        boolean bl = true;
        boolean bl2 = true;
        while (true) {
            boolean bl3;
            boolean bl4;
            int n4 = this.lex(javaLexer, lexerToken);
            int n5 = lexerToken.getStartOffset();
            if (n < n5 || n4 == 0) break;
            switch (n4) {
                default: {
                    bl4 = false;
                    break;
                }
                case 4: 
                case 14: 
                case 124: 
                case 133: 
                case 136: {
                    bl4 = true;
                }
            }
            boolean bl5 = bl3 = n4 == 55;
            if (bl4 && bl || bl3 && bl2) {
                nArray = this.addToIntArray(n5, nArray, n3++);
            }
            bl = n4 != 43 && n4 != 124;
            bl2 = n4 != 4 && n4 != 136 && n4 != 133;
        }
        if (n3 == nArray.length) {
            return nArray;
        }
        int[] nArray2 = new int[n3];
        System.arraycopy(nArray, 0, nArray2, 0, n3);
        return nArray2;
    }

    private FoundSymbol testThisPrimary(int n, int n2, JavaLexer javaLexer, LexerToken lexerToken) {
        javaLexer.setPosition(n);
        boolean bl = true;
        boolean bl2 = false;
        block8: while (true) {
            int n3 = this.lex(javaLexer, lexerToken);
            int n4 = lexerToken.getStartOffset();
            int n5 = lexerToken.getEndOffset();
            if (n2 < n4) {
                return null;
            }
            if (bl) {
                if (n3 == 124) {
                    bl = true;
                    continue;
                }
                switch (n3) {
                    default: {
                        return null;
                    }
                    case 55: {
                        int n6 = this.findEndOfBraceMatching(n4);
                        if (n6 == -1) {
                            return null;
                        }
                        if (n2 <= n6) {
                            return null;
                        }
                        javaLexer.setPosition(n6);
                        bl = false;
                        bl2 = true;
                        break;
                    }
                    case 4: 
                    case 14: 
                    case 133: 
                    case 136: {
                        if (n4 <= n2 && n2 <= n5) {
                            return new FoundSymbol(this.buffer, n, n5);
                        }
                        bl = false;
                        bl2 = false;
                    }
                }
                continue;
            }
            switch (n3) {
                case 43: {
                    if (n2 < n5) {
                        return null;
                    }
                    bl = true;
                    continue block8;
                }
                case 49: 
                case 50: 
                case 55: {
                    if (bl2 && n3 != 50) {
                        return null;
                    }
                    int n7 = this.findEndOfBraceMatching(n4);
                    if (n7 == -1) {
                        return null;
                    }
                    if (n2 < n7) {
                        return null;
                    }
                    if (n2 == n7) {
                        return new FoundSymbol(this.buffer, n, n7);
                    }
                    javaLexer.setPosition(n7);
                    bl = false;
                    continue block8;
                }
            }
            break;
        }
        return null;
    }

    public boolean isCursorPartOfCodeUsage(int n) {
        JavaLexer javaLexer = new JavaLexer();
        javaLexer.setTextBuffer(this.buffer);
        javaLexer.setSkipComments(false);
        LexerToken lexerToken = javaLexer.createLexerToken();
        int n2 = 0;
        while (true) {
            int n3 = this.lex(javaLexer, lexerToken);
            int n4 = lexerToken.getStartOffset();
            int n5 = lexerToken.getEndOffset();
            if (n <= n4 || n3 == 0) {
                return n2 > 0;
            }
            if (n3 == 49) {
                ++n2;
                continue;
            }
            if (n3 == 70) {
                if (n2 <= 0) continue;
                --n2;
                continue;
            }
            if (n3 == 24 || n3 == 14 ? n4 < n && n <= n5 : !ExpressionFinder.isIdentifierPrefix(n3) && n4 < n && n < n5) break;
        }
        return false;
    }

    public FoundSymbol determinePrimaryPrefix(int n, int n2) {
        JavaLexer javaLexer = new JavaLexer();
        javaLexer.setTextBuffer(this.buffer);
        LexerToken lexerToken = javaLexer.createLexerToken();
        int[] nArray = this.buildPrimaryCandidateArray(n, javaLexer, lexerToken);
        int n3 = nArray.length;
        if (n3 == 0) {
            return null;
        }
        FoundSymbol foundSymbol = null;
        int n4 = 0;
        while (n4 < n3) {
            int n5 = nArray[n4];
            FoundSymbol foundSymbol2 = this.testThisPrimaryPrefix(n5, n, javaLexer, lexerToken, n2);
            if (foundSymbol2 != null) {
                foundSymbol = foundSymbol2;
            }
            ++n4;
        }
        return foundSymbol;
    }

    private FoundSymbol testThisPrimaryPrefix(int n, int n2, JavaLexer javaLexer, LexerToken lexerToken, int n3) {
        boolean bl = (n3 & 0) == 0;
        boolean bl2 = (n3 & 1) == 1;
        javaLexer.setPosition(n);
        int n4 = -1;
        boolean bl3 = true;
        block4: while (true) {
            int n5 = this.lex(javaLexer, lexerToken);
            int n6 = lexerToken.getStartOffset();
            int n7 = lexerToken.getEndOffset();
            if (bl3) {
                boolean bl4 = false;
                if (n2 <= n6) break;
                if (n5 == 55) {
                    int n8 = this.findEndOfBraceMatching(n6);
                    if (n8 == -1) {
                        return null;
                    }
                    if (n2 <= n8) {
                        return null;
                    }
                    javaLexer.setPosition(n8);
                    bl3 = false;
                    continue;
                }
                if (n5 == 63 && bl2) {
                    if (n2 == n7) break;
                    return null;
                }
                if (n5 == 124) continue;
                if (!ExpressionFinder.isIdentifierPrefix(n5) && n5 != 14) {
                    return null;
                }
                if (n2 <= n7) break;
                bl3 = false;
                continue;
            }
            switch (n5) {
                case 43: {
                    if (n2 == n6) {
                        return null;
                    }
                    bl3 = true;
                    n4 = n7;
                    if (n2 != n7) continue block4;
                    break block4;
                }
                case 49: 
                case 50: 
                case 55: {
                    if (bl) {
                        int n9 = this.findEndOfBraceMatching(n6);
                        if (n9 == -1) {
                            return null;
                        }
                        if (n2 <= n9) {
                            return null;
                        }
                        javaLexer.setPosition(n9);
                        bl3 = false;
                        break;
                    }
                }
                default: {
                    return null;
                }
            }
        }
        if (n4 == -1) {
            return null;
        }
        return new FoundSymbol(this.buffer, n, n4);
    }

    private boolean isConstructorInvocation(int n, int n2) {
        int n3 = n + n2;
        JavaLexer javaLexer = new JavaLexer();
        LexerToken lexerToken = javaLexer.createLexerToken();
        javaLexer.setTextBuffer(this.buffer);
        javaLexer.setPosition(n);
        boolean bl = false;
        boolean bl2 = false;
        int n4;
        block5: while ((n4 = this.lex(javaLexer, lexerToken)) != 0) {
            int n5 = lexerToken.getStartOffset();
            if (n3 <= n5) {
                return bl;
            }
            switch (n4) {
                case 124: {
                    bl = true;
                    break;
                }
                case 43: {
                    if (!bl2) continue block5;
                    bl = false;
                    break;
                }
                case 55: {
                    int n6 = this.findEndOfBraceMatching(n5);
                    if (n6 == -1 || n3 <= n6) {
                        throw new RuntimeException("Unmatched in constructor query.");
                    }
                    javaLexer.setPosition(n6);
                    bl2 = true;
                }
            }
        }
        return false;
    }

    public boolean isMethodDeclaration(FoundSymbol foundSymbol) {
        String string = foundSymbol.string;
        if (string.indexOf(40) != -1 || string.indexOf(46) != -1) {
            return false;
        }
        int n = foundSymbol.startOffset;
        JavaLexer javaLexer = new JavaLexer();
        javaLexer.setTextBuffer(this.buffer);
        LexerToken lexerToken = javaLexer.createLexerToken();
        javaLexer.setPosition(n);
        int n2 = javaLexer.lex(lexerToken);
        if (n2 != 4) {
            return false;
        }
        int n3 = this.getPrecedingToken(n, javaLexer, lexerToken);
        if (n3 == 4 || n3 == 141) {
            return true;
        }
        return ExpressionFinder.isPrimitiveType(n3);
    }

    public boolean isAnnotation(FoundSymbol foundSymbol) {
        String string = foundSymbol.string;
        if (string.indexOf(40) != -1) {
            return false;
        }
        int n = foundSymbol.startOffset;
        JavaLexer javaLexer = new JavaLexer();
        javaLexer.setTextBuffer(this.buffer);
        LexerToken lexerToken = javaLexer.createLexerToken();
        javaLexer.setPosition(n);
        int n2 = javaLexer.lex(lexerToken);
        if (n2 != 4) {
            return false;
        }
        int n3 = this.getPrecedingToken(n, javaLexer, lexerToken);
        return n3 == 79;
    }

    public FoundSymbol determineArgumentInvocation(int n, int[] nArray) {
        nArray[0] = -1;
        JavaLexer javaLexer = new JavaLexer();
        javaLexer.setTextBuffer(this.buffer);
        LexerToken lexerToken = javaLexer.createLexerToken();
        int[] nArray2 = this.buildArgumentsCandidateArray(n, javaLexer, lexerToken);
        int n2 = nArray2.length;
        int n3 = -1;
        int n4 = 0;
        while (n4 < n2) {
            boolean bl;
            int n5 = nArray2[n4];
            int n6 = this.testThisArguments(n5, n, javaLexer, lexerToken);
            boolean bl2 = bl = n6 != -1;
            if (bl) {
                nArray[0] = n6;
                n3 = n5;
            }
            ++n4;
        }
        if (n3 == -1) {
            return null;
        }
        int n7 = n3 - 1;
        while (n7 >= 0) {
            char c = this.buffer.getChar(n7);
            if (Character.isJavaIdentifierPart(c)) break;
            --n7;
        }
        FoundSymbol foundSymbol = this.determinePrimaryStart(n7);
        return foundSymbol;
    }

    private int[] buildArgumentsCandidateArray(int n, JavaLexer javaLexer, LexerToken lexerToken) {
        int n2 = this.getSearchStartPoint(n, javaLexer, lexerToken);
        int[] nArray = this.createInitialArray();
        int n3 = 0;
        javaLexer.setPosition(n2);
        boolean bl = false;
        while (true) {
            int n4 = this.lex(javaLexer, lexerToken);
            int n5 = lexerToken.getStartOffset();
            if (n <= n5 || n4 == 0) break;
            if (n4 == 55 && bl) {
                nArray = this.addToIntArray(n5, nArray, n3++);
            }
            bl = n4 == 4 || n4 == 136 || n4 == 133;
        }
        if (n3 == nArray.length) {
            return nArray;
        }
        int[] nArray2 = new int[n3];
        System.arraycopy(nArray, 0, nArray2, 0, n3);
        return nArray2;
    }

    private int testThisArguments(int n, int n2, JavaLexer javaLexer, LexerToken lexerToken) {
        javaLexer.setPosition(n);
        this.lex(javaLexer, lexerToken);
        if (lexerToken.getEndOffset() == n2) {
            return 0;
        }
        int n3 = 0;
        block8: while (true) {
            int n4 = this.lex(javaLexer, lexerToken);
            int n5 = lexerToken.getStartOffset();
            if (n2 <= n5) {
                return n3;
            }
            switch (n4) {
                case 0: 
                case 70: 
                case 71: 
                case 72: 
                case 75: {
                    return -1;
                }
                case 39: {
                    ++n3;
                    break;
                }
            }
            switch (n4) {
                case 49: 
                case 50: {
                    int n6 = this.findEndOfBraceMatching(n5);
                    if (n6 == -1) continue block8;
                    if (n5 < n2 && n2 < n6) {
                        return n3;
                    }
                    javaLexer.setPosition(n6);
                    break;
                }
                case 55: {
                    int n7 = this.findEndOfBraceMatching(n5);
                    if (n7 == -1) {
                        return -1;
                    }
                    if (n5 < n2 && n2 < n7) {
                        return -1;
                    }
                    javaLexer.setPosition(n7);
                    break;
                }
            }
        }
    }

    public boolean precededByClassKeyword(int n, String[] stringArray) {
        boolean bl = true;
        stringArray[0] = null;
        JavaLexer javaLexer = new JavaLexer();
        LexerToken lexerToken = javaLexer.createLexerToken();
        javaLexer.setTextBuffer(this.buffer);
        javaLexer.setPosition(0);
        boolean bl2 = false;
        while (true) {
            int n2 = this.lex(javaLexer, lexerToken);
            int n3 = lexerToken.getStartOffset();
            if (n <= n3 || n2 == 0) {
                return bl;
            }
            switch (n2) {
                case 103: {
                    bl = true;
                    break;
                }
                case 121: {
                    bl = false;
                    break;
                }
                case 4: {
                    if (!bl2) break;
                    int n4 = lexerToken.getEndOffset();
                    int n5 = n4 - n3;
                    stringArray[0] = this.buffer.getString(n3, n5);
                    break;
                }
            }
            bl2 = n2 == 103 || n2 == 121;
        }
    }

    public int isCursorPartOfQualifiedNameUsage(int n) {
        JavaLexer javaLexer = new JavaLexer();
        javaLexer.setTextBuffer(this.buffer);
        LexerToken lexerToken = javaLexer.createLexerToken();
        int[] nArray = this.buildQualifiedNameCandidateArray(n, javaLexer, lexerToken);
        int n2 = nArray.length;
        int n3 = -1;
        int n4 = 0;
        while (n4 < n2) {
            int n5 = nArray[n4];
            boolean bl = this.testThisQualifiedNameUsage(n5, n, javaLexer, lexerToken);
            if (bl) {
                return n5;
            }
            ++n4;
        }
        return -1;
    }

    private int[] buildQualifiedNameCandidateArray(int n, JavaLexer javaLexer, LexerToken lexerToken) {
        int n2 = this.getSearchStartPoint(n, javaLexer, lexerToken);
        int[] nArray = this.createInitialArray();
        int n3 = 0;
        javaLexer.setPosition(n2);
        while (true) {
            int n4 = this.lex(javaLexer, lexerToken);
            int n5 = lexerToken.getStartOffset();
            if (n < n5 || n4 == 0) break;
            switch (n4) {
                case 79: 
                case 110: 
                case 117: 
                case 118: 
                case 124: 
                case 125: 
                case 137: 
                case 138: {
                    nArray = this.addToIntArray(n5, nArray, n3++);
                    break;
                }
            }
        }
        if (n3 == nArray.length) {
            return nArray;
        }
        int[] nArray2 = new int[n3];
        System.arraycopy(nArray, 0, nArray2, 0, n3);
        return nArray2;
    }

    private boolean testThisQualifiedNameUsage(int n, int n2, JavaLexer javaLexer, LexerToken lexerToken) {
        javaLexer.setPosition(n);
        int n3 = this.lex(javaLexer, lexerToken);
        int n4 = lexerToken.getEndOffset();
        switch (n3) {
            case 79: {
                if (n2 == n4) {
                    return true;
                }
            }
            case 110: 
            case 117: 
            case 118: 
            case 124: 
            case 125: 
            case 137: 
            case 138: {
                if (n2 > n4) break;
                return false;
            }
            default: {
                throw new RuntimeException("Not a qualified name usage!");
            }
        }
        boolean bl = true;
        boolean bl2 = true;
        while (true) {
            int n5 = this.lex(javaLexer, lexerToken);
            int n6 = lexerToken.getStartOffset();
            int n7 = lexerToken.getEndOffset();
            if (n3 == 137) {
                if (n5 != 124) {
                    return false;
                }
                if (n2 <= n7) {
                    return false;
                }
                n3 = 124;
                continue;
            }
            if (bl) {
                if (n2 <= n6) {
                    return true;
                }
                if (!ExpressionFinder.isIdentifierPrefix(n5)) {
                    return false;
                }
                if (n2 <= n7) {
                    return true;
                }
            } else {
                switch (n5) {
                    case 39: {
                        if (n3 != 117 && n3 != 138) {
                            return false;
                        }
                    }
                    case 43: {
                        if (n2 == n6) {
                            return false;
                        }
                        if (n2 != n7) break;
                        return true;
                    }
                    default: {
                        return false;
                    }
                }
            }
            bl ^= true;
        }
    }

    public boolean isCursorPartOfLabelUsage(int n) {
        JavaLexer javaLexer = new JavaLexer();
        javaLexer.setTextBuffer(this.buffer);
        LexerToken lexerToken = javaLexer.createLexerToken();
        int[] nArray = this.buildLabelCandidateArray(n, javaLexer, lexerToken);
        int n2 = nArray.length;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = nArray[n3];
            boolean bl = this.testThisLabelUsage(n4, n, javaLexer, lexerToken);
            if (bl) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    private int[] buildLabelCandidateArray(int n, JavaLexer javaLexer, LexerToken lexerToken) {
        int n2 = this.getSearchStartPoint(n, javaLexer, lexerToken);
        int[] nArray = this.createInitialArray();
        int n3 = 0;
        javaLexer.setPosition(n2);
        while (true) {
            int n4 = this.lex(javaLexer, lexerToken);
            int n5 = lexerToken.getStartOffset();
            if (n < n5 || n4 == 0) break;
            switch (n4) {
                case 98: 
                case 105: {
                    nArray = this.addToIntArray(n5, nArray, n3++);
                    break;
                }
            }
        }
        if (n3 == nArray.length) {
            return nArray;
        }
        int[] nArray2 = new int[n3];
        System.arraycopy(nArray, 0, nArray2, 0, n3);
        return nArray2;
    }

    private boolean testThisLabelUsage(int n, int n2, JavaLexer javaLexer, LexerToken lexerToken) {
        javaLexer.setPosition(n);
        this.lex(javaLexer, lexerToken);
        int n3 = lexerToken.getEndOffset();
        if (n2 <= n3) {
            return false;
        }
        int n4 = this.lex(javaLexer, lexerToken);
        int n5 = lexerToken.getStartOffset();
        if (n2 < n5) {
            return true;
        }
        if (n4 == 75 && n2 == n5) {
            return true;
        }
        int n6 = lexerToken.getEndOffset();
        return ExpressionFinder.isIdentifierPrefix(n4) && n2 <= n6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int findEndOfBraceMatching(int n) {
        NumberRange numberRange = left;
        synchronized (numberRange) {
            int n2 = this.braceProvider.isPartOfBrace(n, left);
            if (n2 == -1) {
                int n3 = -1;
                return n3;
            }
            int n4 = this.braceProvider.findMatchingBrace(n2, left, right);
            if (n4 == 3) {
                int n5 = -1;
                return n5;
            }
            int n6 = ExpressionFinder.right.end;
            return n6;
        }
    }

    private int lex(JavaLexer javaLexer, LexerToken lexerToken) {
        int n = javaLexer.lex(lexerToken);
        if (verboseOutput) {
            int n2 = lexerToken.getStartOffset();
            int n3 = lexerToken.getEndOffset();
            String string = this.buffer.getString(n2, n3 - n2);
            System.out.print(string + " (" + n2 + "," + n3 + ") ");
        }
        return n;
    }

    private static boolean isLiteral(int n) {
        return 8 <= n && n < 16;
    }

    private static boolean isPrimitiveType(int n) {
        return ExpressionFinder.isKeyword(n) && PrimitiveType.PRIMITIVE_lookup[n - 96] != null;
    }

    private static boolean isModifier(int n) {
        return ExpressionFinder.isKeyword(n) && LexerUtilities.kw2modifier((int)n) != 0;
    }

    private static boolean isKeyword(int n) {
        return 96 <= n && n < 146;
    }

    private static boolean isIdentifierPrefix(int n) {
        return n == 4 || ExpressionFinder.isKeyword(n) || n == 12 || n == 15;
    }
}

