/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.javadoc;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.ide.Ide;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.model.Project;
import oracle.ide.model.panels.ProjectSettingsTraversablePanel;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLTextField;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.javadoc.JProjectJavadoc;
import oracle.jdeveloper.resource.JProjectArb;
import oracle.jdevimpl.javadoc.JavadocArb;

public class JavadocConfigPanel
extends ProjectSettingsTraversablePanel {
    private GridBagLayout gbLayout;
    private JButton btnDir;
    private JCheckBox chkAuthor;
    private JCheckBox chkDeprecated;
    private JCheckBox chkIndex;
    private JCheckBox chkNavBar;
    private JCheckBox chkSince;
    private JCheckBox chkTree;
    private JCheckBox chkVersion;
    private JComboBox cmbScope;
    private JLabel lblDir;
    private JLabel lblMisc;
    private JLabel lblMiscExplanation;
    private JLabel lblScope;
    private JPanel pnlGenerate;
    private JPanel pnlTags;
    private JTextField fldMisc;
    private URLTextField fldDir;
    private static final String[] PROPERTY_KEYS = new String[]{"outputDirectory", "scope", "generateVersion", "generateAuthor", "generateSince", "generateDeprecated", "generateIndex", "generateTree", "generateNavbar", "miscOptions"};
    private static final String PUBLIC_OPTION = JavadocArb.getString(23);
    private static final String PROTECTED_OPTION = JavadocArb.getString(24);
    private static final String PACKAGE_OPTION = JavadocArb.getString(25);
    private static final String PRIVATE_OPTION = JavadocArb.getString(26);

    void $init$() {
        this.gbLayout = new GridBagLayout();
        this.btnDir = new JButton();
        this.chkAuthor = new JCheckBox();
        this.chkDeprecated = new JCheckBox();
        this.chkIndex = new JCheckBox();
        this.chkNavBar = new JCheckBox();
        this.chkSince = new JCheckBox();
        this.chkTree = new JCheckBox();
        this.chkVersion = new JCheckBox();
        this.cmbScope = new JComboBox();
        this.lblDir = new JLabel();
        this.lblMisc = new JLabel();
        this.lblMiscExplanation = new JLabel();
        this.lblScope = new JLabel();
        this.pnlGenerate = new JPanel();
        this.pnlTags = new JPanel();
        this.fldMisc = new JTextField();
        this.fldDir = new URLTextField();
    }

    public JavadocConfigPanel() {
        this.$init$();
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        ResourceUtils.resLabel((JLabel)this.lblDir, (Component)this.fldDir, (String)JavadocArb.getString(12));
        ResourceUtils.resButton((AbstractButton)this.btnDir, (String)JavadocArb.getString(16));
        ResourceUtils.resLabel((JLabel)this.lblScope, (Component)this.cmbScope, (String)JavadocArb.getString(15));
        ResourceUtils.resButton((AbstractButton)this.chkVersion, (String)"@v&ersion");
        ResourceUtils.resButton((AbstractButton)this.chkAuthor, (String)"@auth&or");
        ResourceUtils.resButton((AbstractButton)this.chkSince, (String)"@&since");
        ResourceUtils.resButton((AbstractButton)this.chkDeprecated, (String)"@dep&recated");
        ResourceUtils.resButton((AbstractButton)this.chkIndex, (String)JavadocArb.getString(10));
        ResourceUtils.resButton((AbstractButton)this.chkTree, (String)JavadocArb.getString(11));
        ResourceUtils.resButton((AbstractButton)this.chkNavBar, (String)JavadocArb.getString(17));
        ResourceUtils.resLabel((JLabel)this.lblMisc, (Component)this.fldMisc, (String)JavadocArb.getString(13));
        this.lblMiscExplanation.setText(JavadocArb.getString(14));
        this.btnDir.addActionListener((ActionListener)this.fldDir);
        this.pnlTags.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(JavadocArb.getString(8)), BorderFactory.createEmptyBorder(0, 8, 8, 8)));
        this.pnlTags.setLayout(this.gbLayout);
        Insets insets = new Insets(0, 0, 0, 0);
        this.pnlTags.add((Component)this.chkVersion, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, insets, 0, 0));
        this.pnlTags.add((Component)this.chkAuthor, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, insets, 0, 0));
        this.pnlTags.add((Component)this.chkSince, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, insets, 0, 0));
        this.pnlTags.add((Component)this.chkDeprecated, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 18, 2, insets, 10, 0));
        this.pnlGenerate.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(JavadocArb.getString(9)), BorderFactory.createEmptyBorder(0, 8, 8, 8)));
        this.pnlGenerate.setLayout(this.gbLayout);
        this.pnlGenerate.add((Component)this.chkIndex, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, insets, 0, 0));
        this.pnlGenerate.add((Component)this.chkTree, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, insets, 0, 0));
        this.pnlGenerate.add((Component)this.chkNavBar, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 18, 2, insets, 0, 0));
        this.setLayout(this.gbLayout);
        Insets insets2 = new Insets(0, 0, 0, 8);
        Insets insets3 = new Insets(0, 0, 0, 0);
        this.add(this.lblDir, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, insets2, 0, 0));
        this.add((Component)this.fldDir, new GridBagConstraints(1, -1, 2, 1, 1.0, 0.0, 17, 2, insets2, 0, 0));
        this.add(this.btnDir, new GridBagConstraints(3, -1, 1, 1, 0.0, 0.0, 17, 0, insets3, 0, 0));
        insets2.top = 5;
        insets3.top = 5;
        this.add(this.lblScope, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, insets2, 0, 0));
        this.add(this.cmbScope, new GridBagConstraints(1, -1, 3, 1, 0.0, 0.0, 17, 0, insets3, 10, 0));
        insets2.top = 10;
        insets3.top = 10;
        this.add(this.pnlTags, new GridBagConstraints(0, -1, 2, 1, 1.0, 0.0, 17, 1, insets2, 0, 0));
        this.add(this.pnlGenerate, new GridBagConstraints(2, -1, 2, 1, 1.0, 0.0, 17, 1, insets3, 0, 0));
        insets2.bottom = 2;
        this.add(this.lblMisc, new GridBagConstraints(0, -1, 4, 1, 0.0, 0.0, 17, 0, insets2, 0, 0));
        insets2.top = 0;
        this.add(this.fldMisc, new GridBagConstraints(0, -1, 4, 1, 0.0, 0.0, 18, 2, insets2, 0, 0));
        this.add(this.lblMiscExplanation, new GridBagConstraints(0, -1, 4, 1, 0.0, 1.0, 18, 2, insets, 0, 0));
    }

    public String getDataKey() {
        return JProjectJavadoc.DATA_KEY;
    }

    public String[] getPropertyKeys() {
        return PROPERTY_KEYS;
    }

    public void onProjectPanelEntry(TraversableContext traversableContext) {
        Project project = (Project)traversableContext.find("Project");
        JProjectJavadoc jProjectJavadoc = JavadocConfigPanel.getJProjectJavadoc(traversableContext, project);
        boolean bl = JavadocConfigPanel.isDefaultProject((Namespace)traversableContext);
        boolean bl2 = JavadocConfigPanel.editingUserProperties((Namespace)traversableContext);
        this.setHelpID(bl ? "f1_run_ppdefault_javadoc_html" : "f1_run_ppcustom_javadoc_html");
        this.loadFrom(jProjectJavadoc, project, bl, bl2);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        boolean bl = JavadocConfigPanel.isDefaultProject((Namespace)traversableContext);
        boolean bl2 = JavadocConfigPanel.editingUserProperties((Namespace)traversableContext);
        Project project = (Project)traversableContext.find("Project");
        JProjectJavadoc jProjectJavadoc = JavadocConfigPanel.getJProjectJavadoc(traversableContext, project);
        this.commitTo(jProjectJavadoc, bl, bl2);
    }

    private static JProjectJavadoc getJProjectJavadoc(TraversableContext traversableContext, Project project) {
        PropertyStorage propertyStorage = JavadocConfigPanel.getPropertyData((Namespace)traversableContext);
        return JProjectJavadoc.getInstance(propertyStorage, project.getURL());
    }

    private void loadFrom(JProjectJavadoc jProjectJavadoc, Project project, boolean bl, boolean bl2) {
        URL uRL = jProjectJavadoc.getOutputDirectory();
        if (uRL == null && !bl2) {
            URL uRL2 = URLFileSystem.getParent((URL)project.getURL());
            uRL = URLFactory.newDirURL((URL)uRL2, (String)"javadoc");
        }
        if (bl) {
            URL uRL3 = URLFileSystem.getParent((URL)Ide.getDefaultProject().getURL());
            this.fldDir.setBaseURL(uRL3);
        } else {
            this.fldDir.setBaseURL(null);
        }
        this.fldDir.setURL(uRL);
        this.btnDir.setVisible(bl ^ true);
        NonNullableComboBoxModel nonNullableComboBoxModel = new NonNullableComboBoxModel();
        nonNullableComboBoxModel.addElement((Object)PUBLIC_OPTION);
        nonNullableComboBoxModel.addElement((Object)PROTECTED_OPTION);
        nonNullableComboBoxModel.addElement((Object)PACKAGE_OPTION);
        nonNullableComboBoxModel.addElement((Object)PRIVATE_OPTION);
        this.cmbScope.setModel(nonNullableComboBoxModel);
        String string = jProjectJavadoc.getScope();
        if ("-public".equals(string)) {
            this.cmbScope.setSelectedItem(PUBLIC_OPTION);
        } else if ("-package".equals(string)) {
            this.cmbScope.setSelectedItem(PACKAGE_OPTION);
        } else if ("-private".equals(string)) {
            this.cmbScope.setSelectedItem(PRIVATE_OPTION);
        } else {
            this.cmbScope.setSelectedItem(PROTECTED_OPTION);
        }
        this.chkAuthor.setSelected(jProjectJavadoc.isGenerateAuthor());
        this.chkVersion.setSelected(jProjectJavadoc.isGenerateVersion());
        this.chkSince.setSelected(jProjectJavadoc.isGenerateSince());
        this.chkDeprecated.setSelected(jProjectJavadoc.isGenerateDeprecated());
        this.chkIndex.setSelected(jProjectJavadoc.isGenerateIndex());
        this.chkTree.setSelected(jProjectJavadoc.isGenerateTree());
        this.chkNavBar.setSelected(jProjectJavadoc.isGenerateNavbar());
        this.fldMisc.setText(jProjectJavadoc.getMiscOptions());
    }

    private void commitTo(JProjectJavadoc jProjectJavadoc, boolean bl, boolean bl2) throws TraversalException {
        URL uRL = this.fldDir.getURL();
        if (bl) {
            URL uRL2 = URLFileSystem.getParent((URL)Ide.getDefaultProject().getURL());
            if (uRL == null || URLFileSystem.toRelativeSpec((URL)uRL, (URL)uRL2, (boolean)true) == null) {
                throw new TraversalException(JProjectArb.format(135, JProjectArb.getString(136), this.fldDir.getText().trim()));
            }
        } else if (uRL == null) {
            String string = this.fldDir.getText().trim();
            if (ModelUtil.hasLength((String)string)) {
                String string2 = JProjectArb.format(145, string);
                throw new TraversalException(string2, JavadocArb.getString(34));
            }
            if (!bl2) {
                String string3 = JavadocArb.getString(35);
                throw new TraversalException(string3, JavadocArb.getString(34));
            }
        }
        if (ModelUtil.areDifferent((Object)jProjectJavadoc.getOutputDirectory(), (Object)uRL)) {
            jProjectJavadoc.setOutputDirectory(URLFileSystem.canonicalize((URL)uRL));
        }
        Object object = this.cmbScope.getSelectedItem();
        if (!jProjectJavadoc.getScope().equals(object)) {
            String string;
            if (PUBLIC_OPTION.equals(object)) {
                string = "-public";
            } else if (PROTECTED_OPTION.equals(object)) {
                string = "-protected";
            } else if (PACKAGE_OPTION.equals(object)) {
                string = "-package";
            } else if (PRIVATE_OPTION.equals(object)) {
                string = "-private";
            } else {
                throw new TraversalException(JavadocArb.format(33, object));
            }
            jProjectJavadoc.setScope(string);
        }
        jProjectJavadoc.setGenerateAuthor(this.chkAuthor.isSelected());
        jProjectJavadoc.setGenerateSince(this.chkSince.isSelected());
        jProjectJavadoc.setGenerateVersion(this.chkVersion.isSelected());
        jProjectJavadoc.setGenerateDeprecated(this.chkDeprecated.isSelected());
        jProjectJavadoc.setGenerateIndex(this.chkIndex.isSelected());
        jProjectJavadoc.setGenerateTree(this.chkTree.isSelected());
        jProjectJavadoc.setGenerateNavbar(this.chkNavBar.isSelected());
        jProjectJavadoc.setMiscOptions(this.fldMisc.getText());
    }
}

