/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.javadoc;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.resource.IdeIcons;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.javadoc.JavadocSettings;
import oracle.jdeveloper.javadoc.TagDescriptor;
import oracle.jdevimpl.javadoc.JavadocArb;

public class JavadocOptionsPanel
extends DefaultTraversablePanel {
    private JButton addButton;
    private JButton downButton;
    private JButton removeButton;
    private JButton upButton;
    private JCheckBox hasFieldScope;
    private JCheckBox hasMethodScope;
    private JCheckBox hasClassScope;
    private JCheckBox isRequired;
    private JLabel visLabel;
    private JLabel templateLabel;
    private JLabel listLabel;
    private JWrappedLabel previewLabel;
    private JLabel previewItemLabel;
    private JLabel usageLabel;
    private JLabel tagNameLabel;
    private JLabel tagPropertiesLabel;
    private JList tagList;
    private JScrollPane scroller;
    private JTextField templateText;
    private JTextField tagNameText;
    private TagDescriptor _selectedTD;
    private TagListModel _listModel;
    private boolean _listIsUpdating;
    private boolean _modelIsUpdating;

    public JavadocOptionsPanel() {
        this.setHelpID("f1_jed_javadoc_prefs_html");
        this.initializeComponent();
        this.addListeners();
    }

    public void onEntry(TraversableContext traversableContext) {
        JavadocSettings javadocSettings = this.findOptions(traversableContext);
        this.loadSettingsFrom(javadocSettings);
        this.tagList.setSelectedIndex(0);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        JavadocSettings javadocSettings = this.findOptions(traversableContext);
        this.saveSettingsTo(javadocSettings);
    }

    private JavadocSettings findOptions(TraversableContext traversableContext) {
        JavadocSettings javadocSettings = (JavadocSettings)traversableContext.find("JavadocSettings");
        return javadocSettings;
    }

    void loadSettingsFrom(JavadocSettings javadocSettings) {
        ArrayList arrayList = (ArrayList)javadocSettings.getTagList();
        this._listModel = new TagListModel(arrayList);
        this.tagList.setModel(this._listModel);
    }

    void saveSettingsTo(JavadocSettings javadocSettings) throws TraversalException {
        ListModel listModel = this.tagList.getModel();
        int n = listModel.getSize();
        ArrayList arrayList = new ArrayList(n);
        int n2 = 0;
        while (n2 < n) {
            arrayList.add(listModel.getElementAt(n2));
            ++n2;
        }
        javadocSettings.setTagList(arrayList);
    }

    private void addListeners() {
        InteractionListener interactionListener = new InteractionListener(null);
        this.tagList.addListSelectionListener(interactionListener);
        this.tagNameText.getDocument().addDocumentListener(interactionListener);
        this.templateText.getDocument().addDocumentListener(interactionListener);
        this.hasMethodScope.addItemListener(interactionListener);
        this.hasFieldScope.addItemListener(interactionListener);
        this.hasClassScope.addItemListener(interactionListener);
        this.isRequired.addItemListener(interactionListener);
        this.addButton.addActionListener(interactionListener);
        this.removeButton.addActionListener(interactionListener);
        this.upButton.addActionListener(interactionListener);
        this.downButton.addActionListener(interactionListener);
    }

    private void initializeComponent() {
        this.listLabel = new JLabel();
        this.tagList = new JList();
        this.tagList.setSelectionMode(0);
        ResourceUtils.resLabel((JLabel)this.listLabel, (Component)this.tagList, (String)JavadocArb.getString(44));
        this.scroller = new JScrollPane();
        this.scroller.getViewport().add(this.tagList);
        this.tagPropertiesLabel = new JLabel(JavadocArb.getString(45));
        this.tagNameLabel = new JLabel();
        this.tagNameText = new JTextField();
        ResourceUtils.resLabel((JLabel)this.tagNameLabel, (Component)this.tagNameText, (String)JavadocArb.getString(46));
        this.templateText = new JTextField();
        this.templateLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)this.templateLabel, (Component)this.templateText, (String)JavadocArb.getString(47));
        this.previewLabel = new JWrappedLabel();
        this.previewItemLabel = new JLabel(JavadocArb.getString(42));
        this.isRequired = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.isRequired, (String)JavadocArb.getString(51));
        this.usageLabel = new JLabel(JavadocArb.getString(43));
        this.hasMethodScope = new JCheckBox();
        this.hasFieldScope = new JCheckBox();
        this.hasClassScope = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.hasMethodScope, (String)JavadocArb.getString(49));
        ResourceUtils.resButton((AbstractButton)this.hasFieldScope, (String)JavadocArb.getString(48));
        ResourceUtils.resButton((AbstractButton)this.hasClassScope, (String)JavadocArb.getString(50));
        this.addButton = new JButton();
        ResourceUtils.resButton((AbstractButton)this.addButton, (String)JavadocArb.getString(52));
        this.removeButton = new JButton();
        ResourceUtils.resButton((AbstractButton)this.removeButton, (String)JavadocArb.getString(53));
        JavadocOptionsPanel.ensureSameWidth(new JButton[]{this.addButton, this.removeButton});
        this.upButton = JavadocOptionsPanel.createIconicButton(IdeIcons.getIcon((int)15), IdeIcons.getIcon((int)18), JavadocArb.getString(54));
        this.downButton = JavadocOptionsPanel.createIconicButton(IdeIcons.getIcon((int)16), IdeIcons.getIcon((int)17), JavadocArb.getString(55));
        JPanel jPanel = new JPanel(new GridBagLayout());
        Insets insets = new Insets(0, 0, 2, 0);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, -1, 3, 1, 0.0, 0.0, 17, 0, insets, 0, 0);
        jPanel.add((Component)this.listLabel, gridBagConstraints);
        insets = new Insets(0, 0, 5, 0);
        gridBagConstraints = new GridBagConstraints(0, -1, 2, 2, 1.0, 0.0, 10, 1, insets, 0, 0);
        jPanel.add((Component)this.scroller, gridBagConstraints);
        insets = new Insets(0, 0, 0, 0);
        gridBagConstraints = new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 13, 2, insets, 0, 0);
        jPanel.add((Component)this.addButton, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets.left = 8;
        jPanel.add((Component)this.removeButton, gridBagConstraints);
        insets = new Insets(0, 5, 5, 0);
        gridBagConstraints = new GridBagConstraints(2, -1, 1, 1, 0.0, 0.0, 11, 2, insets, 0, 0);
        jPanel.add((Component)this.upButton, gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 11;
        jPanel.add((Component)this.downButton, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        Border border = BorderFactory.createEmptyBorder(8, 8, 8, 8);
        jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), border));
        insets = new Insets(0, 0, 0, 0);
        gridBagConstraints = new GridBagConstraints(1, -1, 1, 1, 0.0, 0.0, 17, 2, insets, 0, 0);
        jPanel2.add((Component)this.tagNameLabel, gridBagConstraints);
        insets.left = 8;
        insets.right = 0;
        gridBagConstraints = new GridBagConstraints(2, -1, 1, 1, 0.0, 0.0, 17, 2, insets, 0, 0);
        jPanel2.add((Component)this.tagNameText, gridBagConstraints);
        insets.top = 8;
        insets.left = 0;
        gridBagConstraints = new GridBagConstraints(1, -1, 1, 1, 0.0, 0.0, 17, 2, insets, 0, 0);
        jPanel2.add((Component)this.usageLabel, gridBagConstraints);
        insets.left = 8;
        gridBagConstraints = new GridBagConstraints(2, -1, 0, 1, 0.0, 0.0, 17, 2, insets, 0, 0);
        jPanel2.add((Component)this.hasFieldScope, gridBagConstraints);
        insets.bottom = 0;
        insets.top = 0;
        jPanel2.add((Component)this.hasMethodScope, gridBagConstraints);
        jPanel2.add((Component)this.hasClassScope, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        jPanel2.add((Component)this.isRequired, gridBagConstraints);
        insets.top = 8;
        insets.left = 0;
        gridBagConstraints = new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 17, 2, insets, 0, 0);
        jPanel2.add((Component)this.templateLabel, gridBagConstraints);
        insets.left = 8;
        gridBagConstraints = new GridBagConstraints(2, -1, 1, 1, 0.0, 0.0, 17, 2, insets, 0, 0);
        jPanel2.add((Component)this.templateText, gridBagConstraints);
        insets.top = 8;
        insets.left = 0;
        gridBagConstraints = new GridBagConstraints(1, -1, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0);
        jPanel2.add((Component)this.previewItemLabel, gridBagConstraints);
        insets.top = 2;
        gridBagConstraints = new GridBagConstraints(1, -1, 2, 1, 1.0, 1.0, 17, 1, insets, 0, 0);
        jPanel2.add((Component)this.previewLabel, gridBagConstraints);
        JPanel jPanel3 = new JPanel(new BorderLayout(0, 2));
        jPanel3.add((Component)this.tagPropertiesLabel, "North");
        jPanel3.add((Component)jPanel2, "Center");
        this.setLayout(new BorderLayout(8, 8));
        this.add(jPanel, "West");
        this.add(jPanel3, "Center");
    }

    protected void updateNameAndTemplate() {
        String string = this.tagNameText.getText();
        if (!string.startsWith("@")) {
            string = "@" + string;
        }
        String string2 = this.templateText.getText();
        this._selectedTD.setName(string);
        this._selectedTD.setTemplate(string2);
        this.previewLabel.setText(string + " " + string2);
    }

    private static void ensureSameWidth(JButton[] jButtonArray) {
        if (jButtonArray.length < 2) {
            return;
        }
        Dimension dimension = jButtonArray[0].getPreferredSize();
        int n = dimension.width;
        int n2 = 1;
        while (n2 < jButtonArray.length) {
            n = Math.max(n, jButtonArray[n2].getPreferredSize().width);
            ++n2;
        }
        int n3 = 0;
        while (n3 < jButtonArray.length) {
            jButtonArray[n3].setPreferredSize(new Dimension(n, dimension.height));
            ++n3;
        }
    }

    private static JButton createIconicButton(Icon icon, Icon icon2, String string) {
        JButton jButton = new JButton();
        jButton.setIcon(icon);
        jButton.setDisabledIcon(icon2);
        jButton.getAccessibleContext().setAccessibleName(string);
        jButton.setEnabled(false);
        jButton.setMargin(new Insets(2, 0, 2, 0));
        return jButton;
    }

    static boolean ra$_modelIsUpdating(JavadocOptionsPanel javadocOptionsPanel) {
        return javadocOptionsPanel._modelIsUpdating;
    }

    static void wa$_listIsUpdating(JavadocOptionsPanel javadocOptionsPanel, boolean bl) {
        javadocOptionsPanel._listIsUpdating = bl;
    }

    static JList ra$tagList(JavadocOptionsPanel javadocOptionsPanel) {
        return javadocOptionsPanel.tagList;
    }

    static void wa$_selectedTD(JavadocOptionsPanel javadocOptionsPanel, TagDescriptor tagDescriptor) {
        javadocOptionsPanel._selectedTD = tagDescriptor;
    }

    static TagDescriptor ra$_selectedTD(JavadocOptionsPanel javadocOptionsPanel) {
        return javadocOptionsPanel._selectedTD;
    }

    static JTextField ra$tagNameText(JavadocOptionsPanel javadocOptionsPanel) {
        return javadocOptionsPanel.tagNameText;
    }

    static JTextField ra$templateText(JavadocOptionsPanel javadocOptionsPanel) {
        return javadocOptionsPanel.templateText;
    }

    static JCheckBox ra$hasFieldScope(JavadocOptionsPanel javadocOptionsPanel) {
        return javadocOptionsPanel.hasFieldScope;
    }

    static JCheckBox ra$hasMethodScope(JavadocOptionsPanel javadocOptionsPanel) {
        return javadocOptionsPanel.hasMethodScope;
    }

    static JCheckBox ra$hasClassScope(JavadocOptionsPanel javadocOptionsPanel) {
        return javadocOptionsPanel.hasClassScope;
    }

    static JCheckBox ra$isRequired(JavadocOptionsPanel javadocOptionsPanel) {
        return javadocOptionsPanel.isRequired;
    }

    static JButton ra$removeButton(JavadocOptionsPanel javadocOptionsPanel) {
        return javadocOptionsPanel.removeButton;
    }

    static JLabel ra$templateLabel(JavadocOptionsPanel javadocOptionsPanel) {
        return javadocOptionsPanel.templateLabel;
    }

    static JButton ra$upButton(JavadocOptionsPanel javadocOptionsPanel) {
        return javadocOptionsPanel.upButton;
    }

    static TagListModel ra$_listModel(JavadocOptionsPanel javadocOptionsPanel) {
        return javadocOptionsPanel._listModel;
    }

    static JButton ra$downButton(JavadocOptionsPanel javadocOptionsPanel) {
        return javadocOptionsPanel.downButton;
    }

    static boolean ra$_listIsUpdating(JavadocOptionsPanel javadocOptionsPanel) {
        return javadocOptionsPanel._listIsUpdating;
    }

    static JButton ra$addButton(JavadocOptionsPanel javadocOptionsPanel) {
        return javadocOptionsPanel.addButton;
    }

    static void wa$_modelIsUpdating(JavadocOptionsPanel javadocOptionsPanel, boolean bl) {
        javadocOptionsPanel._modelIsUpdating = bl;
    }

    private final class InteractionListener
    implements ListSelectionListener,
    ItemListener,
    DocumentListener,
    ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == JavadocOptionsPanel.ra$addButton(JavadocOptionsPanel.this)) {
                String string = JavadocArb.getString(56);
                TagDescriptor tagDescriptor = new TagDescriptor(string, 15, 1);
                JavadocOptionsPanel.wa$_modelIsUpdating(JavadocOptionsPanel.this, true);
                JavadocOptionsPanel.ra$_listModel(JavadocOptionsPanel.this).addElement(tagDescriptor);
                JavadocOptionsPanel.wa$_modelIsUpdating(JavadocOptionsPanel.this, false);
                JavadocOptionsPanel.ra$tagList(JavadocOptionsPanel.this).setSelectedValue(tagDescriptor, true);
                JavadocOptionsPanel.ra$tagNameText(JavadocOptionsPanel.this).requestFocus();
            } else if (object == JavadocOptionsPanel.ra$removeButton(JavadocOptionsPanel.this)) {
                int n = JavadocOptionsPanel.ra$tagList(JavadocOptionsPanel.this).getSelectedIndex();
                JavadocOptionsPanel.wa$_modelIsUpdating(JavadocOptionsPanel.this, true);
                JavadocOptionsPanel.ra$_listModel(JavadocOptionsPanel.this).removeElement(JavadocOptionsPanel.ra$tagList(JavadocOptionsPanel.this).getSelectedValue());
                JavadocOptionsPanel.wa$_modelIsUpdating(JavadocOptionsPanel.this, false);
                int n2 = JavadocOptionsPanel.ra$_listModel(JavadocOptionsPanel.this).getSize();
                if (n == 0 || n < n2) {
                    JavadocOptionsPanel.ra$tagList(JavadocOptionsPanel.this).setSelectedIndex(n);
                } else if (n >= n2) {
                    JavadocOptionsPanel.ra$tagList(JavadocOptionsPanel.this).setSelectedIndex(n2 - 1);
                }
            } else if (object == JavadocOptionsPanel.ra$upButton(JavadocOptionsPanel.this)) {
                TagDescriptor tagDescriptor = (TagDescriptor)JavadocOptionsPanel.ra$tagList(JavadocOptionsPanel.this).getSelectedValue();
                JavadocOptionsPanel.wa$_modelIsUpdating(JavadocOptionsPanel.this, true);
                JavadocOptionsPanel.ra$_listModel(JavadocOptionsPanel.this).moveUp(tagDescriptor);
                JavadocOptionsPanel.wa$_modelIsUpdating(JavadocOptionsPanel.this, false);
                JavadocOptionsPanel.ra$tagList(JavadocOptionsPanel.this).setSelectedIndex(JavadocOptionsPanel.ra$_listModel(JavadocOptionsPanel.this).indexOf(tagDescriptor));
            } else if (object == JavadocOptionsPanel.ra$downButton(JavadocOptionsPanel.this)) {
                TagDescriptor tagDescriptor = (TagDescriptor)JavadocOptionsPanel.ra$tagList(JavadocOptionsPanel.this).getSelectedValue();
                JavadocOptionsPanel.wa$_modelIsUpdating(JavadocOptionsPanel.this, true);
                JavadocOptionsPanel.ra$_listModel(JavadocOptionsPanel.this).moveDown(tagDescriptor);
                JavadocOptionsPanel.wa$_modelIsUpdating(JavadocOptionsPanel.this, false);
                JavadocOptionsPanel.ra$tagList(JavadocOptionsPanel.this).setSelectedIndex(JavadocOptionsPanel.ra$_listModel(JavadocOptionsPanel.this).indexOf(tagDescriptor));
            }
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.upateName(documentEvent);
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.upateName(documentEvent);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.upateName(documentEvent);
        }

        private void upateName(DocumentEvent documentEvent) {
            if (JavadocOptionsPanel.ra$_listIsUpdating(JavadocOptionsPanel.this)) {
                return;
            }
            JavadocOptionsPanel.this.updateNameAndTemplate();
            JavadocOptionsPanel.ra$tagList(JavadocOptionsPanel.this).setSelectedValue(JavadocOptionsPanel.ra$_selectedTD(JavadocOptionsPanel.this), true);
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (JavadocOptionsPanel.ra$_listIsUpdating(JavadocOptionsPanel.this)) {
                return;
            }
            JCheckBox jCheckBox = (JCheckBox)itemEvent.getSource();
            boolean bl = jCheckBox.isSelected();
            if (jCheckBox == JavadocOptionsPanel.ra$hasFieldScope(JavadocOptionsPanel.this)) {
                if (bl) {
                    JavadocOptionsPanel.ra$_selectedTD(JavadocOptionsPanel.this).setScope(2);
                } else {
                    JavadocOptionsPanel.ra$_selectedTD(JavadocOptionsPanel.this).unsetScope(2);
                }
            } else if (jCheckBox == JavadocOptionsPanel.ra$hasMethodScope(JavadocOptionsPanel.this)) {
                if (bl) {
                    JavadocOptionsPanel.ra$_selectedTD(JavadocOptionsPanel.this).setScope(4);
                    JavadocOptionsPanel.ra$_selectedTD(JavadocOptionsPanel.this).setScope(8);
                } else {
                    JavadocOptionsPanel.ra$_selectedTD(JavadocOptionsPanel.this).unsetScope(4);
                    JavadocOptionsPanel.ra$_selectedTD(JavadocOptionsPanel.this).unsetScope(8);
                }
            } else if (jCheckBox == JavadocOptionsPanel.ra$hasClassScope(JavadocOptionsPanel.this)) {
                if (bl) {
                    JavadocOptionsPanel.ra$_selectedTD(JavadocOptionsPanel.this).setScope(1);
                } else {
                    JavadocOptionsPanel.ra$_selectedTD(JavadocOptionsPanel.this).unsetScope(1);
                }
            } else if (jCheckBox == JavadocOptionsPanel.ra$isRequired(JavadocOptionsPanel.this)) {
                JavadocOptionsPanel.ra$_selectedTD(JavadocOptionsPanel.this).setRequired(bl);
            }
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting() || JavadocOptionsPanel.ra$_modelIsUpdating(JavadocOptionsPanel.this)) {
                return;
            }
            JavadocOptionsPanel.wa$_listIsUpdating(JavadocOptionsPanel.this, true);
            JavadocOptionsPanel.wa$_selectedTD(JavadocOptionsPanel.this, (TagDescriptor)JavadocOptionsPanel.ra$tagList(JavadocOptionsPanel.this).getSelectedValue());
            if (JavadocOptionsPanel.ra$_selectedTD(JavadocOptionsPanel.this) != null) {
                String string = JavadocOptionsPanel.ra$_selectedTD(JavadocOptionsPanel.this).getName();
                if (string.startsWith("@")) {
                    string = string.substring(1);
                }
                JavadocOptionsPanel.ra$tagNameText(JavadocOptionsPanel.this).setText(string);
                JavadocOptionsPanel.ra$templateText(JavadocOptionsPanel.this).setText(JavadocOptionsPanel.ra$_selectedTD(JavadocOptionsPanel.this).getTemplate());
                JavadocOptionsPanel.this.updateNameAndTemplate();
                JavadocOptionsPanel.ra$hasFieldScope(JavadocOptionsPanel.this).setSelected((JavadocOptionsPanel.ra$_selectedTD(JavadocOptionsPanel.this).getScope() & 2) > 0);
                JavadocOptionsPanel.ra$hasMethodScope(JavadocOptionsPanel.this).setSelected((JavadocOptionsPanel.ra$_selectedTD(JavadocOptionsPanel.this).getScope() & 4) > 0);
                JavadocOptionsPanel.ra$hasClassScope(JavadocOptionsPanel.this).setSelected((JavadocOptionsPanel.ra$_selectedTD(JavadocOptionsPanel.this).getScope() & 1) > 0);
                JavadocOptionsPanel.ra$isRequired(JavadocOptionsPanel.this).setSelected(JavadocOptionsPanel.ra$_selectedTD(JavadocOptionsPanel.this).isRequired());
                boolean bl = JavadocOptionsPanel.ra$_selectedTD(JavadocOptionsPanel.this).isCustom();
                JavadocOptionsPanel.ra$tagNameText(JavadocOptionsPanel.this).setEnabled(bl);
                JavadocOptionsPanel.ra$hasFieldScope(JavadocOptionsPanel.this).setEnabled(bl);
                JavadocOptionsPanel.ra$hasMethodScope(JavadocOptionsPanel.this).setEnabled(bl);
                JavadocOptionsPanel.ra$hasMethodScope(JavadocOptionsPanel.this).setEnabled(bl);
                JavadocOptionsPanel.ra$hasClassScope(JavadocOptionsPanel.this).setEnabled(bl);
                JavadocOptionsPanel.ra$removeButton(JavadocOptionsPanel.this).setEnabled(bl);
                bl = JavadocOptionsPanel.ra$_selectedTD(JavadocOptionsPanel.this).isCustom() || JavadocOptionsPanel.ra$_selectedTD(JavadocOptionsPanel.this).isAllowsTemplate();
                JavadocOptionsPanel.ra$templateText(JavadocOptionsPanel.this).setEnabled(bl);
                JavadocOptionsPanel.ra$templateLabel(JavadocOptionsPanel.this).setEnabled(bl);
            }
            JavadocOptionsPanel.ra$upButton(JavadocOptionsPanel.this).setEnabled(JavadocOptionsPanel.ra$_listModel(JavadocOptionsPanel.this).indexOf(JavadocOptionsPanel.ra$_selectedTD(JavadocOptionsPanel.this)) > 0);
            JavadocOptionsPanel.ra$downButton(JavadocOptionsPanel.this).setEnabled(JavadocOptionsPanel.ra$_listModel(JavadocOptionsPanel.this).indexOf(JavadocOptionsPanel.ra$_selectedTD(JavadocOptionsPanel.this)) < JavadocOptionsPanel.ra$_listModel(JavadocOptionsPanel.this).getSize() - 1);
            JavadocOptionsPanel.wa$_listIsUpdating(JavadocOptionsPanel.this, false);
        }

        private InteractionListener() {
        }

        InteractionListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private static final class TagListModel
    extends DefaultListModel {
        private ArrayList _dataList;

        TagListModel(List list) {
            this._dataList = (ArrayList)list;
        }

        public void add(int n, Object object) {
            this._dataList.add(n, object);
            this.fireIntervalAdded(this, n, n);
        }

        public void addElement(Object object) {
            int n = this._dataList.size();
            this.add(n, object);
        }

        public int indexOf(Object object) {
            return this._dataList.indexOf(object);
        }

        public void moveUp(Object object) {
            int n = this._dataList.indexOf(object);
            TagDescriptor tagDescriptor = (TagDescriptor)object;
            this.removeElement(tagDescriptor);
            this.add(--n, tagDescriptor);
        }

        public void moveDown(Object object) {
            int n = this._dataList.indexOf(object);
            TagDescriptor tagDescriptor = (TagDescriptor)object;
            if (this.removeElement(tagDescriptor)) {
                this.add(++n, tagDescriptor);
            }
        }

        public boolean removeElement(Object object) {
            int n = this._dataList.indexOf(object);
            if (n >= 0) {
                this.removeElementAt(n);
                return true;
            }
            return false;
        }

        public void removeElementAt(int n) {
            int n2 = this._dataList.size();
            if (n >= 0 && n <= n2) {
                this._dataList.remove(n);
                this.fireIntervalRemoved(this, n, n);
            }
        }

        public Object getElementAt(int n) {
            return this._dataList.get(n);
        }

        public int getSize() {
            return this._dataList.size();
        }
    }
}

