/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.javadoc.popup;

import java.awt.Component;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.util.HashMap;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import oracle.javatools.editor.ActionHookInvoker;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.editor.popup.PopupWindow;
import oracle.javatools.editor.popup.PopupWindowListener;
import oracle.javatools.editor.popup.PopupWindowManager;
import oracle.jdevimpl.javadoc.popup.JavadocPopupView;
import oracle.jdevimpl.javadoc.popup.PopupEventListener;

public class JavadocPopup
implements PopupWindowListener,
PopupEventListener,
EditorPlugin,
ChangeListener,
CaretListener,
ActionHookInvoker {
    private BasicEditorPane editor;
    private PopupWindow popup;
    private JavadocPopupView docPopupView;
    private HashMap commandMap;
    private static final String PLUGIN_KEY = JavadocPopup.class.getName();
    private static final int UP_COMMAND = 1;
    private static final int DOWN_COMMAND = 2;
    private static final int LEFT_COMMAND = 3;
    private static final int RIGHT_COMMAND = 4;
    private static final int PAGE_UP_COMMAND = 5;
    private static final int PAGE_DOWN_COMMAND = 6;
    private static final int BEGIN_COMMAND = 7;
    private static final int END_COMMAND = 8;
    private static final int CANCEL_COMMAND = 11;
    private static final int UNKNOWN_COMMAND = 0;

    public boolean invokeAction(String string) {
        if (this.docPopupView != null) {
            int n = this.lookupCommand(string);
            switch (n) {
                case 1: {
                    return this.up();
                }
                case 2: {
                    return this.down();
                }
                case 3: {
                    return this.left();
                }
                case 4: {
                    return this.right();
                }
                case 5: {
                    return this.pageUp();
                }
                case 6: {
                    return this.pageDown();
                }
                case 7: {
                    return this.home();
                }
                case 8: {
                    return this.end();
                }
                case 11: {
                    this.cancelPopup();
                    this.editor.requestFocus();
                    return false;
                }
            }
        }
        return false;
    }

    public void caretUpdate(CaretEvent caretEvent) {
        this.cancelPopup();
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.cancelPopup();
    }

    public void install(BasicEditorPane basicEditorPane) {
        this.editor = basicEditorPane;
        this.initializeCommands();
        basicEditorPane.putProperty(PLUGIN_KEY, (Object)this);
        basicEditorPane.addActionHookInvoker((ActionHookInvoker)this);
        basicEditorPane.addCaretListener((CaretListener)this);
    }

    public void deinstall(BasicEditorPane basicEditorPane) {
        this.cancelPopup();
        basicEditorPane.putProperty(PLUGIN_KEY, null);
        basicEditorPane.removeActionHookInvoker((ActionHookInvoker)this);
        basicEditorPane.removeCaretListener((CaretListener)this);
        this.editor = null;
        this.commandMap = null;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void popupClosed(PopupWindow popupWindow, int n) {
        JavadocPopup javadocPopup = this;
        synchronized (javadocPopup) {
            this.popup = null;
        }
    }

    public void editorFocusGained(PopupWindow popupWindow) {
    }

    public void editorFocusLost(PopupWindow popupWindow, boolean bl) {
        this.cancelPopup();
    }

    public void popupCanceled() {
        this.cancelPopup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contentsChanged() {
        JavadocPopup javadocPopup = this;
        synchronized (javadocPopup) {
            if (this.popup != null && this.docPopupView != null) {
                PopupWindowManager popupWindowManager = PopupWindowManager.getPopupWindowManager((BasicEditorPane)this.editor);
                popupWindowManager.changePopupContent(this.popup, (Component)this.docPopupView, false);
            }
        }
    }

    public void showPopup(JavadocPopupView javadocPopupView, Rectangle rectangle) {
        if (this.isPopupVisible()) {
            return;
        }
        PopupWindowManager popupWindowManager = PopupWindowManager.getPopupWindowManager((BasicEditorPane)this.editor);
        javadocPopupView.addPopupEventListener(this);
        this.docPopupView = javadocPopupView;
        this.popup = popupWindowManager.createPopup((Component)javadocPopupView, false);
        int[] nArray = new int[]{8, 4};
        popupWindowManager.positionPopup(this.popup, rectangle, nArray);
        popupWindowManager.showPopup(this.popup, (PopupWindowListener)this);
    }

    private static JavadocPopup lookupPlugin(BasicEditorPane basicEditorPane) {
        return (JavadocPopup)basicEditorPane.getProperty(PLUGIN_KEY);
    }

    static void invokePopup(BasicEditorPane basicEditorPane, JavadocPopupView javadocPopupView) {
        JavadocPopup javadocPopup = JavadocPopup.lookupPlugin(basicEditorPane);
        if (javadocPopup != null) {
            try {
                Rectangle rectangle = basicEditorPane.modelToView(basicEditorPane.getCaretPosition());
                javadocPopup.showPopup(javadocPopupView, rectangle);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelPopup() {
        JavadocPopup javadocPopup = this;
        synchronized (javadocPopup) {
            if (this.popup != null) {
                PopupWindowManager popupWindowManager = PopupWindowManager.getPopupWindowManager((BasicEditorPane)this.editor);
                popupWindowManager.dismissPopup(this.popup);
                this.popup = null;
                this.docPopupView.disposePopup();
                this.docPopupView = null;
            }
        }
    }

    private boolean up() {
        if (this.docPopupView != null) {
            return this.docPopupView.up();
        }
        return false;
    }

    private boolean down() {
        if (this.docPopupView != null) {
            return this.docPopupView.down();
        }
        return false;
    }

    private boolean left() {
        if (this.docPopupView != null) {
            return this.docPopupView.left();
        }
        return false;
    }

    private boolean right() {
        if (this.docPopupView != null) {
            return this.docPopupView.right();
        }
        return false;
    }

    private boolean home() {
        if (this.docPopupView != null) {
            return this.docPopupView.home();
        }
        return false;
    }

    private boolean end() {
        if (this.docPopupView != null) {
            return this.docPopupView.end();
        }
        return false;
    }

    private boolean pageUp() {
        if (this.docPopupView != null) {
            return this.docPopupView.pageUp();
        }
        return false;
    }

    private boolean pageDown() {
        if (this.docPopupView != null) {
            return this.docPopupView.pageDown();
        }
        return false;
    }

    private boolean isPopupVisible() {
        return this.popup != null;
    }

    protected int lookupCommand(String string) {
        Integer n = (Integer)this.commandMap.get(string);
        return n == null ? 0 : n;
    }

    private void initializeCommands() {
        if (this.commandMap == null) {
            this.commandMap = new HashMap();
            this.commandMap = new HashMap(9);
            Integer n = new Integer(1);
            this.commandMap.put("caret-up", n);
            this.commandMap.put("selection-up", n);
            Integer n2 = new Integer(2);
            this.commandMap.put("caret-down", n2);
            this.commandMap.put("selection-down", n2);
            Integer n3 = new Integer(3);
            this.commandMap.put("caret-backward", n3);
            this.commandMap.put("selection-backward", n3);
            Integer n4 = new Integer(4);
            this.commandMap.put("caret-forward", n4);
            this.commandMap.put("selection-forward", n4);
            Integer n5 = new Integer(5);
            this.commandMap.put("page-up", n5);
            this.commandMap.put("selection-page-up", n5);
            Integer n6 = new Integer(6);
            this.commandMap.put("page-down", n6);
            this.commandMap.put("selection-page-down", n6);
            Integer n7 = new Integer(7);
            this.commandMap.put("caret-begin", n7);
            this.commandMap.put("selection-begin", n7);
            this.commandMap.put("caret-begin-line", n7);
            this.commandMap.put("selection-begin-line", n7);
            Integer n8 = new Integer(8);
            this.commandMap.put("caret-end", n8);
            this.commandMap.put("selection-end", n8);
            this.commandMap.put("caret-end-line", n8);
            this.commandMap.put("selection-end-line", n8);
            Integer n9 = new Integer(11);
            this.commandMap.put("cancel", n9);
        }
    }
}

