/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.javadoc.popup;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.PanelUI;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.webbrowser.BrowserRunner;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaMember;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaVariable;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceMember;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.javatools.parser.java.v2.model.doc.SourceDocBlockTag;
import oracle.javatools.parser.java.v2.model.doc.SourceDocComment;
import oracle.javatools.parser.java.v2.model.doc.SourceDocDescription;
import oracle.javatools.parser.java.v2.model.doc.SourceDocElement;
import oracle.javatools.parser.java.v2.model.doc.SourceDocHasDescription;
import oracle.javatools.parser.java.v2.model.doc.SourceDocInlineTag;
import oracle.javatools.parser.java.v2.model.doc.SourceDocReference;
import oracle.javatools.parser.java.v2.model.doc.SourceDocTag;
import oracle.javatools.parser.java.v2.model.doc.SourceDocTextFragment;
import oracle.jdeveloper.help.JavadocUtil;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.javadoc.TagDescriptor;
import oracle.jdeveloper.javadoc.TagManager;
import oracle.jdevimpl.java.browse.JavaBrowseSupport2;
import oracle.jdevimpl.javadoc.JavadocArb;
import oracle.jdevimpl.javadoc.popup.PopupEventListener;

public class JavadocPopupView
extends JPanel {
    private static final String VAR_ARGS = "...";
    private static final String ARRAY = "[] ";
    private static final String SPACE = " ";
    private static final String COMMA = ",";
    private static final String OPEN_PAREN = "(";
    private static final String CLOSE_PAREN = ")";
    private static final String PARENS = "()";
    private static final String DASH = " - ";
    private static final String POUND = "#";
    private static final String NB_SPACE = "&nbsp;";
    private static final String THROWS = "throws ";
    private static final String EXTENDS = "extends ";
    private static final String IMPLEMENTS = "implements ";
    private static final String START_HREF = "<a href=\"";
    private static final String SPLIT_HREF = "\">";
    private static final String END_HREF = "</a>";
    private static final String HTTP = "http:";
    private static final String EMPTY_STRING = "";
    private static final String JOT_HREF = "jot_href";
    private static final String GOTO_JAVADOC_LINK = "goto_javadoc";
    private JButton _backButton;
    private JButton _nextButton;
    private JScrollPane _scrollPane;
    private JTextPane _textPane;
    private JToolBar _toolbar;
    private Context _context;
    private Stack _back = new Stack();
    private Stack _next = new Stack();
    private SourceMember _activeMember;
    private PopupEventListener _listener;
    private HashMap _history = new HashMap();
    private JavaManager _javaManager;
    private TagDescriptor[] _sortedTags = TagManager.getInstance().getAllTags();

    private JavadocPopupView() {
        this.initialize();
    }

    public JavadocPopupView(Context context, String string) {
        this();
        this._context = context;
        this.formatView(string);
    }

    public JavadocPopupView(Context context, SourceMember sourceMember) {
        this();
        this._javaManager = JavaManager.getJavaManager(context.getProject());
        this._context = context;
        this.setActiveMember(sourceMember);
        this.updateStack(sourceMember);
        this.formatView(sourceMember);
    }

    public void disposePopup() {
        this._back = null;
        this._next = null;
        this._activeMember = null;
        this._history = null;
        this._javaManager = null;
    }

    protected boolean up() {
        JViewport jViewport = this._scrollPane.getViewport();
        Rectangle rectangle = jViewport.getViewRect();
        int n = this._textPane.getScrollableUnitIncrement(rectangle, 1, -1);
        if (rectangle.y > 0) {
            int n2 = rectangle.y > n ? rectangle.y - n : 0;
            Point point = new Point(rectangle.x, n2);
            jViewport.setViewPosition(point);
        }
        return true;
    }

    protected boolean pageUp() {
        JViewport jViewport = this._scrollPane.getViewport();
        Dimension dimension = jViewport.getViewSize();
        Rectangle rectangle = jViewport.getViewRect();
        if (rectangle.y > 0 && dimension.height > rectangle.height) {
            int n = rectangle.y > rectangle.height ? rectangle.y - rectangle.height : 0;
            Point point = new Point(rectangle.x, n);
            jViewport.setViewPosition(point);
        }
        return true;
    }

    protected boolean down() {
        JViewport jViewport = this._scrollPane.getViewport();
        Dimension dimension = jViewport.getViewSize();
        Rectangle rectangle = jViewport.getViewRect();
        int n = this._textPane.getScrollableUnitIncrement(rectangle, 1, 1);
        if (dimension.height > rectangle.height && dimension.height - (rectangle.y + rectangle.height) > 0) {
            int n2 = rectangle.y + n < dimension.height ? rectangle.y + n : dimension.height - rectangle.height;
            Point point = new Point(rectangle.x, n2);
            jViewport.setViewPosition(point);
        }
        return true;
    }

    protected boolean pageDown() {
        JViewport jViewport = this._scrollPane.getViewport();
        Dimension dimension = jViewport.getViewSize();
        Rectangle rectangle = jViewport.getViewRect();
        if (dimension.height > rectangle.height && rectangle.y < dimension.height - rectangle.height) {
            int n = rectangle.y + rectangle.height < dimension.height ? rectangle.y + rectangle.height : dimension.height - rectangle.height;
            Point point = new Point(rectangle.x, n);
            jViewport.setViewPosition(point);
        }
        return true;
    }

    protected boolean home() {
        JViewport jViewport = this._scrollPane.getViewport();
        Rectangle rectangle = jViewport.getViewRect();
        if (rectangle.x > 0 || rectangle.y > 0) {
            Point point = new Point(0, 0);
            jViewport.setViewPosition(point);
        }
        return true;
    }

    protected boolean end() {
        JViewport jViewport = this._scrollPane.getViewport();
        Dimension dimension = jViewport.getViewSize();
        Rectangle rectangle = jViewport.getViewRect();
        if (rectangle.y + rectangle.height < dimension.height || rectangle.x + rectangle.width < dimension.width) {
            Point point = new Point(dimension.width - rectangle.width, dimension.height - rectangle.height);
            jViewport.setViewPosition(point);
        }
        return true;
    }

    protected boolean left() {
        JViewport jViewport = this._scrollPane.getViewport();
        Rectangle rectangle = jViewport.getViewRect();
        int n = this._textPane.getScrollableUnitIncrement(rectangle, 0, -1);
        if (rectangle.x > 0) {
            int n2 = rectangle.x > n ? rectangle.x - n : 0;
            Point point = new Point(n2, rectangle.y);
            jViewport.setViewPosition(point);
        }
        return true;
    }

    protected boolean right() {
        JViewport jViewport = this._scrollPane.getViewport();
        Dimension dimension = jViewport.getViewSize();
        Rectangle rectangle = jViewport.getViewRect();
        int n = this._textPane.getScrollableUnitIncrement(rectangle, 0, 1);
        if (dimension.width > rectangle.width && dimension.width - (rectangle.x + rectangle.width) > 0) {
            int n2 = rectangle.x + n < dimension.width ? rectangle.x + n : dimension.width - rectangle.width;
            Point point = new Point(n2, rectangle.y);
            jViewport.setViewPosition(point);
        }
        return true;
    }

    public void formatView(String string) {
        StringBuffer stringBuffer = new StringBuffer(5000);
        stringBuffer.append(this.body());
        stringBuffer.append(string);
        stringBuffer.append(this.bodyClose());
        this._textPane.setText(stringBuffer.toString());
        this._textPane.setCaretPosition(0);
        SwingUtilities.invokeLater(new 4());
    }

    public void formatView(SourceMember sourceMember) {
        Collection collection;
        JavaMethod[] javaMethodArray;
        String string;
        boolean bl = this._history.containsKey(sourceMember);
        if (bl) {
            this.formatView((String)this._history.get(sourceMember));
            return;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuffer stringBuffer = new StringBuffer(5000);
        if (sourceMember instanceof SourceMethod) {
            bl2 = true;
            this.addSignature(stringBuffer, (SourceMethod)sourceMember);
        } else if (sourceMember instanceof SourceVariable) {
            bl4 = true;
            this.addSignature(stringBuffer, (SourceFieldVariable)sourceMember);
        } else if (sourceMember instanceof SourceClass) {
            bl3 = true;
            this.addSignature(stringBuffer, (SourceClass)sourceMember);
        }
        SourceDocComment sourceDocComment = sourceMember.getDocComment();
        if (sourceDocComment != null && (string = this.getTagDescriptionText((SourceDocHasDescription)sourceDocComment)).length() > 0) {
            stringBuffer.append(string);
        }
        if (bl2 && (javaMethodArray = (collection = ((SourceMethod)sourceMember).getOverriddenMethods()).toArray(new JavaMethod[collection.size()])).length > 0) {
            JavaMethod javaMethod = javaMethodArray[0];
            JavaClass javaClass = javaMethod.getOwningClass();
            boolean bl5 = javaClass.isInterface();
            String string2 = bl5 ? JavadocArb.getString(81) : JavadocArb.getString(83);
            this.startDefintionList(stringBuffer, string2);
            String string3 = javaMethod.getName();
            String string4 = javaClass.getQualifiedName();
            String string5 = this.createJotLink(string4 + POUND + string3, string3);
            String string6 = this.createJotLink(string4, javaClass.getName());
            String string7 = bl5 ? JavadocArb.getString(82) : JavadocArb.getString(84);
            this.addToDefinitionList(stringBuffer, this.code(string5 + SPACE + string7 + SPACE + string6));
            this.endDefinitionList(stringBuffer);
        }
        if (sourceDocComment != null) {
            HashMap hashMap = this.groupTagsByType(sourceDocComment.getBlockTags().iterator());
            int n = 0;
            while (n < this._sortedTags.length) {
                List list;
                int n2;
                TagDescriptor tagDescriptor = this._sortedTags[n];
                String string8 = tagDescriptor.getName();
                if (hashMap.containsKey(string8) && (n2 = (list = (List)hashMap.get(string8)).size()) != 0) {
                    int n3 = tagDescriptor.getScope();
                    if (bl4 && (n3 & 2) > 0 || bl2 && (n3 & 4) > 0 || bl3 && (n3 & 1) > 0) {
                        SourceDocTag[] sourceDocTagArray = list.toArray(new SourceDocTag[n2]);
                        if ("@throws".equals(string8) || "@exception".equals(string8)) {
                            this.addThrowsComments(sourceMember, stringBuffer, sourceDocTagArray);
                        } else if ("@deprecated".equals(string8)) {
                            this.addDeprecatedComments(stringBuffer, sourceDocTagArray);
                        } else if ("@param".equals(string8)) {
                            this.addParamComments(stringBuffer, sourceDocTagArray);
                        } else if ("@return".equals(string8)) {
                            this.addReturnComments(stringBuffer, sourceDocTagArray);
                        } else if ("@see".equals(string8)) {
                            this.addSeeComments(stringBuffer, sourceDocTagArray);
                        } else if ("@since".equals(string8)) {
                            this.addOtherComments(stringBuffer, sourceDocTagArray);
                        }
                    }
                }
                ++n;
            }
        }
        String string9 = stringBuffer.toString();
        if (!bl) {
            this._history.put(sourceMember, string9);
        }
        this.formatView(string9);
    }

    static String createGotoJavadocLink(String string) {
        return "<a href=\"goto_javadoc\">" + string + END_HREF;
    }

    private void initialize() {
        this._textPane = new 3();
        this._textPane.setEditable(false);
        this._textPane.setDragEnabled(true);
        this._textPane.setFocusable(true);
        this._textPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this._textPane.setEditorKit(new JavadocViewerKit());
        this._scrollPane = new 2();
        this._scrollPane.getViewport().add(this._textPane);
        this._scrollPane.setVerticalScrollBarPolicy(20);
        this._scrollPane.setHorizontalScrollBarPolicy(30);
        this._scrollPane.setBorder(null);
        this._backButton = new JButton();
        this._backButton.setIcon(JavadocArb.getIcon(66));
        this._backButton.setEnabled(false);
        this._backButton.setDefaultCapable(false);
        this._nextButton = new JButton();
        this._nextButton.setIcon(JavadocArb.getIcon(67));
        this._nextButton.setEnabled(false);
        this._nextButton.setDefaultCapable(false);
        this._toolbar = new JToolBar();
        this._toolbar.setFloatable(false);
        this._toolbar.setRollover(true);
        this._toolbar.setVisible(false);
        this._toolbar.add(this._backButton);
        this._toolbar.add(this._nextButton);
        this.setBorder(UIManager.getBorder("ToolTip.border"));
        this.setLayout(new BorderLayout());
        this.add((Component)this._toolbar, "North");
        this.add((Component)this._scrollPane, "Center");
        ToolbarButtonListener toolbarButtonListener = new ToolbarButtonListener(null);
        this._backButton.addActionListener(toolbarButtonListener);
        this._nextButton.addActionListener(toolbarButtonListener);
        this.setupActionMap();
    }

    public void setUI(PanelUI panelUI) {
        super.setUI(panelUI);
        LookAndFeel.installColorsAndFont(this, "ToolTip.background", "ToolTip.foreground", "ToolTip.font");
    }

    private void setupActionMap() {
        InputMap inputMap = this._textPane.getInputMap(2);
        ActionMap actionMap = new ActionMap();
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
        1 var2_4 = new 1("cancel");
        inputMap.put(keyStroke, var2_4);
        actionMap.put(var2_4.toString(), var2_4);
    }

    private void setActiveMember(SourceMember sourceMember) {
        this._activeMember = sourceMember;
    }

    private HashMap groupTagsByType(Iterator iterator) {
        HashMap hashMap = new HashMap();
        while (iterator.hasNext()) {
            List<SourceDocTag> list;
            String string;
            SourceDocTag sourceDocTag = (SourceDocTag)iterator.next();
            String string2 = string = "@exception".equals(sourceDocTag.getName()) ? "@throws" : sourceDocTag.getName();
            if (hashMap.containsKey(string)) {
                list = (List)hashMap.get(string);
            } else {
                list = new ArrayList();
                hashMap.put(string, list);
            }
            list.add(sourceDocTag);
        }
        return hashMap;
    }

    private void addSignature(StringBuffer stringBuffer, SourceMethod sourceMethod) {
        JavaClass javaClass;
        SourceClass sourceClass = this.getOwningClass((SourceMember)sourceMethod);
        String string = sourceClass.getQualifiedName();
        String string2 = this.createJotLink(string, string);
        this.h3(stringBuffer, this.code(string2));
        stringBuffer.append(this.pre());
        int n = sourceMethod.getModifiers();
        n &= 0xFFFFFF7F;
        if (sourceClass.isInterface()) {
            n &= 0xFFFFFBFF;
        }
        String string3 = Modifier.toString(n) + SPACE;
        stringBuffer.append(string3);
        int n2 = string3.length();
        Object object = javaClass = sourceMethod.isConstructor() ? sourceMethod.getOwningClass() : sourceMethod.getReturnType();
        if (javaClass != null) {
            String string4 = this.getTextForType((JavaType)javaClass);
            stringBuffer.append(string4).append(SPACE);
            n2 += javaClass.getName().length() + 1;
        }
        int n3 = n2;
        if (!sourceMethod.isConstructor()) {
            String string5 = sourceMethod.getName();
            stringBuffer.append(this.b(string5));
            n2 += string5.length() + 1;
        }
        stringBuffer.append(OPEN_PAREN);
        Collection collection = sourceMethod.getParameters();
        int n4 = collection.size();
        int n5 = 1;
        for (JavaVariable javaVariable : collection) {
            String string6;
            String string7 = javaVariable.getName();
            JavaType javaType = javaVariable.getResolvedType();
            if (javaVariable.isVarargs()) {
                String string8 = javaType.getName();
                string8 = string8.substring(0, string8.length() - 2) + VAR_ARGS;
                JavaType javaType2 = javaType.getComponentType();
                string6 = javaType2.isPrimitive() ? string8 : this.createJotLink(javaType2.getQualifiedName(), string8);
            } else {
                string6 = javaType != null ? this.getTextForType(javaType) : javaVariable.getUnresolvedType().getSimplifiedName();
            }
            String string9 = string6 + SPACE + string7;
            stringBuffer.append(string9);
            if (n5 < n4) {
                stringBuffer.append(COMMA + this.br() + this.filler(n2));
            }
            ++n5;
        }
        stringBuffer.append(CLOSE_PAREN);
        Collection collection2 = sourceMethod.getExceptions();
        n5 = 1;
        int n6 = collection2.size();
        if (n6 > 0) {
            stringBuffer.append(this.br() + this.filler(n3) + THROWS);
        }
        for (JavaType javaType : collection2) {
            String string10 = javaType.getQualifiedName();
            String string11 = this.createJotLink(string10, string10);
            stringBuffer.append(n5 < n6 ? string11 + this.br() + this.filler(n3 + 7) : string11);
            ++n5;
        }
        stringBuffer.append(this.preClose());
    }

    private String getTextForType(JavaType javaType) {
        JavaType javaType2 = javaType.isArray() ? javaType.getComponentType() : javaType;
        if (javaType2.isPrimitive()) {
            return javaType.getName();
        }
        return this.createJotLink(javaType2.getTypeErasure().getQualifiedName(), javaType.getName());
    }

    private void addSignature(StringBuffer stringBuffer, SourceFieldVariable sourceFieldVariable) {
        SourceClass sourceClass = this.getOwningClass((SourceMember)sourceFieldVariable);
        String string = sourceClass.getQualifiedName();
        String string2 = this.createJotLink(string, string);
        this.h3(stringBuffer, this.code(string2));
        stringBuffer.append(this.pre());
        String string3 = Modifier.toString(sourceFieldVariable.getModifiers()) + SPACE;
        JavaType javaType = sourceFieldVariable.getSourceType().getResolvedType();
        String string4 = this.getTextForType(javaType);
        stringBuffer.append(string3 + string4 + SPACE);
        StringBuffer stringBuffer2 = new StringBuffer(50);
        List list = sourceFieldVariable.getOwningDeclaration().getVariables();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            if (stringBuffer2.length() > 0) {
                stringBuffer2.append(", ");
            }
            SourceVariable sourceVariable = (SourceVariable)iterator.next();
            stringBuffer2.append(sourceVariable.getName());
        }
        stringBuffer.append(this.b(stringBuffer2.toString()));
        stringBuffer.append(this.preClose());
    }

    private void addSignature(StringBuffer stringBuffer, SourceClass sourceClass) {
        String string = sourceClass.getPackageName();
        if (string != null && string.length() > 0) {
            this.h3(stringBuffer, string);
        }
        int n = sourceClass.getModifiers();
        if (sourceClass.isInterface()) {
            n &= 0xFFFFFBFF;
        }
        String string2 = Modifier.toString(n);
        String string3 = sourceClass.getResolvedType().getQualifiedName();
        if (string != null && string.length() > 0 && string3.startsWith(string)) {
            string3 = string3.substring(string.length() + 1);
        }
        this.pre(stringBuffer, string2 + SPACE + this.b(string3));
        JavaType javaType = sourceClass.getSuperclass();
        if (javaType != null) {
            String string4 = this.createJotLink(javaType.getQualifiedName(), javaType.getName());
            stringBuffer.append(this.dl());
            stringBuffer.append(this.dt());
            stringBuffer.append(this.code(EXTENDS + string4));
        }
        Collection collection = sourceClass.getInterfaces();
        int n2 = collection.size();
        int n3 = 1;
        if (n2 > 0) {
            if (javaType == null) {
                stringBuffer.append(this.dl());
            }
            stringBuffer.append(this.dt());
            stringBuffer.append(this.code());
            stringBuffer.append(IMPLEMENTS);
            for (JavaType javaType2 : collection) {
                String string5 = javaType2.getQualifiedName();
                String string6 = this.createJotLink(string5, string5);
                stringBuffer.append(n3 < n2 ? string6 + COMMA + SPACE : string6);
                ++n3;
            }
            stringBuffer.append(this.codeClose());
        }
        stringBuffer.append(this.dlClose());
    }

    private SourceClass getOwningClass(SourceMember sourceMember) {
        SourceMember sourceMember2 = sourceMember;
        while (sourceMember != null && !(sourceMember instanceof SourceClass)) {
            if (sourceMember2 instanceof SourceMember && sourceMember2 instanceof SourceClass) {
                return (SourceClass)sourceMember2;
            }
            sourceMember2 = sourceMember2.getParent();
        }
        return null;
    }

    private String filler(int n) {
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(NB_SPACE);
            ++n2;
        }
        return stringBuffer.toString();
    }

    private void addParamComments(StringBuffer stringBuffer, SourceDocTag[] sourceDocTagArray) {
        if (sourceDocTagArray.length == 0) {
            return;
        }
        boolean bl = false;
        int n = 0;
        while (n < sourceDocTagArray.length) {
            if (sourceDocTagArray[n].getDescription() != null) {
                bl = true;
                break;
            }
            ++n;
        }
        if (bl) {
            String string = JavadocArb.getString(74);
            this.startDefintionList(stringBuffer, string);
            int n2 = 0;
            while (n2 < sourceDocTagArray.length) {
                SourceDocTag sourceDocTag = sourceDocTagArray[n2];
                if (sourceDocTag.isParameter()) {
                    String string2 = this.code(sourceDocTag.getReferenceText());
                    String string3 = this.getTagDescriptionText((SourceDocHasDescription)sourceDocTag);
                    string2 = string2 + (string3.length() > 0 ? DASH + string3 : EMPTY_STRING);
                    this.addToDefinitionList(stringBuffer, string2);
                } else {
                    String string4 = sourceDocTag.getArgumentText();
                    this.addToDefinitionList(stringBuffer, string4);
                }
                ++n2;
            }
            this.endDefinitionList(stringBuffer);
        }
    }

    private void addReturnComments(StringBuffer stringBuffer, SourceDocTag[] sourceDocTagArray) {
        SourceDocTag sourceDocTag = sourceDocTagArray[0];
        String string = this.getTagDescriptionText((SourceDocHasDescription)sourceDocTag);
        if (string.length() > 0) {
            String string2 = JavadocArb.getString(75);
            this.startDefintionList(stringBuffer, string2);
            this.addToDefinitionList(stringBuffer, string);
            this.endDefinitionList(stringBuffer);
        }
    }

    private void addThrowsComments(SourceMember sourceMember, StringBuffer stringBuffer, SourceDocTag[] sourceDocTagArray) {
        if (sourceDocTagArray.length == 0) {
            return;
        }
        if (!(sourceMember instanceof SourceMethod)) {
            return;
        }
        Collection collection = ((SourceMethod)sourceMember).getExceptions();
        int n = collection.size();
        ArrayList<String> arrayList = new ArrayList<String>(n);
        boolean bl = false;
        if (n > 0) {
            String string = JavadocArb.getString(76);
            this.startDefintionList(stringBuffer, string);
            bl = true;
            for (JavaType javaType : collection) {
                String string2 = javaType.getQualifiedName();
                String string3 = javaType.getName();
                boolean bl2 = false;
                int n2 = 0;
                while (n2 < sourceDocTagArray.length) {
                    String string4 = sourceDocTagArray[n2].getReferenceText().trim();
                    boolean bl3 = bl2 = string3.equals(string4) || string3.endsWith(string4);
                    if (bl2) {
                        String string5;
                        arrayList.add(string4);
                        String string6 = this.createJotLink(string2, string3);
                        String string7 = this.code(string6);
                        String string8 = string5 = this.getTagDescriptionText((SourceDocHasDescription)sourceDocTagArray[n2]);
                        if (string8.length() > 0) {
                            string7 = string7 + DASH + string8;
                        }
                        this.addToDefinitionList(stringBuffer, string7);
                        break;
                    }
                    ++n2;
                }
                if (bl2) continue;
                String string9 = this.createJotLink(string2, string3);
                this.addToDefinitionList(stringBuffer, this.code(string9));
            }
        }
        if (sourceDocTagArray.length > arrayList.size()) {
            int n3 = 0;
            while (n3 < sourceDocTagArray.length) {
                if (sourceDocTagArray[n3].isException()) {
                    String string;
                    if (!bl) {
                        String string10 = JavadocArb.getString(76);
                        this.startDefintionList(stringBuffer, string10);
                        bl = true;
                    }
                    if ((string = sourceDocTagArray[n3].getReferenceText()) != null && !arrayList.contains(string)) {
                        String string11 = this.createReferenceForTag(sourceDocTagArray[n3]);
                        String string12 = this.code(string11);
                        String string13 = this.getTagDescriptionText((SourceDocHasDescription)sourceDocTagArray[n3]);
                        if (string13.length() > 0) {
                            StringBuffer stringBuffer2 = new StringBuffer(string12);
                            stringBuffer2.append(DASH).append(string13);
                            this.addToDefinitionList(stringBuffer, stringBuffer2.toString());
                        } else {
                            this.addToDefinitionList(stringBuffer, string12);
                        }
                    }
                }
                ++n3;
            }
        }
        this.endDefinitionList(stringBuffer);
    }

    private void addSeeComments(StringBuffer stringBuffer, SourceDocTag[] sourceDocTagArray) {
        String string = JavadocArb.getString(78);
        this.startDefintionList(stringBuffer, string);
        StringBuffer stringBuffer2 = new StringBuffer(50);
        stringBuffer2.append(this.dd());
        int n = sourceDocTagArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = this.createSeeLink(sourceDocTagArray[n2]);
            if (n2 < n - 1) {
                stringBuffer2.append(string2 + ", ");
            } else {
                stringBuffer2.append(string2);
            }
            ++n2;
        }
        stringBuffer.append(stringBuffer2);
        this.endDefinitionList(stringBuffer);
    }

    private void addOtherComments(StringBuffer stringBuffer, SourceDocTag[] sourceDocTagArray) {
        StringBuffer stringBuffer2 = new StringBuffer();
        int n = 0;
        while (n < sourceDocTagArray.length) {
            String string = this.getTagDescriptionText((SourceDocHasDescription)sourceDocTagArray[n]);
            if (string.length() > 0) {
                if (stringBuffer2.length() > 0) {
                    stringBuffer2.append(", ");
                }
                stringBuffer2.append(string.trim());
            }
            ++n;
        }
        if (stringBuffer2.length() > 0) {
            String string = sourceDocTagArray[0].getName();
            String string2 = string.substring(1) + ":";
            if ("@version".equals(string)) {
                string2 = JavadocArb.getString(80);
            } else if ("@since".equals(string)) {
                string2 = JavadocArb.getString(79);
            }
            this.startDefintionList(stringBuffer, string2);
            this.addToDefinitionList(stringBuffer, stringBuffer2.toString());
            this.endDefinitionList(stringBuffer);
        }
    }

    private void addDeprecatedComments(StringBuffer stringBuffer, SourceDocTag[] sourceDocTagArray) {
        StringBuffer stringBuffer2 = new StringBuffer(this.b(JavadocArb.getString(77)));
        stringBuffer2.append(SPACE).append(this.getTagDescriptionText((SourceDocHasDescription)sourceDocTagArray[0]));
        this.p(stringBuffer, stringBuffer2.toString());
    }

    private String getTagDescriptionText(SourceDocHasDescription sourceDocHasDescription) {
        SourceDocDescription sourceDocDescription = sourceDocHasDescription.getDescription();
        if (sourceDocDescription == null) {
            return EMPTY_STRING;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (Object e : sourceDocDescription.getChildren()) {
            if (e instanceof SourceDocInlineTag) {
                SourceDocInlineTag sourceDocInlineTag = (SourceDocInlineTag)e;
                if (sourceDocInlineTag.isReference()) {
                    String string = this.createReferenceForTag((SourceDocTag)sourceDocInlineTag);
                    stringBuffer.append(string);
                    continue;
                }
                if ("@inheritDoc".equals(sourceDocInlineTag.getName())) {
                    String string = this.getInheritedComment((SourceDocElement)sourceDocHasDescription);
                    if (string.length() <= 0) continue;
                    stringBuffer.append(string);
                    continue;
                }
                String string = this.getTagDescriptionText((SourceDocHasDescription)sourceDocInlineTag);
                if (string.length() == 0) {
                    string = sourceDocInlineTag.getArgumentText();
                }
                stringBuffer.append(string);
                continue;
            }
            SourceDocTextFragment sourceDocTextFragment = (SourceDocTextFragment)e;
            stringBuffer.append(sourceDocTextFragment.getDocText());
        }
        String string = stringBuffer.toString().trim();
        return string.length() == 0 ? string : SPACE + string + SPACE;
    }

    private String getInheritedComment(SourceDocElement sourceDocElement) {
        SourceMember sourceMember = sourceDocElement.getOwningMember();
        if (!(sourceMember instanceof SourceMethod)) {
            return EMPTY_STRING;
        }
        SourceMethod sourceMethod = (SourceMethod)sourceMember;
        for (JavaMethod javaMethod : sourceMethod.getOverriddenMethods()) {
            SourceDocBlockTag sourceDocBlockTag;
            String string;
            SourceDocComment sourceDocComment;
            SourceElement sourceElement = javaMethod.getSourceElement();
            if (sourceElement == null || (sourceDocComment = ((SourceMethod)sourceElement).getDocComment()) == null) continue;
            if (sourceDocElement instanceof SourceDocComment) {
                return this.getTagDescriptionText((SourceDocHasDescription)sourceDocComment);
            }
            if (!(sourceDocElement instanceof SourceDocTag)) continue;
            SourceDocTag sourceDocTag = (SourceDocTag)sourceDocElement;
            if ("@return".equals(sourceDocTag.getName())) {
                Collection collection = sourceDocComment.findTags("@return");
                if (collection.size() <= 0) continue;
                SourceDocTag[] sourceDocTagArray = collection.toArray(new SourceDocTag[collection.size()]);
                return this.getTagDescriptionText((SourceDocHasDescription)sourceDocTagArray[0]);
            }
            if (sourceDocTag.isException()) {
                SourceDocBlockTag sourceDocBlockTag2;
                String string2;
                SourceDocReference sourceDocReference = sourceDocTag.getReference();
                String string3 = string2 = sourceDocReference != null ? sourceDocReference.getClassName() : sourceDocTag.getReferenceText();
                if (string2 == null) {
                    string2 = sourceDocTag.getReferenceText();
                }
                if ((sourceDocBlockTag2 = sourceDocComment.findExceptionTag(string2)) == null) continue;
                return this.getTagDescriptionText((SourceDocHasDescription)sourceDocBlockTag2);
            }
            if (!sourceDocTag.isParameter()) continue;
            SourceDocReference sourceDocReference = sourceDocTag.getReference();
            String string4 = string = sourceDocReference != null ? sourceDocReference.getParameterName() : sourceDocTag.getReferenceText();
            if (string == null) {
                string = sourceDocTag.getReferenceText();
            }
            if ((sourceDocBlockTag = sourceDocComment.findParameterTag(string)) == null) continue;
            return this.getTagDescriptionText((SourceDocHasDescription)sourceDocBlockTag);
        }
        return EMPTY_STRING;
    }

    private String createReferenceForTag(SourceDocTag sourceDocTag) {
        String string;
        StringBuffer stringBuffer = new StringBuffer(100);
        SourceDocReference sourceDocReference = sourceDocTag.getReference();
        if (sourceDocReference != null) {
            String string2 = this.determineLinkTarget(sourceDocTag);
            if (string2 == null) {
                string = this.error(sourceDocTag.getText());
            } else {
                SourceDocDescription sourceDocDescription;
                String string3 = sourceDocTag.isException() ? sourceDocTag.getReferenceText() : ((sourceDocDescription = sourceDocTag.getDescription()) != null ? sourceDocDescription.getDocText() : sourceDocTag.getArgumentText());
                String string4 = string3.startsWith(POUND) ? string3.substring(1) : string3.replace('#', '.');
                string = this.createJotLink(string2, string4);
            }
        } else {
            String string5 = this.getTagDescriptionText((SourceDocHasDescription)sourceDocTag);
            if (string5.length() == 0) {
                string5 = sourceDocTag.getArgumentText();
            }
            string = string5;
        }
        stringBuffer.append(SPACE).append(string).append(SPACE);
        return stringBuffer.toString();
    }

    private String determineLinkTarget(SourceDocTag sourceDocTag) {
        String string = null;
        String string2 = null;
        SourceDocReference sourceDocReference = sourceDocTag.getReference();
        if (sourceDocReference != null) {
            string2 = sourceDocReference.getMemberName();
            JavaHasType javaHasType = sourceDocReference.getResolvedObject();
            if (javaHasType instanceof JavaMember) {
                JavaMember javaMember = (JavaMember)javaHasType;
                if (3 == javaHasType.getElementKind()) {
                    string = javaMember.getResolvedType().getQualifiedName();
                } else {
                    SourceElement sourceElement = javaMember.getSourceElement();
                    if (sourceElement != null) {
                        string = ((JavaMember)sourceElement).getOwningClass().getQualifiedName();
                    }
                }
            }
        }
        if (string != null) {
            if (string2 == null) {
                return string;
            }
            Collection collection = sourceDocReference.getMethodParameterTypeNames();
            int n = collection.size();
            if (n > 0) {
                int n2 = 1;
                StringBuffer stringBuffer = new StringBuffer(50);
                stringBuffer.append(OPEN_PAREN);
                for (String string3 : collection) {
                    stringBuffer.append(string3.endsWith(ARRAY) ? string3.substring(0, string3.length() - 2) : string3);
                    if (n2++ >= n) continue;
                    stringBuffer.append(", ");
                }
                stringBuffer.append(CLOSE_PAREN);
                string2 = string2 + stringBuffer.toString();
            } else if (sourceDocTag.getDocText().indexOf(40) != -1) {
                string2 = string2 + PARENS;
            }
            return string + POUND + string2;
        }
        return null;
    }

    private String createSeeLink(SourceDocTag sourceDocTag) {
        String string;
        SourceDocReference sourceDocReference = sourceDocTag.getReference();
        if (sourceDocReference != null && (string = this.determineLinkTarget(sourceDocTag)) != null) {
            String string2;
            int n = string.indexOf(35);
            if (n == -1) {
                String string3 = this.getShortName(string);
                String string4 = this.createJotLink(string, string3);
                return this.code(string4);
            }
            String string5 = EMPTY_STRING;
            SourceDocDescription sourceDocDescription = sourceDocTag.getDescription();
            if (sourceDocDescription != null) {
                string5 = sourceDocTag.getDescription().getText().trim();
            }
            String string6 = string5.length() > 0 ? string5 : ((string2 = sourceDocTag.getArgumentText()).startsWith(POUND) ? string2.substring(1) : string2.replaceAll(POUND, "."));
            String string7 = this.createJotLink(string, string6);
            return this.code(string7);
        }
        return this.error(this.code(sourceDocTag.getArgumentText()));
    }

    private String createJotLink(String string, String string2) {
        return "<a href=\"jot_href" + string + SPLIT_HREF + string2.trim() + END_HREF;
    }

    private String getShortName(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return string;
        }
        return string.substring(++n);
    }

    private void startDefintionList(StringBuffer stringBuffer, String string) {
        stringBuffer.append(this.dl());
        this.dt(stringBuffer, this.b(string));
    }

    private void addToDefinitionList(StringBuffer stringBuffer, String string) {
        stringBuffer.append(this.dd());
        stringBuffer.append(string);
    }

    private void endDefinitionList(StringBuffer stringBuffer) {
        stringBuffer.append(this.dlClose());
    }

    private void h3(StringBuffer stringBuffer, String string) {
        stringBuffer.append(this.h3());
        stringBuffer.append(string);
        stringBuffer.append(this.h3Close());
    }

    private void p(StringBuffer stringBuffer, String string) {
        stringBuffer.append(this.p());
        stringBuffer.append(string);
        stringBuffer.append(this.pClose());
    }

    private void pre(StringBuffer stringBuffer, String string) {
        stringBuffer.append(this.pre());
        stringBuffer.append(string);
        stringBuffer.append(this.preClose());
    }

    private void code(StringBuffer stringBuffer, String string) {
        stringBuffer.append(this.code());
        stringBuffer.append(string);
        stringBuffer.append(this.codeClose());
    }

    private void dt(StringBuffer stringBuffer, String string) {
        stringBuffer.append(this.dt());
        stringBuffer.append(string);
        stringBuffer.append(this.dtClose());
    }

    private void dd(StringBuffer stringBuffer, String string) {
        stringBuffer.append(this.dd());
        stringBuffer.append(string);
        stringBuffer.append(this.ddClose());
    }

    private void dl(StringBuffer stringBuffer, String string) {
        stringBuffer.append(this.dl());
        stringBuffer.append(string);
        stringBuffer.append(this.dlClose());
    }

    private String br() {
        return "<br>";
    }

    private String code() {
        return "<code>";
    }

    private String codeClose() {
        return "</code>";
    }

    private String code(String string) {
        return this.code() + string + this.codeClose();
    }

    private String error() {
        return "<font color = \"red\">";
    }

    private String errorClose() {
        return "</font>";
    }

    private String error(String string) {
        return this.error() + string + this.errorClose();
    }

    private String b() {
        return "<b>";
    }

    private String bClose() {
        return "</b>";
    }

    private String b(String string) {
        return this.b() + string + this.bClose();
    }

    private String i() {
        return "<i>";
    }

    private String iClose() {
        return "</i>";
    }

    private String i(String string) {
        return this.i() + string + this.iClose();
    }

    private String pre() {
        return "<pre>";
    }

    private String preClose() {
        return "</pre>";
    }

    private String p() {
        return "<p>";
    }

    private String pClose() {
        return "</p>";
    }

    private String h3() {
        return "<h3>";
    }

    private String h3Close() {
        return "</h3>";
    }

    private String dl() {
        return "<dl>";
    }

    private String dlClose() {
        return "</dl>";
    }

    private String dd() {
        return "<dd>";
    }

    private String ddClose() {
        return "</dd>";
    }

    private String dt() {
        return "<dt>";
    }

    private String dtClose() {
        return "</dt>";
    }

    private String body() {
        return "<body>";
    }

    private String bodyClose() {
        return "</body>";
    }

    private String getHREF(int n, JEditorPane jEditorPane) {
        HTMLDocument hTMLDocument;
        Element element;
        AttributeSet attributeSet;
        AttributeSet attributeSet2;
        Document document = jEditorPane.getDocument();
        if (document instanceof HTMLDocument && (attributeSet2 = (AttributeSet)(attributeSet = (element = (hTMLDocument = (HTMLDocument)document).getCharacterElement(n)).getAttributes()).getAttribute(HTML.Tag.A)) != null) {
            return (String)attributeSet2.getAttribute(HTML.Attribute.HREF);
        }
        return null;
    }

    private SourceMember resolveJotReference(String string) {
        String string2;
        String string3;
        int n = string.indexOf(35);
        if (n >= 0) {
            String[] stringArray = string.split(POUND);
            string3 = stringArray[0];
            string2 = stringArray[1];
        } else {
            string3 = string;
            string2 = null;
        }
        SourceClass sourceClass = this._javaManager.getSourceClass(string3);
        if (sourceClass != null) {
            String string4;
            if (string2 == null) {
                return sourceClass;
            }
            int n2 = string2.indexOf(OPEN_PAREN);
            boolean bl = n2 != -1;
            String string5 = string4 = bl ? string2.substring(0, n2) : string2;
            if (string3.endsWith("." + string4)) {
                String string6 = n2 != -1 ? string2.substring(n2 + 1) : EMPTY_STRING;
                String[] stringArray = this.getParameterTypes(string6);
                List list = sourceClass.getSourceConstructors();
                SourceMethod[] sourceMethodArray = list.toArray(new SourceMethod[list.size()]);
                SourceMethod sourceMethod = this.getMatchingMethod(sourceMethodArray, stringArray, bl);
                if (sourceMethod != null) {
                    return sourceMethod;
                }
            }
            String string7 = n2 != -1 ? string2.substring(n2 + 1) : EMPTY_STRING;
            String[] stringArray = this.getParameterTypes(string7);
            Collection collection = sourceClass.getSourceMethods(string4);
            SourceMethod[] sourceMethodArray = collection.toArray(new SourceMethod[collection.size()]);
            SourceMethod sourceMethod = this.getMatchingMethod(sourceMethodArray, stringArray, bl);
            if (sourceMethod != null) {
                return sourceMethod;
            }
            SourceFieldVariable sourceFieldVariable = sourceClass.getSourceFieldVariable(string2);
            if (sourceFieldVariable != null) {
                return sourceFieldVariable;
            }
        }
        return null;
    }

    private SourceMethod getMatchingMethod(SourceMethod[] sourceMethodArray, String[] stringArray, boolean bl) {
        int n = 0;
        while (n < sourceMethodArray.length) {
            SourceVariable[] sourceVariableArray;
            SourceMethod sourceMethod = sourceMethodArray[n];
            List list = sourceMethod.getSourceParameters();
            if (stringArray.length == list.size() && this.matches(sourceVariableArray = list.toArray(new SourceVariable[list.size()]), stringArray)) {
                return sourceMethod;
            }
            ++n;
        }
        if (stringArray.length == 0) {
            return sourceMethodArray.length > 0 ? sourceMethodArray[0] : null;
        }
        return null;
    }

    private boolean matches(SourceVariable[] sourceVariableArray, String[] stringArray) {
        int n = 0;
        while (n < sourceVariableArray.length) {
            String string = stringArray[n];
            JavaType javaType = sourceVariableArray[n].getSourceType().getResolvedType();
            if (javaType == null) {
                return false;
            }
            String string2 = javaType.getTypeErasure().getQualifiedName();
            if (!string2.equals(string) && !string2.endsWith("." + string)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private String[] getParameterTypes(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "(,)", false);
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextElement().toString().trim();
            if (string2.length() <= 0) continue;
            arrayList.add(string2);
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    private void updateStack(SourceMember sourceMember) {
        if (!(this._activeMember == null || this._activeMember.equals(sourceMember) || !this._back.empty() && this._activeMember.equals((SourceMember)this._back.peek()))) {
            this._toolbar.setVisible(true);
            this._back.push(this._activeMember);
        } else {
            this._toolbar.setVisible(false);
        }
        if (sourceMember != null) {
            this.setActiveMember(sourceMember);
            this._next.clear();
        }
        this._backButton.setEnabled(this._back.empty() ^ true);
        this._nextButton.setEnabled(sourceMember != null && !this._next.empty());
    }

    public void addPopupEventListener(PopupEventListener popupEventListener) {
        if (popupEventListener != null) {
            this._listener = popupEventListener;
        }
    }

    public void removePopupEventListener(PopupEventListener popupEventListener) {
        if (popupEventListener != null && popupEventListener.equals(this._listener)) {
            this._listener = null;
        }
    }

    private void notifyCanceled() {
        if (this._listener != null) {
            this._listener.popupCanceled();
        }
    }

    private void notifyContentsChanged() {
        if (this._listener != null) {
            this._listener.contentsChanged();
        }
    }

    static void mav$notifyContentsChanged(JavadocPopupView javadocPopupView) {
        javadocPopupView.notifyContentsChanged();
    }

    static void mav$notifyCanceled(JavadocPopupView javadocPopupView) {
        javadocPopupView.notifyCanceled();
    }

    static void mav$updateStack(JavadocPopupView javadocPopupView, SourceMember sourceMember) {
        javadocPopupView.updateStack(sourceMember);
    }

    static JTextPane ra$_textPane(JavadocPopupView javadocPopupView) {
        return javadocPopupView._textPane;
    }

    static SourceMember ra$_activeMember(JavadocPopupView javadocPopupView) {
        return javadocPopupView._activeMember;
    }

    static Context ra$_context(JavadocPopupView javadocPopupView) {
        return javadocPopupView._context;
    }

    static String mav$getHREF(JavadocPopupView javadocPopupView, int n, JEditorPane jEditorPane) {
        return javadocPopupView.getHREF(n, jEditorPane);
    }

    static SourceMember mav$resolveJotReference(JavadocPopupView javadocPopupView, String string) {
        return javadocPopupView.resolveJotReference(string);
    }

    static JButton ra$_backButton(JavadocPopupView javadocPopupView) {
        return javadocPopupView._backButton;
    }

    static Stack ra$_back(JavadocPopupView javadocPopupView) {
        return javadocPopupView._back;
    }

    static Stack ra$_next(JavadocPopupView javadocPopupView) {
        return javadocPopupView._next;
    }

    static void mav$setActiveMember(JavadocPopupView javadocPopupView, SourceMember sourceMember) {
        javadocPopupView.setActiveMember(sourceMember);
    }

    static JButton ra$_nextButton(JavadocPopupView javadocPopupView) {
        return javadocPopupView._nextButton;
    }

    public final class 4
    implements Runnable {
        public void run() {
            JavadocPopupView.mav$notifyContentsChanged(JavadocPopupView.this);
        }
    }

    public final class 3
    extends JTextPane {
        public Dimension getPreferredScrollableViewportSize() {
            Dimension dimension = super.getPreferredScrollableViewportSize();
            dimension.height = Math.min(300, dimension.height);
            return dimension;
        }

        public boolean isValidateRoot() {
            return false;
        }
    }

    public final class 2
    extends JScrollPane {
        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            dimension.width = 530;
            return dimension;
        }

        public boolean isValidateRoot() {
            return false;
        }
    }

    public final class 1
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            JavadocPopupView.mav$notifyCanceled(JavadocPopupView.this);
        }

        public 1(String string) {
            super(string);
        }
    }

    public class JavadocViewerKit
    extends HTMLEditorKit {
        private JEditorPane editor;
        private LinkController linkHandler;

        void $init$() {
            this.linkHandler = new LinkController();
        }

        public void install(JEditorPane jEditorPane) {
            jEditorPane.addMouseListener(this.linkHandler);
            super.install(jEditorPane);
            this.editor = jEditorPane;
        }

        public JavadocViewerKit() {
            this.$init$();
        }

        public class LinkController
        extends HTMLEditorKit.LinkController {
            public void mouseClicked(MouseEvent mouseEvent) {
                String string;
                Point point;
                int n;
                if (mouseEvent.getButton() != 1) {
                    return;
                }
                JEditorPane jEditorPane = (JEditorPane)mouseEvent.getSource();
                if (!jEditorPane.isEditable() && (n = jEditorPane.viewToModel(point = new Point(mouseEvent.getX(), mouseEvent.getY()))) >= 0 && (string = JavadocPopupView.mav$getHREF(JavadocPopupView.this, n, jEditorPane)) != null) {
                    if (string.startsWith(JavadocPopupView.JOT_HREF)) {
                        String string2 = string.substring(JavadocPopupView.JOT_HREF.length());
                        SourceMember sourceMember = JavadocPopupView.mav$resolveJotReference(JavadocPopupView.this, string2);
                        if (sourceMember != null) {
                            this.activateJavadocLink(sourceMember);
                        } else {
                            JavadocPopupView.mav$updateStack(JavadocPopupView.this, null);
                            JavadocPopupView.this.formatView(JavadocArb.format(69, string2));
                        }
                    } else if (JavadocPopupView.GOTO_JAVADOC_LINK.equals(string)) {
                        try {
                            JavadocPopupView.ra$_textPane(JavadocPopupView.this).setCursor(Cursor.getPredefinedCursor(3));
                            CodeEditor codeEditor = (CodeEditor)JavadocPopupView.ra$_context(JavadocPopupView.this).getView();
                            int n2 = codeEditor.getCaretPosition();
                            JavaBrowseSupport2.performBrowseDocAtOffset(JavadocPopupView.ra$_context(JavadocPopupView.this), n2);
                        }
                        catch (Exception exception) {
                            JavadocPopupView.ra$_textPane(JavadocPopupView.this).setCursor(Cursor.getPredefinedCursor(0));
                        }
                    } else {
                        this.activateExternalLink(string);
                    }
                }
                jEditorPane.getParent().requestFocus();
            }

            private void activateExternalLink(String string) {
                block9: {
                    try {
                        try {
                            JavadocPopupView.ra$_textPane(JavadocPopupView.this).setCursor(Cursor.getPredefinedCursor(3));
                            if (string.toLowerCase().startsWith(JavadocPopupView.HTTP)) {
                                BrowserRunner.getBrowserRunner().runBrowserOnURL(new URL(string), null, null);
                                break block9;
                            }
                            if (string.startsWith(JavadocPopupView.POUND)) {
                                String string2 = JavadocPopupView.ra$_activeMember(JavadocPopupView.this).getEnclosingClass().getQualifiedName();
                                URL uRL = JavadocUtil.resolveJavadocURL(JavadocPopupView.ra$_context(JavadocPopupView.this), string2);
                                if (uRL != null && uRL.getRef() != null) {
                                    String string3 = uRL.toString();
                                    int n = string3.lastIndexOf(JavadocPopupView.POUND);
                                    if (n >= 0) {
                                        string3 = string3.substring(n + 1) + string;
                                    }
                                    BrowserRunner.getBrowserRunner().runBrowserOnURL(new URL(string3), null, null);
                                }
                                break block9;
                            }
                            URL uRL = new URL(string);
                            BrowserRunner.getBrowserRunner().runBrowserOnURL(uRL, null, null);
                        }
                        catch (MalformedURLException malformedURLException) {
                            MessageDialog.error((Component)Ide.getMainWindow(), (Object)JavadocArb.format(68, string), (String)JavadocArb.getString(73), null);
                        }
                    }
                    finally {
                        JavadocPopupView.ra$_textPane(JavadocPopupView.this).setCursor(Cursor.getPredefinedCursor(0));
                    }
                }
            }

            private void activateJavadocLink(SourceMember sourceMember) {
                JavadocPopupView.mav$updateStack(JavadocPopupView.this, sourceMember);
                JavadocPopupView.this.formatView(sourceMember);
            }
        }
    }

    private class ToolbarButtonListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == JavadocPopupView.ra$_backButton(JavadocPopupView.this)) {
                if (JavadocPopupView.ra$_back(JavadocPopupView.this).peek().equals(JavadocPopupView.ra$_activeMember(JavadocPopupView.this))) {
                    JavadocPopupView.ra$_back(JavadocPopupView.this).pop();
                } else {
                    JavadocPopupView.ra$_next(JavadocPopupView.this).push(JavadocPopupView.ra$_activeMember(JavadocPopupView.this));
                    JavadocPopupView.mav$setActiveMember(JavadocPopupView.this, (SourceMember)JavadocPopupView.ra$_back(JavadocPopupView.this).pop());
                }
                JavadocPopupView.this.formatView(JavadocPopupView.ra$_activeMember(JavadocPopupView.this));
            } else if (object == JavadocPopupView.ra$_nextButton(JavadocPopupView.this)) {
                JavadocPopupView.ra$_back(JavadocPopupView.this).push(JavadocPopupView.ra$_activeMember(JavadocPopupView.this));
                JavadocPopupView.mav$setActiveMember(JavadocPopupView.this, (SourceMember)JavadocPopupView.ra$_next(JavadocPopupView.this).pop());
                JavadocPopupView.this.formatView(JavadocPopupView.ra$_activeMember(JavadocPopupView.this));
            }
            JavadocPopupView.ra$_backButton(JavadocPopupView.this).setEnabled(JavadocPopupView.ra$_back(JavadocPopupView.this).empty() ^ true);
            JavadocPopupView.ra$_nextButton(JavadocPopupView.this).setEnabled(JavadocPopupView.ra$_next(JavadocPopupView.this).empty() ^ true);
        }

        private ToolbarButtonListener() {
        }

        ToolbarButtonListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

