/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.jsr198.editor;

import java.awt.Component;
import java.util.prefs.Preferences;
import javax.ide.command.Context;
import javax.ide.command.Controller;
import javax.ide.editor.TextEditor;
import javax.ide.view.GUIPanel;
import javax.ide.view.View;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.editor.Editor;
import oracle.ideimpl.jsr198.editor.EditorAdapter;
import oracle.ideimpl.jsr198.model.ContextFactory;
import oracle.ideimpl.jsr198.view.ViewAdapter;

public class CodeEditorAdapter
extends TextEditor {
    private final CodeEditor _editor;

    public CodeEditorAdapter(CodeEditor codeEditor) {
        this._editor = codeEditor;
    }

    public final Editor getOracleEditor() {
        return this._editor;
    }

    public void open(Context context) {
    }

    public void close() {
    }

    public void restore(Preferences preferences) {
    }

    public void save(Preferences preferences) {
    }

    public GUIPanel getGUI() {
        Component component = this.getOracleEditor().getGUI();
        return new GUIPanel((Object)component, null);
    }

    public Context getContext() {
        oracle.ide.Context context = this.getOracleEditor().getContext();
        return ContextFactory.createJsrContext((oracle.ide.Context)context);
    }

    public void activate() {
        this.getOracleEditor().activate();
    }

    public void deactivate() {
        this.getOracleEditor().deactivate();
    }

    public Controller getController() {
        return null;
    }

    public View parent() {
        oracle.ide.view.View view = this.getOracleEditor().owner();
        if (view == null) {
            return null;
        }
        if (view instanceof Editor) {
            return new EditorAdapter((Editor)view);
        }
        return new ViewAdapter(view);
    }

    public String getID() {
        return this.getOracleEditor().getClass().getName();
    }

    public boolean isVisible() {
        return this.getOracleEditor().isVisible();
    }

    public void setVisible(boolean bl) {
        throw new UnsupportedOperationException();
    }

    public String getLabel() {
        return this.getOracleEditor().getDisplayName();
    }

    public int getCaretPosition() {
        return this._editor.getCaretPosition();
    }

    public void setCaretPosition(int n) {
        this._editor.setCaretPosition(n);
    }

    public void setCaretPosition(int n, int n2) {
        int n3 = this._editor.getLineStartOffset(n + 1);
        this._editor.setCaretPosition(n3 + n2 - 1);
    }

    public int getCaretColumn() {
        int n = this.getCaretPosition();
        int n2 = this._editor.getLineStartOffset(this._editor.getLineFromOffset(n));
        return n - n2 + 1;
    }

    public int getCaretLine() {
        return this._editor.getLineFromOffset(this.getCaretPosition()) - 1;
    }

    public int getSelectionStart() {
        return this._editor.getSelectionStart();
    }

    public int getSelectionLength() {
        return this._editor.getSelectionEnd() - this._editor.getSelectionStart();
    }

    public void setSelection(int n, int n2) {
        this._editor.setSelectionStart(n);
        this._editor.setSelectionEnd(n + n2);
    }
}

