/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.jsr198.java;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.WeakHashMap;
import javax.ide.model.java.JavaModel;
import javax.ide.model.java.declaration.ClassD;
import javax.ide.model.java.declaration.Declaration;
import javax.ide.model.java.declaration.PackageD;
import javax.ide.model.java.declaration.TypeD;
import javax.ide.model.java.source.tree.FileT;
import javax.ide.model.java.source.tree.Tree;
import javax.ide.model.java.source.write.MultiTreeTransaction;
import javax.ide.model.java.source.write.SingleTreeTransaction;
import javax.ide.model.java.source.write.TreeManager;
import javax.ide.net.URIFactory;
import javax.ide.net.URIPath;
import javax.swing.undo.UndoableEdit;
import oracle.ide.model.Project;
import oracle.ide.net.URLPath;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaPackage;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaTypeVariable;
import oracle.javatools.parser.java.v2.model.JavaWildcardType;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceInvokeExpression;
import oracle.javatools.parser.java.v2.write.SourceTransaction;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdevimpl.jsr198.java.ClassDImpl;
import oracle.jdevimpl.jsr198.java.ConstructorDImpl;
import oracle.jdevimpl.jsr198.java.DeclarationImpl;
import oracle.jdevimpl.jsr198.java.FieldDImpl;
import oracle.jdevimpl.jsr198.java.MethodDImpl;
import oracle.jdevimpl.jsr198.java.PackageDImpl;
import oracle.jdevimpl.jsr198.java.TypeVariableDImpl;
import oracle.jdevimpl.jsr198.java.WildcardTypeDImpl;
import oracle.jdevimpl.jsr198.java.tree.TreeAdapter;
import oracle.jdevimpl.jsr198.java.tree.TreeImpl;

public class JavaModelImpl
implements JavaConstants,
JavaModel {
    private final IdentityHashMap elementToDeclMap;
    private static final WeakHashMap transactionMap = new WeakHashMap();
    private final JavaManager manager;
    private final TreeAdapter treeAdapter;

    public static JavaModelImpl getJavaModelImpl(Project project) {
        JavaManager javaManager = JavaManager.getJavaManager(project);
        return new JavaModelImpl(javaManager);
    }

    public static JavaModelImpl getJavaModelImpl(URIPath uRIPath, URIPath uRIPath2) {
        JavaManager javaManager = JavaManager.getJavaManager(JavaModelImpl.uripathToUrlpath(uRIPath), JavaModelImpl.uripathToUrlpath(uRIPath2));
        return new JavaModelImpl(javaManager);
    }

    public static URIPath getJdkClasspath() {
        String string = System.getProperty("java.home.override");
        if (string == null) {
            string = System.getProperty("java.home");
        }
        if (string == null) {
            throw new NullPointerException();
        }
        File file = new File(string + "/lib/rt.jar");
        if (!file.exists()) {
            file = new File(string + "/jre/lib/rt.jar");
        }
        URIPath uRIPath = new URIPath();
        if (file.exists()) {
            uRIPath.add(URIFactory.newJarURI((File)file, null));
        }
        return uRIPath;
    }

    public static URIPath getJdkSourcepath() {
        String string = System.getProperty("java.home.override");
        if (string == null) {
            string = System.getProperty("java.home");
        }
        if (string == null) {
            throw new NullPointerException();
        }
        URIPath uRIPath = new URIPath();
        File file = new File(string + "/src.zip");
        if (file.exists()) {
            uRIPath.add(URIFactory.newJarURI((File)file, null));
        }
        return uRIPath;
    }

    public static JavaModelImpl getJavaModelImpl() {
        return JavaModelImpl.getJavaModelImpl(JavaModelImpl.getJdkSourcepath(), JavaModelImpl.getJdkClasspath());
    }

    void $init$() {
        this.elementToDeclMap = new IdentityHashMap();
    }

    private JavaModelImpl(JavaManager javaManager) {
        this.$init$();
        this.manager = javaManager;
        this.treeAdapter = new TreeAdapter(this);
    }

    final DeclarationImpl elementToDecl(JavaElement javaElement) {
        if (javaElement == null) {
            return null;
        }
        DeclarationImpl declarationImpl = (DeclarationImpl)this.elementToDeclMap.get(javaElement);
        if (declarationImpl != null) {
            return declarationImpl;
        }
        DeclarationImpl declarationImpl2 = this.createDecl(javaElement);
        this.elementToDeclMap.put(javaElement, declarationImpl2);
        return declarationImpl2;
    }

    private DeclarationImpl createDecl(JavaElement javaElement) {
        int n = javaElement.getElementKind();
        switch (n) {
            case 3: {
                return new ClassDImpl((JavaClass)javaElement, this);
            }
            case 10: {
                return new TypeVariableDImpl((JavaTypeVariable)javaElement, this);
            }
            case 11: {
                return new WildcardTypeDImpl((JavaWildcardType)javaElement, this);
            }
            case 9: {
                return new PackageDImpl((JavaPackage)javaElement, this);
            }
            case 5: {
                return new FieldDImpl((JavaField)javaElement, this);
            }
            case 8: {
                JavaMethod javaMethod = (JavaMethod)javaElement;
                if (javaMethod.isConstructor()) {
                    return new ConstructorDImpl(javaMethod, this);
                }
                return new MethodDImpl(javaMethod, this);
            }
        }
        return null;
    }

    public ClassD getClass(String string) {
        return (ClassD)this.elementToDecl((JavaElement)this.manager.getClass(string));
    }

    public PackageD getPackage(String string) {
        return (PackageD)this.elementToDecl((JavaElement)this.manager.getPackage(string));
    }

    public TypeD getArrayType(TypeD typeD, int n) {
        JavaType javaType = (JavaType)JavaModelImpl.declToElement((DeclarationImpl)typeD);
        return (TypeD)this.elementToDecl((JavaElement)this.manager.getArrayType(javaType, n));
    }

    public ClassD getClass(JavaClass javaClass) {
        return (ClassD)this.elementToDecl((JavaElement)javaClass);
    }

    public TypeD getType(JavaType javaType) {
        return (TypeD)this.elementToDecl((JavaElement)javaType);
    }

    public Object getValue(Object object) {
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            int n = objectArray.length;
            Object[] objectArray2 = new Object[n];
            int n2 = 0;
            while (n2 < n) {
                objectArray2[n2] = this.getValue(objectArray[n2]);
                ++n2;
            }
            return objectArray2;
        }
        if (object instanceof JavaElement) {
            return this.elementToDecl((JavaElement)object);
        }
        return object;
    }

    public Declaration getResolvedDeclaration(Tree tree) {
        JavaElement javaElement;
        TreeImpl treeImpl = (TreeImpl)tree;
        SourceElement sourceElement = this.treeAdapter.treeToSym(treeImpl);
        int n = sourceElement.getSymbolKind();
        if (47 <= n && n < 63) {
            switch (n) {
                case 54: 
                case 56: {
                    SourceInvokeExpression sourceInvokeExpression = (SourceInvokeExpression)sourceElement;
                    javaElement = sourceInvokeExpression.getResolvedMethod();
                    break;
                }
                default: {
                    SourceExpression sourceExpression = (SourceExpression)sourceElement;
                    javaElement = sourceExpression.getResolvedObject();
                    break;
                }
            }
        } else {
            javaElement = sourceElement.getCompiledObject();
        }
        return this.elementToDecl(javaElement);
    }

    public TypeD getResolvedType(Tree tree) {
        JavaHasType javaHasType;
        JavaType javaType;
        TreeImpl treeImpl = (TreeImpl)tree;
        SourceElement sourceElement = this.treeAdapter.treeToSym(treeImpl);
        if (sourceElement instanceof JavaHasType && (javaType = (javaHasType = (JavaHasType)sourceElement).getResolvedType()) != null) {
            return this.getType(javaType);
        }
        return null;
    }

    public Collection getResolvedDeclarations(FileT fileT) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public Collection getResolvedTypes(FileT fileT) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public FileT getSourceFile(String string) {
        TextBuffer textBuffer = TextBufferFactory.createTextBuffer();
        textBuffer.insert(0, string.toCharArray());
        SourceFile sourceFile = this.manager.getSourceFile(textBuffer);
        return (FileT)this.treeAdapter.symToTree((SourceElement)sourceFile);
    }

    public FileT getSourceFile(URI uRI) {
        URL uRL = JavaModelImpl.uriToUrl(uRI);
        SourceFile sourceFile = this.manager.getSourceFile(uRL);
        return (FileT)this.treeAdapter.symToTree((SourceElement)sourceFile);
    }

    public FileT createSourceFile(URI uRI) throws IOException {
        URL uRL = JavaModelImpl.uriToUrl(uRI);
        SourceFile sourceFile = this.manager.createSourceFile(uRL);
        return (FileT)this.treeAdapter.symToTree((SourceElement)sourceFile);
    }

    public void cloneSourceFile(FileT fileT, FileT fileT2) {
        SourceFile sourceFile = (SourceFile)this.treeAdapter.treeToSym((Tree)fileT);
        SourceFile sourceFile2 = (SourceFile)this.treeAdapter.treeToSym((Tree)fileT2);
        List list = sourceFile2.getChildren();
        list.clear();
        for (SourceElement sourceElement : sourceFile.getChildren()) {
            SourceElement sourceElement2 = sourceElement.cloneSelf(sourceFile2);
            TreeImpl treeImpl = this.treeAdapter.symToTree(sourceElement2);
            list.add(sourceElement2);
        }
    }

    public FileT getAnonymousFile() {
        SourceFile sourceFile = SourceFactory.createFile((int)3);
        sourceFile.beginTransaction();
        return (FileT)this.treeAdapter.symToTree((SourceElement)sourceFile);
    }

    public MultiTreeTransaction beginMultiTransaction() {
        CommonUtilities.unsupported();
        return null;
    }

    public MultiTreeTransaction getMultiTransaction() {
        CommonUtilities.unsupported();
        return null;
    }

    public Tree getTree(Declaration declaration) {
        JavaElement javaElement = JavaModelImpl.declToElement(declaration);
        if (javaElement == null) {
            return null;
        }
        SourceElement sourceElement = javaElement.getSourceElement();
        if (sourceElement == null) {
            return null;
        }
        return this.treeAdapter.symToTree(sourceElement);
    }

    public SingleTreeTransaction beginTransaction(FileT fileT) {
        if (fileT == null) {
            return null;
        }
        SourceFile sourceFile = (SourceFile)this.treeAdapter.treeToSym((Tree)fileT);
        SourceTransaction sourceTransaction = sourceFile.beginTransaction();
        SingleTreeTransactionImpl singleTreeTransactionImpl = new SingleTreeTransactionImpl(sourceTransaction);
        transactionMap.put(sourceTransaction, singleTreeTransactionImpl);
        return singleTreeTransactionImpl;
    }

    public SingleTreeTransaction getTransaction(SourceTransaction sourceTransaction) {
        return (SingleTreeTransaction)transactionMap.get(sourceTransaction);
    }

    private static URL uriToUrl(URI uRI) {
        try {
            URL uRL = uRI.toURL();
            return uRL;
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    private static URLPath uripathToUrlpath(URIPath uRIPath) {
        URI[] uRIArray = uRIPath.getEntries();
        URLPath uRLPath = new URLPath();
        int n = uRIArray.length;
        int n2 = 0;
        while (n2 < n) {
            try {
                URL uRL = uRIArray[n2].toURL();
                if (uRL != null) {
                    uRLPath.add(uRL);
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            ++n2;
        }
        return uRLPath;
    }

    public static JavaElement declToElement(Declaration declaration) {
        return JavaModelImpl.declToElement((DeclarationImpl)declaration);
    }

    private static JavaElement declToElement(DeclarationImpl declarationImpl) {
        if (declarationImpl != null) {
            return declarationImpl.getJavaElement();
        }
        return null;
    }

    protected class SingleTreeTransactionImpl
    implements SingleTreeTransaction {
        private final SourceTransaction thing;

        protected SingleTreeTransactionImpl(SourceTransaction sourceTransaction) {
            this.thing = sourceTransaction;
        }

        public FileT getFile() {
            SourceFile sourceFile = this.thing.getOwningSourceFile();
            return (FileT)JavaModelImpl.this.elementToDecl((JavaElement)sourceFile);
        }

        public void abort() {
            this.thing.abort();
        }

        public UndoableEdit commit() {
            return this.thing.commit();
        }

        public TreeManager getOwningManager() {
            return JavaModelImpl.this;
        }
    }

    protected class CollectionOfThings
    extends AbstractCollection {
        private final Collection things;

        protected CollectionOfThings(Collection collection) {
            this.things = collection;
        }

        public int size() {
            return this.things.size();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public boolean isEmpty() {
            return this.things.isEmpty();
        }

        public boolean add(Object object) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(Object object) {
            throw new UnsupportedOperationException();
        }

        public boolean containsAll(Collection collection) {
            return false;
        }

        public Iterator iterator() {
            return new IteratorOfThings(this.things.iterator());
        }
    }

    protected class IteratorOfThings
    implements Iterator {
        private final Iterator things;

        protected IteratorOfThings(Iterator iterator) {
            this.things = iterator;
        }

        public boolean hasNext() {
            return this.things.hasNext();
        }

        public Object next() {
            JavaType javaType = (JavaType)this.things.next();
            return JavaModelImpl.this.elementToDecl((JavaElement)javaType);
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

