/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.jsr198.model;

import java.net.URI;
import java.util.Collection;
import javax.ide.extension.ElementName;
import javax.ide.model.Document;
import javax.ide.model.java.JavaSource;
import javax.ide.model.spi.DocumentHook;
import javax.ide.model.spi.SuffixRecognizer;
import javax.ide.model.spi.XMLRootElementRecognizer;
import javax.ide.model.xml.XMLDocument;
import oracle.bali.xml.addin.XMLSourceNode;
import oracle.ide.model.Node;
import oracle.ide.xml.XMLRecognizer;
import oracle.ideimpl.jsr198.model.OracleDocumentFactory;
import oracle.jdeveloper.model.JavaSourceNode;
import oracle.jdevimpl.jsr198.model.CustomXMLNode;

public final class JDeveloperDocumentFactory
extends OracleDocumentFactory {
    protected Document convert(URI uRI, Node node) {
        if (node == null) {
            return null;
        }
        JavaSource javaSource = null;
        if (node instanceof JavaSourceNode) {
            javaSource = new JavaSource();
        } else if (node instanceof XMLSourceNode) {
            javaSource = new XMLDocument();
        }
        if (javaSource == null) {
            return super.convert(uRI, node);
        }
        javaSource.setURI(uRI);
        return javaSource;
    }

    protected Class getOracleNodeClassFor(String string) {
        if (JavaSource.class.getName().equals(string)) {
            return JavaSourceNode.class;
        }
        if (XMLDocument.class.getName().equals(string)) {
            return XMLSourceNode.class;
        }
        return super.getOracleNodeClassFor(string);
    }

    protected Class getCustomNodeClassFor(Class clazz) {
        if (XMLDocument.class.isAssignableFrom(clazz)) {
            return CustomXMLNode.class;
        }
        return super.getCustomNodeClassFor(clazz);
    }

    protected void registerDocumentTypes(DocumentHook documentHook) {
        super.registerDocumentTypes(documentHook);
        Collection collection = documentHook.getXMLRecognizers();
        for (SuffixRecognizer suffixRecognizer : collection) {
            Collection collection2 = suffixRecognizer.getSuffixes();
            for (String string : collection2) {
                XMLRecognizer.treatExtensionAsXML((String)string);
            }
            if (!(suffixRecognizer instanceof XMLRootElementRecognizer)) continue;
            XMLRootElementRecognizer xMLRootElementRecognizer = (XMLRootElementRecognizer)suffixRecognizer;
            for (ElementName elementName : xMLRootElementRecognizer.getRootElements()) {
                if (elementName.getNamespaceURI() == null) {
                    XMLRecognizer.mapRootElementToClass((String)elementName.getLocalName(), CustomXMLNode.class);
                    continue;
                }
                XMLRecognizer.mapNamespaceElemToClass((String)elementName.getNamespaceURI(), (String)elementName.getLocalName(), CustomXMLNode.class);
            }
        }
    }
}

