/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.jsr198.model;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import javax.ide.model.spi.XMLDocumentImpl;
import javax.ide.model.xml.XMLModel;
import javax.ide.net.VirtualFileSystem;
import javax.swing.undo.UndoableEdit;
import oracle.bali.xml.addin.XMLSourceNode;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.XmlModel;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ideimpl.jsr198.model.TextNodeBridge;
import org.w3c.dom.Document;

public class XMLSourceNodeBridge
extends TextNodeBridge
implements XMLDocumentImpl {
    public XMLSourceNodeBridge(URI uRI) {
        super(uRI);
    }

    public XMLModel getXMLModel(javax.ide.model.Project project) throws IOException {
        XMLSourceNode xMLSourceNode = (XMLSourceNode)this.getIdeElement();
        return new XMLModelImpl(project, xMLSourceNode);
    }

    private static final class XMLModelImpl
    implements XMLModel {
        private final XMLSourceNode _xmlSourceNode;
        private final javax.ide.model.Project _project;

        XMLModelImpl(javax.ide.model.Project project, XMLSourceNode xMLSourceNode) {
            this._project = project;
            this._xmlSourceNode = xMLSourceNode;
        }

        private XmlModel getJDevModel() {
            try {
                Project project = (Project)NodeFactory.find((URL)VirtualFileSystem.getVirtualFileSystem().toURL(this._project.getURI()));
                XmlModel xmlModel = this._xmlSourceNode.getModel(project);
                return xmlModel;
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
                return null;
            }
        }

        public Document getDOMDocument() {
            return this.getJDevModel().getDocument();
        }

        public void rollbackEdit() {
            this.getJDevModel().rollbackTransaction();
        }

        public UndoableEdit commitEdit() {
            try {
                this.getJDevModel().commitTransaction();
                UndoableEdit undoableEdit = null;
                return undoableEdit;
            }
            catch (XmlCommitException xmlCommitException) {
                xmlCommitException.printStackTrace();
                return null;
            }
        }

        public void beginEdit() {
            this.getJDevModel().startTransaction("");
        }

        public void read(Runnable runnable) {
            try {
                this.getJDevModel().acquireReadLock();
                runnable.run();
            }
            finally {
                this.getJDevModel().releaseReadLock();
            }
        }

        public void write(Runnable runnable) {
            try {
                this.getJDevModel().startTransaction("");
                runnable.run();
            }
            finally {
                try {
                    this.getJDevModel().commitTransaction();
                }
                catch (XmlCommitException xmlCommitException) {
                    xmlCommitException.printStackTrace();
                }
            }
        }
    }
}

