/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.jvmti.common;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;

public class Transport {
    private Socket socket;
    private DataInputStream dataInputStream;
    private DataOutputStream dataOutputStream;
    private int negotiatedVersion;

    public boolean makeSocketConnection(int n, String string, int n2) {
        try {
            ServerSocket serverSocket = new ServerSocket(n);
            this.socket = serverSocket.accept();
            serverSocket.close();
            this.dataInputStream = new DataInputStream(this.socket.getInputStream());
            this.dataOutputStream = new DataOutputStream(this.socket.getOutputStream());
            int n3 = string.length();
            int n4 = 0;
            while (n4 < n3) {
                char c = string.charAt(n4);
                this.dataOutputStream.writeByte((byte)c);
                char c2 = (char)this.dataInputStream.readByte();
                if (c2 != c) {
                    boolean bl = false;
                    return bl;
                }
                ++n4;
            }
            this.sendInt(n2);
            this.negotiatedVersion = this.receiveInt();
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public void closeSocketConnection() {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.socket = null;
        }
    }

    public void sendByte(byte by) throws IOException {
        this.dataOutputStream.writeByte(by);
    }

    public void sendBoolean(boolean bl) throws IOException {
        this.dataOutputStream.writeBoolean(bl);
    }

    public void sendShort(short s) throws IOException {
        this.dataOutputStream.writeShort(s);
    }

    public void sendChar(char c) throws IOException {
        this.dataOutputStream.writeChar(c);
    }

    public void sendInt(int n) throws IOException {
        this.dataOutputStream.writeInt(n);
    }

    public void sendLong(long l) throws IOException {
        this.dataOutputStream.writeLong(l);
    }

    public void sendFloat(float f) throws IOException {
        this.dataOutputStream.writeFloat(f);
    }

    public void sendDouble(double d) throws IOException {
        this.dataOutputStream.writeDouble(d);
    }

    public byte receiveByte() throws IOException {
        return this.dataInputStream.readByte();
    }

    public boolean receiveBoolean() throws IOException {
        return this.dataInputStream.readBoolean();
    }

    public short receiveShort() throws IOException {
        return this.dataInputStream.readShort();
    }

    public char receiveChar() throws IOException {
        return this.dataInputStream.readChar();
    }

    public int receiveInt() throws IOException {
        return this.dataInputStream.readInt();
    }

    public long receiveLong() throws IOException {
        return this.dataInputStream.readLong();
    }

    public float receiveFloat() throws IOException {
        return this.dataInputStream.readFloat();
    }

    public double receiveDouble() throws IOException {
        return this.dataInputStream.readDouble();
    }

    public void sendString(String string) throws IOException {
        byte[] byArray = string.getBytes("UTF-8");
        this.dataOutputStream.writeInt(byArray.length);
        this.dataOutputStream.write(byArray);
    }

    public String receiveString() throws IOException {
        int n = this.dataInputStream.readInt();
        byte[] byArray = new byte[n];
        this.dataInputStream.read(byArray);
        return new String(byArray, "UTF-8");
    }
}

