/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.library;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.ide.help.HelpSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.net.URLTextField;
import oracle.ide.util.ResourceUtils;
import oracle.ide.util.VersionNumber;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.library.JDKUtil;
import oracle.jdeveloper.library.Library;
import oracle.jdeveloper.resource.ControlsArb;
import oracle.jdevimpl.library.LibraryArb;
import oracle.jdevimpl.library.LibraryEditPanel;

public class JDKEditPanel
extends LibraryEditPanel {
    protected JLabel lblExe;
    protected URLTextField fldExe;
    protected JButton btnExe;
    protected JLabel lblOjvm;
    protected JButton btnOjvm;
    protected String[] vms;
    protected VersionNumber version;
    protected URL sdkDir;
    private ExeListener _listener;

    void $init$() {
        this.lblExe = new JLabel();
        this.fldExe = new URLTextField(null, false, false);
        this.btnExe = new JButton();
        this.lblOjvm = new JLabel();
        this.btnOjvm = new JButton();
        this._listener = new ExeListener(null);
    }

    public JDKEditPanel() {
        this.$init$();
        try {
            this.jbInit();
            HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_idednewjdk_html");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public JDKEditPanel(JDK jDK) {
        this();
        this.setLibrary(jDK);
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_idededitj2se_html");
    }

    private void jbInit() throws Exception {
        ResourceUtils.resLabel((JLabel)this.lblName, (Component)this.fldName, (String)LibraryArb.getString(20));
        ResourceUtils.resLabel((JLabel)this.lblExe, (Component)this.fldExe, (String)LibraryArb.getString(21));
        this.lblExe.setHorizontalAlignment(0);
        ResourceUtils.resLabel((JLabel)this.lblOjvm, (Component)this.btnOjvm, (String)ControlsArb.getString(77));
        this.fldExe.setDialogTitle(ControlsArb.getString(54));
        this.fldExe.setFilter((URLFilter)new JDKUtil.JDKExeFilter());
        this.fldExe.getDocument().addDocumentListener(this._listener);
        ResourceUtils.resButton((AbstractButton)this.btnExe, (String)LibraryArb.getString(22));
        this.btnExe.addActionListener((ActionListener)this.fldExe);
        ResourceUtils.resButton((AbstractButton)this.btnOjvm, (String)ControlsArb.getString(78));
        this.btnOjvm.addActionListener(new 1());
        this.remove(this.cbDeployedByDefault);
        int n = 0;
        this.add((Component)this.lblExe, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 5, 0, 2), 0, 0));
        this.add((Component)this.fldExe, new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 0, 0, 2), 0, 0));
        this.add((Component)this.btnExe, new GridBagConstraints(2, n, 1, 1, 0.0, 0.0, 10, 2, new Insets(2, 0, 0, 5), 0, 0));
        this.add((Component)this.lblName, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 2), 0, 0));
        this.add((Component)this.fldName, new GridBagConstraints(1, n, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 5), 0, 0));
        if (File.separatorChar == '\\') {
            ++n;
            this.add((Component)this.lblOjvm, new GridBagConstraints(0, ++n, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 2), 0, 0));
            this.add((Component)this.btnOjvm, new GridBagConstraints(2, n, 1, 1, 0.0, 0.0, 13, 2, new Insets(2, 0, 0, 5), 0, 0));
        }
        this.add((Component)this.rightScroll, new GridBagConstraints(0, ++n, 3, 1, 1.0, 1.0, 10, 1, new Insets(2, 5, 0, 5), 0, 0));
        this.add((Component)this.posPanel, new GridBagConstraints(3, n, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 0, 0, 0), 0, 0));
        this.add((Component)this.addPanel, new GridBagConstraints(0, ++n, 3, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
    }

    public void setListsVisible(boolean bl) {
        if (bl) {
            this.add((Component)this.lblLibList, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 0, 2), 0, 0));
            this.add((Component)this.fldLibLists, new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 10, 2, new Insets(2, 0, 0, 5), 0, 0));
        } else {
            this.remove(this.lblLibList);
            this.remove(this.fldLibLists);
        }
    }

    public String[] getVMs() {
        return this.vms;
    }

    public VersionNumber getJavaVersion() {
        return this.version;
    }

    public URL getSDKDir() {
        return this.sdkDir;
    }

    public URL getExecutable() {
        return this.fldExe.getURL();
    }

    public String getExecutableText() {
        return this.fldExe.getText();
    }

    public void setLibrary(Library library) {
        this.fldExe.getDocument().removeDocumentListener(this._listener);
        this.currentLib = library;
        this.updatePaths();
        boolean bl = true;
        if (this.currentLib != null) {
            bl = this.currentLib.isLocked() ^ true;
            this.fldName.setText(this.currentLib.getName());
            this.fldExe.setURL(((JDK)this.currentLib).getJavaExecutable());
        } else {
            this.fldName.setText("");
            this.fldExe.setText("");
            bl = false;
        }
        this.updateOjvm();
        this.fldName.setEnabled(bl);
        this.fldName.setEditable(bl);
        this.fldExe.setEnabled(bl);
        this.fldExe.setEditable(bl);
        this.btnExe.setEnabled(bl);
        this.pathsTree.setEnabled(bl);
        this.fldExe.getDocument().addDocumentListener(this._listener);
        int n = this.pathsTree.getRowCount();
        while (--n >= 0) {
            this.pathsTree.expandRow(n);
        }
        this.updatePathsButtons(null);
    }

    protected void updatePaths() {
        if (this.currentLib != null) {
            JDK jDK = (JDK)this.currentLib;
            this.vms = jDK.getInstalledVMs();
            this.version = jDK.getJavaVersion();
            this.sdkDir = jDK.getSDKBinDir();
        } else {
            this.vms = null;
            this.version = null;
            this.sdkDir = null;
        }
        super.updatePaths();
    }

    private void updateOjvm() {
        if (this.currentLib != null && ((JDK)this.currentLib).getJavaVersion() != null) {
            boolean bl = JDKUtil.ojvmUptodate((JDK)this.currentLib);
            this.btnOjvm.setEnabled(bl ^ true);
            String string = ControlsArb.getString(bl ? 79 : 77);
            ResourceUtils.resLabel((JLabel)this.lblOjvm, (Component)this.btnOjvm, (String)string);
            this.lblOjvm.setEnabled(true);
        } else {
            this.lblOjvm.setEnabled(false);
            this.btnOjvm.setEnabled(false);
        }
    }

    private void updateEXE() {
        URL uRL = this.fldExe.getURL();
        if (uRL != null) {
            boolean bl = JDKUtil.initJDK((JDK)this.currentLib, uRL);
            this.updateOjvm();
            this.updatePaths();
            String string = this.fldName.getText();
            String string2 = string = string != null ? string.trim() : null;
            if (string == null || string.length() == 0) {
                VersionNumber versionNumber = ((JDK)this.currentLib).getJavaVersion();
                this.fldName.setText(versionNumber != null ? versionNumber.toString() : "");
            }
        }
    }

    static void mav$updateOjvm(JDKEditPanel jDKEditPanel) {
        jDKEditPanel.updateOjvm();
    }

    static void mav$updateEXE(JDKEditPanel jDKEditPanel) {
        jDKEditPanel.updateEXE();
    }

    public final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            JDK jDK = (JDK)JDKEditPanel.this.currentLib;
            if (JDKUtil.updateOjvm(jDK, true) && jDK.getSDKBinDir() != null) {
                JDKEditPanel.this.vms = JDKUtil.getVMChoices(jDK.getSDKBinDir(), true);
            }
            JDKEditPanel.mav$updateOjvm(JDKEditPanel.this);
        }
    }

    private final class ExeListener
    implements DocumentListener {
        public void changedUpdate(DocumentEvent documentEvent) {
            JDKEditPanel.mav$updateEXE(JDKEditPanel.this);
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            JDKEditPanel.mav$updateEXE(JDKEditPanel.this);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            JDKEditPanel.mav$updateEXE(JDKEditPanel.this);
        }

        private ExeListener() {
        }

        ExeListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

