/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.library;

import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ExtensionHook;
import javax.ide.net.URIFactory;
import javax.ide.net.VirtualFileSystem;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLPath;

public final class LibrariesHook
extends ExtensionHook {
    public static final ElementName ELEMENT = LibrariesHook.e("libraries");
    private static String LIBRARY = "Library";
    private static String LIBRARYNAME = "LibraryName";
    private static String LIBRARYDEPLOYED = "LibraryDeployed";
    private static final String NS = "http://xmlns.oracle.com/jdeveloper/1013/jdev-libraries";
    private ElementVisitor _libraryHandler;
    private ElementVisitor _aliasHandler;
    private final List _aliases;
    private final List _libraries;

    void $init$() {
        this._libraryHandler = new LibraryHandler(null);
        this._aliasHandler = new AliasHandler(null);
        this._aliases = new ArrayList();
        this._libraries = new ArrayList();
    }

    public Collection getAliases() {
        return this._aliases;
    }

    public Collection getLibraries() {
        return this._libraries;
    }

    private static final ElementName e(String string) {
        return new ElementName(NS, string);
    }

    public void start(ElementStartContext elementStartContext) {
        elementStartContext.registerChildVisitor(LibrariesHook.e("library"), this._libraryHandler);
        elementStartContext.registerChildVisitor(LibrariesHook.e("alias"), this._aliasHandler);
    }

    public LibrariesHook() {
        this.$init$();
    }

    static List ra$_aliases(LibrariesHook librariesHook) {
        return librariesHook._aliases;
    }

    static URI mav$resolvePath(LibrariesHook librariesHook, ElementContext elementContext, String string) {
        return librariesHook.resolvePath(elementContext, string);
    }

    static String ra$LIBRARY() {
        return LIBRARY;
    }

    static String ra$LIBRARYNAME() {
        return LIBRARYNAME;
    }

    static String ra$LIBRARYDEPLOYED() {
        return LIBRARYDEPLOYED;
    }

    static List ra$_libraries(LibrariesHook librariesHook) {
        return librariesHook._libraries;
    }

    static ElementName maS$e(String string) {
        return LibrariesHook.e(string);
    }

    private class AliasHandler
    extends ElementVisitor {
        public void start(ElementStartContext elementStartContext) {
            String string = elementStartContext.getAttributeValue("from");
            String string2 = elementStartContext.getAttributeValue("to");
            LibrariesHook.ra$_aliases(LibrariesHook.this).add(new LibraryAlias(string, string2, null));
        }

        private AliasHandler() {
        }

        AliasHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class LibraryHandler
    extends ElementVisitor {
        public void start(ElementStartContext elementStartContext) {
            elementStartContext.registerChildVisitor(LibrariesHook.maS$e("classpath"), (ElementVisitor)new ClassPathHandler(null));
            elementStartContext.registerChildVisitor(LibrariesHook.maS$e("docpath"), (ElementVisitor)new DocPathHandler(null));
            elementStartContext.registerChildVisitor(LibrariesHook.maS$e("srcpath"), (ElementVisitor)new SrcPathHandler(null));
            elementStartContext.getScopeData().put(LibrariesHook.ra$LIBRARYNAME(), elementStartContext.getAttributeValue("name"));
            elementStartContext.getScopeData().put(LibrariesHook.ra$LIBRARYDEPLOYED(), elementStartContext.getAttributeValue("deployed"));
            elementStartContext.getScopeData().put(LibrariesHook.ra$LIBRARY(), new LibraryObject());
        }

        public void end(ElementEndContext elementEndContext) {
            String string = (String)elementEndContext.getScopeData().get(LibrariesHook.ra$LIBRARYNAME());
            LibraryObject libraryObject = this.getLibrary((ElementContext)elementEndContext);
            String string2 = (String)elementEndContext.getScopeData().get(LibrariesHook.ra$LIBRARYDEPLOYED());
            boolean bl = string2 != null && string2.equalsIgnoreCase("true");
            LibrariesHook.ra$_libraries(LibrariesHook.this).add(new LibraryInfo(string, libraryObject._classPath, libraryObject._srcPath, libraryObject._docPath, bl ? Boolean.TRUE : Boolean.FALSE, null));
        }

        private LibraryObject getLibrary(ElementContext elementContext) {
            return (LibraryObject)elementContext.getScopeData().get(LibrariesHook.ra$LIBRARY());
        }

        private void addURLPath(URLPath uRLPath, ElementEndContext elementEndContext) {
            String string = elementEndContext.getText();
            if ((string = string.replace('\\', '/')) == null || (string = string.trim()).length() == 0) {
                this.log((ElementContext)elementEndContext, Level.SEVERE, "Element must not be empty");
                return;
            }
            if (string.indexOf(59) >= 0) {
                this.log((ElementContext)elementEndContext, Level.WARNING, "Use of path separator is no longer supported");
            }
            if (string.startsWith("http") || string.startsWith("https")) {
                uRLPath.add(URLFactory.newURL((String)string));
            } else {
                URI uRI = LibrariesHook.mav$resolvePath(LibrariesHook.this, (ElementContext)elementEndContext, string);
                String[] stringArray = new String[]{".jar", ".war", ".ear", ".zip"};
                if (Arrays.asList(stringArray).contains(VirtualFileSystem.getVirtualFileSystem().getSuffix(uRI).toLowerCase())) {
                    uRI = URIFactory.newJarURI((URI)uRI, (String)"");
                } else {
                    String string2 = uRI.toString();
                    int n = string2.indexOf("!/");
                    if (n > 0) {
                        String string3 = string2.substring(0, n);
                        String string4 = string2.substring(n + 2);
                        uRI = URIFactory.newJarURI((URI)URIFactory.newURI((String)string3), (String)string4);
                    }
                }
                try {
                    uRLPath.add(VirtualFileSystem.getVirtualFileSystem().toURL(uRI));
                }
                catch (MalformedURLException malformedURLException) {
                    this.log((ElementContext)elementEndContext, Level.SEVERE, "Malformed URL: " + uRI);
                }
            }
        }

        private LibraryHandler() {
        }

        LibraryHandler(1 var2_2) {
            this();
        }

        static LibraryObject mav$getLibrary(LibraryHandler libraryHandler, ElementContext elementContext) {
            return libraryHandler.getLibrary(elementContext);
        }

        static void mav$addURLPath(LibraryHandler libraryHandler, URLPath uRLPath, ElementEndContext elementEndContext) {
            libraryHandler.addURLPath(uRLPath, elementEndContext);
        }

        public class LibraryObject {
            URLPath _classPath;
            URLPath _srcPath;
            URLPath _docPath;

            void $init$() {
                this._classPath = new URLPath();
                this._srcPath = new URLPath();
                this._docPath = new URLPath();
            }

            LibraryObject() {
                this.$init$();
            }
        }

        private final class ClassPathHandler
        extends ElementVisitor {
            public void end(ElementEndContext elementEndContext) {
                LibraryHandler.mav$addURLPath(LibraryHandler.this, LibraryHandler.mav$getLibrary((LibraryHandler)LibraryHandler.this, (ElementContext)elementEndContext)._classPath, elementEndContext);
            }

            private ClassPathHandler() {
            }

            ClassPathHandler(1 var2_2) {
                this();
            }

            public final class 1 {
            }
        }

        private final class DocPathHandler
        extends ElementVisitor {
            public void end(ElementEndContext elementEndContext) {
                LibraryHandler.mav$addURLPath(LibraryHandler.this, LibraryHandler.mav$getLibrary((LibraryHandler)LibraryHandler.this, (ElementContext)elementEndContext)._docPath, elementEndContext);
            }

            private DocPathHandler() {
            }

            DocPathHandler(1 var2_2) {
                this();
            }

            public final class 1 {
            }
        }

        private final class SrcPathHandler
        extends ElementVisitor {
            public void end(ElementEndContext elementEndContext) {
                LibraryHandler.mav$addURLPath(LibraryHandler.this, LibraryHandler.mav$getLibrary((LibraryHandler)LibraryHandler.this, (ElementContext)elementEndContext)._srcPath, elementEndContext);
            }

            private SrcPathHandler() {
            }

            SrcPathHandler(1 var2_2) {
                this();
            }

            public final class 1 {
            }
        }

        public final class 1 {
        }
    }

    public final class LibraryInfo {
        private final String _name;
        private final URLPath _classPath;
        private final URLPath _sourcePath;
        private final URLPath _docPath;
        private final Boolean _deployed;

        private LibraryInfo(String string, URLPath uRLPath, URLPath uRLPath2, URLPath uRLPath3, Boolean bl) {
            this._name = string;
            this._classPath = uRLPath;
            this._sourcePath = uRLPath2;
            this._docPath = uRLPath3;
            this._deployed = bl;
        }

        public String getName() {
            return this._name;
        }

        public URLPath getClassPath() {
            return this._classPath;
        }

        public URLPath getDocPath() {
            return this._docPath;
        }

        public URLPath getSourcePath() {
            return this._sourcePath;
        }

        public Boolean isDeployed() {
            return this._deployed;
        }

        LibraryInfo(String string, URLPath uRLPath, URLPath uRLPath2, URLPath uRLPath3, Boolean bl, 1 var7_7) {
            this(string, uRLPath, uRLPath2, uRLPath3, bl);
        }

        public final class 1 {
        }
    }

    public final class LibraryAlias {
        private final String _from;
        private final String _to;

        private LibraryAlias(String string, String string2) {
            this._from = string;
            this._to = string2;
        }

        public String getFrom() {
            return this._from;
        }

        public String getTo() {
            return this._to;
        }

        LibraryAlias(String string, String string2, 1 var4_4) {
            this(string, string2);
        }

        public final class 1 {
        }
    }
}

