/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.library;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.javatools.data.HashStructure;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.library.JLibraryAdapter;
import oracle.jdeveloper.library.Library;
import oracle.jdeveloper.library.ListWrapper;
import oracle.jdeveloper.library.MutableLibraryList;
import oracle.jdeveloper.model.JLibraryModel;
import oracle.jdevimpl.library.LeafNode;
import oracle.jdevimpl.library.LibraryArb;
import oracle.jdevimpl.library.LibraryEditPanel;
import oracle.jdevimpl.library.ListNode;
import oracle.jdevimpl.library.TreePanel;

public class LibrariesPanel
extends TreePanel {
    private LibraryEditPanel _detailPanel;
    private Library _currentLib;
    protected final LocalChangeListener listener;

    void $init$() {
        this.listener = new LocalChangeListener();
    }

    public LibrariesPanel() {
        this.$init$();
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, this.getHelpId());
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.getDetailPanel().setLibrary(null);
        this.setDetailPanel(this.getDetailPanel(), this.getDetailTitle());
    }

    protected LibraryEditPanel getDetailPanel() {
        if (this._detailPanel == null) {
            this._detailPanel = new LibraryEditPanel();
        }
        return this._detailPanel;
    }

    protected String getDetailTitle() {
        return LibraryArb.getString(66);
    }

    public String getHelpId() {
        return "f1_idedmanagelibrarieslibraries_html";
    }

    protected DefaultTreeModel createTreeModel(ListWrapper[] listWrapperArray) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
        int n = listWrapperArray.length - 1;
        while (n >= 0) {
            ListWrapper listWrapper = listWrapperArray[n];
            LibraryListNode libraryListNode = this.buildListNode(listWrapper);
            defaultMutableTreeNode.add(libraryListNode);
            --n;
        }
        return new DefaultTreeModel(defaultMutableTreeNode);
    }

    public boolean commitChanges() {
        ListNode listNode;
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.findNode(null, this._currentLib);
        Object[] objectArray = defaultMutableTreeNode != null ? defaultMutableTreeNode.getPath() : null;
        TreePath treePath = objectArray != null && objectArray.length > 1 ? new TreePath(objectArray) : null;
        ListNode listNode2 = listNode = treePath != null ? (ListNode)treePath.getPathComponent(1) : null;
        if (listNode != null) {
            try {
                this._currentLib = this.commitChanges(listNode.getList(), this._currentLib, this.getDetailPanel());
                defaultMutableTreeNode.setUserObject(this._currentLib);
            }
            catch (Exception exception) {
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }

    protected Library commitChanges(MutableLibraryList mutableLibraryList, Library library, LibraryEditPanel libraryEditPanel) throws Exception {
        if (library == null) {
            return library;
        }
        JLibraryModel jLibraryModel = new JLibraryModel((JLibrary)library, mutableLibraryList, (Component)libraryEditPanel);
        jLibraryModel.setName(libraryEditPanel.getLibraryName());
        jLibraryModel.setClassPath(libraryEditPanel.getClassPath());
        jLibraryModel.setSourcePath(libraryEditPanel.getSourcePath());
        jLibraryModel.setDocPath(libraryEditPanel.getDocPath());
        jLibraryModel.setDeployedByDefault(libraryEditPanel.isDeployByDefault());
        return jLibraryModel.commit();
    }

    protected Library createNewElement(ListWrapper[] listWrapperArray) {
        ListWrapper listWrapper = listWrapperArray[0];
        HashStructure hashStructure = HashStructure.newInstance();
        Library library = new JLibraryAdapter(hashStructure);
        LibraryEditPanel libraryEditPanel = new LibraryEditPanel();
        libraryEditPanel.setLibrary(library);
        libraryEditPanel.setLibraryLists(this.getLibraryLists());
        libraryEditPanel.setListsVisible(true);
        libraryEditPanel.setLibraryList(listWrapper);
        this.listener.initialize(libraryEditPanel, library);
        if (OnePageWizardDialogFactory.runDialog((Component)this, (Component)libraryEditPanel, (Component)libraryEditPanel.addBtn, (String)this.getDetailTitle(), (int)7, (VetoableChangeListener)this.listener)) {
            library = this.listener.getLibrary();
            listWrapperArray[0] = (ListWrapper)libraryEditPanel.getLibraryList();
        } else {
            library = null;
        }
        return library;
    }

    protected ListNode addLibraryList(ListWrapper listWrapper) {
        LibraryListNode libraryListNode = this.buildListNode(listWrapper);
        DefaultTreeModel defaultTreeModel = this.getTreeModel();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)defaultTreeModel.getRoot();
        defaultTreeModel.insertNodeInto(libraryListNode, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
        return libraryListNode;
    }

    protected void nodeDeleted(LeafNode leafNode) {
        if (leafNode instanceof LibraryNode && ((LibraryNode)leafNode).getLibrary() == this._currentLib) {
            this._currentLib = null;
            this.getDetailPanel().setLibrary(null);
        }
    }

    protected boolean updateSelection(Library library) {
        Library library2 = library;
        if (this._currentLib != library2) {
            if (this._currentLib != null && this.isSplit()) {
                try {
                    this.commitChanges();
                }
                catch (Exception exception) {
                    boolean bl = false;
                    return bl;
                }
            }
            this._currentLib = library2;
            this.getDetailPanel().setLibrary(library2);
        }
        return true;
    }

    protected LibraryListNode buildListNode(ListWrapper listWrapper) {
        List list = listWrapper != null ? listWrapper.getLibraryList() : null;
        Iterator iterator = list != null ? list.iterator() : null;
        return new LibraryListNode(listWrapper, iterator);
    }

    public final class LocalChangeListener
    implements VetoableChangeListener {
        private boolean vetoThrown;
        private LibraryEditPanel _newPanel;
        private Library _lib;

        public void initialize(LibraryEditPanel libraryEditPanel, Library library) {
            this._newPanel = libraryEditPanel;
            this._lib = library;
        }

        public Library getLibrary() {
            return this._lib;
        }

        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            if (this.vetoThrown) {
                this.vetoThrown = false;
                return;
            }
            try {
                this._lib = LibrariesPanel.this.commitChanges((MutableLibraryList)this._newPanel.getLibraryList(), this._lib, this._newPanel);
            }
            catch (Exception exception) {
                this.vetoThrown = true;
                throw new PropertyVetoException(null, propertyChangeEvent);
            }
        }

        LocalChangeListener() {
        }
    }

    protected class LibraryListNode
    extends ListNode {
        LibraryListNode(ListWrapper listWrapper, Iterator iterator) {
            super(listWrapper, iterator);
        }

        boolean _isRightType(Object object) {
            return object instanceof Library;
        }

        LeafNode _createTreeNode(Object object) {
            return new LibraryNode((Library)object);
        }

        void selectNode(DefaultMutableTreeNode defaultMutableTreeNode) {
            LibrariesPanel.this.selectNode(defaultMutableTreeNode);
        }
    }

    protected static class LibraryNode
    extends LeafNode {
        LibraryNode(Library library) {
            super(library);
        }

        Library getLibrary() {
            return (Library)this.getUserObject();
        }
    }
}

