/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.library;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.net.URL;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Ide;
import oracle.ide.component.URLPanel;
import oracle.ide.controls.SortedComboBoxModel;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.help.HelpSystem;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.resource.ComponentArb;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.library.Library;
import oracle.jdeveloper.library.LibraryList;
import oracle.jdeveloper.library.MutableLibraryList;
import oracle.jdevimpl.library.LibraryArb;

public class LibraryEditPanel
extends JPanel {
    protected static URL defDir = URLFactory.newDirURL((String)Ide.getWorkDirectory());
    protected JScrollPane rightScroll;
    protected JTree pathsTree;
    protected GridBagLayout gridBagLayout2;
    protected JLabel lblLibList;
    protected JComboBox fldLibLists;
    protected JTextField txtLibLists;
    protected JCheckBox cbDeployedByDefault;
    protected JButton addBtn;
    protected JButton urlBtn;
    protected JButton removeBtn;
    protected JPanel addPanel;
    protected GridLayout addLayout;
    protected JButton dnBtn;
    protected JButton upBtn;
    protected JPanel posPanel;
    protected GridLayout posLayout;
    protected JTextField fldName;
    protected JLabel lblName;
    protected Library currentLib;
    protected DefaultMutableTreeNode root;
    protected DefaultTreeModel pathsModel;
    protected DefaultMutableTreeNode clsNode;
    protected DefaultMutableTreeNode srcNode;
    protected DefaultMutableTreeNode docNode;
    protected DefaultTreeCellRenderer pathsTreeRenderer;

    void $init$() {
        this.rightScroll = new JScrollPane();
        this.pathsTree = new JTree();
        this.gridBagLayout2 = new GridBagLayout();
        this.lblLibList = new JLabel();
        this.fldLibLists = new JComboBox();
        this.txtLibLists = new JTextField();
        this.cbDeployedByDefault = new JCheckBox();
        this.addBtn = new JButton();
        this.urlBtn = new JButton();
        this.removeBtn = new JButton();
        this.addPanel = new JPanel();
        this.addLayout = new GridLayout();
        this.dnBtn = new JButton();
        this.upBtn = new JButton();
        this.posPanel = new JPanel();
        this.posLayout = new GridLayout();
        this.fldName = new JTextField();
        this.lblName = new JLabel();
        this.root = new DefaultMutableTreeNode("Root");
        this.pathsModel = new DefaultTreeModel(this.root);
        this.clsNode = new DefaultMutableTreeNode(StringUtils.stripMnemonic((String)LibraryArb.getString(10)));
        this.srcNode = new DefaultMutableTreeNode(StringUtils.stripMnemonic((String)LibraryArb.getString(11)));
        this.docNode = new DefaultMutableTreeNode(StringUtils.stripMnemonic((String)LibraryArb.getString(12)));
        this.pathsTreeRenderer = new PathsRenderer(null);
    }

    public LibraryEditPanel() {
        this.$init$();
        try {
            this.jbInit();
            HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_idedcreatelibrary_html");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public LibraryEditPanel(JLibrary jLibrary) {
        this();
        this.setLibrary(jLibrary);
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_idededitlibrarydefinition_html");
    }

    private void jbInit() throws Exception {
        this.root.add(this.clsNode);
        this.root.add(this.srcNode);
        this.root.add(this.docNode);
        this.setLayout(this.gridBagLayout2);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.lblName.setHorizontalAlignment(0);
        this.pathsTree.setRootVisible(false);
        this.pathsTree.setShowsRootHandles(true);
        this.pathsTree.setModel(this.pathsModel);
        this.pathsTree.getSelectionModel().setSelectionMode(4);
        this.pathsTree.setCellRenderer(this.pathsTreeRenderer);
        this.pathsTree.addTreeSelectionListener(new 8());
        this.pathsTree.addKeyListener(new 7());
        ToolTipManager.sharedInstance().registerComponent(this.pathsTree);
        this.pathsTreeRenderer.setLeafIcon(null);
        this.addBtn.setEnabled(false);
        this.addBtn.addActionListener(new 6());
        this.removeBtn.setEnabled(false);
        this.removeBtn.addActionListener(new 5());
        this.urlBtn.setEnabled(false);
        this.urlBtn.addActionListener(new 4());
        this.addPanel.setLayout(this.addLayout);
        this.addPanel.setBorder(BorderFactory.createEmptyBorder());
        this.addLayout.setRows(1);
        this.addLayout.setHgap(2);
        this.upBtn.setMargin(new Insets(1, 1, 1, 1));
        this.upBtn.setIcon(ComponentArb.getIcon((int)0));
        this.upBtn.setEnabled(false);
        this.upBtn.setToolTipText(LibraryArb.getString(61));
        this.upBtn.addActionListener(new 3());
        this.dnBtn.setMargin(new Insets(1, 1, 1, 1));
        this.dnBtn.setIcon(ComponentArb.getIcon((int)1));
        this.dnBtn.setEnabled(false);
        this.dnBtn.setToolTipText(LibraryArb.getString(60));
        this.dnBtn.addActionListener(new 2());
        this.posPanel.setLayout(this.posLayout);
        this.posPanel.setBorder(BorderFactory.createEmptyBorder());
        this.posLayout.setColumns(1);
        this.posLayout.setRows(0);
        this.posLayout.setVgap(2);
        this.rightScroll.setViewportView(this.pathsTree);
        ResourceUtils.resLabel((JLabel)this.lblName, (Component)this.fldName, (String)LibraryArb.getString(68));
        ResourceUtils.resLabel((JLabel)this.lblLibList, (Component)this.fldLibLists, (String)LibraryArb.getString(70));
        ResourceUtils.resButton((AbstractButton)this.cbDeployedByDefault, (String)LibraryArb.getString(19));
        ResourceUtils.resButton((AbstractButton)this.addBtn, (String)LibraryArb.getString(58));
        ResourceUtils.resButton((AbstractButton)this.removeBtn, (String)LibraryArb.getString(56));
        ResourceUtils.resButton((AbstractButton)this.urlBtn, (String)ComponentArb.getString((int)13));
        this.posPanel.add((Component)this.upBtn, null);
        this.posPanel.add((Component)this.dnBtn, null);
        this.addPanel.add((Component)this.addBtn, null);
        this.addPanel.add((Component)this.urlBtn, null);
        this.addPanel.add((Component)this.removeBtn, null);
        this.add((Component)this.lblName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 2), 0, 0));
        this.add((Component)this.fldName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 2, 0, 5), 0, 0));
        this.add((Component)this.cbDeployedByDefault, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 0, 5), 0, 0));
        this.add((Component)this.rightScroll, new GridBagConstraints(0, 3, 2, 1, 1.0, 1.0, 10, 1, new Insets(2, 5, 0, 5), 0, 0));
        this.add((Component)this.posPanel, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.addPanel, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
    }

    public void setLibrary(Library library) {
        this.currentLib = library;
        this.updatePaths();
        boolean bl = true;
        if (this.currentLib != null) {
            bl = this.currentLib.isLocked() ^ true;
            this.fldName.setText(this.currentLib.getName());
            this.cbDeployedByDefault.setSelected(Boolean.TRUE.equals(((JLibrary)this.currentLib).getDeployedByDefault()));
        } else {
            this.fldName.setText("");
            this.cbDeployedByDefault.setSelected(false);
            bl = false;
        }
        this.lblName.setEnabled(bl);
        this.fldName.setEnabled(bl);
        this.fldName.setEditable(bl);
        this.lblLibList.setEnabled(bl);
        this.fldLibLists.setEnabled(bl);
        this.txtLibLists.setEnabled(false);
        this.txtLibLists.setEditable(false);
        this.cbDeployedByDefault.setEnabled(bl);
        this.pathsTree.setEnabled(bl);
        int n = this.pathsTree.getRowCount();
        while (--n >= 0) {
            this.pathsTree.expandRow(n);
        }
        TreePath treePath = this.pathsTree.getPathForRow(n);
        this.updatePathsButtons(new TreeSelectionEvent((Object)this.pathsTree, treePath, true, null, treePath));
    }

    public void setListsVisible(boolean bl) {
        if (bl) {
            this.remove(this.txtLibLists);
            this.add((Component)this.lblLibList, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 0, 2), 0, 0));
            this.add((Component)this.fldLibLists, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 0, 5), 0, 0));
        } else {
            this.remove(this.fldLibLists);
            this.add((Component)this.lblLibList, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 0, 2), 0, 0));
            this.add((Component)this.txtLibLists, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 0, 5), 0, 0));
        }
    }

    public LibraryList getLibraryList() {
        return (LibraryList)this.fldLibLists.getSelectedItem();
    }

    public void setLibraryList(LibraryList libraryList) {
        this.fldLibLists.setSelectedItem(libraryList);
        if (this.fldLibLists.getSelectedItem() == null && this.fldLibLists.getItemCount() > 0) {
            this.fldLibLists.setSelectedIndex(0);
        }
        this.txtLibLists.setText((libraryList = (LibraryList)this.fldLibLists.getSelectedItem()) != null ? libraryList.getShortLabel() : null);
        this.txtLibLists.setToolTipText(libraryList != null ? libraryList.getToolTipText() : null);
    }

    public void setLibraryLists(MutableLibraryList[] mutableLibraryListArray) {
        SortedComboBoxModel sortedComboBoxModel = new SortedComboBoxModel();
        int n = 0;
        while (n < mutableLibraryListArray.length) {
            if (!mutableLibraryListArray[n].isTransient()) {
                sortedComboBoxModel.addElement((Object)mutableLibraryListArray[n]);
            }
            ++n;
        }
        this.fldLibLists.setModel(sortedComboBoxModel);
    }

    protected void updatePaths() {
        if (this.currentLib != null) {
            this.populatePath(this.srcNode, this.currentLib.getSourcePath());
            this.populatePath(this.clsNode, this.currentLib.getClassPath());
            this.populatePath(this.docNode, this.currentLib.getDocPath());
        } else {
            this.srcNode.removeAllChildren();
            this.clsNode.removeAllChildren();
            this.docNode.removeAllChildren();
            this.pathsModel.nodeStructureChanged(this.root);
        }
        this.selectNode(this.clsNode);
    }

    protected void populatePath(DefaultMutableTreeNode defaultMutableTreeNode, URLPath uRLPath) {
        Iterator iterator;
        defaultMutableTreeNode.removeAllChildren();
        Iterator iterator2 = iterator = uRLPath != null ? uRLPath.iterator() : null;
        if (iterator != null) {
            while (iterator.hasNext()) {
                URL uRL = (URL)iterator.next();
                PathNode pathNode = new PathNode(uRL);
                pathNode.setUserObject(uRL);
                defaultMutableTreeNode.add(pathNode);
            }
        }
        this.pathsModel.nodeStructureChanged(defaultMutableTreeNode);
    }

    public String getLibraryName() {
        return this.fldName.getText();
    }

    public void setLibraryName(String string) {
        this.fldName.setText(string != null ? string : "");
    }

    public boolean isDeployByDefault() {
        return this.cbDeployedByDefault.isSelected();
    }

    public URLPath getClassPath() {
        return this.getPath(this.clsNode);
    }

    public URLPath getSourcePath() {
        return this.getPath(this.srcNode);
    }

    public URLPath getDocPath() {
        return this.getPath(this.docNode);
    }

    private URLPath getPath(DefaultMutableTreeNode defaultMutableTreeNode) {
        URLPath uRLPath = new URLPath();
        int n = defaultMutableTreeNode.getChildCount();
        int n2 = 0;
        while (n2 < n) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n2);
            uRLPath.add((URL)defaultMutableTreeNode2.getUserObject());
            ++n2;
        }
        return uRLPath;
    }

    protected void updatePathsButtons(TreeSelectionEvent treeSelectionEvent) {
        boolean bl;
        boolean bl2 = bl = treeSelectionEvent != null && !this.isLocked();
        if (bl) {
            DefaultMutableTreeNode defaultMutableTreeNode;
            TreePath[] treePathArray = this.pathsTree.getSelectionPaths();
            DefaultMutableTreeNode defaultMutableTreeNode2 = defaultMutableTreeNode = treePathArray != null && treePathArray.length == 1 ? (DefaultMutableTreeNode)treePathArray[0].getLastPathComponent() : null;
            if (defaultMutableTreeNode != null) {
                if (defaultMutableTreeNode == this.clsNode || defaultMutableTreeNode == this.srcNode || defaultMutableTreeNode == this.docNode) {
                    this.addBtn.setEnabled(true);
                    this.urlBtn.setEnabled(defaultMutableTreeNode == this.docNode);
                    this.removeBtn.setEnabled(false);
                    this.upBtn.setEnabled(false);
                    this.dnBtn.setEnabled(false);
                } else {
                    TreeNode treeNode = defaultMutableTreeNode.getParent();
                    int n = treeNode.getIndex(defaultMutableTreeNode);
                    this.addBtn.setEnabled(true);
                    this.urlBtn.setEnabled(treeNode == this.docNode);
                    this.removeBtn.setEnabled(true);
                    this.upBtn.setEnabled(n > 0);
                    this.dnBtn.setEnabled(n < treeNode.getChildCount() - 1);
                }
            } else {
                this.urlBtn.setEnabled(false);
                this.upBtn.setEnabled(false);
                this.dnBtn.setEnabled(false);
                boolean bl3 = treePathArray != null;
                boolean bl4 = treePathArray != null;
                DefaultMutableTreeNode defaultMutableTreeNode3 = null;
                if (bl3) {
                    int n = 0;
                    while (n < treePathArray.length) {
                        DefaultMutableTreeNode defaultMutableTreeNode4 = (DefaultMutableTreeNode)treePathArray[n].getLastPathComponent();
                        if (defaultMutableTreeNode4 == this.clsNode || defaultMutableTreeNode4 == this.srcNode || defaultMutableTreeNode4 == this.docNode) {
                            bl3 = false;
                            if (defaultMutableTreeNode3 == null) {
                                defaultMutableTreeNode3 = defaultMutableTreeNode4;
                            } else if (defaultMutableTreeNode3 != defaultMutableTreeNode4) {
                                bl4 = false;
                            }
                            if (!bl3 && !bl4) {
                                break;
                            }
                        } else {
                            defaultMutableTreeNode4 = (DefaultMutableTreeNode)defaultMutableTreeNode4.getParent();
                            if (defaultMutableTreeNode3 == null) {
                                defaultMutableTreeNode3 = defaultMutableTreeNode4;
                            } else if (defaultMutableTreeNode3 != defaultMutableTreeNode4) {
                                bl4 = false;
                            }
                            if (!bl3 && !bl4) break;
                        }
                        ++n;
                    }
                }
                this.addBtn.setEnabled(bl4);
                this.removeBtn.setEnabled(bl3);
            }
            return;
        }
        this.addBtn.setEnabled(false);
        this.urlBtn.setEnabled(false);
        this.removeBtn.setEnabled(false);
        this.upBtn.setEnabled(false);
        this.dnBtn.setEnabled(false);
    }

    protected boolean isLocked() {
        return this.currentLib == null || this.currentLib.isLocked();
    }

    private void addEntry(ActionEvent actionEvent) {
        URL[] uRLArray;
        int n;
        URLChooser uRLChooser = DialogUtil.newURLChooser((URL)defDir);
        uRLChooser.setSelectionMode(2);
        uRLChooser.setSelectionScope(1);
        uRLChooser.setShowJarsAsDirs(true);
        int n2 = uRLChooser.showOpenDialog((Component)this, ComponentArb.getString((int)17));
        if (n2 == 0 && (n = (uRLArray = uRLChooser.getSelectedURLs()).length) > 0) {
            DefaultMutableTreeNode defaultMutableTreeNode;
            TreePath treePath = this.pathsTree.getSelectionPath();
            DefaultMutableTreeNode defaultMutableTreeNode2 = defaultMutableTreeNode = treePath != null ? (DefaultMutableTreeNode)treePath.getLastPathComponent() : null;
            if (defaultMutableTreeNode == null) {
                return;
            }
            if (defaultMutableTreeNode != this.clsNode && defaultMutableTreeNode != this.srcNode && defaultMutableTreeNode != this.docNode) {
                defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
            }
            URL uRL = null;
            PathNode pathNode = null;
            int n3 = 0;
            while (n3 < n) {
                uRL = uRLArray[n3];
                pathNode = new PathNode(uRL);
                this.pathsModel.insertNodeInto(pathNode, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
                ++n3;
            }
            defDir = uRL != null ? URLFileSystem.getParent(uRL) : null;
            this.selectNode(pathNode);
            String string = this.fldName.getText();
            String string2 = string = string != null ? string.trim() : null;
            if (string == null || string.length() == 0) {
                this.fldName.setText(this.capitalize(uRLArray[0]));
            }
        }
    }

    private String capitalize(URL uRL) {
        int n;
        String string = URLFileSystem.getFileName((URL)uRL);
        if (!URLFileSystem.isDirectory((URL)uRL) && (n = string.lastIndexOf(46)) > 0) {
            string = string.substring(0, n);
        }
        if (!Character.isUpperCase(string.charAt(0))) {
            return Character.toUpperCase(string.charAt(0)) + string.substring(1);
        }
        return string;
    }

    private void addURL(ActionEvent actionEvent) {
        URL uRL;
        DefaultMutableTreeNode defaultMutableTreeNode;
        TreePath treePath = this.pathsTree.getSelectionPath();
        DefaultMutableTreeNode defaultMutableTreeNode2 = defaultMutableTreeNode = treePath != null ? (DefaultMutableTreeNode)treePath.getLastPathComponent() : null;
        if (defaultMutableTreeNode == null) {
            return;
        }
        if (defaultMutableTreeNode != this.clsNode && defaultMutableTreeNode != this.srcNode && defaultMutableTreeNode != this.docNode) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
        }
        if ((uRL = new URLPanel().promptForURL((Component)this)) != null) {
            PathNode pathNode = new PathNode(uRL);
            this.pathsModel.insertNodeInto(pathNode, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
            this.selectNode(pathNode);
        }
    }

    protected void selectNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (defaultMutableTreeNode == null) {
            return;
        }
        TreePath treePath = new TreePath(defaultMutableTreeNode.getPath());
        SwingUtilities.invokeLater(new 1(this, treePath));
    }

    private void removeEntry(ActionEvent actionEvent) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        TreePath[] treePathArray = this.pathsTree.getSelectionPaths();
        if (treePathArray == null || treePathArray.length == 0 || this.isLocked()) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = defaultMutableTreeNode = treePathArray.length == 1 ? (DefaultMutableTreeNode)treePathArray[0].getLastPathComponent() : null;
        if (defaultMutableTreeNode == this.clsNode || defaultMutableTreeNode == this.srcNode || defaultMutableTreeNode == this.docNode) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode3 = null;
        int n = 0;
        int n2 = 0;
        while (n2 < treePathArray.length) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[n2].getLastPathComponent();
            defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
            n = defaultMutableTreeNode3.getIndex(defaultMutableTreeNode);
            this.pathsModel.removeNodeFromParent(defaultMutableTreeNode);
            ++n2;
        }
        int n3 = defaultMutableTreeNode3.getChildCount();
        defaultMutableTreeNode = n3 == 0 ? defaultMutableTreeNode3 : (DefaultMutableTreeNode)defaultMutableTreeNode3.getChildAt(n3 > n ? n : --n);
        this.selectNode(defaultMutableTreeNode);
    }

    private void moveUp(ActionEvent actionEvent) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        TreePath treePath = this.pathsTree.getSelectionPath();
        DefaultMutableTreeNode defaultMutableTreeNode2 = defaultMutableTreeNode = treePath != null ? (DefaultMutableTreeNode)treePath.getLastPathComponent() : null;
        if (defaultMutableTreeNode == null || defaultMutableTreeNode == this.clsNode || defaultMutableTreeNode == this.srcNode || defaultMutableTreeNode == this.docNode) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
        int n = defaultMutableTreeNode3.getIndex(defaultMutableTreeNode);
        if (n > 0) {
            this.pathsModel.removeNodeFromParent(defaultMutableTreeNode);
            this.pathsModel.insertNodeInto(defaultMutableTreeNode, defaultMutableTreeNode3, --n);
            this.selectNode(defaultMutableTreeNode);
        }
    }

    private void moveDown(ActionEvent actionEvent) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        TreePath treePath = this.pathsTree.getSelectionPath();
        DefaultMutableTreeNode defaultMutableTreeNode2 = defaultMutableTreeNode = treePath != null ? (DefaultMutableTreeNode)treePath.getLastPathComponent() : null;
        if (defaultMutableTreeNode == null || defaultMutableTreeNode == this.clsNode || defaultMutableTreeNode == this.srcNode || defaultMutableTreeNode == this.docNode) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
        int n = defaultMutableTreeNode3.getIndex(defaultMutableTreeNode);
        if (n < defaultMutableTreeNode3.getChildCount() - 1) {
            this.pathsModel.removeNodeFromParent(defaultMutableTreeNode);
            this.pathsModel.insertNodeInto(defaultMutableTreeNode, defaultMutableTreeNode3, ++n);
            this.selectNode(defaultMutableTreeNode);
        }
    }

    private void tryDelete(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() == '\u007f') {
            this.removeEntry(null);
            keyEvent.consume();
        }
    }

    static void mav$tryDelete(LibraryEditPanel libraryEditPanel, KeyEvent keyEvent) {
        libraryEditPanel.tryDelete(keyEvent);
    }

    static void mav$addEntry(LibraryEditPanel libraryEditPanel, ActionEvent actionEvent) {
        libraryEditPanel.addEntry(actionEvent);
    }

    static void mav$removeEntry(LibraryEditPanel libraryEditPanel, ActionEvent actionEvent) {
        libraryEditPanel.removeEntry(actionEvent);
    }

    static void mav$addURL(LibraryEditPanel libraryEditPanel, ActionEvent actionEvent) {
        libraryEditPanel.addURL(actionEvent);
    }

    static void mav$moveUp(LibraryEditPanel libraryEditPanel, ActionEvent actionEvent) {
        libraryEditPanel.moveUp(actionEvent);
    }

    static void mav$moveDown(LibraryEditPanel libraryEditPanel, ActionEvent actionEvent) {
        libraryEditPanel.moveDown(actionEvent);
    }

    public final class 8
    implements TreeSelectionListener {
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            LibraryEditPanel.this.updatePathsButtons(treeSelectionEvent);
        }
    }

    public final class 7
    extends KeyAdapter {
        public void keyTyped(KeyEvent keyEvent) {
            LibraryEditPanel.mav$tryDelete(LibraryEditPanel.this, keyEvent);
        }
    }

    public final class 6
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            LibraryEditPanel.mav$addEntry(LibraryEditPanel.this, actionEvent);
        }
    }

    public final class 5
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            LibraryEditPanel.mav$removeEntry(LibraryEditPanel.this, actionEvent);
        }
    }

    public final class 4
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            LibraryEditPanel.mav$addURL(LibraryEditPanel.this, actionEvent);
        }
    }

    public final class 3
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            LibraryEditPanel.mav$moveUp(LibraryEditPanel.this, actionEvent);
        }
    }

    public final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            LibraryEditPanel.mav$moveDown(LibraryEditPanel.this, actionEvent);
        }
    }

    public final class 1
    implements Runnable {
        private final /* synthetic */ TreePath v$path;
        final /* synthetic */ LibraryEditPanel this$0;

        public void run() {
            this.this$0.pathsTree.setSelectionPath(this.v$path);
            this.this$0.pathsTree.scrollPathToVisible(this.v$path);
        }

        public 1(LibraryEditPanel libraryEditPanel, TreePath treePath) {
            this.v$path = treePath;
            this.this$0 = libraryEditPanel;
        }
    }

    private static final class PathNode
    extends DefaultMutableTreeNode {
        PathNode(URL uRL) {
            super(uRL);
        }

        public String toString() {
            return URLFileSystem.getPlatformPathName((URL)((URL)this.getUserObject()));
        }
    }

    private final class PathsRenderer
    extends DefaultTreeCellRenderer {
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            JLabel jLabel = (JLabel)super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            jLabel.setIcon(null);
            jLabel.setDisabledIcon(null);
            if (object == LibraryEditPanel.this.clsNode) {
                jLabel.setIcon(LibraryArb.getIcon(62));
                jLabel.setDisabledIcon(LibraryArb.getIcon(62));
            } else if (object == LibraryEditPanel.this.srcNode) {
                jLabel.setIcon(LibraryArb.getIcon(63));
                jLabel.setDisabledIcon(LibraryArb.getIcon(63));
            } else if (object == LibraryEditPanel.this.docNode) {
                jLabel.setIcon(LibraryArb.getIcon(64));
                jLabel.setDisabledIcon(LibraryArb.getIcon(64));
            } else if (object != null) {
                jLabel.setToolTipText(object.toString());
            }
            return jLabel;
        }

        private PathsRenderer() {
        }

        PathsRenderer(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

