/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.library;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.ide.Ide;
import oracle.ide.controls.checkboxlist.CheckBoxListModel;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.dialogs.SelectFilesPanel;
import oracle.ide.model.Displayable;
import oracle.ide.model.Node;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.resource.IdeArb;
import oracle.ide.resource.IdeIcons;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.library.JLibraryList;
import oracle.jdeveloper.library.JLibraryManager;
import oracle.jdeveloper.library.Library;
import oracle.jdeveloper.library.ListWrapper;
import oracle.jdevimpl.library.LeafNode;
import oracle.jdevimpl.library.LibraryArb;
import oracle.jdevimpl.library.LibraryPanel;
import oracle.jdevimpl.library.ListNode;

public abstract class TreePanel
extends LibraryPanel {
    private static final String NEW_CMD = "New";
    private static final String ADD_CMD = "Add";
    private static final String REMOVE_CMD = "Remove";
    private static URL defDir = URLFactory.newDirURL((String)Ide.getUserHomeDirectory());
    private CardLayout cardLayout1;
    private JSplitPane splitPane;
    private JScrollPane libsTreeScroller;
    private JPanel masterPanel;
    private JComponent detailPanel;
    private String detailTitle;
    private JTree libsTree;
    private JPanel buttonPanel;
    private GridLayout buttonLayout;
    private JButton newButton;
    private JButton addButton;
    private JButton removeButton;
    private GridBagLayout gridBagLayout1;
    private DefaultTreeModel libsModel;
    private DefaultTreeCellRenderer libsTreeRenderer;
    private SelectionManager selMgr;
    private boolean isSplit;
    private boolean vetoThrown;

    void $init$() {
        this.cardLayout1 = new CardLayout();
        this.splitPane = new JSplitPane();
        this.libsTreeScroller = new JScrollPane();
        this.masterPanel = new JPanel();
        this.libsTree = new JTree();
        this.buttonPanel = new JPanel();
        this.buttonLayout = new GridLayout();
        this.newButton = new JButton();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.gridBagLayout1 = new GridBagLayout();
        this.libsTreeRenderer = new Renderer();
        this.selMgr = new SelectionManager(null);
        this.isSplit = true;
    }

    public TreePanel() {
        this.$init$();
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.cardLayout1);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.addTreeSelectionListener(this.selMgr);
        this.setFocusable(false);
        this.masterPanel.setBorder(BorderFactory.createEmptyBorder());
        this.masterPanel.setLayout(this.gridBagLayout1);
        this.libsTree.getSelectionModel().setSelectionMode(1);
        this.libsTree.setRootVisible(false);
        this.libsTree.setShowsRootHandles(true);
        this.libsTree.setCellRenderer(this.libsTreeRenderer);
        this.libsTree.addKeyListener(this.selMgr);
        ToolTipManager.sharedInstance().registerComponent(this.libsTree);
        this.buttonPanel.setLayout(this.buttonLayout);
        this.buttonPanel.setBorder(BorderFactory.createEmptyBorder());
        this.buttonLayout.setHgap(2);
        this.newButton.setActionCommand(NEW_CMD);
        this.newButton.setEnabled(false);
        this.newButton.addActionListener(this.selMgr);
        this.addButton.setActionCommand(ADD_CMD);
        this.addButton.setEnabled(true);
        this.addButton.addActionListener(this.selMgr);
        this.removeButton.setActionCommand(REMOVE_CMD);
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(this.selMgr);
        this.splitPane.setBorder(BorderFactory.createEmptyBorder());
        this.libsTreeScroller.setViewportView(this.libsTree);
        ResourceUtils.resButton((AbstractButton)this.newButton, (String)LibraryArb.getString(5));
        ResourceUtils.resButton((AbstractButton)this.addButton, (String)LibraryArb.getString(6));
        ResourceUtils.resButton((AbstractButton)this.removeButton, (String)LibraryArb.getString(7));
        this.buttonPanel.add((Component)this.newButton, null);
        this.buttonPanel.add((Component)this.addButton, null);
        this.buttonPanel.add((Component)this.removeButton, null);
        this.masterPanel.add((Component)this.libsTreeScroller, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.masterPanel.add((Component)this.buttonPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.splitPane.add((Component)this.masterPanel, "left");
        this.add((Component)this.splitPane, "jSplitPane1");
    }

    public final boolean isSplit() {
        return this.isSplit;
    }

    public void setSplit(boolean bl) {
        if (this.isSplit == bl) {
            return;
        }
        this.isSplit = bl;
        if (this.isSplit) {
            this.remove(this.masterPanel);
            this.splitPane.add((Component)this.masterPanel, "left");
            this.splitPane.add((Component)this.detailPanel, "right");
            this.add((Component)this.splitPane, "jSplitPane1");
            this.libsTree.getSelectionModel().setSelectionMode(1);
        } else {
            this.remove(this.splitPane);
            this.add((Component)this.masterPanel, "masterPanel");
            this.libsTree.getSelectionModel().setSelectionMode(4);
        }
    }

    public void setSelectionMode(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 4: {
                this.libsTree.getSelectionModel().setSelectionMode(n);
            }
        }
    }

    public final void initPanel(ListWrapper[] listWrapperArray, Object object) {
        TreePath treePath;
        this.initPanel(listWrapperArray);
        TreeNode treeNode = this.findNode(null, object);
        if (treeNode != null && (treePath = new TreePath(this.libsModel.getPathToRoot(treeNode))) != null) {
            this.libsTree.setSelectionPath(treePath);
            this.libsTree.scrollPathToVisible(treePath);
        }
    }

    public void initPanel(ListWrapper[] listWrapperArray) {
        this.libsModel = this.createTreeModel(listWrapperArray);
        this.libsTree.setModel(this.libsModel);
        int n = listWrapperArray.length - 1;
        while (n >= 0) {
            this.libsTree.expandRow(n);
            --n;
        }
        TreeNode treeNode = (TreeNode)this.libsModel.getRoot();
        int n2 = treeNode.getChildCount();
        int n3 = 0;
        while (n3 < n2) {
            TreeNode treeNode2 = treeNode.getChildAt(n3);
            if (treeNode2.getChildCount() > 0) {
                TreePath treePath = new TreePath(((DefaultMutableTreeNode)treeNode2.getChildAt(0)).getPath());
                this.libsTree.setSelectionPath(treePath);
                return;
            }
            ++n3;
        }
        if (n2 > 0) {
            this.libsTree.setSelectionRow(0);
        }
        this.libsTree.requestFocus();
    }

    public final ListWrapper[] getLibraryLists() {
        TreeNode treeNode = (TreeNode)this.libsModel.getRoot();
        ListWrapper[] listWrapperArray = new ListWrapper[treeNode.getChildCount()];
        int n = 0;
        while (n < listWrapperArray.length) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeNode.getChildAt(n);
            listWrapperArray[n] = (ListWrapper)defaultMutableTreeNode.getUserObject();
            ++n;
        }
        return listWrapperArray;
    }

    public final void addTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
        this.libsTree.addTreeSelectionListener(treeSelectionListener);
    }

    protected abstract DefaultTreeModel createTreeModel(ListWrapper[] var1);

    protected final DefaultTreeModel getTreeModel() {
        return this.libsModel;
    }

    public boolean commitChanges() {
        return true;
    }

    public Library[] getSelection() {
        return SelectionManager.mav$_getElements(this.selMgr, SelectionManager.ra$selPaths(this.selMgr));
    }

    protected final void setLeafIcon(Icon icon) {
        this.libsTreeRenderer.setLeafIcon(icon);
    }

    protected final void setDetailPanel(JComponent jComponent, String string) {
        this.detailPanel = jComponent;
        this.detailTitle = string;
        this.splitPane.add((Component)this.detailPanel, "right");
    }

    protected void selectNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        TreePath treePath = new TreePath(defaultMutableTreeNode.getPath());
        SwingUtilities.invokeLater(new 1(this, treePath));
    }

    protected TreeNode findNode(TreeNode treeNode, Object object) {
        if (treeNode == null) {
            treeNode = (TreeNode)this.libsModel.getRoot();
        }
        return TreePanel._findMatch(treeNode, object);
    }

    protected static TreeNode _findMatch(TreeNode treeNode, Object object) {
        TreeNode treeNode2 = null;
        Object object2 = ((DefaultMutableTreeNode)treeNode).getUserObject();
        if (object2 != null && object != null && object2.equals(object)) {
            treeNode2 = treeNode;
        } else if (treeNode.getAllowsChildren()) {
            int n = treeNode.getChildCount();
            int n2 = 0;
            while (n2 < n) {
                treeNode2 = TreePanel._findMatch(treeNode.getChildAt(n2), object);
                if (treeNode2 != null) break;
                ++n2;
            }
        }
        return treeNode2;
    }

    private void _updateButtons(DefaultMutableTreeNode[] defaultMutableTreeNodeArray) {
        boolean bl = true;
        boolean bl2 = true;
        if (defaultMutableTreeNodeArray != null && defaultMutableTreeNodeArray.length > 0) {
            int n = 0;
            int n2 = 0;
            boolean bl3 = true;
            ListNode listNode = null;
            int n3 = 0;
            while (n3 < defaultMutableTreeNodeArray.length) {
                if (defaultMutableTreeNodeArray[n3] instanceof LeafNode) {
                    ++n;
                    if (listNode == null) {
                        listNode = (ListNode)defaultMutableTreeNodeArray[n3].getParent();
                    } else if (listNode != defaultMutableTreeNodeArray[n3].getParent()) {
                        bl3 = false;
                        listNode = (ListNode)defaultMutableTreeNodeArray[n3].getParent();
                    }
                    bl2 = bl2 && n2 == 0 && this._canListChange(listNode);
                } else if (defaultMutableTreeNodeArray[n3] instanceof ListNode) {
                    listNode = (ListNode)defaultMutableTreeNodeArray[n3];
                    ++n2;
                    bl2 = bl2 && n == 0 && listNode.getList().getWrappedList() != JLibraryManager.getUserLibraries() && listNode.getList().getWrappedList() instanceof JLibraryList;
                } else {
                    bl2 = false;
                }
                ++n3;
            }
        } else {
            bl2 = false;
        }
        this.newButton.setEnabled(bl);
        this.removeButton.setEnabled(bl2);
    }

    private boolean _canListChange(ListNode listNode) {
        ListWrapper listWrapper = listNode.getList();
        return listWrapper.isTransient() ^ true;
    }

    protected abstract boolean updateSelection(Library var1);

    protected abstract Library createNewElement(ListWrapper[] var1);

    protected abstract ListNode addLibraryList(ListWrapper var1);

    protected abstract void nodeDeleted(LeafNode var1);

    static JTree ra$libsTree(TreePanel treePanel) {
        return treePanel.libsTree;
    }

    static DefaultTreeModel ra$libsModel(TreePanel treePanel) {
        return treePanel.libsModel;
    }

    static URL ra$defDir() {
        return defDir;
    }

    static void wa$defDir(URL uRL) {
        defDir = uRL;
    }

    static boolean ra$isSplit(TreePanel treePanel) {
        return treePanel.isSplit;
    }

    static JButton ra$removeButton(TreePanel treePanel) {
        return treePanel.removeButton;
    }

    static void mav$_updateButtons(TreePanel treePanel, DefaultMutableTreeNode[] defaultMutableTreeNodeArray) {
        treePanel._updateButtons(defaultMutableTreeNodeArray);
    }

    public final class 1
    implements Runnable {
        private final /* synthetic */ TreePath v$path;
        final /* synthetic */ TreePanel this$0;

        public void run() {
            TreePanel.ra$libsTree(this.this$0).setSelectionPath(this.v$path);
            TreePanel.ra$libsTree(this.this$0).scrollPathToVisible(this.v$path);
        }

        public 1(TreePanel treePanel, TreePath treePath) {
            this.v$path = treePath;
            this.this$0 = treePanel;
        }
    }

    private final class SelectionManager
    extends KeyAdapter
    implements TreeSelectionListener,
    ActionListener {
        private TreePath[] selPaths;

        private Library[] _getElements(TreePath[] treePathArray) {
            if (treePathArray == null || treePathArray.length == 0) {
                return null;
            }
            ArrayList<Library> arrayList = new ArrayList<Library>();
            int n = 0;
            while (n < treePathArray.length) {
                DefaultMutableTreeNode defaultMutableTreeNode;
                DefaultMutableTreeNode defaultMutableTreeNode2 = defaultMutableTreeNode = treePathArray[n] != null ? (DefaultMutableTreeNode)treePathArray[n].getLastPathComponent() : null;
                if (defaultMutableTreeNode instanceof LeafNode) {
                    arrayList.add((Library)defaultMutableTreeNode.getUserObject());
                }
                ++n;
            }
            if (arrayList.size() > 0) {
                return arrayList.toArray(new Library[arrayList.size()]);
            }
            return null;
        }

        public final void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (TreePanel.NEW_CMD.equals(string)) {
                this.createLibrary();
            } else if (TreePanel.ADD_CMD.equals(string)) {
                this.addDirectory();
            } else if (TreePanel.REMOVE_CMD.equals(string)) {
                this.deleteSelection();
            }
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            Library[] libraryArray = null;
            TreePath[] treePathArray = TreePanel.ra$libsTree(TreePanel.this).getSelectionPaths();
            DefaultMutableTreeNode[] defaultMutableTreeNodeArray = null;
            if (treePathArray != null) {
                defaultMutableTreeNodeArray = new DefaultMutableTreeNode[treePathArray.length];
                int n = 0;
                while (n < treePathArray.length) {
                    defaultMutableTreeNodeArray[n] = (DefaultMutableTreeNode)treePathArray[n].getLastPathComponent();
                    ++n;
                }
                libraryArray = this._getElements(treePathArray);
            }
            TreePanel.mav$_updateButtons(TreePanel.this, defaultMutableTreeNodeArray);
            if (!TreePanel.this.updateSelection(libraryArray != null && libraryArray.length > 0 ? libraryArray[0] : null)) {
                SwingUtilities.invokeLater(new 1());
            } else {
                this.selPaths = treePathArray;
            }
        }

        public void keyTyped(KeyEvent keyEvent) {
            if (keyEvent.getKeyChar() == '\u007f') {
                if (TreePanel.ra$removeButton(TreePanel.this).isEnabled()) {
                    this.deleteSelection();
                }
                keyEvent.consume();
            }
        }

        private void createLibrary() {
            ListWrapper[] listWrapperArray;
            Library library;
            boolean bl;
            TreePath[] treePathArray = TreePanel.ra$libsTree(TreePanel.this).getSelectionPaths();
            Object object = treePathArray != null && treePathArray.length > 0 ? treePathArray[0].getLastPathComponent() : null;
            ListNode listNode = null;
            if (object instanceof ListNode) {
                listNode = (ListNode)object;
            } else if (object instanceof LeafNode) {
                listNode = (ListNode)((LeafNode)object).getParent();
            }
            boolean bl2 = bl = TreePanel.ra$isSplit(TreePanel.this) ? TreePanel.this.commitChanges() : true;
            if (bl && (library = TreePanel.this.createNewElement(listWrapperArray = new ListWrapper[]{listNode != null ? listNode.getList() : null})) != null) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)TreePanel.this.findNode(null, library);
                if (defaultMutableTreeNode != null) {
                    defaultMutableTreeNode.setUserObject(library);
                    TreePanel.ra$libsModel(TreePanel.this).nodeChanged(defaultMutableTreeNode);
                } else {
                    ListNode listNode2 = (ListNode)TreePanel.this.findNode(null, listWrapperArray[0]);
                    if (listNode2 != null) {
                        listNode = listNode2;
                    }
                    defaultMutableTreeNode = (DefaultMutableTreeNode)listNode.add(library);
                    TreePanel.ra$libsModel(TreePanel.this).nodesWereInserted(listNode, new int[]{listNode.getIndex(defaultMutableTreeNode)});
                }
                TreePanel.this.selectNode(defaultMutableTreeNode);
            }
        }

        private void addDirectory() {
            URL uRL;
            URLChooser uRLChooser = DialogUtil.newURLChooser((URL)TreePanel.ra$defDir());
            uRLChooser.setSelectionMode(0);
            uRLChooser.setSelectionScope(1);
            uRLChooser.setShowJarsAsDirs(false);
            int n = uRLChooser.showOpenDialog((Component)TreePanel.this, LibraryArb.getString(81));
            if (n == 0 && (uRL = uRLChooser.getSelectedURL()) != null) {
                JLibraryList jLibraryList = JLibraryManager.addLibraryList(uRL);
                ListWrapper[] listWrapperArray = TreePanel.this.getLibraryLists();
                boolean bl = false;
                if (listWrapperArray != null) {
                    int n2 = 0;
                    while (n2 < listWrapperArray.length) {
                        if (jLibraryList == listWrapperArray[n2]) {
                            bl = true;
                        }
                        ++n2;
                    }
                }
                if (!bl) {
                    ListWrapper listWrapper = new ListWrapper(jLibraryList);
                    ListNode listNode = TreePanel.this.addLibraryList(listWrapper);
                    TreePath treePath = new TreePath(listNode.getPath());
                    TreePanel.wa$defDir(URLFileSystem.getParent((URL)uRL));
                    TreePanel.ra$libsTree(TreePanel.this).expandPath(treePath);
                    TreePanel.this.selectNode(listNode);
                }
            }
        }

        private void deleteSelection() {
            TreePath[] treePathArray = TreePanel.ra$libsTree(TreePanel.this).getSelectionPaths();
            if (treePathArray == null) {
                return;
            }
            HashMap<ListWrapper, ArrayList<Library>> hashMap = new HashMap<ListWrapper, ArrayList<Library>>();
            int n = 0;
            while (n < treePathArray.length) {
                Object object = treePathArray[n].getLastPathComponent();
                if (object instanceof ListNode) {
                    ListNode listNode = (ListNode)object;
                    ListWrapper listWrapper = listNode.getList();
                    JLibraryManager.removeLibraryList(listWrapper.getWrappedList());
                    TreePanel.ra$libsModel(TreePanel.this).removeNodeFromParent(listNode);
                } else if (object instanceof LeafNode) {
                    LeafNode leafNode = (LeafNode)object;
                    ListNode listNode = (ListNode)leafNode.getParent();
                    Library library = (Library)leafNode.getUserObject();
                    ListWrapper listWrapper = listNode.getList();
                    ArrayList<Library> arrayList = (ArrayList<Library>)hashMap.get(listWrapper);
                    if (arrayList == null) {
                        arrayList = new ArrayList<Library>();
                        hashMap.put(listWrapper, arrayList);
                    }
                    arrayList.add(library);
                }
                ++n;
            }
            if (!hashMap.isEmpty()) {
                CheckBoxListModel checkBoxListModel = new CheckBoxListModel();
                Iterator iterator = hashMap.keySet().iterator();
                ArrayList<Library> arrayList = new ArrayList<Library>();
                while (iterator.hasNext()) {
                    Object k = iterator.next();
                    ArrayList arrayList2 = (ArrayList)hashMap.get(k);
                    int n2 = arrayList2.size() - 1;
                    while (n2 >= 0) {
                        Library library = (Library)arrayList2.get(n2);
                        Object object = library.getID();
                        String string = object instanceof URL ? URLFileSystem.getPlatformPathName((URL)((URL)object)) : object.toString();
                        checkBoxListModel.addElement((Object)library, library.getIcon(), true, true, string);
                        --n2;
                    }
                }
                int n3 = checkBoxListModel.getSize();
                if (n3 > 0) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Library library = (Library)checkBoxListModel.getUserObjectAt(0);
                    String string = LibraryArb.format(78, new String[]{library instanceof JDK ? LibraryArb.getString(73) : LibraryArb.getString(71)});
                    if (library instanceof JDK) {
                        Object[] objectArray3 = new String[2];
                        objectArray3[0] = LibraryArb.getString(73);
                        objectArray2 = objectArray3;
                        objectArray3[1] = checkBoxListModel.findTextForElement(0);
                    } else {
                        String[] stringArray = new String[2];
                        stringArray[0] = LibraryArb.getString(71);
                        objectArray2 = stringArray;
                        stringArray[1] = checkBoxListModel.findTextForElement(0);
                    }
                    String string2 = LibraryArb.format(79, objectArray2);
                    if (library instanceof JDK) {
                        Object[] objectArray4 = new String[1];
                        objectArray = objectArray4;
                        objectArray4[0] = LibraryArb.getString(73);
                    } else {
                        String[] stringArray = new String[1];
                        objectArray = stringArray;
                        stringArray[0] = LibraryArb.getString(72);
                    }
                    if (SelectFilesPanel.showDialog((String)string, (String)string2, (String)LibraryArb.format(80, objectArray), (CheckBoxListModel)checkBoxListModel, (boolean)true, (int)0, null) == 0) {
                        int n4 = 0;
                        while (n4 < n3) {
                            if (checkBoxListModel.isElementSelected(n4)) {
                                library = (Library)checkBoxListModel.getUserObjectAt(n4);
                                arrayList.add(library);
                            }
                            ++n4;
                        }
                        int n5 = arrayList.size() - 1;
                        while (n5 >= 0) {
                            library = (Library)arrayList.get(n5);
                            LeafNode leafNode = (LeafNode)TreePanel.this.findNode(null, library);
                            ListNode listNode = (ListNode)leafNode.getParent();
                            ListWrapper listWrapper = listNode.getList();
                            listWrapper.remove(library);
                            TreePanel.ra$libsModel(TreePanel.this).removeNodeFromParent(leafNode);
                            --n5;
                        }
                    }
                }
            }
        }

        private SelectionManager() {
        }

        static TreePath[] ra$selPaths(SelectionManager selectionManager) {
            return selectionManager.selPaths;
        }

        static Library[] mav$_getElements(SelectionManager selectionManager, TreePath[] treePathArray) {
            return selectionManager._getElements(treePathArray);
        }

        SelectionManager(1 var2_2) {
            this();
        }

        public final class 1
        implements Runnable {
            public void run() {
                if (SelectionManager.ra$selPaths(SelectionManager.this) != null && SelectionManager.ra$selPaths(SelectionManager.this).length > 0) {
                    TreePanel.ra$libsTree(TreePanel.this).setSelectionPaths(SelectionManager.ra$selPaths(SelectionManager.this));
                }
            }
        }
    }

    private static final class Renderer
    extends DefaultTreeCellRenderer {
        public Renderer() {
            this.setOpenIcon(IdeArb.getIcon((int)55));
            this.setClosedIcon(IdeIcons.getIcon((int)4));
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            JLabel jLabel = (JLabel)super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            Object object2 = ((DefaultMutableTreeNode)object).getUserObject();
            if (object2 instanceof Displayable) {
                Displayable displayable = (Displayable)object2;
                if (object2 instanceof Node && !((Node)object2).isOpen()) {
                    try {
                        ((Node)object2).open();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
                this.setText(displayable.getShortLabel());
                this.setToolTipText(displayable.getToolTipText());
                if (object2 instanceof Library) {
                    this.setIcon(this.getIcon((Library)object2));
                } else if (bl2) {
                    this.setIcon(this.getOpenIcon());
                } else {
                    this.setIcon(this.getClosedIcon());
                }
            } else if (object2 != null) {
                this.setToolTipText(object2.toString());
                if (bl3) {
                    this.setIcon(this.getLeafIcon());
                } else if (bl2) {
                    this.setIcon(this.getOpenIcon());
                } else {
                    this.setIcon(this.getClosedIcon());
                }
            }
            return jLabel;
        }

        private Icon getIcon(Library library) {
            URLPath uRLPath = library.getClassPath();
            if (!(uRLPath != null && uRLPath.size() != 0 || (uRLPath = library.getSourcePath()) != null && uRLPath.size() != 0 || (uRLPath = library.getDocPath()) != null && uRLPath.size() != 0)) {
                this.setForeground(Color.red);
                return LibraryArb.getIcon(65);
            }
            return library.getIcon();
        }
    }
}

