/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.model;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.config.DocumentExtensions;
import oracle.ide.config.IdeSettings;
import oracle.ide.controls.checkboxlist.CheckBoxList;
import oracle.ide.controls.checkboxlist.CheckBoxListItemStateListener;
import oracle.ide.controls.checkboxlist.CheckBoxListModel;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.help.HelpSystem;
import oracle.ide.net.WildcardURLFilter;
import oracle.ide.util.PatternFilters;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.dialogs.JDevDialogHeader;
import oracle.jdeveloper.resource.ModelArb;

public class FilesPatternFilterPanel
extends JPanel
implements DocumentListener,
CheckBoxListItemStateListener,
ActionListener {
    private GridBagLayout gridBagLayout1;
    private JLabel lblFileTypes;
    private JRadioButton rbShow;
    private JRadioButton rbHide;
    private CheckBoxListModel fileListModel;
    private CheckBoxList fileList;
    private JScrollPane listScroller;
    private JCheckBox checkSubdirectories;
    private JPanel buttonPanel;
    private JButton btnSelectAll;
    private JButton btnDeselectAll;
    private JLabel lblMoreFilters;
    private JLabel lblMoreFiltersHint;
    private JTextField txtMoreFilters;
    private JDevDialogHeader dlgHeader;
    private JEWTDialog dialog;
    private static boolean recurse = true;
    private static boolean show = false;
    private static final String HELP_TOPIC = "f1_idedaddfilefilter_html";

    void $init$() {
        this.gridBagLayout1 = new GridBagLayout();
        this.lblFileTypes = new JLabel();
        this.rbShow = new JRadioButton();
        this.rbHide = new JRadioButton();
        this.fileListModel = new CheckBoxListModel();
        this.fileList = new CheckBoxList();
        this.listScroller = new JScrollPane();
        this.checkSubdirectories = new JCheckBox();
        this.buttonPanel = new JPanel();
        this.btnSelectAll = new JButton();
        this.btnDeselectAll = new JButton();
        this.lblMoreFilters = new JLabel();
        this.lblMoreFiltersHint = new JLabel();
        this.txtMoreFilters = new JTextField();
    }

    public FilesPatternFilterPanel() {
        this.$init$();
        try {
            this.initializeUI();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean showDialog(Component component, PatternFilters patternFilters, String string) {
        String string2 = string;
        if (string.endsWith("/")) {
            string2 = string.substring(0, string.length() - 1);
        } else if (string2.length() == 0) {
            string2 = ModelArb.getString(76);
        }
        ResourceUtils.resButton((AbstractButton)this.checkSubdirectories, (String)ModelArb.format(87, string2));
        this.initFileListModel();
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, HELP_TOPIC);
        this.dialog = DialogUtil.createJEWTDialogOwnedBy((Component)component);
        if (this.dialog == null) {
            return false;
        }
        this.dialog.setDialogHeader((Component)this.getDialogHeader());
        this.dialog.setContent((Component)this);
        this.dialog.setOKButtonEnabled(false);
        this.dialog.setInitialFocus((Component)this.fileList);
        this.dialog.setTitle(ModelArb.getString(77));
        this.dialog.setButtonMask(7);
        this.dialog.setResizable(true);
        this.dialog.pack();
        if (this.dialog.runDialog()) {
            this.commitTo(patternFilters, string);
            return true;
        }
        this.dialog.dispose();
        this.dialog = null;
        return false;
    }

    private void commitTo(PatternFilters patternFilters, String string) {
        String string2;
        String string3;
        String string4 = "**/";
        if (string.length() > 0 && !string.endsWith("/")) {
            string = string + "/";
        }
        boolean bl = this.checkSubdirectories.isSelected();
        boolean bl2 = this.rbShow.isSelected();
        List list = this.fileListModel.getSelectionList();
        if (list != null) {
            for (TextPair textPair : list) {
                String string5 = textPair.toString();
                String string6 = string3 = bl ? string + string4 + string5 : string + string5;
                if (bl2) {
                    patternFilters.addInclude(string3);
                    continue;
                }
                patternFilters.addExclude(string3);
            }
        }
        if ((string2 = this.txtMoreFilters.getText()).length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ";");
            while (stringTokenizer.hasMoreTokens()) {
                String string7 = stringTokenizer.nextToken();
                String string8 = string3 = recurse ? string + string4 + string7 : string + string7;
                if (bl2) {
                    patternFilters.addInclude(string3);
                    continue;
                }
                patternFilters.addExclude(string3);
            }
        }
        show = bl2;
        recurse = bl;
    }

    private JDevDialogHeader getDialogHeader() {
        if (this.dlgHeader == null) {
            this.dlgHeader = new JDevDialogHeader();
            this.dlgHeader.setHeaderTitle(ModelArb.getString(78));
            this.dlgHeader.setHeaderDescription(ModelArb.getString(79));
        }
        return this.dlgHeader;
    }

    private void initializeUI() throws Exception {
        ResourceUtils.resButton((AbstractButton)this.rbShow, (String)ModelArb.getString(81));
        ResourceUtils.resButton((AbstractButton)this.rbHide, (String)ModelArb.getString(82));
        ResourceUtils.resLabel((JLabel)this.lblFileTypes, (Component)this.fileList, (String)ModelArb.getString(80));
        ResourceUtils.resLabel((JLabel)this.lblMoreFilters, (Component)this.txtMoreFilters, (String)ModelArb.getString(83));
        ResourceUtils.resLabel((JLabel)this.lblMoreFiltersHint, (Component)this.txtMoreFilters, (String)ModelArb.getString(84));
        ResourceUtils.resButton((AbstractButton)this.checkSubdirectories, (String)ModelArb.getString(73));
        ResourceUtils.resButton((AbstractButton)this.btnSelectAll, (String)ModelArb.getString(85));
        ResourceUtils.resButton((AbstractButton)this.btnDeselectAll, (String)ModelArb.getString(86));
        this.btnSelectAll.addActionListener(this);
        this.btnDeselectAll.addActionListener(this);
        this.txtMoreFilters.getDocument().addDocumentListener(this);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.rbShow);
        buttonGroup.add(this.rbHide);
        if (show) {
            this.rbShow.setSelected(true);
        } else {
            this.rbHide.setSelected(true);
        }
        this.checkSubdirectories.setSelected(recurse);
        this.fileList.setModel((ListModel)this.fileListModel);
        this.listScroller.getViewport().add((Component)this.fileList, null);
        this.buttonPanel.setLayout(new GridLayout(1, 2, 8, 8));
        this.buttonPanel.add(this.btnSelectAll);
        this.buttonPanel.add(this.btnDeselectAll);
        this.setLayout(this.gridBagLayout1);
        int n = -1;
        int n2 = 10;
        Insets insets = new Insets(0, 0, 0, 0);
        Insets insets2 = new Insets(10, 0, 0, 0);
        Insets insets3 = new Insets(3, 0, 0, 0);
        Insets insets4 = new Insets(8, 30, 0, 0);
        this.add((Component)this.rbShow, new GridBagConstraints(1, -1, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)this.rbHide, new GridBagConstraints(2, -1, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)this.lblFileTypes, new GridBagConstraints(1, -1, 1, 1, 0.0, 0.0, 17, 0, insets2, 0, 0));
        this.add((Component)this.listScroller, new GridBagConstraints(1, -1, 2, 1, 1.0, 1.0, 17, 1, insets3, 0, 0));
        this.add((Component)this.buttonPanel, new GridBagConstraints(1, -1, 2, 1, 0.0, 0.0, 13, 0, insets4, 0, 0));
        this.add((Component)this.lblMoreFilters, new GridBagConstraints(1, -1, 2, 1, 0.0, 0.0, 17, 0, insets2, 0, 0));
        this.add((Component)this.txtMoreFilters, new GridBagConstraints(1, -1, 2, 1, 0.0, 0.0, 17, 2, insets3, 0, 0));
        this.add((Component)this.lblMoreFiltersHint, new GridBagConstraints(1, -1, 2, 1, 0.0, 0.0, 17, 2, insets3, 0, 0));
        this.add((Component)this.checkSubdirectories, new GridBagConstraints(1, -1, 2, 1, 0.0, 0.0, 17, 0, insets2, 0, 0));
    }

    private void initFileListModel() {
        if (this.fileListModel.getSize() > 0) {
            return;
        }
        IdeSettings ideSettings = Ide.getSettings();
        DocumentExtensions documentExtensions = (DocumentExtensions)ideSettings.getData("document-extensions-options");
        ArrayList<String> arrayList = new ArrayList<String>(25);
        Collection collection = documentExtensions.getDocuments();
        for (DocumentExtensions.DocRecord docRecord : collection) {
            List list = docRecord.getExtensions();
            int n = list.size();
            int n2 = 0;
            while (n2 < n) {
                DocumentExtensions.ExtInfo extInfo = (DocumentExtensions.ExtInfo)list.get(n2);
                String string = extInfo.getExtension();
                if (!arrayList.contains(string)) {
                    arrayList.add(string);
                    TextPair textPair = new TextPair(string);
                    this.fileListModel.addElement((Object)textPair, null, true, false);
                }
                ++n2;
            }
        }
        this.fileListModel.sort();
        this.fileListModel.addCheckBoxStateListener((CheckBoxListItemStateListener)this);
    }

    private void enableOkButton() {
        if (this.dialog != null) {
            boolean bl = this.txtMoreFilters.getText().length() > 0;
            this.dialog.setOKButtonEnabled(bl || this.hasFileSelection());
        }
    }

    private synchronized boolean hasFileSelection() {
        boolean bl = false;
        int n = this.fileListModel.getSize();
        int n2 = 0;
        while (n2 < n) {
            if (this.fileListModel.isElementSelected(n2)) {
                bl = true;
                break;
            }
            ++n2;
        }
        return bl;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.btnSelectAll) {
            this.fileListModel.selectAll();
            this.fileList.repaint();
        } else if (object == this.btnDeselectAll) {
            this.fileListModel.deselectAll();
            this.fileList.repaint();
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.enableOkButton();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.enableOkButton();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public void stateChanged(Object object) {
        this.enableOkButton();
    }

    private static class TextPair {
        String _filterText;
        String _displayText;

        public TextPair(String string) {
            this._filterText = string;
        }

        public String getFilterText() {
            return this._filterText;
        }

        public void setFilterText(String string) {
            this._filterText = string;
        }

        public String toString() {
            if (this._displayText == null) {
                this.parseFilterText();
            }
            return this._displayText;
        }

        private void parseFilterText() {
            if (this._filterText.startsWith("*.") && !WildcardURLFilter.hasWildcard((String)this._filterText.substring(2))) {
                this._displayText = this._filterText;
                this.setFilterText(this._filterText.substring(1));
            } else {
                this._displayText = this._filterText.startsWith(".") && !WildcardURLFilter.hasWildcard((String)this._filterText) ? "*" + this._filterText : this._filterText;
            }
        }
    }
}

