/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.model;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.ide.controls.GridBagConstants;
import oracle.ide.controls.KeyNavigationManager;
import oracle.ide.controls.WaitCursor;
import oracle.ide.controls.tree.CustomJTree;
import oracle.ide.controls.tree.JMutableTreeNode;
import oracle.ide.controls.tree.JTreeCellData;
import oracle.ide.controls.tree.TreeCellCheckedEvent;
import oracle.ide.controls.tree.TreeCellCheckedListener;
import oracle.ide.model.ContentLevel;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.Namespace;
import oracle.ide.util.PatternFilters;
import oracle.ide.util.ResourceUtils;
import oracle.ide.util.SwingWorker;
import oracle.ide.util.TriStateBoolean;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.resource.ModelArb;
import oracle.jdevimpl.deploy.ProfileDeployer;
import oracle.jdevimpl.model.DirectoriesPatternFilterPanel;
import oracle.jdevimpl.model.FilesPatternFilterPanel;
import oracle.jdevimpl.model.WorkingSetsEditor;

public class PatternFiltersTreePanel
extends DefaultTraversablePanel
implements TreeCellCheckedListener,
TreeWillExpandListener,
GridBagConstants,
ActionListener {
    private final JScrollPane _spFiles;
    private final JMutableTreeNode _root;
    private final DefaultTreeModel _treeModel;
    private final FileURLComparator _urlComparator;
    protected final JButton _btnFilterFiles;
    protected final JButton _btnFilterDirectories;
    protected JPanel _buttonPanel;
    protected CustomJTree _dirTree;
    private KeyNavigationManager keyMgr;
    private PatternFilters _filters;
    protected ContentLevelNode _rootNode;
    private transient ContentLevel _contentLevel;
    private static final String CONTENT_LEVEL = "content-level-data";
    protected String _rootNodeLabel;

    void $init$() {
        this._spFiles = new JScrollPane();
        this._root = new JMutableTreeNode();
        this._treeModel = new DefaultTreeModel((TreeNode)this._root, true);
        this._urlComparator = new FileURLComparator(null);
        this._btnFilterFiles = new JButton();
        this._btnFilterDirectories = new JButton();
        this._rootNodeLabel = ModelArb.getString(76);
    }

    public PatternFiltersTreePanel() {
        this.$init$();
        this.createTree();
        this._btnFilterFiles.addActionListener(this);
        ResourceUtils.resButton((AbstractButton)this._btnFilterFiles, (String)ModelArb.getString(74));
        this._btnFilterDirectories.addActionListener(this);
        ResourceUtils.resButton((AbstractButton)this._btnFilterDirectories, (String)ModelArb.getString(75));
        this._spFiles.getViewport().add((Component)this._dirTree, null);
        this._dirTree.setRootVisible(false);
        this._dirTree.addTreeCellCheckedListener((TreeCellCheckedListener)this);
        this._dirTree.addTreeWillExpandListener((TreeWillExpandListener)this);
        this._dirTree.enableToolTips(true);
        this.setLayout(new GridBagLayout());
        Insets insets = new Insets(5, 5, 0, 5);
        Insets insets2 = new Insets(8, 3, 5, 5);
        this.add(this._spFiles, this.gbc(0, 0, 1, 1, 1.0, 1.0, 18, 1, insets));
        this._buttonPanel = new JPanel(new GridLayout(1, 2, 8, 0));
        this.add(this._buttonPanel, this.gbc(0, 1, 1, 1, 0.0, 0.0, 14, 0, insets2));
        this._buttonPanel.add(this._btnFilterFiles);
        this._buttonPanel.add(this._btnFilterDirectories);
        this.setHelpID("f1_depfgpkgfilefilter_html");
    }

    public void onEntry(TraversableContext traversableContext) {
        Project project = (Project)traversableContext.find("Project");
        this._filters = WorkingSetsEditor.getPatternFilters((Namespace)traversableContext);
        if (this._filters != null) {
            if (this._rootNode != null && this._rootNode.isLoaded()) {
                this.updateCheckedStates(this._rootNode);
                return;
            }
            this._rootNode = new ContentLevelNode();
            PatternFilters patternFilters = PatternFilters.getInstance((HashStructure)HashStructure.newInstance());
            patternFilters.addInclude("**");
            ContentSet contentSet = ProjectContent.getInstance((PropertyStorage)project).getAllContents();
            this._contentLevel = ContentLevel.newInstanceForHideDirs((ContentSet)contentSet, (PatternFilters)patternFilters, (boolean)false);
            ContentLevel contentLevel = (ContentLevel)traversableContext.find(CONTENT_LEVEL);
            if (this._contentLevel != null && ModelUtil.areEqual((Object)this._contentLevel, (Object)contentLevel)) {
                this.updateCheckedStates(this._rootNode);
                return;
            }
            traversableContext.put(CONTENT_LEVEL, (Object)this._contentLevel);
            this._root.removeAllChildren();
            this._root.add((MutableTreeNode)((Object)this._rootNode));
            this._treeModel.nodeStructureChanged((TreeNode)this._root);
            this._dirTree.setVisible(true);
            this._dirTree.setEnabled(this._filters != null);
            String[] stringArray = (String[])traversableContext.find("initial-selection");
            this.initializeTreeSelection(stringArray);
            this.updateCheckedStates(this._rootNode);
        }
        boolean bl = false;
        if (this._filters != null && this._rootNode != null) {
            bl = true;
        }
        this._dirTree.setVisible(bl);
        this._btnFilterDirectories.setEnabled(bl);
        this._btnFilterFiles.setEnabled(bl);
    }

    public void onExit(TraversableContext traversableContext) {
    }

    public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) {
        TreePath treePath = treeExpansionEvent.getPath();
        ContentLevelNode contentLevelNode = (ContentLevelNode)((Object)treePath.getLastPathComponent());
        contentLevelNode.maybeLoad();
    }

    public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) {
    }

    public void cellChecked(TreeCellCheckedEvent treeCellCheckedEvent) {
        this.handleCheck(treeCellCheckedEvent, true);
    }

    public void cellUnchecked(TreeCellCheckedEvent treeCellCheckedEvent) {
        this.handleCheck(treeCellCheckedEvent, false);
    }

    private void handleCheck(TreeCellCheckedEvent treeCellCheckedEvent, boolean bl) {
        ContentLevelNode contentLevelNode = (ContentLevelNode)((Object)treeCellCheckedEvent.getSource());
        String string = ContentLevelNode.mav$isRootPath(contentLevelNode) ? "**" : contentLevelNode.getRelPath();
        if (string != null) {
            if (bl) {
                this._filters.addInclude(string, true);
            } else {
                this._filters.addExclude(string, true);
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        DirectoriesPatternFilterPanel directoriesPatternFilterPanel;
        JMutableTreeNode jMutableTreeNode = this.getNearestDirectory();
        String string = jMutableTreeNode.isRoot() ? "" : ((ContentLevelNode)jMutableTreeNode).getRelPath();
        Object object = actionEvent.getSource();
        if (object == this._btnFilterFiles) {
            FilesPatternFilterPanel filesPatternFilterPanel = new FilesPatternFilterPanel();
            if (filesPatternFilterPanel.showDialog((Component)((Object)this), this._filters, string)) {
                this.updateCheckedStates(this._rootNode);
                this._dirTree.repaint();
            }
        } else if (object == this._btnFilterDirectories && (directoriesPatternFilterPanel = new DirectoriesPatternFilterPanel()).showDialog((Component)((Object)this), this._filters, string)) {
            this.updateCheckedStates(this._rootNode);
            this._dirTree.repaint();
        }
    }

    private void initializeTreeSelection(String[] stringArray) {
        TreePath treePath;
        if (stringArray != null && stringArray.length > 0 && (treePath = this.convertPath(stringArray)) != null) {
            this._dirTree.expandPath(treePath);
            this._dirTree.setSelectionPath(treePath);
            this._dirTree.scrollPathToVisible(treePath);
            return;
        }
        IdeUtil.expandTreeToDepth((JTree)this._dirTree, (int)2);
    }

    private TreePath convertPath(String[] stringArray) {
        if (stringArray != null && stringArray.length > 0) {
            TreePath treePath = new TreePath(this._root);
            TreePath treePath2 = treePath.pathByAddingChild(this._root.getChildAt(0));
            return this.findPath(treePath2, stringArray, 0);
        }
        return null;
    }

    private TreePath findPath(TreePath treePath, String[] stringArray, int n) {
        ContentLevelNode contentLevelNode = (ContentLevelNode)((Object)treePath.getLastPathComponent());
        contentLevelNode.maybeLoad();
        int n2 = contentLevelNode.getChildCount();
        int n3 = 0;
        while (n3 < n2) {
            ContentLevelNode contentLevelNode2 = (ContentLevelNode)((Object)contentLevelNode.getChildAt(n3));
            if (ContentLevelNode.ra$_label(contentLevelNode2).equals(stringArray[n])) {
                TreePath treePath2 = treePath.pathByAddingChild((Object)contentLevelNode2);
                if (++n < stringArray.length) {
                    return this.findPath(treePath2, stringArray, n);
                }
                return treePath2;
            }
            ++n3;
        }
        return null;
    }

    private void createTree() {
        this._dirTree = new 1(this._treeModel);
        this.keyMgr = new KeyNavigationManager((KeyNavigationManager.KeyComponentAdapter)new KeyNavigationManager.TreeKeyAdapter((JTree)this._dirTree));
        this._dirTree.setExpandsSelectedPaths(true);
        this._dirTree.setScrollsOnExpand(true);
    }

    private void updateCheckedStates(ContentLevelNode contentLevelNode) {
        if (contentLevelNode == null) {
            return;
        }
        if (contentLevelNode.isLeaf()) {
            contentLevelNode.getModel().setCheckBoxState(this.isSelected(contentLevelNode.getRelPath()));
            return;
        }
        if (contentLevelNode.isLoaded()) {
            Enumeration enumeration = contentLevelNode.children();
            while (enumeration.hasMoreElements()) {
                ContentLevelNode contentLevelNode2 = (ContentLevelNode)((Object)enumeration.nextElement());
                if (contentLevelNode2 == null) continue;
                this.updateCheckedStates(contentLevelNode2);
            }
            contentLevelNode.updateNodes();
        } else {
            TriStateBoolean triStateBoolean = TriStateBoolean.FALSE;
            if (this._filters != null) {
                triStateBoolean = this._filters.inferFromFilters(contentLevelNode.getRelPath());
            }
            contentLevelNode.getModel().setCheckBoxState(triStateBoolean);
        }
    }

    private boolean isSelected(String string) {
        return this._filters != null ? this._filters.isIncluded(string) : false;
    }

    private TriStateBoolean isInitiallySelected(String string) {
        return this._filters != null ? this._filters.inferFromFilters(string) : TriStateBoolean.FALSE;
    }

    private static String getLabel(String string) {
        if (string != null) {
            if (string.endsWith("/")) {
                int n = string.lastIndexOf(47);
                if (n > 0) {
                    int n2 = string.lastIndexOf(47, n - 1);
                    return string.substring(n2 >= 0 ? n2 + 1 : 0, n);
                }
            } else {
                int n = string.lastIndexOf("/");
                if (n >= 0) {
                    return string.substring(n + 1);
                }
            }
        }
        return string;
    }

    private static JTreeCellData newJTreeCellData(ContentLevel contentLevel, String string) {
        String string2;
        JTreeCellData jTreeCellData = new JTreeCellData(string);
        if (contentLevel != null && ModelUtil.hasLength((String)(string2 = URLFileSystem.getPlatformPathName((URL)contentLevel.getDirectoryURL())))) {
            jTreeCellData.setToolTipText(string2);
        }
        return jTreeCellData;
    }

    private JMutableTreeNode getNearestDirectory() {
        JMutableTreeNode jMutableTreeNode = (JMutableTreeNode)this._dirTree.getLastSelectedPathComponent();
        if (jMutableTreeNode.isLeaf()) {
            return (JMutableTreeNode)jMutableTreeNode.getParent();
        }
        return jMutableTreeNode;
    }

    static KeyNavigationManager ra$keyMgr(PatternFiltersTreePanel patternFiltersTreePanel) {
        return patternFiltersTreePanel.keyMgr;
    }

    static JTreeCellData maS$newJTreeCellData(ContentLevel contentLevel, String string) {
        return PatternFiltersTreePanel.newJTreeCellData(contentLevel, string);
    }

    static TriStateBoolean mav$isInitiallySelected(PatternFiltersTreePanel patternFiltersTreePanel, String string) {
        return patternFiltersTreePanel.isInitiallySelected(string);
    }

    static String maS$getLabel(String string) {
        return PatternFiltersTreePanel.getLabel(string);
    }

    static DefaultTreeModel ra$_treeModel(PatternFiltersTreePanel patternFiltersTreePanel) {
        return patternFiltersTreePanel._treeModel;
    }

    static ContentLevel ra$_contentLevel(PatternFiltersTreePanel patternFiltersTreePanel) {
        return patternFiltersTreePanel._contentLevel;
    }

    static FileURLComparator ra$_urlComparator(PatternFiltersTreePanel patternFiltersTreePanel) {
        return patternFiltersTreePanel._urlComparator;
    }

    public final class 1
    extends CustomJTree {
        protected void processKeyEvent(KeyEvent keyEvent) {
            if (PatternFiltersTreePanel.ra$keyMgr(PatternFiltersTreePanel.this) != null) {
                PatternFiltersTreePanel.ra$keyMgr(PatternFiltersTreePanel.this).preProcessKeyEvent(keyEvent);
            }
            super.processKeyEvent(keyEvent);
            if (PatternFiltersTreePanel.ra$keyMgr(PatternFiltersTreePanel.this) != null) {
                PatternFiltersTreePanel.ra$keyMgr(PatternFiltersTreePanel.this).postProcessKeyEvent(keyEvent);
            }
        }

        public 1(TreeModel treeModel) {
            super(treeModel);
        }
    }

    private class ContentLevelNode
    extends JMutableTreeNode {
        private final ContentLevel _level;
        private final boolean _isLeaf;
        private final String _label;
        private final String _path;
        private boolean _isLoaded;

        ContentLevelNode() {
            this(null, patternFiltersTreePanel._rootNodeLabel, "");
        }

        ContentLevelNode(ContentLevel contentLevel) {
            this(contentLevel, PatternFiltersTreePanel.maS$getLabel(contentLevel.getRelPath()), contentLevel.getRelPath());
        }

        ContentLevelNode(String string) {
            this(null, PatternFiltersTreePanel.maS$getLabel(string), string);
        }

        private ContentLevelNode(ContentLevel contentLevel, String string, String string2) {
            super(PatternFiltersTreePanel.maS$newJTreeCellData(contentLevel, string));
            this._level = contentLevel;
            this._label = string;
            this._path = string2;
            this._isLeaf = this._level == null && !this.isRootPath();
            this._treeCellData.setIcon(this._isLeaf ? UIManager.getIcon("FileView.fileIcon") : UIManager.getIcon("FileView.directoryIcon"));
            this._treeCellData.setCheckBoxState(PatternFiltersTreePanel.mav$isInitiallySelected(PatternFiltersTreePanel.this, this.getRelPath()));
            this._treeCellData.setHasCheckBox(true);
        }

        private boolean isRootPath() {
            return "".equals(this._path);
        }

        public String getRelPath() {
            return this._path;
        }

        public boolean getAllowsChildren() {
            return this._isLeaf ^ true;
        }

        public boolean isLeaf() {
            return this._isLeaf;
        }

        boolean isLoaded() {
            return this._isLoaded;
        }

        void maybeLoad() {
            if (this._isLoaded || this._level == null && !this.isRootPath()) {
                return;
            }
            WaitCursor waitCursor = new WaitCursor((Component)((Object)PatternFiltersTreePanel.this));
            1 var2_2 = new 1(this, waitCursor);
            waitCursor.show(400L);
            this._isLoaded = true;
            var2_2.construct();
            var2_2.finished();
        }

        public String toString() {
            return this._label;
        }

        static String ra$_label(ContentLevelNode contentLevelNode) {
            return contentLevelNode._label;
        }

        static boolean mav$isRootPath(ContentLevelNode contentLevelNode) {
            return contentLevelNode.isRootPath();
        }

        static ContentLevel ra$_level(ContentLevelNode contentLevelNode) {
            return contentLevelNode._level;
        }

        public final class 1
        extends SwingWorker {
            private URL[] _files;
            private String[] _folders;
            private ContentLevel contentLevel;
            private final /* synthetic */ WaitCursor v$waitCursor;
            final /* synthetic */ ContentLevelNode this$0;

            public Object construct() {
                URLPath uRLPath;
                if (ContentLevelNode.mav$isRootPath(this.this$0)) {
                    uRLPath = ProfileDeployer.stripRegularFiles((URLPath)PatternFiltersTreePanel.ra$_contentLevel(this.this$0.PatternFiltersTreePanel.this).getDirectoryURLPath());
                    this.contentLevel = PatternFiltersTreePanel.ra$_contentLevel(this.this$0.PatternFiltersTreePanel.this);
                } else {
                    uRLPath = null;
                    this.contentLevel = ContentLevelNode.ra$_level(this.this$0);
                }
                if (this.contentLevel != null) {
                    List list = this.contentLevel.getFiles();
                    if (uRLPath != null && uRLPath.size() > 0) {
                        List<URL> list2 = Arrays.asList(uRLPath.getEntries());
                        list.addAll(list2);
                    }
                    Collections.sort(list, PatternFiltersTreePanel.ra$_urlComparator(this.this$0.PatternFiltersTreePanel.this));
                    this._files = list.toArray(new URL[list.size()]);
                    List list3 = this.contentLevel.getDirectories();
                    Collections.sort(list3);
                    this._folders = list3.toArray(new String[list3.size()]);
                } else {
                    this._files = new URL[0];
                    this._folders = new String[0];
                }
                return null;
            }

            public void finished() {
                if (this._folders.length > 0) {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    int n = this._folders.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String string = this._folders[n2];
                        if (!arrayList.contains(string)) {
                            arrayList.add(string);
                            ContentLevel contentLevel = this.contentLevel.getContentLevel(string);
                            if (contentLevel != null) {
                                ContentLevelNode contentLevelNode = new ContentLevelNode(contentLevel);
                                this.this$0.add((MutableTreeNode)((Object)contentLevelNode));
                            }
                        }
                        ++n2;
                    }
                    PatternFiltersTreePanel.ra$_treeModel(this.this$0.PatternFiltersTreePanel.this).nodeStructureChanged((TreeNode)((Object)this.this$0));
                }
                if (this._files.length > 0) {
                    URLPath uRLPath = this.contentLevel.getDirectoryURLPath();
                    int n = 0;
                    while (n < this._files.length) {
                        String string = uRLPath.toShortestRelativePath(this._files[n]);
                        ContentLevelNode contentLevelNode = new ContentLevelNode(string);
                        this.this$0.add((MutableTreeNode)((Object)contentLevelNode));
                        ++n;
                    }
                }
                this.this$0.updateNodes();
                this.v$waitCursor.hide();
            }

            public 1(ContentLevelNode contentLevelNode, WaitCursor waitCursor) {
                this.v$waitCursor = waitCursor;
                this.this$0 = contentLevelNode;
            }
        }
    }

    private static class FileURLComparator
    implements Comparator {
        private final boolean _caseSensitive;

        void $init$() {
            this._caseSensitive = URLFileSystem.isLocalFileSystemCaseSensitive();
        }

        public int compare(Object object, Object object2) {
            if (object == object2) {
                return 0;
            }
            if (object == null) {
                return -1;
            }
            if (object2 == null) {
                return 1;
            }
            URL uRL = (URL)object;
            URL uRL2 = (URL)object2;
            String string = URLFileSystem.getFileName((URL)uRL);
            String string2 = URLFileSystem.getFileName((URL)uRL2);
            if (this._caseSensitive) {
                return string.compareTo(string2);
            }
            return string.compareToIgnoreCase(string2);
        }

        private FileURLComparator() {
            this.$init$();
        }

        FileURLComparator(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

