/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.model;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.config.DTCache;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.model.Project;
import oracle.ide.model.WorkingSet;
import oracle.ide.model.WorkingSets;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.panels.TabbedPanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.ide.util.PatternFilter;
import oracle.ide.util.PatternFilters;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.data.ChangeInfo;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.resource.ModelArb;
import oracle.jdevimpl.model.NewWorkingSetPanel;
import oracle.jdevimpl.model.PatternFiltersPanel;
import oracle.jdevimpl.model.PatternFiltersTreePanel;
import oracle.jdevimpl.model.WorkingSetsEditor;

public class WorkingSetsPanel
extends DefaultTraversablePanel
implements ItemListener,
ActionListener {
    private static final String HELP_TOPIC_ID = "f1_idedworkingsets_html";
    private final TabbedPanel tabbedPanel;
    private final JComboBox cbWorkingSet;
    private final JButton btnSaveAs;
    private final JButton btnDelete;
    private final DTCache dtCache;
    private transient int defaultTab;
    private transient Project _project;
    private transient WorkingSets _workingSets;
    private WorkingSetChangedListener _workingSetListener;
    private String[] _initialSelection;
    private final HashMap _state;

    void $init$() {
        this.cbWorkingSet = new JComboBox();
        this.btnSaveAs = new JButton();
        this.btnDelete = new JButton();
        this.dtCache = Ide.isRunning() ? Ide.getDTCache() : new DTCache();
        this.defaultTab = this.dtCache.getInteger("WorkingSetsPanel.defaultTab", -1);
        this._state = new HashMap();
    }

    public WorkingSetsPanel() {
        this.$init$();
        this.tabbedPanel = new TabbedPanel(new Navigable[]{new Navigable(ModelArb.getString(57), PatternFiltersTreePanel.class), new Navigable(ModelArb.getString(58), PatternFiltersPanel.class)});
        JWrappedLabel jWrappedLabel = new JWrappedLabel(ModelArb.getString(59));
        JLabel jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.cbWorkingSet, (String)ModelArb.getString(60));
        this.btnSaveAs.addActionListener(this);
        ResourceUtils.resButton((AbstractButton)this.btnSaveAs, (String)ModelArb.getString(61));
        this.btnDelete.addActionListener(this);
        ResourceUtils.resButton((AbstractButton)this.btnDelete, (String)ModelArb.getString(62));
        this.setLayout(new GridBagLayout());
        Insets insets = new Insets(0, 0, 10, 0);
        Insets insets2 = new Insets(0, 0, 0, 0);
        Insets insets3 = new Insets(0, 8, 0, 0);
        Insets insets4 = new Insets(10, 0, 0, 0);
        this.add((Component)jWrappedLabel, this.gbc(0, 0, 4, 1, 1.0, 0.0, 18, 2, insets));
        this.add(jLabel, this.gbc(0, 1, 1, 1, 0.0, 0.0, 17, 0, insets2));
        this.add(this.cbWorkingSet, this.gbc(1, 1, 1, 1, 1.0, 0.0, 17, 2, insets3));
        JPanel jPanel = new JPanel(new GridLayout(1, 2, 8, 0));
        jPanel.add(this.btnSaveAs);
        jPanel.add(this.btnDelete);
        this.add(jPanel, this.gbc(2, 1, 1, 1, 0.0, 0.0, 17, 0, insets3));
        this.add((Component)this.tabbedPanel, this.gbc(0, 2, 4, 1, 1.0, 1.0, 18, 1, insets4));
    }

    public void onEntry(TraversableContext traversableContext) {
        WorkingSet workingSet;
        this._initialSelection = (String[])traversableContext.find("initial-selection");
        this._project = (Project)traversableContext.find("Project");
        this._workingSets = WorkingSets.getInstance((Project)this._project);
        List list = this._workingSets.getWorkingSetNames();
        list.remove(WorkingSets.ALL_FILES_WORKING_SET_LABEL);
        int n = 0;
        String string = this._workingSets.getCurrentWorkingSetName();
        Object[] objectArray = new WS[list.size()];
        int n2 = 0;
        while (n2 < list.size()) {
            String string2 = (String)list.get(n2);
            objectArray[n2] = new WS(string2);
            if (string2.equals(string)) {
                n = n2;
            }
            ++n2;
        }
        NonNullableComboBoxModel nonNullableComboBoxModel = new NonNullableComboBoxModel(objectArray);
        this.cbWorkingSet.setModel(nonNullableComboBoxModel);
        this.cbWorkingSet.setSelectedIndex(n);
        this.storeState(this.curWorkingSetName());
        this.cbWorkingSet.addItemListener(this);
        this.addWorkingSetListener();
        if (this.cbWorkingSet.getSelectedItem() == null) {
            this.tabbedPanel.setEnabled(false);
        }
        WorkingSetsEditor.setPatternFilters((Namespace)traversableContext, (workingSet = this._workingSets.getCurrentWorkingSet()) != null ? workingSet.getPatternFilters() : null);
        this.enterTabbedPanel(this.curWorkingSetName());
        this.updateEnabledStates();
    }

    private void enterTabbedPanel(String string) {
        this.tabbedPanel.onEntry(this.getTabbedTC(string));
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        this._state.clear();
        this.removeWorkingSetListener();
        this.cbWorkingSet.removeItemListener(this);
        TraversableContext traversableContext2 = this.exitTabbedPanel(this.curWorkingSetName());
        Integer n = (Integer)traversableContext2.getDesignTimeObject("TabbedPanel.DEFAULT_TAB_INDEX");
        if (n != null) {
            this.dtCache.putInteger("WorkingSetsPanel.defaultTab", n.intValue());
        }
    }

    private TraversableContext exitTabbedPanel(String string) throws TraversalException {
        TraversableContext traversableContext = this.getTabbedTC(string);
        this.tabbedPanel.onExit(traversableContext);
        return traversableContext;
    }

    private String curWorkingSetName() {
        return ((WS)this.cbWorkingSet.getSelectedItem()).getName();
    }

    private TraversableContext getTabbedTC(String string) {
        WorkingSet workingSet;
        Namespace namespace = new Namespace();
        if (string != null && (workingSet = this._workingSets.getWorkingSet(string)) != null) {
            PatternFilters patternFilters = workingSet.getPatternFilters();
            WorkingSetsEditor.setPatternFilters(namespace, patternFilters);
        }
        namespace.put("Project", (Object)this._project);
        namespace.put("initial-selection", (Object)this._initialSelection);
        TraversableContext traversableContext = new TraversableContext(namespace, 0);
        if (this.defaultTab != -1) {
            traversableContext.putDesignTimeObject("TabbedPanel.DEFAULT_TAB_INDEX", (Object)new Integer(this.defaultTab));
        }
        return traversableContext;
    }

    private void workingSetModified() {
        WS wS = (WS)this.cbWorkingSet.getSelectedItem();
        wS.setModified(true);
        this.cbWorkingSet.repaint();
    }

    private WorkingSetChangedListener getWorkingSetListener() {
        if (this._workingSetListener == null) {
            this._workingSetListener = new WorkingSetChangedListener(null);
        }
        return this._workingSetListener;
    }

    private void addWorkingSetListener() {
        HashStructure hashStructure = this._project.getUserPropertiesOnly();
        hashStructure.addStructureChangeListener((StructureChangeListener)this.getWorkingSetListener());
    }

    private void removeWorkingSetListener() {
        HashStructure hashStructure = this._project.getUserPropertiesOnly();
        hashStructure.removeStructureChangeListener((StructureChangeListener)this.getWorkingSetListener());
    }

    private void storeState(String string) {
        if (!this._state.containsKey(string)) {
            PatternFilter[] patternFilterArray = this._workingSets.getWorkingSet(string).getPatternFilters().getFilters();
            String[] stringArray = new String[patternFilterArray.length];
            int n = 0;
            while (n < patternFilterArray.length) {
                stringArray[n] = patternFilterArray[n].toStr();
                ++n;
            }
            this._state.put(string, stringArray);
        }
    }

    private void refreshFromState(WorkingSet workingSet) {
        String string = workingSet.getName();
        if (this._state.containsKey(string)) {
            PatternFilters patternFilters = workingSet.getPatternFilters();
            patternFilters.setFilters(new PatternFilter[0]);
            String[] stringArray = (String[])this._state.get(string);
            int n = stringArray.length - 1;
            while (n >= 0) {
                if (stringArray[n].startsWith("+")) {
                    patternFilters.addInclude(stringArray[n].substring(1));
                } else {
                    patternFilters.addExclude(stringArray[n].substring(1));
                }
                --n;
            }
        }
        this._state.remove(string);
    }

    public String getHelpID() {
        return HELP_TOPIC_ID;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        int n = itemEvent.getStateChange();
        WS wS = (WS)itemEvent.getItem();
        String string = wS.getName();
        if (n == 1) {
            this._workingSets.setCurrentWorkingSetName(string);
            this.enterTabbedPanel(string);
            this.updateEnabledStates();
            if (!wS._modified) {
                this.storeState(string);
                this.addWorkingSetListener();
            }
        } else if (n == 2) {
            try {
                this.exitTabbedPanel(string);
            }
            catch (TraversalException traversalException) {
                traversalException.printStackTrace();
            }
        }
    }

    private void updateEnabledStates() {
        Object object = this.cbWorkingSet.getSelectedItem();
        boolean bl = object != null;
        this.btnDelete.setEnabled(bl && this.cbWorkingSet.getItemCount() > 1);
        if (object == null) {
            this.enterTabbedPanel(null);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.btnSaveAs) {
            NewWorkingSetPanel newWorkingSetPanel = new NewWorkingSetPanel();
            newWorkingSetPanel.setHelpID("f1_idedsaveas_html");
            Namespace namespace = new Namespace();
            TDialogLauncher tDialogLauncher = newWorkingSetPanel.getTDialogLauncher((Component)((Object)this), namespace);
            JEWTDialog jEWTDialog = tDialogLauncher.initDialog();
            jEWTDialog.addVetoableChangeListener((VetoableChangeListener)new 1(this, namespace, jEWTDialog));
            boolean bl = jEWTDialog.runDialog();
            if (bl) {
                String string = namespace.find("name").toString();
                WS wS = (WS)this.cbWorkingSet.getSelectedItem();
                WorkingSet workingSet = this._workingSets.getWorkingSet(wS.getName());
                if (this._workingSets.getWorkingSetNames().contains(string)) {
                    if (!string.equals(workingSet.getName())) {
                        workingSet.copyTo((Object)this._workingSets.getWorkingSet(string));
                        this.refreshFromState(workingSet);
                    }
                    int n = 0;
                    while (n < this.cbWorkingSet.getItemCount()) {
                        WS wS2 = (WS)this.cbWorkingSet.getItemAt(n);
                        if (string.equals(wS2.getName())) {
                            this.cbWorkingSet.setSelectedIndex(n);
                            break;
                        }
                        ++n;
                    }
                } else {
                    WorkingSet workingSet2 = this._workingSets.getWorkingSet(string);
                    workingSet.copyTo((Object)workingSet2);
                    this.refreshFromState(workingSet);
                    WS wS3 = new WS(string);
                    this.cbWorkingSet.addItem(wS3);
                    this.cbWorkingSet.setSelectedItem(wS3);
                }
                wS.setModified(false);
                this.cbWorkingSet.repaint();
            }
        } else if (object == this.btnDelete) {
            String string = this.curWorkingSetName();
            int n = this.cbWorkingSet.getSelectedIndex();
            this.cbWorkingSet.removeItemAt(n);
            int n2 = this.cbWorkingSet.getItemCount() - 1;
            if (n2 < 0) {
                this.cbWorkingSet.setSelectedItem(null);
            } else {
                this.cbWorkingSet.setSelectedIndex(n <= n2 ? n : n2);
            }
            this.updateEnabledStates();
            this._workingSets.deleteWorkingSet(string);
        }
    }

    static String mav$curWorkingSetName(WorkingSetsPanel workingSetsPanel) {
        return workingSetsPanel.curWorkingSetName();
    }

    static void mav$removeWorkingSetListener(WorkingSetsPanel workingSetsPanel) {
        workingSetsPanel.removeWorkingSetListener();
    }

    static void mav$workingSetModified(WorkingSetsPanel workingSetsPanel) {
        workingSetsPanel.workingSetModified();
    }

    public final class 1
    implements VetoableChangeListener {
        private final /* synthetic */ Namespace v$data;
        private final /* synthetic */ JEWTDialog v$dlg;
        final /* synthetic */ WorkingSetsPanel this$0;

        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            String string;
            if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)propertyChangeEvent) && ((string = this.v$data.find("name").toString()).indexOf(File.separatorChar) != -1 || string.indexOf(47) != -1)) {
                String string2 = ModelArb.getString(66);
                String string3 = ModelArb.getString(67);
                MessageDialog.error((Component)this.v$dlg, (Object)string3, (String)string2, null);
                throw new PropertyVetoException("no", propertyChangeEvent);
            }
        }

        public 1(WorkingSetsPanel workingSetsPanel, Namespace namespace, JEWTDialog jEWTDialog) {
            this.v$dlg = jEWTDialog;
            this.v$data = namespace;
            this.this$0 = workingSetsPanel;
        }
    }

    private class WorkingSetChangedListener
    extends StructureChangeListener {
        public void structureValuesChanged(StructureChangeEvent structureChangeEvent) {
            ChangeInfo[] changeInfoArray = structureChangeEvent.getChangeDetails();
            int n = 0;
            while (n < changeInfoArray.length) {
                String string = changeInfoArray[n].getPropertyName();
                if (string.startsWith("working-sets") && string.indexOf(WorkingSetsPanel.mav$curWorkingSetName(WorkingSetsPanel.this)) != -1) {
                    WorkingSetsPanel.mav$removeWorkingSetListener(WorkingSetsPanel.this);
                    WorkingSetsPanel.mav$workingSetModified(WorkingSetsPanel.this);
                    return;
                }
                ++n;
            }
        }

        private WorkingSetChangedListener() {
        }

        WorkingSetChangedListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private static class WS {
        String _name;
        boolean _modified;
        final String MODIFIED;

        void $init$() {
            this.MODIFIED = " " + ModelArb.getString(63);
        }

        WS(String string) {
            this.$init$();
            this._name = string;
        }

        void setModified(boolean bl) {
            this._modified = bl;
        }

        String getName() {
            return this._name;
        }

        public String toString() {
            if (this._modified) {
                return this._name + this.MODIFIED;
            }
            return this._name;
        }

        public boolean equals(Object object) {
            if (!(object instanceof WS)) {
                return false;
            }
            WS wS = (WS)object;
            return this._name.equals(wS._name) && this._modified == wS._modified;
        }
    }
}

