/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.multifilesearch;

import java.awt.Component;
import java.awt.Font;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Ide;
import oracle.ide.config.GlobalIgnoreList;
import oracle.ide.dialogs.filter.FileTypeIncludeFilter;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.log.LogManager;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.model.Reference;
import oracle.ide.model.TextNode;
import oracle.ide.model.WorkingSet;
import oracle.ide.model.WorkingSets;
import oracle.ide.model.Workspace;
import oracle.ide.model.Workspaces;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.util.IntersectedFilters;
import oracle.ide.util.PatternFilters;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdeveloper.compiler.Helpers;
import oracle.jdeveloper.compiler.IdeStorage;
import oracle.jdeveloper.compiler.JarStorage;
import oracle.jdeveloper.refactoring.model.UsageEntry;
import oracle.jdeveloper.refactoring.model.UsageModel;
import oracle.jdevimpl.multifilesearch.CancelException;
import oracle.jdevimpl.multifilesearch.MatchLog;
import oracle.jdevimpl.multifilesearch.MfsArb;
import oracle.jdevimpl.multifilesearch.MultiFileSearchInfo;
import oracle.jdevimpl.multifilesearch.SearchException;
import oracle.ojc.interfaces.Storage;
import oracle.ojc.storage.DirectoryStorage;

class MultiFileSearch {
    public static int MaxFileSize = 0x800000;
    private MatchLog _matchLog;
    private boolean _caseSensitive;
    private boolean _wholeWordOnly;
    private boolean _regExpEnabled;
    private boolean _recursiveSearch;
    private boolean _treatJarAsDir;
    private boolean _replacing;
    private boolean _firstMatchOnly;
    private boolean _oneMatchPerLine;
    private boolean _openFilesOnly;
    private boolean _noMatchesOnly;
    private boolean _newTab;
    private boolean _autoFillSearchText;
    private String _searchText;
    private String _replaceText;
    private String _searchingInDisplayString;
    private Pattern _regExpPattern;
    private HashSet _urlHashSet;
    private UsageModel _usageModel;
    private Object _searchObject;
    private boolean _usePatternFilters;
    private PatternFilters _patternFilters;
    private FileTypeIncludeFilter _fileTypeIncludeFilter;
    private String _workingSetName;
    private PatternFilters _workingSetPatternFilters;
    private PatternFilters _globalIgnoreFilters;
    private Font _font;
    private Workspace _currentWorkspace;
    private Project _currentProject;
    private boolean _createWorkspaceNodeInTree;
    private boolean _createProjectNodeInTree;
    private List _pairList;
    private HashSet _alreadySearchedSet;

    void $init$() {
        this._createProjectNodeInTree = true;
    }

    public MultiFileSearch(MultiFileSearchInfo multiFileSearchInfo) {
        this.$init$();
        this.init(multiFileSearchInfo);
    }

    private void init(MultiFileSearchInfo multiFileSearchInfo) {
        this._caseSensitive = multiFileSearchInfo.isCaseSensitive();
        this._wholeWordOnly = multiFileSearchInfo.isWholeWordOnly();
        this._regExpEnabled = multiFileSearchInfo.isRegExpEnabled();
        this._recursiveSearch = multiFileSearchInfo.isRecursive();
        this._treatJarAsDir = multiFileSearchInfo.isTreatJarAsDir();
        this._openFilesOnly = multiFileSearchInfo.isOpenFilesOnly();
        this._noMatchesOnly = multiFileSearchInfo.isNoMatchesOnly();
        this._autoFillSearchText = multiFileSearchInfo.isAutoFillSearchText();
        this._searchText = multiFileSearchInfo.getSelectedSearchText();
        this._replacing = multiFileSearchInfo.isReplacing();
        if (this._replacing) {
            this._replaceText = multiFileSearchInfo.getSelectedReplaceText();
            this._firstMatchOnly = false;
            this._oneMatchPerLine = false;
            this._newTab = false;
        } else {
            this._firstMatchOnly = multiFileSearchInfo.getFirstMatchOnly();
            this._oneMatchPerLine = multiFileSearchInfo.isOneMatchPerLine();
            this._noMatchesOnly = multiFileSearchInfo.isNoMatchesOnly();
            this._newTab = multiFileSearchInfo.isNewTab();
        }
        this._searchObject = multiFileSearchInfo.getSearchObject();
        this._usePatternFilters = multiFileSearchInfo.isUsePatternFilters();
        this._patternFilters = multiFileSearchInfo.getPatternFilters();
        this._workingSetName = multiFileSearchInfo.getWorkingSetName();
        this._fileTypeIncludeFilter = multiFileSearchInfo.getFileTypeIncludeFilter();
        this._urlHashSet = new HashSet();
        if (multiFileSearchInfo.getSearchAllWorkspaces()) {
            this._searchingInDisplayString = StringUtils.stripMnemonic((String)MfsArb.getString(10));
        } else if (multiFileSearchInfo.getSearchCurrentWorkspace()) {
            Workspace workspace = (Workspace)this._searchObject;
            this._searchingInDisplayString = workspace.getShortLabel();
        } else if (multiFileSearchInfo.getSearchCurrentProject()) {
            Project project = (Project)this._searchObject;
            if (this._workingSetName != null && this._workingSetName.length() > 0) {
                WorkingSets workingSets = WorkingSets.getInstance((Project)project);
                WorkingSet workingSet = workingSets.getWorkingSet(this._workingSetName);
                this._workingSetPatternFilters = workingSet.getPatternFilters();
                this._searchingInDisplayString = project.getShortLabel() + ":" + this._workingSetName;
            } else {
                this._searchingInDisplayString = project.getShortLabel();
            }
        } else if (multiFileSearchInfo.getSearchCurrentPackage()) {
            this._searchingInDisplayString = (String)this._searchObject;
        } else if (multiFileSearchInfo.getSearchUserDefined()) {
            this._searchingInDisplayString = multiFileSearchInfo.getSelectedSearchLocation();
        } else if (multiFileSearchInfo.isOpenFilesOnly()) {
            this._searchingInDisplayString = StringUtils.stripMnemonic((String)MfsArb.getString(14));
        }
        this._globalIgnoreFilters = GlobalIgnoreList.getPatternFilters();
    }

    public void setMatchLog(MatchLog matchLog) {
        this._matchLog = matchLog;
    }

    public MatchLog getMatchLog() {
        return this._matchLog;
    }

    public boolean isNoMatchesOnly() {
        return this._noMatchesOnly;
    }

    public boolean isSingleProjectSearch() {
        boolean bl = false;
        if (this._searchObject instanceof Project) {
            bl = true;
        } else if (this._searchObject instanceof Workspaces || this._searchObject instanceof Workspace) {
            bl = this._pairList.size() == 1;
        }
        return bl;
    }

    public Project getSingleProject() {
        Project project = null;
        if (this._searchObject instanceof Project) {
            project = (Project)this._searchObject;
        } else if (this._searchObject instanceof Workspaces || this._searchObject instanceof Workspace) {
            WorkspaceProjectPair workspaceProjectPair = (WorkspaceProjectPair)this._pairList.get(0);
            project = workspaceProjectPair.getProject();
        }
        return project;
    }

    public boolean isCreateWorkspaceNodeInTree() {
        return this._createWorkspaceNodeInTree;
    }

    public boolean isCreateProjectNodeInTree() {
        return this._createProjectNodeInTree;
    }

    private char[] read(Reader reader, String string) {
        try {
            try {
                int n = 0;
                char[] cArray = null;
                do {
                    int n2;
                    int n3;
                    char[] cArray2 = new char[n == 0 ? 65536 : n * 2];
                    if (cArray != null) {
                        System.arraycopy(cArray, 0, cArray2, 0, n);
                    }
                    if ((n3 = reader.read(cArray = cArray2, cArray.length - (n2 = cArray.length - n), n2)) >= 0) {
                        n += n3;
                    }
                    if (n <= MaxFileSize) continue;
                    String string2 = MfsArb.format(50, string, new Integer(MaxFileSize));
                    LogManager.getLogManager().getMsgPage().log((Object)string2);
                    break;
                } while (n == cArray.length && reader.ready());
                if (n < cArray.length) {
                    char[] cArray3 = new char[n];
                    System.arraycopy(cArray, 0, cArray3, 0, n);
                    cArray = cArray3;
                }
                char[] cArray4 = cArray;
                try {
                    reader.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return cArray4;
            }
            catch (Throwable throwable) {
                String string3 = MfsArb.format(51, string);
                ExceptionDialog.showExceptionDialog((Component)null, (Throwable)throwable, (String)string3);
            }
        }
        finally {
            try {
                reader.close();
            }
            catch (Throwable throwable) {}
        }
        return null;
    }

    private boolean matchChar(char c, char c2) {
        return c == c2 || !this._caseSensitive && Character.toUpperCase(c) == c2;
    }

    private int getLineNo(char[] cArray, int n) {
        int n2 = 1;
        while (n > 0) {
            if (cArray[--n] != '\n') continue;
            ++n2;
        }
        return n2;
    }

    private void searchCharArray(char[] cArray, Storage storage) {
        int n = 0;
        try {
            String string = new String(cArray);
            Matcher matcher = this._regExpPattern.matcher(string);
            int n2 = -1;
            while (matcher.find()) {
                int n3 = matcher.start();
                int n4 = matcher.end();
                int n5 = n4 - n3;
                if (this._wholeWordOnly && (n3 > 0 && Character.isJavaIdentifierPart(string.charAt(n3 - 1)) || n4 < string.length() && Character.isJavaIdentifierPart(string.charAt(n4)))) continue;
                int n6 = n3;
                while (n6 > 0 && string.charAt(n6) != '\n') {
                    --n6;
                }
                ++n6;
                int n7 = n4;
                while (n7 < string.length() && string.charAt(n7) != '\n' && string.charAt(n7) != '\r') {
                    ++n7;
                }
                String string2 = string.substring(n6, n7);
                string2 = this.removeBinaryChars(string2, storage);
                ++n;
                if (this._matchLog != null) {
                    if (!this._noMatchesOnly) {
                        int n8 = this.getLineNo(cArray, n3);
                        if (!this._oneMatchPerLine || this._oneMatchPerLine && n8 != n2) {
                            this._matchLog.match(this._currentWorkspace, this._currentProject, storage, string2, this.getLineNo(cArray, n3), n3 - n6, n5);
                            n2 = n8;
                            String string3 = storage.getCanonicalPath();
                            URL uRL = URLFactory.newURL((String)string3);
                            this._urlHashSet.add(uRL);
                        }
                    }
                } else {
                    String string4 = storage.getCanonicalPath();
                    URL uRL = URLFactory.newURL((String)string4);
                    this._urlHashSet.add(uRL);
                    UsageEntry usageEntry = UsageEntry.createEntry(Ide.getActiveProject(), uRL, n3, n5, 0);
                    if (usageEntry != null) {
                        this._usageModel.addUsageEntry(usageEntry);
                    }
                }
                if (!this._firstMatchOnly) continue;
                return;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this._noMatchesOnly && n == 0 && this._matchLog != null) {
            this._matchLog.match(this._currentWorkspace, this._currentProject, storage);
            String string = storage.getCanonicalPath();
            URL uRL = URLFactory.newURL((String)string);
            this._urlHashSet.add(uRL);
        }
    }

    private void searchCharArray(char[] cArray, String string, Storage storage) {
        if (this._regExpEnabled) {
            this.searchCharArray(cArray, storage);
            return;
        }
        int n = 0;
        char[] cArray2 = string.toCharArray();
        if (!this._caseSensitive) {
            int n2 = 0;
            while (n2 < cArray2.length) {
                cArray2[n2] = Character.toUpperCase(cArray2[n2]);
                ++n2;
            }
        }
        int n3 = 0;
        int n4 = 1;
        int n5 = -1;
        while (n3 < cArray.length) {
            if (cArray[n3] == '\n') {
                ++n4;
            }
            if (!this.matchChar(cArray[n3++], cArray2[0]) || this._wholeWordOnly && n3 >= 2 && Character.isJavaIdentifierPart(cArray[n3 - 2])) continue;
            int n6 = n3;
            int n7 = 1;
            int n8 = 0;
            while (n7 < cArray2.length && n6 < cArray.length) {
                if (cArray[n6] == '\n') {
                    ++n8;
                }
                if (!this.matchChar(cArray[n6], cArray2[n7])) break;
                ++n7;
                ++n6;
            }
            if (n7 < cArray2.length) continue;
            n4 += n8;
            if (this._wholeWordOnly && n6 < cArray.length && Character.isJavaIdentifierPart(cArray[n6])) continue;
            int n9 = n3 - 1;
            while (n9 >= 0) {
                if (cArray[n9] == '\n') break;
                --n9;
            }
            ++n9;
            int n10 = n3;
            while (n10 < cArray.length && cArray[n10] != '\n' && cArray[n10] != '\r') {
                ++n10;
            }
            String string2 = new String(cArray, n9, n10 - n9);
            string2 = this.removeBinaryChars(string2, storage);
            ++n;
            if (this._matchLog != null) {
                if (!this._noMatchesOnly && (!this._oneMatchPerLine || this._oneMatchPerLine && n4 != n5)) {
                    this._matchLog.match(this._currentWorkspace, this._currentProject, storage, string2, n4, n3 - n9, n7);
                    n5 = n4;
                    String string3 = storage.getCanonicalPath();
                    URL uRL = URLFactory.newURL((String)string3);
                    this._urlHashSet.add(uRL);
                }
            } else {
                String string4 = storage.getCanonicalPath();
                URL uRL = URLFactory.newURL((String)string4);
                this._urlHashSet.add(uRL);
                UsageEntry usageEntry = UsageEntry.createEntry(Ide.getActiveProject(), uRL, n3 - 1, cArray2.length, 0);
                if (usageEntry != null) {
                    this._usageModel.addUsageEntry(usageEntry);
                }
            }
            n3 += n7 - 1;
            if (!this._firstMatchOnly) continue;
            return;
        }
        if (this._noMatchesOnly && n == 0 && this._matchLog != null) {
            this._matchLog.match(this._currentWorkspace, this._currentProject, storage);
            String string5 = storage.getCanonicalPath();
            URL uRL = URLFactory.newURL((String)string5);
            this._urlHashSet.add(uRL);
        }
    }

    private String removeBinaryChars(String string, Storage storage) {
        if (!storage.isInJar()) {
            return string;
        }
        if (this._font == null) {
            JTree jTree = new JTree();
            this._font = jTree.getFont();
        }
        if (this._font == null) {
            return string;
        }
        char[] cArray = string.toCharArray();
        char[] cArray2 = new char[cArray.length];
        Arrays.fill(cArray2, ' ');
        int n = 0;
        int n2 = 0;
        while (n2 < cArray.length) {
            char c = cArray[n2];
            if (this._font.canDisplay(c)) {
                cArray2[n] = c;
                ++n;
            }
            ++n2;
        }
        String string2 = new String(cArray2);
        string2.trim();
        return string2;
    }

    private int searchStore(Storage storage, String string) throws CancelException {
        int n = 0;
        try {
            Object[] objectArray = storage.list();
            if (objectArray != null) {
                if (this._matchLog != null) {
                    this._matchLog.logProgress(MfsArb.format(33, storage.getPath()));
                }
                n = this.searchFiles(objectArray, storage, string);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return n;
    }

    private boolean isExcluded(URL uRL) {
        boolean bl = false;
        String string = URLFileSystem.getPath((URL)uRL);
        if (!this._globalIgnoreFilters.isIncluded(string)) {
            bl = true;
        } else if (string.toLowerCase().indexOf("web-inf\\lib") > -1) {
            bl = true;
        } else if (this._usePatternFilters && this._patternFilters.containsFilters() && !this._patternFilters.isIncluded(string)) {
            bl = true;
        }
        if (!bl && this._fileTypeIncludeFilter != null && this._fileTypeIncludeFilter.getList() != null) {
            boolean bl2 = false;
            if (!URLFileSystem.isDirectory((URL)uRL)) {
                bl2 = true;
                bl2 = true;
                List list = this._fileTypeIncludeFilter.getList();
                int n = list.size();
                int n2 = 0;
                while (n2 < n) {
                    URLFilter uRLFilter = (URLFilter)list.get(n2);
                    if (uRLFilter.accept(uRL)) {
                        bl2 = false;
                        break;
                    }
                    ++n2;
                }
            }
            bl = bl2;
        }
        return bl;
    }

    private static boolean isZipOrJar(String string) {
        return string.endsWith(".zip") || string.endsWith(".jar");
    }

    private int searchFiles(Object[] objectArray, Storage storage, String string) throws CancelException, IOException {
        int n = 0;
        int n2 = 0;
        while (n2 < objectArray.length) {
            URL uRL;
            String string2 = null;
            Storage storage2 = null;
            if (objectArray[n2] instanceof String) {
                string2 = (String)objectArray[n2];
                storage2 = storage.open(string2);
            } else if (objectArray[n2] instanceof URL) {
                string2 = URLFileSystem.getPath((URL)((URL)objectArray[n2]));
                storage2 = Helpers.createFileStorage(string2);
            }
            if (storage2 != null && !this.isExcluded(uRL = URLFactory.newURL((String)storage2.getPath()))) {
                if (storage2 != null && storage2.isDirectory() && !this._alreadySearchedSet.contains(storage2)) {
                    if (this._recursiveSearch) {
                        this._alreadySearchedSet.add(storage2);
                        n += this.searchStore(storage2, string);
                    }
                } else if (storage2 != null && MultiFileSearch.isZipOrJar(string2) && this._treatJarAsDir && this._recursiveSearch && !this._alreadySearchedSet.contains(storage2)) {
                    URL uRL2 = URLFactory.newJarURL((File)new File(storage2.getPath()), (String)"");
                    JarStorage jarStorage = new JarStorage(uRL2);
                    this._alreadySearchedSet.add(storage2);
                    n += this.searchStore(jarStorage, string);
                } else {
                    String string3 = null;
                    string3 = storage != null ? storage.getPath() : string2;
                    string3 = storage2 != null ? storage2.getPath() : string3 + File.separator + string2;
                    if (!this._alreadySearchedSet.contains(string3)) {
                        this._alreadySearchedSet.add(string3);
                        Reader reader = null;
                        Node node = null;
                        boolean bl = false;
                        if (!(storage instanceof JarStorage)) {
                            try {
                                node = NodeFactory.find((URL)URLFactory.newURL((String)string3));
                                if (node == null) {
                                    bl = true;
                                    node = NodeFactory.findOrCreate((URL)URLFactory.newURL((String)string3));
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (node != null) {
                            storage2 = new IdeStorage(node);
                            if (node instanceof TextNode) {
                                reader = ((TextNode)node).getReader();
                            } else {
                                InputStream inputStream = node.getInputStream();
                                if (inputStream != null) {
                                    reader = new InputStreamReader(inputStream);
                                }
                            }
                        } else if (storage2 != null) {
                            InputStream inputStream = storage2 instanceof JarStorage ? (InputStream)new ByteArrayInputStream(storage2.read()) : (InputStream)new FileInputStream(storage2.getPath());
                            reader = new InputStreamReader(inputStream);
                        }
                        if (storage2 != null && reader != null) {
                            ++n;
                            char[] cArray = this.read(reader, storage2.getPath());
                            if (cArray != null) {
                                this.searchCharArray(cArray, string, storage2);
                            }
                            if (bl) {
                                NodeFactory.uncache((URL)node.getURL());
                            }
                        }
                    }
                }
            }
            ++n2;
        }
        return n;
    }

    private int searchContainer(List list, String string) throws CancelException {
        int n = 0;
        int n2 = list.size();
        WorkspaceProjectPair workspaceProjectPair = null;
        ProjectContent projectContent = null;
        ContentSet contentSet = null;
        int n3 = 0;
        while (n3 < n2) {
            workspaceProjectPair = (WorkspaceProjectPair)list.get(n3);
            this._currentWorkspace = workspaceProjectPair.getWorkspace();
            this._currentProject = workspaceProjectPair.getProject();
            projectContent = ProjectContent.getInstance((PropertyStorage)this._currentProject);
            contentSet = projectContent.getAllContents();
            Iterator iterator = null;
            if (this._workingSetPatternFilters == null) {
                iterator = contentSet.nodeIterator(null);
            } else {
                IntersectedFilters intersectedFilters = new IntersectedFilters(this._workingSetPatternFilters);
                iterator = contentSet.nodeIterator(null, intersectedFilters);
            }
            Object[] objectArray = new URL[1];
            while (iterator.hasNext()) {
                Node node = (Node)iterator.next();
                String string2 = URLFileSystem.getPath((URL)node.getURL());
                Storage storage = Helpers.createFileStorage(string2);
                if (this._matchLog != null) {
                    this._matchLog.logProgress(MfsArb.format(33, storage.getPath()));
                }
                objectArray[0] = node.getURL();
                try {
                    n += this.searchFiles(objectArray, storage, string);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            ++n3;
        }
        return n;
    }

    private int searchContainer(String string, String string2) throws CancelException {
        JarPath jarPath = JarPath.getJarPath(string);
        if (jarPath != null) {
            URL uRL = URLFactory.newJarURL((File)new File(jarPath.jarName), (String)"");
            JarStorage jarStorage = new JarStorage(uRL);
            if (jarPath.startingPath != null && jarPath.startingPath.length() > 0) {
                jarStorage = new JarStorage(uRL).openDir(jarPath.startingPath);
            }
            if (jarStorage != null) {
                return this.searchStore(jarStorage, string2);
            }
            return 0;
        }
        File file = new File(string);
        if (file.exists() && file.isDirectory()) {
            DirectoryStorage directoryStorage = new DirectoryStorage(file);
            return this.searchStore((Storage)directoryStorage, string2);
        }
        return this.searchStore(Helpers.createFileStorage(string), string2);
    }

    public static Pattern compilePattern(String string, boolean bl) throws Throwable {
        return Pattern.compile(string, bl ? 0 : 2);
    }

    void setupSearch() {
        if (this._openFilesOnly || this._searchObject instanceof String) {
            this._createWorkspaceNodeInTree = false;
            this._createProjectNodeInTree = false;
        } else if (this._searchObject instanceof Workspaces || this._searchObject instanceof Workspace || this._searchObject instanceof Project) {
            ArrayList<WorkspaceProjectPair> arrayList = new ArrayList<WorkspaceProjectPair>();
            if (this._searchObject instanceof Workspaces) {
                this.processAllWorkspaces((Workspaces)this._searchObject, arrayList);
            } else if (this._searchObject instanceof Workspace) {
                this.processWorkspace((Workspace)this._searchObject, arrayList);
            } else if (this._searchObject instanceof Project) {
                this._createWorkspaceNodeInTree = false;
                arrayList.add(new WorkspaceProjectPair(null, (Project)this._searchObject));
            }
            this._pairList = arrayList;
        }
    }

    int performSearch() throws SearchException, CancelException {
        this._alreadySearchedSet = new HashSet();
        String string = null;
        Object object = null;
        try {
            string = this._searchText;
            object = this._searchObject;
        }
        catch (Throwable throwable) {
            int n = -1;
            return n;
        }
        if (string == null || string.length() == 0 || object == null && !this._openFilesOnly) {
            return -1;
        }
        if (this._regExpEnabled) {
            try {
                this._regExpPattern = MultiFileSearch.compilePattern(string, this._caseSensitive);
            }
            catch (Throwable throwable) {
                throw new SearchException(MfsArb.format(34, string, throwable.getMessage()));
            }
        }
        int n = 0;
        if (this._openFilesOnly) {
            ArrayList arrayList = new ArrayList();
            1 var7_8 = new 1(this, arrayList);
            try {
                SwingUtilities.invokeAndWait(var7_8);
            }
            catch (Exception exception) {
                int n2 = 0;
                return n2;
            }
            Object[] objectArray = new URL[arrayList.size()];
            objectArray = arrayList.toArray(objectArray);
            try {
                n += this.searchFiles(objectArray, null, string);
            }
            catch (IOException iOException) {}
        } else if (object instanceof String) {
            String string2 = (String)object;
            StringTokenizer stringTokenizer = new StringTokenizer(string2, File.pathSeparator);
            while (stringTokenizer.hasMoreElements()) {
                String string3 = (String)stringTokenizer.nextElement();
                n += this.searchContainer(string3, string);
            }
        } else if (this._searchObject instanceof Workspaces || this._searchObject instanceof Workspace || this._searchObject instanceof Project) {
            n += this.searchContainer(this._pairList, string);
        }
        return n;
    }

    String getSearchingInDisplayString() {
        return this._searchingInDisplayString;
    }

    String getSearchText() {
        return this._searchText;
    }

    static URL getFirstChildURL(Element element) {
        if (element instanceof Node) {
            return ((Node)element).getURL();
        }
        Iterator iterator = element.getChildren();
        if (iterator != null) {
            while (iterator.hasNext()) {
                Element element2 = (Element)iterator.next();
                URL uRL = MultiFileSearch.getFirstChildURL(element2);
                if (uRL == null) continue;
                return uRL;
            }
        }
        return null;
    }

    HashSet getURLs() {
        this._urlHashSet = null;
        this._urlHashSet = new HashSet();
        this._usageModel = null;
        this._usageModel = new UsageModel();
        try {
            this.setupSearch();
            this.performSearch();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this._urlHashSet;
    }

    UsageModel getUsageModel() {
        return this._usageModel;
    }

    HashSet getURLHashSet() {
        return this._urlHashSet;
    }

    private void processWorkspace(Workspace workspace, List list) {
        Iterator iterator = workspace.getChildren();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof Project)) continue;
            list.add(new WorkspaceProjectPair(workspace, (Project)e));
        }
    }

    private void processAllWorkspaces(Workspaces workspaces, List list) {
        List list2 = workspaces.getListOfChildren();
        int n = list2.size();
        if (n > 1) {
            this._createWorkspaceNodeInTree = true;
        }
        int n2 = 0;
        while (n2 < n) {
            Reference reference = (Reference)list2.get(n2);
            if (reference.getData() instanceof Workspace) {
                this.processWorkspace((Workspace)reference.getData(), list);
            }
            ++n2;
        }
    }

    static boolean maS$isZipOrJar(String string) {
        return MultiFileSearch.isZipOrJar(string);
    }

    private static class JarPath {
        String jarName;
        String startingPath;

        JarPath(String string, String string2) {
            this.jarName = string;
            this.startingPath = string2;
        }

        static JarPath getJarPath(String string) {
            if (MultiFileSearch.maS$isZipOrJar(string)) {
                return new JarPath(string, "");
            }
            int n = string.indexOf(".zip!");
            if (n < 0) {
                n = string.indexOf(".jar!");
            }
            if (n >= 0) {
                String string2 = string.substring(0, n + 4);
                String string3 = string.length() >= n + 6 ? string.substring(n + 6) : "";
                return new JarPath(string2, string3);
            }
            return null;
        }
    }

    final class 1
    implements Runnable {
        private final /* synthetic */ List v$urlList;
        final /* synthetic */ MultiFileSearch this$0;

        public void run() {
            EditorManager editorManager = EditorManager.getEditorManager();
            List list = editorManager.getAllEditors();
            if (list != null) {
                int n = list.size();
                int n2 = 0;
                while (n2 < n) {
                    Editor editor = (Editor)list.get(n2);
                    this.v$urlList.add(editor.getContext().getNode().getURL());
                    ++n2;
                }
            }
        }

        public 1(MultiFileSearch multiFileSearch, List list) {
            this.v$urlList = list;
            this.this$0 = multiFileSearch;
        }
    }

    private static final class WorkspaceProjectPair {
        private Workspace _workspace;
        private Project _project;

        public WorkspaceProjectPair(Workspace workspace, Project project) {
            this._workspace = workspace;
            this._project = project;
        }

        public Workspace getWorkspace() {
            return this._workspace;
        }

        public Project getProject() {
            return this._project;
        }
    }
}

